#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpisbaijsetpreallocation_ MATMPISBAIJSETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpisbaijsetpreallocation_ matmpisbaijsetpreallocation
#endif
PETSC_EXTERN void matmpisbaijsetpreallocation_(Mat *a, PetscInt *b, PetscInt *c, const PetscInt d[], PetscInt *e, const PetscInt f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(f);
  *ierr = MatMPISBAIJSetPreallocation(*a, *b, *c, d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatesbaij_ MATCREATESBAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatesbaij_ matcreatesbaij
#endif
PETSC_EXTERN void matcreatesbaij_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, const PetscInt h[], PetscInt *i, const PetscInt j[], Mat *k, PetscErrorCode *ierr)
{
  PetscBool null_k = !*(void**) k ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLINTEGER(j);
  CHKFORTRANNULLOBJECT(k);
  *ierr = MatCreateSBAIJ(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, *g, h, *i, j, k);
  if (*ierr) return;
  if (! null_k && !*(void**) k) *(void **) k = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatempisbaijwitharrays_ MATCREATEMPISBAIJWITHARRAYS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatempisbaijwitharrays_ matcreatempisbaijwitharrays
#endif
PETSC_EXTERN void matcreatempisbaijwitharrays_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, const PetscInt g[], const PetscInt h[], const PetscScalar i[], Mat *j, PetscErrorCode *ierr)
{
  PetscBool null_j = !*(void**) j ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLSCALAR(i);
  CHKFORTRANNULLOBJECT(j);
  *ierr = MatCreateMPISBAIJWithArrays(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, g, h, i, j);
  if (*ierr) return;
  if (! null_j && !*(void**) j) *(void **) j = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpisbaijsetpreallocationcsr_ MATMPISBAIJSETPREALLOCATIONCSR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpisbaijsetpreallocationcsr_ matmpisbaijsetpreallocationcsr
#endif
PETSC_EXTERN void matmpisbaijsetpreallocationcsr_(Mat *a, PetscInt *b, const PetscInt c[], const PetscInt d[], const PetscScalar e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLSCALAR(e);
  *ierr = MatMPISBAIJSetPreallocationCSR(*a, *b, c, d, e);
  if (*ierr) return;
}
