#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pceisenstatsetomega_ PCEISENSTATSETOMEGA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pceisenstatsetomega_ pceisenstatsetomega
#endif
PETSC_EXTERN void pceisenstatsetomega_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PCEisenstatSetOmega(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pceisenstatsetnodiagonalscaling_ PCEISENSTATSETNODIAGONALSCALING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pceisenstatsetnodiagonalscaling_ pceisenstatsetnodiagonalscaling
#endif
PETSC_EXTERN void pceisenstatsetnodiagonalscaling_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCEisenstatSetNoDiagonalScaling(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pceisenstatgetomega_ PCEISENSTATGETOMEGA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pceisenstatgetomega_ pceisenstatgetomega
#endif
PETSC_EXTERN void pceisenstatgetomega_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = PCEisenstatGetOmega(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pceisenstatgetnodiagonalscaling_ PCEISENSTATGETNODIAGONALSCALING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pceisenstatgetnodiagonalscaling_ pceisenstatgetnodiagonalscaling
#endif
PETSC_EXTERN void pceisenstatgetnodiagonalscaling_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCEisenstatGetNoDiagonalScaling(*a, b);
  if (*ierr) return;
}
