#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreateseqwitharray_ VECCREATESEQWITHARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreateseqwitharray_ veccreateseqwitharray
#endif
PETSC_EXTERN void veccreateseqwitharray_(MPI_Fint *a, PetscInt *b, PetscInt *c, const PetscScalar d[], Vec *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLSCALAR(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = VecCreateSeqWithArray(MPI_Comm_f2c(*(a)), *b, *c, d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
