#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetcolumnvector_ MATGETCOLUMNVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetcolumnvector_ matgetcolumnvector
#endif
PETSC_EXTERN void matgetcolumnvector_(Mat *a, Vec *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = MatGetColumnVector(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetcolumnnorms_ MATGETCOLUMNNORMS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetcolumnnorms_ matgetcolumnnorms
#endif
PETSC_EXTERN void matgetcolumnnorms_(Mat *a, NormType *b, PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = MatGetColumnNorms(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetcolumnsumsrealpart_ MATGETCOLUMNSUMSREALPART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetcolumnsumsrealpart_ matgetcolumnsumsrealpart
#endif
PETSC_EXTERN void matgetcolumnsumsrealpart_(Mat *a, PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = MatGetColumnSumsRealPart(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetcolumnsumsimaginarypart_ MATGETCOLUMNSUMSIMAGINARYPART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetcolumnsumsimaginarypart_ matgetcolumnsumsimaginarypart
#endif
PETSC_EXTERN void matgetcolumnsumsimaginarypart_(Mat *a, PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = MatGetColumnSumsImaginaryPart(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetcolumnsums_ MATGETCOLUMNSUMS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetcolumnsums_ matgetcolumnsums
#endif
PETSC_EXTERN void matgetcolumnsums_(Mat *a, PetscScalar b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = MatGetColumnSums(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetcolumnmeansrealpart_ MATGETCOLUMNMEANSREALPART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetcolumnmeansrealpart_ matgetcolumnmeansrealpart
#endif
PETSC_EXTERN void matgetcolumnmeansrealpart_(Mat *a, PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = MatGetColumnMeansRealPart(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetcolumnmeansimaginarypart_ MATGETCOLUMNMEANSIMAGINARYPART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetcolumnmeansimaginarypart_ matgetcolumnmeansimaginarypart
#endif
PETSC_EXTERN void matgetcolumnmeansimaginarypart_(Mat *a, PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = MatGetColumnMeansImaginaryPart(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetcolumnmeans_ MATGETCOLUMNMEANS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetcolumnmeans_ matgetcolumnmeans
#endif
PETSC_EXTERN void matgetcolumnmeans_(Mat *a, PetscScalar b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = MatGetColumnMeans(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetcolumnreductions_ MATGETCOLUMNREDUCTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetcolumnreductions_ matgetcolumnreductions
#endif
PETSC_EXTERN void matgetcolumnreductions_(Mat *a, PetscInt *b, PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = MatGetColumnReductions(*a, *b, c);
  if (*ierr) return;
}
