#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewervusetvecseen_ PETSCVIEWERVUSETVECSEEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewervusetvecseen_ petscviewervusetvecseen
#endif
PETSC_EXTERN void petscviewervusetvecseen_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerVUSetVecSeen(v_a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewervugetvecseen_ PETSCVIEWERVUGETVECSEEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewervugetvecseen_ petscviewervugetvecseen
#endif
PETSC_EXTERN void petscviewervugetvecseen_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerVUGetVecSeen(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewervuflushdeferred_ PETSCVIEWERVUFLUSHDEFERRED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewervuflushdeferred_ petscviewervuflushdeferred
#endif
PETSC_EXTERN void petscviewervuflushdeferred_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerVUFlushDeferred(v_a);
  if (*ierr) return;
}
