#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snescompositesettype_ SNESCOMPOSITESETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snescompositesettype_ snescompositesettype
#endif
PETSC_EXTERN void snescompositesettype_(SNES *a, SNESCompositeType *b, PetscErrorCode *ierr)
{
  *ierr = SNESCompositeSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snescompositeaddsnes_ SNESCOMPOSITEADDSNES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snescompositeaddsnes_ snescompositeaddsnes
#endif
PETSC_EXTERN void snescompositeaddsnes_(SNES *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = SNESCompositeAddSNES(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snescompositegetsnes_ SNESCOMPOSITEGETSNES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snescompositegetsnes_ snescompositegetsnes
#endif
PETSC_EXTERN void snescompositegetsnes_(SNES *a, PetscInt *b, SNES *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = SNESCompositeGetSNES(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snescompositegetnumber_ SNESCOMPOSITEGETNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snescompositegetnumber_ snescompositegetnumber
#endif
PETSC_EXTERN void snescompositegetnumber_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESCompositeGetNumber(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snescompositesetdamping_ SNESCOMPOSITESETDAMPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snescompositesetdamping_ snescompositesetdamping
#endif
PETSC_EXTERN void snescompositesetdamping_(SNES *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = SNESCompositeSetDamping(*a, *b, *c);
  if (*ierr) return;
}
