#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgcreate_ PETSCDRAWHGCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgcreate_ petscdrawhgcreate
#endif
PETSC_EXTERN void petscdrawhgcreate_(PetscDraw *a, int *b, PetscDrawHG *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDrawHGCreate(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgsetnumberbins_ PETSCDRAWHGSETNUMBERBINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgsetnumberbins_ petscdrawhgsetnumberbins
#endif
PETSC_EXTERN void petscdrawhgsetnumberbins_(PetscDrawHG *a, int *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawHGSetNumberBins(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgreset_ PETSCDRAWHGRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgreset_ petscdrawhgreset
#endif
PETSC_EXTERN void petscdrawhgreset_(PetscDrawHG *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawHGReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgdestroy_ PETSCDRAWHGDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgdestroy_ petscdrawhgdestroy
#endif
PETSC_EXTERN void petscdrawhgdestroy_(PetscDrawHG *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscDrawHGDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgaddvalue_ PETSCDRAWHGADDVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgaddvalue_ petscdrawhgaddvalue
#endif
PETSC_EXTERN void petscdrawhgaddvalue_(PetscDrawHG *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawHGAddValue(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgaddweightedvalue_ PETSCDRAWHGADDWEIGHTEDVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgaddweightedvalue_ petscdrawhgaddweightedvalue
#endif
PETSC_EXTERN void petscdrawhgaddweightedvalue_(PetscDrawHG *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = PetscDrawHGAddWeightedValue(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgdraw_ PETSCDRAWHGDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgdraw_ petscdrawhgdraw
#endif
PETSC_EXTERN void petscdrawhgdraw_(PetscDrawHG *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawHGDraw(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgsave_ PETSCDRAWHGSAVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgsave_ petscdrawhgsave
#endif
PETSC_EXTERN void petscdrawhgsave_(PetscDrawHG *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawHGSave(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgview_ PETSCDRAWHGVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgview_ petscdrawhgview
#endif
PETSC_EXTERN void petscdrawhgview_(PetscDrawHG *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscDrawHGView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgsetcolor_ PETSCDRAWHGSETCOLOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgsetcolor_ petscdrawhgsetcolor
#endif
PETSC_EXTERN void petscdrawhgsetcolor_(PetscDrawHG *a, int *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawHGSetColor(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgsetlimits_ PETSCDRAWHGSETLIMITS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgsetlimits_ petscdrawhgsetlimits
#endif
PETSC_EXTERN void petscdrawhgsetlimits_(PetscDrawHG *a, PetscReal *b, PetscReal *c, int *d, int *e, PetscErrorCode *ierr)
{
  *ierr = PetscDrawHGSetLimits(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgcalcstats_ PETSCDRAWHGCALCSTATS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgcalcstats_ petscdrawhgcalcstats
#endif
PETSC_EXTERN void petscdrawhgcalcstats_(PetscDrawHG *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawHGCalcStats(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhgintegerbins_ PETSCDRAWHGINTEGERBINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhgintegerbins_ petscdrawhgintegerbins
#endif
PETSC_EXTERN void petscdrawhgintegerbins_(PetscDrawHG *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawHGIntegerBins(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhggetaxis_ PETSCDRAWHGGETAXIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhggetaxis_ petscdrawhggetaxis
#endif
PETSC_EXTERN void petscdrawhggetaxis_(PetscDrawHG *a, PetscDrawAxis *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawHGGetAxis(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawhggetdraw_ PETSCDRAWHGGETDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawhggetdraw_ petscdrawhggetdraw
#endif
PETSC_EXTERN void petscdrawhggetdraw_(PetscDrawHG *a, PetscDraw *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawHGGetDraw(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
