#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatelmvmdqn_ MATCREATELMVMDQN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatelmvmdqn_ matcreatelmvmdqn
#endif
PETSC_EXTERN void matcreatelmvmdqn_(MPI_Fint *a, PetscInt *b, PetscInt *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatCreateLMVMDQN(MPI_Comm_f2c(*(a)), *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatelmvmdbfgs_ MATCREATELMVMDBFGS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatelmvmdbfgs_ matcreatelmvmdbfgs
#endif
PETSC_EXTERN void matcreatelmvmdbfgs_(MPI_Fint *a, PetscInt *b, PetscInt *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatCreateLMVMDBFGS(MPI_Comm_f2c(*(a)), *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatelmvmddfp_ MATCREATELMVMDDFP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatelmvmddfp_ matcreatelmvmddfp
#endif
PETSC_EXTERN void matcreatelmvmddfp_(MPI_Fint *a, PetscInt *b, PetscInt *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatCreateLMVMDDFP(MPI_Comm_f2c(*(a)), *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matlmvmdensesettype_ MATLMVMDENSESETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matlmvmdensesettype_ matlmvmdensesettype
#endif
PETSC_EXTERN void matlmvmdensesettype_(Mat *a, MatLMVMDenseType *b, PetscErrorCode *ierr)
{
  *ierr = MatLMVMDenseSetType(*a, *b);
  if (*ierr) return;
}
