#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmcreatesectionsubdm_ DMCREATESECTIONSUBDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmcreatesectionsubdm_ dmcreatesectionsubdm
#endif
PETSC_EXTERN void dmcreatesectionsubdm_(DM *a, PetscInt *b, const PetscInt c[], const PetscInt d[], const PetscInt e[], IS *f, DM *g, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLOBJECT(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = DMCreateSectionSubDM(*a, *b, c, d, e, f, g);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
