#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpopensetmachine_ PETSCPOPENSETMACHINE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpopensetmachine_ petscpopensetmachine
#endif
PETSC_EXTERN void petscpopensetmachine_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscPOpenSetMachine(c_a);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
