#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetreordering_ MATSTRUMPACKSETREORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetreordering_ matstrumpacksetreordering
#endif
PETSC_EXTERN void matstrumpacksetreordering_(Mat *a, MatSTRUMPACKReordering *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetReordering(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpackgetreordering_ MATSTRUMPACKGETREORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpackgetreordering_ matstrumpackgetreordering
#endif
PETSC_EXTERN void matstrumpackgetreordering_(Mat *a, MatSTRUMPACKReordering *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKGetReordering(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetcolperm_ MATSTRUMPACKSETCOLPERM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetcolperm_ matstrumpacksetcolperm
#endif
PETSC_EXTERN void matstrumpacksetcolperm_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetColPerm(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpackgetcolperm_ MATSTRUMPACKGETCOLPERM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpackgetcolperm_ matstrumpackgetcolperm
#endif
PETSC_EXTERN void matstrumpackgetcolperm_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatSTRUMPACKGetColPerm(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetgpu_ MATSTRUMPACKSETGPU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetgpu_ matstrumpacksetgpu
#endif
PETSC_EXTERN void matstrumpacksetgpu_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetGPU(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpackgetgpu_ MATSTRUMPACKGETGPU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpackgetgpu_ matstrumpackgetgpu
#endif
PETSC_EXTERN void matstrumpackgetgpu_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatSTRUMPACKGetGPU(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetcompression_ MATSTRUMPACKSETCOMPRESSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetcompression_ matstrumpacksetcompression
#endif
PETSC_EXTERN void matstrumpacksetcompression_(Mat *a, MatSTRUMPACKCompressionType *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetCompression(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpackgetcompression_ MATSTRUMPACKGETCOMPRESSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpackgetcompression_ matstrumpackgetcompression
#endif
PETSC_EXTERN void matstrumpackgetcompression_(Mat *a, MatSTRUMPACKCompressionType *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKGetCompression(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetcompreltol_ MATSTRUMPACKSETCOMPRELTOL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetcompreltol_ matstrumpacksetcompreltol
#endif
PETSC_EXTERN void matstrumpacksetcompreltol_(Mat *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetCompRelTol(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpackgetcompreltol_ MATSTRUMPACKGETCOMPRELTOL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpackgetcompreltol_ matstrumpackgetcompreltol
#endif
PETSC_EXTERN void matstrumpackgetcompreltol_(Mat *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = MatSTRUMPACKGetCompRelTol(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetcompabstol_ MATSTRUMPACKSETCOMPABSTOL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetcompabstol_ matstrumpacksetcompabstol
#endif
PETSC_EXTERN void matstrumpacksetcompabstol_(Mat *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetCompAbsTol(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpackgetcompabstol_ MATSTRUMPACKGETCOMPABSTOL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpackgetcompabstol_ matstrumpackgetcompabstol
#endif
PETSC_EXTERN void matstrumpackgetcompabstol_(Mat *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = MatSTRUMPACKGetCompAbsTol(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetcompleafsize_ MATSTRUMPACKSETCOMPLEAFSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetcompleafsize_ matstrumpacksetcompleafsize
#endif
PETSC_EXTERN void matstrumpacksetcompleafsize_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetCompLeafSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpackgetcompleafsize_ MATSTRUMPACKGETCOMPLEAFSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpackgetcompleafsize_ matstrumpackgetcompleafsize
#endif
PETSC_EXTERN void matstrumpackgetcompleafsize_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatSTRUMPACKGetCompLeafSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetgeometricnxyz_ MATSTRUMPACKSETGEOMETRICNXYZ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetgeometricnxyz_ matstrumpacksetgeometricnxyz
#endif
PETSC_EXTERN void matstrumpacksetgeometricnxyz_(Mat *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetGeometricNxyz(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetgeometriccomponents_ MATSTRUMPACKSETGEOMETRICCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetgeometriccomponents_ matstrumpacksetgeometriccomponents
#endif
PETSC_EXTERN void matstrumpacksetgeometriccomponents_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetGeometricComponents(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetgeometricwidth_ MATSTRUMPACKSETGEOMETRICWIDTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetgeometricwidth_ matstrumpacksetgeometricwidth
#endif
PETSC_EXTERN void matstrumpacksetgeometricwidth_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetGeometricWidth(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetcompminsepsize_ MATSTRUMPACKSETCOMPMINSEPSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetcompminsepsize_ matstrumpacksetcompminsepsize
#endif
PETSC_EXTERN void matstrumpacksetcompminsepsize_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetCompMinSepSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpackgetcompminsepsize_ MATSTRUMPACKGETCOMPMINSEPSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpackgetcompminsepsize_ matstrumpackgetcompminsepsize
#endif
PETSC_EXTERN void matstrumpackgetcompminsepsize_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatSTRUMPACKGetCompMinSepSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetcomplossyprecision_ MATSTRUMPACKSETCOMPLOSSYPRECISION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetcomplossyprecision_ matstrumpacksetcomplossyprecision
#endif
PETSC_EXTERN void matstrumpacksetcomplossyprecision_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetCompLossyPrecision(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpackgetcomplossyprecision_ MATSTRUMPACKGETCOMPLOSSYPRECISION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpackgetcomplossyprecision_ matstrumpackgetcomplossyprecision
#endif
PETSC_EXTERN void matstrumpackgetcomplossyprecision_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatSTRUMPACKGetCompLossyPrecision(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpacksetcompbutterflylevels_ MATSTRUMPACKSETCOMPBUTTERFLYLEVELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpacksetcompbutterflylevels_ matstrumpacksetcompbutterflylevels
#endif
PETSC_EXTERN void matstrumpacksetcompbutterflylevels_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatSTRUMPACKSetCompButterflyLevels(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matstrumpackgetcompbutterflylevels_ MATSTRUMPACKGETCOMPBUTTERFLYLEVELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matstrumpackgetcompbutterflylevels_ matstrumpackgetcompbutterflylevels
#endif
PETSC_EXTERN void matstrumpackgetcompbutterflylevels_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatSTRUMPACKGetCompButterflyLevels(*a, b);
  if (*ierr) return;
}
