#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taovecgetsubvec_ TAOVECGETSUBVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taovecgetsubvec_ taovecgetsubvec
#endif
PETSC_EXTERN void taovecgetsubvec_(Vec *a, IS *b, TaoSubsetType *c, PetscReal *d, Vec *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = TaoVecGetSubVec(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomatgetsubmat_ TAOMATGETSUBMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomatgetsubmat_ taomatgetsubmat
#endif
PETSC_EXTERN void taomatgetsubmat_(Mat *a, IS *b, Vec *c, TaoSubsetType *d, Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = TaoMatGetSubMat(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoestimateactivebounds_ TAOESTIMATEACTIVEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoestimateactivebounds_ taoestimateactivebounds
#endif
PETSC_EXTERN void taoestimateactivebounds_(Vec *a, Vec *b, Vec *c, Vec *d, Vec *e, Vec *f, PetscReal *g, PetscReal *h, IS *i, IS *j, IS *k, IS *l, IS *m, PetscErrorCode *ierr)
{
  PetscBool null_i = !*(void**) i ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_j = !*(void**) j ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_k = !*(void**) k ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_l = !*(void**) l ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_m = !*(void**) m ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLREAL(h);
  CHKFORTRANNULLOBJECT(i);
  CHKFORTRANNULLOBJECT(j);
  CHKFORTRANNULLOBJECT(k);
  CHKFORTRANNULLOBJECT(l);
  CHKFORTRANNULLOBJECT(m);
  *ierr = TaoEstimateActiveBounds(*a, *b, *c, *d, *e, *f, *g, h, i, j, k, l, m);
  if (*ierr) return;
  if (! null_i && !*(void**) i) *(void **) i = (void *)-2;
  if (! null_j && !*(void**) j) *(void **) j = (void *)-2;
  if (! null_k && !*(void**) k) *(void **) k = (void *)-2;
  if (! null_l && !*(void**) l) *(void **) l = (void *)-2;
  if (! null_m && !*(void**) m) *(void **) m = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoboundstep_ TAOBOUNDSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoboundstep_ taoboundstep
#endif
PETSC_EXTERN void taoboundstep_(Vec *a, Vec *b, Vec *c, IS *d, IS *e, IS *f, PetscReal *g, Vec *h, PetscErrorCode *ierr)
{
  *ierr = TaoBoundStep(*a, *b, *c, *d, *e, *f, *g, *h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoboundsolution_ TAOBOUNDSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoboundsolution_ taoboundsolution
#endif
PETSC_EXTERN void taoboundsolution_(Vec *a, Vec *b, Vec *c, PetscReal *d, PetscInt *e, Vec *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  *ierr = TaoBoundSolution(*a, *b, *c, *d, e, *f);
  if (*ierr) return;
}
