#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpythonfinalize_ PETSCPYTHONFINALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpythonfinalize_ petscpythonfinalize
#endif
PETSC_EXTERN void petscpythonfinalize_(PetscErrorCode *ierr)
{
  *ierr = PetscPythonFinalize();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpythoninitialize_ PETSCPYTHONINITIALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpythoninitialize_ petscpythoninitialize
#endif
PETSC_EXTERN void petscpythoninitialize_(char a[], char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscPythonInitialize(c_a, c_b);
  if (*ierr) return;
  FREECHAR(a, c_a);
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpythonprinterror_ PETSCPYTHONPRINTERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpythonprinterror_ petscpythonprinterror
#endif
PETSC_EXTERN void petscpythonprinterror_(PetscErrorCode *ierr)
{
  *ierr = PetscPythonPrintError();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpythonmonitorset_ PETSCPYTHONMONITORSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpythonmonitorset_ petscpythonmonitorset
#endif
PETSC_EXTERN void petscpythonmonitorset_(PetscObject *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscPythonMonitorSet(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
