#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecnestgetsubvec_ VECNESTGETSUBVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecnestgetsubvec_ vecnestgetsubvec
#endif
PETSC_EXTERN void vecnestgetsubvec_(Vec *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = VecNestGetSubVec(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecnestsetsubvec_ VECNESTSETSUBVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecnestsetsubvec_ vecnestsetsubvec
#endif
PETSC_EXTERN void vecnestsetsubvec_(Vec *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = VecNestSetSubVec(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecnestsetsubvecs_ VECNESTSETSUBVECS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecnestsetsubvecs_ vecnestsetsubvecs
#endif
PETSC_EXTERN void vecnestsetsubvecs_(Vec *a, PetscInt *b, PetscInt c[], Vec d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = VecNestSetSubVecs(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecnestgetsize_ VECNESTGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecnestgetsize_ vecnestgetsize
#endif
PETSC_EXTERN void vecnestgetsize_(Vec *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = VecNestGetSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreatenest_ VECCREATENEST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreatenest_ veccreatenest
#endif
PETSC_EXTERN void veccreatenest_(MPI_Fint *a, PetscInt *b, IS c[], Vec d[], Vec *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = VecCreateNest(MPI_Comm_f2c(*(a)), *b, c, d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
