#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlggetaxis_ PETSCDRAWLGGETAXIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlggetaxis_ petscdrawlggetaxis
#endif
PETSC_EXTERN void petscdrawlggetaxis_(PetscDrawLG *a, PetscDrawAxis *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawLGGetAxis(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlggetdraw_ PETSCDRAWLGGETDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlggetdraw_ petscdrawlggetdraw
#endif
PETSC_EXTERN void petscdrawlggetdraw_(PetscDrawLG *a, PetscDraw *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawLGGetDraw(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgspdraw_ PETSCDRAWLGSPDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgspdraw_ petscdrawlgspdraw
#endif
PETSC_EXTERN void petscdrawlgspdraw_(PetscDrawLG *a, PetscDrawSP *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawLGSPDraw(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgcreate_ PETSCDRAWLGCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgcreate_ petscdrawlgcreate
#endif
PETSC_EXTERN void petscdrawlgcreate_(PetscDraw *a, PetscInt *b, PetscDrawLG *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDrawLGCreate(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgsetcolors_ PETSCDRAWLGSETCOLORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgsetcolors_ petscdrawlgsetcolors
#endif
PETSC_EXTERN void petscdrawlgsetcolors_(PetscDrawLG *a, const int b[], PetscErrorCode *ierr)
{
  *ierr = PetscDrawLGSetColors(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlggetdimension_ PETSCDRAWLGGETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlggetdimension_ petscdrawlggetdimension
#endif
PETSC_EXTERN void petscdrawlggetdimension_(PetscDrawLG *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDrawLGGetDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgsetdimension_ PETSCDRAWLGSETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgsetdimension_ petscdrawlgsetdimension
#endif
PETSC_EXTERN void petscdrawlgsetdimension_(PetscDrawLG *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawLGSetDimension(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgsetlimits_ PETSCDRAWLGSETLIMITS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgsetlimits_ petscdrawlgsetlimits
#endif
PETSC_EXTERN void petscdrawlgsetlimits_(PetscDrawLG *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  *ierr = PetscDrawLGSetLimits(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgreset_ PETSCDRAWLGRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgreset_ petscdrawlgreset
#endif
PETSC_EXTERN void petscdrawlgreset_(PetscDrawLG *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawLGReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgdestroy_ PETSCDRAWLGDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgdestroy_ petscdrawlgdestroy
#endif
PETSC_EXTERN void petscdrawlgdestroy_(PetscDrawLG *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscDrawLGDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgsetusemarkers_ PETSCDRAWLGSETUSEMARKERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgsetusemarkers_ petscdrawlgsetusemarkers
#endif
PETSC_EXTERN void petscdrawlgsetusemarkers_(PetscDrawLG *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawLGSetUseMarkers(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgdraw_ PETSCDRAWLGDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgdraw_ petscdrawlgdraw
#endif
PETSC_EXTERN void petscdrawlgdraw_(PetscDrawLG *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawLGDraw(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgsave_ PETSCDRAWLGSAVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgsave_ petscdrawlgsave
#endif
PETSC_EXTERN void petscdrawlgsave_(PetscDrawLG *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawLGSave(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgview_ PETSCDRAWLGVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgview_ petscdrawlgview
#endif
PETSC_EXTERN void petscdrawlgview_(PetscDrawLG *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscDrawLGView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgsetoptionsprefix_ PETSCDRAWLGSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgsetoptionsprefix_ petscdrawlgsetoptionsprefix
#endif
PETSC_EXTERN void petscdrawlgsetoptionsprefix_(PetscDrawLG *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscDrawLGSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlgsetfromoptions_ PETSCDRAWLGSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlgsetfromoptions_ petscdrawlgsetfromoptions
#endif
PETSC_EXTERN void petscdrawlgsetfromoptions_(PetscDrawLG *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawLGSetFromOptions(*a);
  if (*ierr) return;
}
