#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpythonsettype_ MATPYTHONSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpythonsettype_ matpythonsettype
#endif
PETSC_EXTERN void matpythonsettype_(Mat *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatPythonSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpythongettype_ MATPYTHONGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpythongettype_ matpythongettype
#endif
PETSC_EXTERN void matpythongettype_(Mat *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = MatPythonGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matpythoncreate_ MATPYTHONCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matpythoncreate_ matpythoncreate
#endif
PETSC_EXTERN void matpythoncreate_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, char f[], Mat *g, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_f)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(g);
  char* c_f;
  FIXCHAR(f, l_f, c_f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = MatPythonCreate(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, c_f, g);
  if (*ierr) return;
  FREECHAR(f, c_f);
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
