#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetblockfills_ DMDASETBLOCKFILLS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetblockfills_ dmdasetblockfills
#endif
PETSC_EXTERN void dmdasetblockfills_(DM *a, const PetscInt *b, const PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMDASetBlockFills(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetblockfillssparse_ DMDASETBLOCKFILLSSPARSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetblockfillssparse_ dmdasetblockfillssparse
#endif
PETSC_EXTERN void dmdasetblockfillssparse_(DM *a, const PetscInt *b, const PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMDASetBlockFillsSparse(*a, b, c);
  if (*ierr) return;
}
