#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointqueuecreate_ DMPLEXPOINTQUEUECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointqueuecreate_ dmplexpointqueuecreate
#endif
PETSC_EXTERN void dmplexpointqueuecreate_(PetscInt *a, DMPlexPointQueue *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexPointQueueCreate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointqueuedestroy_ DMPLEXPOINTQUEUEDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointqueuedestroy_ dmplexpointqueuedestroy
#endif
PETSC_EXTERN void dmplexpointqueuedestroy_(DMPlexPointQueue *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = DMPlexPointQueueDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointqueueensuresize_ DMPLEXPOINTQUEUEENSURESIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointqueueensuresize_ dmplexpointqueueensuresize
#endif
PETSC_EXTERN void dmplexpointqueueensuresize_(DMPlexPointQueue *a, PetscErrorCode *ierr)
{
  *ierr = DMPlexPointQueueEnsureSize(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointqueueenqueue_ DMPLEXPOINTQUEUEENQUEUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointqueueenqueue_ dmplexpointqueueenqueue
#endif
PETSC_EXTERN void dmplexpointqueueenqueue_(DMPlexPointQueue *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexPointQueueEnqueue(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointqueuedequeue_ DMPLEXPOINTQUEUEDEQUEUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointqueuedequeue_ dmplexpointqueuedequeue
#endif
PETSC_EXTERN void dmplexpointqueuedequeue_(DMPlexPointQueue *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexPointQueueDequeue(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointqueuefront_ DMPLEXPOINTQUEUEFRONT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointqueuefront_ dmplexpointqueuefront
#endif
PETSC_EXTERN void dmplexpointqueuefront_(DMPlexPointQueue *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexPointQueueFront(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointqueueback_ DMPLEXPOINTQUEUEBACK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointqueueback_ dmplexpointqueueback
#endif
PETSC_EXTERN void dmplexpointqueueback_(DMPlexPointQueue *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexPointQueueBack(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointqueueemptycollective_ DMPLEXPOINTQUEUEEMPTYCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointqueueemptycollective_ dmplexpointqueueemptycollective
#endif
PETSC_EXTERN void dmplexpointqueueemptycollective_(PetscObject *a, DMPlexPointQueue *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = DMPlexPointQueueEmptyCollective(*a, *b, c);
  if (*ierr) return;
}
