#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aocreatememoryscalable_ AOCREATEMEMORYSCALABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aocreatememoryscalable_ aocreatememoryscalable
#endif
PETSC_EXTERN void aocreatememoryscalable_(MPI_Fint *a, PetscInt *b, const PetscInt c[], const PetscInt d[], AO *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = AOCreateMemoryScalable(MPI_Comm_f2c(*(a)), *b, c, d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aocreatememoryscalableis_ AOCREATEMEMORYSCALABLEIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aocreatememoryscalableis_ aocreatememoryscalableis
#endif
PETSC_EXTERN void aocreatememoryscalableis_(IS *a, IS *b, AO *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = AOCreateMemoryScalableIS(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
