#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsarkimexregisterdestroy_ TSARKIMEXREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsarkimexregisterdestroy_ tsarkimexregisterdestroy
#endif
PETSC_EXTERN void tsarkimexregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = TSARKIMEXRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsarkimexinitializepackage_ TSARKIMEXINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsarkimexinitializepackage_ tsarkimexinitializepackage
#endif
PETSC_EXTERN void tsarkimexinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = TSARKIMEXInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsarkimexfinalizepackage_ TSARKIMEXFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsarkimexfinalizepackage_ tsarkimexfinalizepackage
#endif
PETSC_EXTERN void tsarkimexfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = TSARKIMEXFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsarkimexregister_ TSARKIMEXREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsarkimexregister_ tsarkimexregister
#endif
PETSC_EXTERN void tsarkimexregister_(char * a, PetscInt *b, PetscInt *c, const PetscReal d[], const PetscReal e[], const PetscReal f[], const PetscReal g[], const PetscReal h[], const PetscReal i[], const PetscReal j[], const PetscReal k[], PetscInt *l, const PetscReal m[], const PetscReal n[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  CHKFORTRANNULLREAL(h);
  CHKFORTRANNULLREAL(i);
  CHKFORTRANNULLREAL(j);
  CHKFORTRANNULLREAL(k);
  CHKFORTRANNULLREAL(m);
  CHKFORTRANNULLREAL(n);
  *ierr = TSARKIMEXRegister(c_a, *b, *c, d, e, f, g, h, i, j, k, *l, m, n);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsdirkregister_ TSDIRKREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsdirkregister_ tsdirkregister
#endif
PETSC_EXTERN void tsdirkregister_(char * a, PetscInt *b, PetscInt *c, const PetscReal d[], const PetscReal e[], const PetscReal f[], const PetscReal g[], PetscInt *h, const PetscReal i[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  CHKFORTRANNULLREAL(i);
  *ierr = TSDIRKRegister(c_a, *b, *c, d, e, f, g, *h, i);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsarkimexsettype_ TSARKIMEXSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsarkimexsettype_ tsarkimexsettype
#endif
PETSC_EXTERN void tsarkimexsettype_(TS *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSARKIMEXSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsarkimexgettype_ TSARKIMEXGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsarkimexgettype_ tsarkimexgettype
#endif
PETSC_EXTERN void tsarkimexgettype_(TS *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TSARKIMEXGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsarkimexsetfullyimplicit_ TSARKIMEXSETFULLYIMPLICIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsarkimexsetfullyimplicit_ tsarkimexsetfullyimplicit
#endif
PETSC_EXTERN void tsarkimexsetfullyimplicit_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSARKIMEXSetFullyImplicit(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsarkimexgetfullyimplicit_ TSARKIMEXGETFULLYIMPLICIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsarkimexgetfullyimplicit_ tsarkimexgetfullyimplicit
#endif
PETSC_EXTERN void tsarkimexgetfullyimplicit_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TSARKIMEXGetFullyImplicit(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsdirksettype_ TSDIRKSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsdirksettype_ tsdirksettype
#endif
PETSC_EXTERN void tsdirksettype_(TS *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSDIRKSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsdirkgettype_ TSDIRKGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsdirkgettype_ tsdirkgettype
#endif
PETSC_EXTERN void tsdirkgettype_(TS *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TSDIRKGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsarkimexsetfastslowsplit_ TSARKIMEXSETFASTSLOWSPLIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsarkimexsetfastslowsplit_ tsarkimexsetfastslowsplit
#endif
PETSC_EXTERN void tsarkimexsetfastslowsplit_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSARKIMEXSetFastSlowSplit(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsarkimexgetfastslowsplit_ TSARKIMEXGETFASTSLOWSPLIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsarkimexgetfastslowsplit_ tsarkimexgetfastslowsplit
#endif
PETSC_EXTERN void tsarkimexgetfastslowsplit_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TSARKIMEXGetFastSlowSplit(*a, b);
  if (*ierr) return;
}
