#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmvectordefinefield_ DMSWARMVECTORDEFINEFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmvectordefinefield_ dmswarmvectordefinefield
#endif
PETSC_EXTERN void dmswarmvectordefinefield_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSwarmVectorDefineField(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmvectordefinefields_ DMSWARMVECTORDEFINEFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmvectordefinefields_ dmswarmvectordefinefields
#endif
PETSC_EXTERN void dmswarmvectordefinefields_(DM *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  *ierr = DMSwarmVectorDefineFields(*a, *b, (const char **)&c_c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcreatemassmatrixsquare_ DMSWARMCREATEMASSMATRIXSQUARE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcreatemassmatrixsquare_ dmswarmcreatemassmatrixsquare
#endif
PETSC_EXTERN void dmswarmcreatemassmatrixsquare_(DM *a, DM *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMSwarmCreateMassMatrixSquare(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcreateglobalvectorfromfield_ DMSWARMCREATEGLOBALVECTORFROMFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcreateglobalvectorfromfield_ dmswarmcreateglobalvectorfromfield
#endif
PETSC_EXTERN void dmswarmcreateglobalvectorfromfield_(DM *a, char b[], Vec *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMSwarmCreateGlobalVectorFromField(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmdestroyglobalvectorfromfield_ DMSWARMDESTROYGLOBALVECTORFROMFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmdestroyglobalvectorfromfield_ dmswarmdestroyglobalvectorfromfield
#endif
PETSC_EXTERN void dmswarmdestroyglobalvectorfromfield_(DM *a, char b[], Vec *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMSwarmDestroyGlobalVectorFromField(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcreatelocalvectorfromfield_ DMSWARMCREATELOCALVECTORFROMFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcreatelocalvectorfromfield_ dmswarmcreatelocalvectorfromfield
#endif
PETSC_EXTERN void dmswarmcreatelocalvectorfromfield_(DM *a, char b[], Vec *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMSwarmCreateLocalVectorFromField(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmdestroylocalvectorfromfield_ DMSWARMDESTROYLOCALVECTORFROMFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmdestroylocalvectorfromfield_ dmswarmdestroylocalvectorfromfield
#endif
PETSC_EXTERN void dmswarmdestroylocalvectorfromfield_(DM *a, char b[], Vec *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMSwarmDestroyLocalVectorFromField(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcreateglobalvectorfromfields_ DMSWARMCREATEGLOBALVECTORFROMFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcreateglobalvectorfromfields_ dmswarmcreateglobalvectorfromfields
#endif
PETSC_EXTERN void dmswarmcreateglobalvectorfromfields_(DM *a, PetscInt *b, char c[], Vec *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_c = PETSC_NULLPTR;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMSwarmCreateGlobalVectorFromFields(*a, *b, (const char **)&c_c, d);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmdestroyglobalvectorfromfields_ DMSWARMDESTROYGLOBALVECTORFROMFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmdestroyglobalvectorfromfields_ dmswarmdestroyglobalvectorfromfields
#endif
PETSC_EXTERN void dmswarmdestroyglobalvectorfromfields_(DM *a, PetscInt *b, char c[], Vec *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_c = PETSC_NULLPTR;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMSwarmDestroyGlobalVectorFromFields(*a, *b, (const char **)&c_c, d);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcreatelocalvectorfromfields_ DMSWARMCREATELOCALVECTORFROMFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcreatelocalvectorfromfields_ dmswarmcreatelocalvectorfromfields
#endif
PETSC_EXTERN void dmswarmcreatelocalvectorfromfields_(DM *a, PetscInt *b, char c[], Vec *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_c = PETSC_NULLPTR;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMSwarmCreateLocalVectorFromFields(*a, *b, (const char **)&c_c, d);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmdestroylocalvectorfromfields_ DMSWARMDESTROYLOCALVECTORFROMFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmdestroylocalvectorfromfields_ dmswarmdestroylocalvectorfromfields
#endif
PETSC_EXTERN void dmswarmdestroylocalvectorfromfields_(DM *a, PetscInt *b, char c[], Vec *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_c = PETSC_NULLPTR;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMSwarmDestroyLocalVectorFromFields(*a, *b, (const char **)&c_c, d);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarminitializefieldregister_ DMSWARMINITIALIZEFIELDREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarminitializefieldregister_ dmswarminitializefieldregister
#endif
PETSC_EXTERN void dmswarminitializefieldregister_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMSwarmInitializeFieldRegister(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmfinalizefieldregister_ DMSWARMFINALIZEFIELDREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmfinalizefieldregister_ dmswarmfinalizefieldregister
#endif
PETSC_EXTERN void dmswarmfinalizefieldregister_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMSwarmFinalizeFieldRegister(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsetlocalsizes_ DMSWARMSETLOCALSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsetlocalsizes_ dmswarmsetlocalsizes
#endif
PETSC_EXTERN void dmswarmsetlocalsizes_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMSwarmSetLocalSizes(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsetcelldm_ DMSWARMSETCELLDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsetcelldm_ dmswarmsetcelldm
#endif
PETSC_EXTERN void dmswarmsetcelldm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMSwarmSetCellDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmgetcelldm_ DMSWARMGETCELLDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmgetcelldm_ dmswarmgetcelldm
#endif
PETSC_EXTERN void dmswarmgetcelldm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMSwarmGetCellDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsetcelldmactive_ DMSWARMSETCELLDMACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsetcelldmactive_ dmswarmsetcelldmactive
#endif
PETSC_EXTERN void dmswarmsetcelldmactive_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSwarmSetCellDMActive(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmgetcelldmactive_ DMSWARMGETCELLDMACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmgetcelldmactive_ dmswarmgetcelldmactive
#endif
PETSC_EXTERN void dmswarmgetcelldmactive_(DM *a, DMSwarmCellDM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMSwarmGetCellDMActive(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmgetcelldmbyname_ DMSWARMGETCELLDMBYNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmgetcelldmbyname_ dmswarmgetcelldmbyname
#endif
PETSC_EXTERN void dmswarmgetcelldmbyname_(DM *a, char b[], DMSwarmCellDM *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMSwarmGetCellDMByName(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmaddcelldm_ DMSWARMADDCELLDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmaddcelldm_ dmswarmaddcelldm
#endif
PETSC_EXTERN void dmswarmaddcelldm_(DM *a, DMSwarmCellDM *b, PetscErrorCode *ierr)
{
  *ierr = DMSwarmAddCellDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmgetlocalsize_ DMSWARMGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmgetlocalsize_ dmswarmgetlocalsize
#endif
PETSC_EXTERN void dmswarmgetlocalsize_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMSwarmGetLocalSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmgetsize_ DMSWARMGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmgetsize_ dmswarmgetsize
#endif
PETSC_EXTERN void dmswarmgetsize_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMSwarmGetSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmregisterpetscdatatypefield_ DMSWARMREGISTERPETSCDATATYPEFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmregisterpetscdatatypefield_ dmswarmregisterpetscdatatypefield
#endif
PETSC_EXTERN void dmswarmregisterpetscdatatypefield_(DM *a, char b[], PetscInt *c, PetscDataType *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSwarmRegisterPetscDatatypeField(*a, c_b, *c, *d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmregisteruserstructfield_ DMSWARMREGISTERUSERSTRUCTFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmregisteruserstructfield_ dmswarmregisteruserstructfield
#endif
PETSC_EXTERN void dmswarmregisteruserstructfield_(DM *a, char b[], size_t *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSwarmRegisterUserStructField(*a, c_b, *c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmregisteruserdatatypefield_ DMSWARMREGISTERUSERDATATYPEFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmregisteruserdatatypefield_ dmswarmregisteruserdatatypefield
#endif
PETSC_EXTERN void dmswarmregisteruserdatatypefield_(DM *a, char b[], size_t *c, PetscInt *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMSwarmRegisterUserDatatypeField(*a, c_b, *c, *d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmgetfieldinfo_ DMSWARMGETFIELDINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmgetfieldinfo_ dmswarmgetfieldinfo
#endif
PETSC_EXTERN void dmswarmgetfieldinfo_(DM *a, char b[], PetscInt *c, PetscDataType *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMSwarmGetFieldInfo(*a, c_b, c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmaddpoint_ DMSWARMADDPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmaddpoint_ dmswarmaddpoint
#endif
PETSC_EXTERN void dmswarmaddpoint_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMSwarmAddPoint(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmaddnpoints_ DMSWARMADDNPOINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmaddnpoints_ dmswarmaddnpoints
#endif
PETSC_EXTERN void dmswarmaddnpoints_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMSwarmAddNPoints(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmremovepoint_ DMSWARMREMOVEPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmremovepoint_ dmswarmremovepoint
#endif
PETSC_EXTERN void dmswarmremovepoint_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMSwarmRemovePoint(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmremovepointatindex_ DMSWARMREMOVEPOINTATINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmremovepointatindex_ dmswarmremovepointatindex
#endif
PETSC_EXTERN void dmswarmremovepointatindex_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMSwarmRemovePointAtIndex(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcopypoint_ DMSWARMCOPYPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcopypoint_ dmswarmcopypoint
#endif
PETSC_EXTERN void dmswarmcopypoint_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMSwarmCopyPoint(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmmigrate_ DMSWARMMIGRATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmmigrate_ dmswarmmigrate
#endif
PETSC_EXTERN void dmswarmmigrate_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMSwarmMigrate(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcollectviewcreate_ DMSWARMCOLLECTVIEWCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcollectviewcreate_ dmswarmcollectviewcreate
#endif
PETSC_EXTERN void dmswarmcollectviewcreate_(DM *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_CREATE(a);
  *ierr = DMSwarmCollectViewCreate(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcollectviewdestroy_ DMSWARMCOLLECTVIEWDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcollectviewdestroy_ dmswarmcollectviewdestroy
#endif
PETSC_EXTERN void dmswarmcollectviewdestroy_(DM *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  *ierr = DMSwarmCollectViewDestroy(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsetpointcoordinatesrandom_ DMSWARMSETPOINTCOORDINATESRANDOM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsetpointcoordinatesrandom_ dmswarmsetpointcoordinatesrandom
#endif
PETSC_EXTERN void dmswarmsetpointcoordinatesrandom_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMSwarmSetPointCoordinatesRandom(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmgettype_ DMSWARMGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmgettype_ dmswarmgettype
#endif
PETSC_EXTERN void dmswarmgettype_(DM *a, DMSwarmType *b, PetscErrorCode *ierr)
{
  *ierr = DMSwarmGetType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmsettype_ DMSWARMSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmsettype_ dmswarmsettype
#endif
PETSC_EXTERN void dmswarmsettype_(DM *a, DMSwarmType *b, PetscErrorCode *ierr)
{
  *ierr = DMSwarmSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmgetcellswarm_ DMSWARMGETCELLSWARM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmgetcellswarm_ dmswarmgetcellswarm
#endif
PETSC_EXTERN void dmswarmgetcellswarm_(DM *a, PetscInt *b, DM *c, PetscErrorCode *ierr)
{
  *ierr = DMSwarmGetCellSwarm(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmrestorecellswarm_ DMSWARMRESTORECELLSWARM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmrestorecellswarm_ dmswarmrestorecellswarm
#endif
PETSC_EXTERN void dmswarmrestorecellswarm_(DM *a, PetscInt *b, DM *c, PetscErrorCode *ierr)
{
  *ierr = DMSwarmRestoreCellSwarm(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmcomputemoments_ DMSWARMCOMPUTEMOMENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmcomputemoments_ dmswarmcomputemoments
#endif
PETSC_EXTERN void dmswarmcomputemoments_(DM *a, char b[], char c[], PetscReal d[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLREAL(d);
  *ierr = DMSwarmComputeMoments(*a, c_b, c_c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmreplace_ DMSWARMREPLACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmreplace_ dmswarmreplace
#endif
PETSC_EXTERN void dmswarmreplace_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMSwarmReplace(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmduplicate_ DMSWARMDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmduplicate_ dmswarmduplicate
#endif
PETSC_EXTERN void dmswarmduplicate_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMSwarmDuplicate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
