#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetpartitioner_ DMPLEXGETPARTITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetpartitioner_ dmplexgetpartitioner
#endif
PETSC_EXTERN void dmplexgetpartitioner_(DM *a, PetscPartitioner *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetPartitioner(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetpartitioner_ DMPLEXSETPARTITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetpartitioner_ dmplexsetpartitioner
#endif
PETSC_EXTERN void dmplexsetpartitioner_(DM *a, PetscPartitioner *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetPartitioner(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpartitionlabelclosure_ DMPLEXPARTITIONLABELCLOSURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpartitionlabelclosure_ dmplexpartitionlabelclosure
#endif
PETSC_EXTERN void dmplexpartitionlabelclosure_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexPartitionLabelClosure(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpartitionlabeladjacency_ DMPLEXPARTITIONLABELADJACENCY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpartitionlabeladjacency_ dmplexpartitionlabeladjacency
#endif
PETSC_EXTERN void dmplexpartitionlabeladjacency_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexPartitionLabelAdjacency(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpartitionlabelpropagate_ DMPLEXPARTITIONLABELPROPAGATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpartitionlabelpropagate_ dmplexpartitionlabelpropagate
#endif
PETSC_EXTERN void dmplexpartitionlabelpropagate_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexPartitionLabelPropagate(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpartitionlabelinvert_ DMPLEXPARTITIONLABELINVERT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpartitionlabelinvert_ dmplexpartitionlabelinvert
#endif
PETSC_EXTERN void dmplexpartitionlabelinvert_(DM *a, DMLabel *b, PetscSF *c, DMLabel *d, PetscErrorCode *ierr)
{
  *ierr = DMPlexPartitionLabelInvert(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpartitionlabelcreatesf_ DMPLEXPARTITIONLABELCREATESF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpartitionlabelcreatesf_ dmplexpartitionlabelcreatesf
#endif
PETSC_EXTERN void dmplexpartitionlabelcreatesf_(DM *a, DMLabel *b, PetscBool *c, PetscSF *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexPartitionLabelCreateSF(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexrebalancesharedpoints_ DMPLEXREBALANCESHAREDPOINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexrebalancesharedpoints_ dmplexrebalancesharedpoints
#endif
PETSC_EXTERN void dmplexrebalancesharedpoints_(DM *a, PetscInt *b, PetscBool *c, PetscBool *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(e);
  *ierr = DMPlexRebalanceSharedPoints(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d ? PETSC_TRUE : PETSC_FALSE, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpartitionerdmplexpartition_ PETSCPARTITIONERDMPLEXPARTITION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpartitionerdmplexpartition_ petscpartitionerdmplexpartition
#endif
PETSC_EXTERN void petscpartitionerdmplexpartition_(PetscPartitioner *a, DM *b, PetscSection *c, PetscSection *d, IS *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscPartitionerDMPlexPartition(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
