#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscstring.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmemcmp_ PETSCMEMCMP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmemcmp_ petscmemcmp
#endif
PETSC_EXTERN void petscmemcmp_(const void *a, const void *b, size_t *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscMemcmp(a, b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscprocessplacementview_ PETSCPROCESSPLACEMENTVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscprocessplacementview_ petscprocessplacementview
#endif
PETSC_EXTERN void petscprocessplacementview_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscProcessPlacementView(v_a);
  if (*ierr) return;
}
