#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetplex_ DMNETWORKGETPLEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetplex_ dmnetworkgetplex
#endif
PETSC_EXTERN void dmnetworkgetplex_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMNetworkGetPlex(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetnumsubnetworks_ DMNETWORKGETNUMSUBNETWORKS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetnumsubnetworks_ dmnetworkgetnumsubnetworks
#endif
PETSC_EXTERN void dmnetworkgetnumsubnetworks_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMNetworkGetNumSubNetworks(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworksetnumsubnetworks_ DMNETWORKSETNUMSUBNETWORKS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworksetnumsubnetworks_ dmnetworksetnumsubnetworks
#endif
PETSC_EXTERN void dmnetworksetnumsubnetworks_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMNetworkSetNumSubNetworks(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkaddsubnetwork_ DMNETWORKADDSUBNETWORK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkaddsubnetwork_ dmnetworkaddsubnetwork
#endif
PETSC_EXTERN void dmnetworkaddsubnetwork_(DM *a, char b[], PetscInt *c, PetscInt d[], PetscInt *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMNetworkAddSubnetwork(*a, c_b, *c, d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworklayoutsetup_ DMNETWORKLAYOUTSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworklayoutsetup_ dmnetworklayoutsetup
#endif
PETSC_EXTERN void dmnetworklayoutsetup_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMNetworkLayoutSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkaddsharedvertices_ DMNETWORKADDSHAREDVERTICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkaddsharedvertices_ dmnetworkaddsharedvertices
#endif
PETSC_EXTERN void dmnetworkaddsharedvertices_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt e[], PetscInt f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  *ierr = DMNetworkAddSharedVertices(*a, *b, *c, *d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkregistercomponent_ DMNETWORKREGISTERCOMPONENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkregistercomponent_ dmnetworkregistercomponent
#endif
PETSC_EXTERN void dmnetworkregistercomponent_(DM *a, char b[], size_t *c, PetscInt *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMNetworkRegisterComponent(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetnumvertices_ DMNETWORKGETNUMVERTICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetnumvertices_ dmnetworkgetnumvertices
#endif
PETSC_EXTERN void dmnetworkgetnumvertices_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMNetworkGetNumVertices(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetnumedges_ DMNETWORKGETNUMEDGES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetnumedges_ dmnetworkgetnumedges
#endif
PETSC_EXTERN void dmnetworkgetnumedges_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMNetworkGetNumEdges(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetvertexrange_ DMNETWORKGETVERTEXRANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetvertexrange_ dmnetworkgetvertexrange
#endif
PETSC_EXTERN void dmnetworkgetvertexrange_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMNetworkGetVertexRange(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetedgerange_ DMNETWORKGETEDGERANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetedgerange_ dmnetworkgetedgerange
#endif
PETSC_EXTERN void dmnetworkgetedgerange_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMNetworkGetEdgeRange(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetglobaledgeindex_ DMNETWORKGETGLOBALEDGEINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetglobaledgeindex_ dmnetworkgetglobaledgeindex
#endif
PETSC_EXTERN void dmnetworkgetglobaledgeindex_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMNetworkGetGlobalEdgeIndex(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetglobalvertexindex_ DMNETWORKGETGLOBALVERTEXINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetglobalvertexindex_ dmnetworkgetglobalvertexindex
#endif
PETSC_EXTERN void dmnetworkgetglobalvertexindex_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMNetworkGetGlobalVertexIndex(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetnumcomponents_ DMNETWORKGETNUMCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetnumcomponents_ dmnetworkgetnumcomponents
#endif
PETSC_EXTERN void dmnetworkgetnumcomponents_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMNetworkGetNumComponents(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetlocalvecoffset_ DMNETWORKGETLOCALVECOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetlocalvecoffset_ dmnetworkgetlocalvecoffset
#endif
PETSC_EXTERN void dmnetworkgetlocalvecoffset_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMNetworkGetLocalVecOffset(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetglobalvecoffset_ DMNETWORKGETGLOBALVECOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetglobalvecoffset_ dmnetworkgetglobalvecoffset
#endif
PETSC_EXTERN void dmnetworkgetglobalvecoffset_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMNetworkGetGlobalVecOffset(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetedgeoffset_ DMNETWORKGETEDGEOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetedgeoffset_ dmnetworkgetedgeoffset
#endif
PETSC_EXTERN void dmnetworkgetedgeoffset_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMNetworkGetEdgeOffset(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetvertexoffset_ DMNETWORKGETVERTEXOFFSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetvertexoffset_ dmnetworkgetvertexoffset
#endif
PETSC_EXTERN void dmnetworkgetvertexoffset_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMNetworkGetVertexOffset(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkaddcomponent_ DMNETWORKADDCOMPONENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkaddcomponent_ dmnetworkaddcomponent
#endif
PETSC_EXTERN void dmnetworkaddcomponent_(DM *a, PetscInt *b, PetscInt *c, void *d, PetscInt *e, PetscErrorCode *ierr)
{
  *ierr = DMNetworkAddComponent(*a, *b, *c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetcomponent_ DMNETWORKGETCOMPONENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetcomponent_ dmnetworkgetcomponent
#endif
PETSC_EXTERN void dmnetworkgetcomponent_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PeCtx e, PetscInt *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(f);
  *ierr = DMNetworkGetComponent(*a, *b, *c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkassemblegraphstructures_ DMNETWORKASSEMBLEGRAPHSTRUCTURES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkassemblegraphstructures_ dmnetworkassemblegraphstructures
#endif
PETSC_EXTERN void dmnetworkassemblegraphstructures_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMNetworkAssembleGraphStructures(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkdistribute_ DMNETWORKDISTRIBUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkdistribute_ dmnetworkdistribute
#endif
PETSC_EXTERN void dmnetworkdistribute_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = DMNetworkDistribute(a, *b);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkissharedvertex_ DMNETWORKISSHAREDVERTEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkissharedvertex_ dmnetworkissharedvertex
#endif
PETSC_EXTERN void dmnetworkissharedvertex_(DM *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = DMNetworkIsSharedVertex(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkisghostvertex_ DMNETWORKISGHOSTVERTEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkisghostvertex_ dmnetworkisghostvertex
#endif
PETSC_EXTERN void dmnetworkisghostvertex_(DM *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = DMNetworkIsGhostVertex(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkhasjacobian_ DMNETWORKHASJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkhasjacobian_ dmnetworkhasjacobian
#endif
PETSC_EXTERN void dmnetworkhasjacobian_(DM *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = DMNetworkHasJacobian(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkedgesetmatrix_ DMNETWORKEDGESETMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkedgesetmatrix_ dmnetworkedgesetmatrix
#endif
PETSC_EXTERN void dmnetworkedgesetmatrix_(DM *a, PetscInt *b, Mat c[], PetscErrorCode *ierr)
{
  *ierr = DMNetworkEdgeSetMatrix(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkvertexsetmatrix_ DMNETWORKVERTEXSETMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkvertexsetmatrix_ dmnetworkvertexsetmatrix
#endif
PETSC_EXTERN void dmnetworkvertexsetmatrix_(DM *a, PetscInt *b, Mat c[], PetscErrorCode *ierr)
{
  *ierr = DMNetworkVertexSetMatrix(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkgetvertexlocaltoglobalordering_ DMNETWORKGETVERTEXLOCALTOGLOBALORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkgetvertexlocaltoglobalordering_ dmnetworkgetvertexlocaltoglobalordering
#endif
PETSC_EXTERN void dmnetworkgetvertexlocaltoglobalordering_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMNetworkGetVertexLocalToGlobalOrdering(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworksetvertexlocaltoglobalordering_ DMNETWORKSETVERTEXLOCALTOGLOBALORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworksetvertexlocaltoglobalordering_ dmnetworksetvertexlocaltoglobalordering
#endif
PETSC_EXTERN void dmnetworksetvertexlocaltoglobalordering_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMNetworkSetVertexLocalToGlobalOrdering(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmnetworkfinalizecomponents_ DMNETWORKFINALIZECOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmnetworkfinalizecomponents_ dmnetworkfinalizecomponents
#endif
PETSC_EXTERN void dmnetworkfinalizecomponents_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMNetworkFinalizeComponents(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmnetwork.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsfgetsubsf_ PETSCSFGETSUBSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsfgetsubsf_ petscsfgetsubsf
#endif
PETSC_EXTERN void petscsfgetsubsf_(PetscSF *a, ISLocalToGlobalMapping *b, PetscSF *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSFGetSubSF(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
