#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstatecreate_ PETSCLOGSTATECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstatecreate_ petsclogstatecreate
#endif
PETSC_EXTERN void petsclogstatecreate_(PetscLogState *a, PetscErrorCode *ierr)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(a);
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscLogStateCreate(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstatedestroy_ PETSCLOGSTATEDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstatedestroy_ petsclogstatedestroy
#endif
PETSC_EXTERN void petsclogstatedestroy_(PetscLogState *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscLogStateDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstatestagepush_ PETSCLOGSTATESTAGEPUSH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstatestagepush_ petsclogstatestagepush
#endif
PETSC_EXTERN void petsclogstatestagepush_(PetscLogState *a, PetscLogStage *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateStagePush(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstatestagepop_ PETSCLOGSTATESTAGEPOP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstatestagepop_ petsclogstatestagepop
#endif
PETSC_EXTERN void petsclogstatestagepop_(PetscLogState *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateStagePop(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstategetcurrentstage_ PETSCLOGSTATEGETCURRENTSTAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstategetcurrentstage_ petsclogstategetcurrentstage
#endif
PETSC_EXTERN void petsclogstategetcurrentstage_(PetscLogState *a, PetscLogStage *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateGetCurrentStage(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstatestageregister_ PETSCLOGSTATESTAGEREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstatestageregister_ petsclogstatestageregister
#endif
PETSC_EXTERN void petsclogstatestageregister_(PetscLogState *a, char b[], PetscLogStage *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscLogStateStageRegister(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstateeventregister_ PETSCLOGSTATEEVENTREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstateeventregister_ petsclogstateeventregister
#endif
PETSC_EXTERN void petsclogstateeventregister_(PetscLogState *a, char b[], PetscClassId *c, PetscLogEvent *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscLogStateEventRegister(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstateeventsetcollective_ PETSCLOGSTATEEVENTSETCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstateeventsetcollective_ petsclogstateeventsetcollective
#endif
PETSC_EXTERN void petsclogstateeventsetcollective_(PetscLogState *a, PetscLogEvent *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateEventSetCollective(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstatestagesetactive_ PETSCLOGSTATESTAGESETACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstatestagesetactive_ petsclogstatestagesetactive
#endif
PETSC_EXTERN void petsclogstatestagesetactive_(PetscLogState *a, PetscLogStage *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateStageSetActive(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstatestagegetactive_ PETSCLOGSTATESTAGEGETACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstatestagegetactive_ petsclogstatestagegetactive
#endif
PETSC_EXTERN void petsclogstatestagegetactive_(PetscLogState *a, PetscLogStage *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscLogStateStageGetActive(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstateeventsetactive_ PETSCLOGSTATEEVENTSETACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstateeventsetactive_ petsclogstateeventsetactive
#endif
PETSC_EXTERN void petsclogstateeventsetactive_(PetscLogState *a, PetscLogStage *b, PetscLogEvent *c, PetscBool *d, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateEventSetActive(*a, *b, *c, *d ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstateeventsetactiveall_ PETSCLOGSTATEEVENTSETACTIVEALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstateeventsetactiveall_ petsclogstateeventsetactiveall
#endif
PETSC_EXTERN void petsclogstateeventsetactiveall_(PetscLogState *a, PetscLogEvent *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateEventSetActiveAll(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstateclasssetactive_ PETSCLOGSTATECLASSSETACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstateclasssetactive_ petsclogstateclasssetactive
#endif
PETSC_EXTERN void petsclogstateclasssetactive_(PetscLogState *a, PetscLogStage *b, PetscClassId *c, PetscBool *d, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateClassSetActive(*a, *b, *c, *d ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstateclasssetactiveall_ PETSCLOGSTATECLASSSETACTIVEALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstateclasssetactiveall_ petsclogstateclasssetactiveall
#endif
PETSC_EXTERN void petsclogstateclasssetactiveall_(PetscLogState *a, PetscClassId *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateClassSetActiveAll(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstateeventgetactive_ PETSCLOGSTATEEVENTGETACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstateeventgetactive_ petsclogstateeventgetactive
#endif
PETSC_EXTERN void petsclogstateeventgetactive_(PetscLogState *a, PetscLogStage *b, PetscLogEvent *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscLogStateEventGetActive(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstategeteventfromname_ PETSCLOGSTATEGETEVENTFROMNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstategeteventfromname_ petsclogstategeteventfromname
#endif
PETSC_EXTERN void petsclogstategeteventfromname_(PetscLogState *a, char b[], PetscLogEvent *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscLogStateGetEventFromName(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstategetstagefromname_ PETSCLOGSTATEGETSTAGEFROMNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstategetstagefromname_ petsclogstategetstagefromname
#endif
PETSC_EXTERN void petsclogstategetstagefromname_(PetscLogState *a, char b[], PetscLogStage *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscLogStateGetStageFromName(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstategetclassfromname_ PETSCLOGSTATEGETCLASSFROMNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstategetclassfromname_ petsclogstategetclassfromname
#endif
PETSC_EXTERN void petsclogstategetclassfromname_(PetscLogState *a, char b[], PetscLogClass *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscLogStateGetClassFromName(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstategetclassfromclassid_ PETSCLOGSTATEGETCLASSFROMCLASSID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstategetclassfromclassid_ petsclogstategetclassfromclassid
#endif
PETSC_EXTERN void petsclogstategetclassfromclassid_(PetscLogState *a, PetscClassId *b, PetscLogClass *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateGetClassFromClassId(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstategetnumevents_ PETSCLOGSTATEGETNUMEVENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstategetnumevents_ petsclogstategetnumevents
#endif
PETSC_EXTERN void petsclogstategetnumevents_(PetscLogState *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscLogStateGetNumEvents(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstategetnumstages_ PETSCLOGSTATEGETNUMSTAGES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstategetnumstages_ petsclogstategetnumstages
#endif
PETSC_EXTERN void petsclogstategetnumstages_(PetscLogState *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscLogStateGetNumStages(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstategetnumclasses_ PETSCLOGSTATEGETNUMCLASSES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstategetnumclasses_ petsclogstategetnumclasses
#endif
PETSC_EXTERN void petsclogstategetnumclasses_(PetscLogState *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscLogStateGetNumClasses(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstateeventgetinfo_ PETSCLOGSTATEEVENTGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstateeventgetinfo_ petsclogstateeventgetinfo
#endif
PETSC_EXTERN void petsclogstateeventgetinfo_(PetscLogState *a, PetscLogEvent *b, PetscLogEventInfo *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateEventGetInfo(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstatestagegetinfo_ PETSCLOGSTATESTAGEGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstatestagegetinfo_ petsclogstatestagegetinfo
#endif
PETSC_EXTERN void petsclogstatestagegetinfo_(PetscLogState *a, PetscLogStage *b, PetscLogStageInfo *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateStageGetInfo(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstateclassregister_ PETSCLOGSTATECLASSREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstateclassregister_ petsclogstateclassregister
#endif
PETSC_EXTERN void petsclogstateclassregister_(PetscLogState *a, char b[], PetscClassId *c, PetscLogClass *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscLogStateClassRegister(*a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsclogstateclassgetinfo_ PETSCLOGSTATECLASSGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsclogstateclassgetinfo_ petsclogstateclassgetinfo
#endif
PETSC_EXTERN void petsclogstateclassgetinfo_(PetscLogState *a, PetscLogClass *b, PetscLogClassInfo *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogStateClassGetInfo(*a, *b, c);
  if (*ierr) return;
}
