#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateschurcomplement_ MATCREATESCHURCOMPLEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateschurcomplement_ matcreateschurcomplement
#endif
PETSC_EXTERN void matcreateschurcomplement_(Mat *a, Mat *b, Mat *c, Mat *d, Mat *e, Mat *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = MatCreateSchurComplement(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matschurcomplementsetsubmatrices_ MATSCHURCOMPLEMENTSETSUBMATRICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matschurcomplementsetsubmatrices_ matschurcomplementsetsubmatrices
#endif
PETSC_EXTERN void matschurcomplementsetsubmatrices_(Mat *a, Mat *b, Mat *c, Mat *d, Mat *e, Mat *f, PetscErrorCode *ierr)
{
  *ierr = MatSchurComplementSetSubMatrices(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matschurcomplementgetksp_ MATSCHURCOMPLEMENTGETKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matschurcomplementgetksp_ matschurcomplementgetksp
#endif
PETSC_EXTERN void matschurcomplementgetksp_(Mat *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatSchurComplementGetKSP(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matschurcomplementsetksp_ MATSCHURCOMPLEMENTSETKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matschurcomplementsetksp_ matschurcomplementsetksp
#endif
PETSC_EXTERN void matschurcomplementsetksp_(Mat *a, KSP *b, PetscErrorCode *ierr)
{
  *ierr = MatSchurComplementSetKSP(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matschurcomplementupdatesubmatrices_ MATSCHURCOMPLEMENTUPDATESUBMATRICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matschurcomplementupdatesubmatrices_ matschurcomplementupdatesubmatrices
#endif
PETSC_EXTERN void matschurcomplementupdatesubmatrices_(Mat *a, Mat *b, Mat *c, Mat *d, Mat *e, Mat *f, PetscErrorCode *ierr)
{
  *ierr = MatSchurComplementUpdateSubMatrices(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matschurcomplementgetsubmatrices_ MATSCHURCOMPLEMENTGETSUBMATRICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matschurcomplementgetsubmatrices_ matschurcomplementgetsubmatrices
#endif
PETSC_EXTERN void matschurcomplementgetsubmatrices_(Mat *a, Mat *b, Mat *c, Mat *d, Mat *e, Mat *f, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = MatSchurComplementGetSubMatrices(*a, b, c, d, e, f);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matschurcomplementcomputeexplicitoperator_ MATSCHURCOMPLEMENTCOMPUTEEXPLICITOPERATOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matschurcomplementcomputeexplicitoperator_ matschurcomplementcomputeexplicitoperator
#endif
PETSC_EXTERN void matschurcomplementcomputeexplicitoperator_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatSchurComplementComputeExplicitOperator(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetschurcomplement_ MATGETSCHURCOMPLEMENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetschurcomplement_ matgetschurcomplement
#endif
PETSC_EXTERN void matgetschurcomplement_(Mat *a, IS *b, IS *c, IS *d, IS *e, MatReuse *f, Mat *g, MatSchurComplementAinvType *h, MatReuse *i, Mat *j, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_j = !*(void**) j ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(g);
  CHKFORTRANNULLOBJECT(j);
  *ierr = MatGetSchurComplement(*a, *b, *c, *d, *e, *f, g, *h, *i, j);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
  if (! null_j && !*(void**) j) *(void **) j = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matschurcomplementsetainvtype_ MATSCHURCOMPLEMENTSETAINVTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matschurcomplementsetainvtype_ matschurcomplementsetainvtype
#endif
PETSC_EXTERN void matschurcomplementsetainvtype_(Mat *a, MatSchurComplementAinvType *b, PetscErrorCode *ierr)
{
  *ierr = MatSchurComplementSetAinvType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matschurcomplementgetainvtype_ MATSCHURCOMPLEMENTGETAINVTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matschurcomplementgetainvtype_ matschurcomplementgetainvtype
#endif
PETSC_EXTERN void matschurcomplementgetainvtype_(Mat *a, MatSchurComplementAinvType *b, PetscErrorCode *ierr)
{
  *ierr = MatSchurComplementGetAinvType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateschurcomplementpmat_ MATCREATESCHURCOMPLEMENTPMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateschurcomplementpmat_ matcreateschurcomplementpmat
#endif
PETSC_EXTERN void matcreateschurcomplementpmat_(Mat *a, Mat *b, Mat *c, Mat *d, MatSchurComplementAinvType *e, MatReuse *f, Mat *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(g);
  *ierr = MatCreateSchurComplementPmat(*a, *b, *c, *d, *e, *f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matschurcomplementgetpmat_ MATSCHURCOMPLEMENTGETPMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matschurcomplementgetpmat_ matschurcomplementgetpmat
#endif
PETSC_EXTERN void matschurcomplementgetpmat_(Mat *a, MatReuse *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatSchurComplementGetPmat(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
