#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchviewfromoptions_ TAOLINESEARCHVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchviewfromoptions_ taolinesearchviewfromoptions
#endif
PETSC_EXTERN void taolinesearchviewfromoptions_(TaoLineSearch *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = TaoLineSearchViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchview_ TAOLINESEARCHVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchview_ taolinesearchview
#endif
PETSC_EXTERN void taolinesearchview_(TaoLineSearch *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = TaoLineSearchView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchcreate_ TAOLINESEARCHCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchcreate_ taolinesearchcreate
#endif
PETSC_EXTERN void taolinesearchcreate_(MPI_Fint *a, TaoLineSearch *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoLineSearchCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchsetup_ TAOLINESEARCHSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchsetup_ taolinesearchsetup
#endif
PETSC_EXTERN void taolinesearchsetup_(TaoLineSearch *a, PetscErrorCode *ierr)
{
  *ierr = TaoLineSearchSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchreset_ TAOLINESEARCHRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchreset_ taolinesearchreset
#endif
PETSC_EXTERN void taolinesearchreset_(TaoLineSearch *a, PetscErrorCode *ierr)
{
  *ierr = TaoLineSearchReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchdestroy_ TAOLINESEARCHDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchdestroy_ taolinesearchdestroy
#endif
PETSC_EXTERN void taolinesearchdestroy_(TaoLineSearch *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TaoLineSearchDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchapply_ TAOLINESEARCHAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchapply_ taolinesearchapply
#endif
PETSC_EXTERN void taolinesearchapply_(TaoLineSearch *a, Vec *b, PetscReal *c, Vec *d, Vec *e, PetscReal *f, TaoLineSearchConvergedReason *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(f);
  *ierr = TaoLineSearchApply(*a, *b, c, *d, *e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchsettype_ TAOLINESEARCHSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchsettype_ taolinesearchsettype
#endif
PETSC_EXTERN void taolinesearchsettype_(TaoLineSearch *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TaoLineSearchSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchmonitor_ TAOLINESEARCHMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchmonitor_ taolinesearchmonitor
#endif
PETSC_EXTERN void taolinesearchmonitor_(TaoLineSearch *a, PetscInt *b, PetscReal *c, PetscReal *d, PetscErrorCode *ierr)
{
  *ierr = TaoLineSearchMonitor(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchsetfromoptions_ TAOLINESEARCHSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchsetfromoptions_ taolinesearchsetfromoptions
#endif
PETSC_EXTERN void taolinesearchsetfromoptions_(TaoLineSearch *a, PetscErrorCode *ierr)
{
  *ierr = TaoLineSearchSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchgettype_ TAOLINESEARCHGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchgettype_ taolinesearchgettype
#endif
PETSC_EXTERN void taolinesearchgettype_(TaoLineSearch *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TaoLineSearchGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchgetnumberfunctionevaluations_ TAOLINESEARCHGETNUMBERFUNCTIONEVALUATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchgetnumberfunctionevaluations_ taolinesearchgetnumberfunctionevaluations
#endif
PETSC_EXTERN void taolinesearchgetnumberfunctionevaluations_(TaoLineSearch *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = TaoLineSearchGetNumberFunctionEvaluations(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchisusingtaoroutines_ TAOLINESEARCHISUSINGTAOROUTINES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchisusingtaoroutines_ taolinesearchisusingtaoroutines
#endif
PETSC_EXTERN void taolinesearchisusingtaoroutines_(TaoLineSearch *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TaoLineSearchIsUsingTaoRoutines(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchusetaoroutines_ TAOLINESEARCHUSETAOROUTINES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchusetaoroutines_ taolinesearchusetaoroutines
#endif
PETSC_EXTERN void taolinesearchusetaoroutines_(TaoLineSearch *a, Tao *b, PetscErrorCode *ierr)
{
  *ierr = TaoLineSearchUseTaoRoutines(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchcomputeobjective_ TAOLINESEARCHCOMPUTEOBJECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchcomputeobjective_ taolinesearchcomputeobjective
#endif
PETSC_EXTERN void taolinesearchcomputeobjective_(TaoLineSearch *a, Vec *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = TaoLineSearchComputeObjective(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchcomputeobjectiveandgradient_ TAOLINESEARCHCOMPUTEOBJECTIVEANDGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchcomputeobjectiveandgradient_ taolinesearchcomputeobjectiveandgradient
#endif
PETSC_EXTERN void taolinesearchcomputeobjectiveandgradient_(TaoLineSearch *a, Vec *b, PetscReal *c, Vec *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = TaoLineSearchComputeObjectiveAndGradient(*a, *b, c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchcomputegradient_ TAOLINESEARCHCOMPUTEGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchcomputegradient_ taolinesearchcomputegradient
#endif
PETSC_EXTERN void taolinesearchcomputegradient_(TaoLineSearch *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TaoLineSearchComputeGradient(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchcomputeobjectiveandgts_ TAOLINESEARCHCOMPUTEOBJECTIVEANDGTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchcomputeobjectiveandgts_ taolinesearchcomputeobjectiveandgts
#endif
PETSC_EXTERN void taolinesearchcomputeobjectiveandgts_(TaoLineSearch *a, Vec *b, PetscReal *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  *ierr = TaoLineSearchComputeObjectiveAndGTS(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchgetsolution_ TAOLINESEARCHGETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchgetsolution_ taolinesearchgetsolution
#endif
PETSC_EXTERN void taolinesearchgetsolution_(TaoLineSearch *a, Vec *b, PetscReal *c, Vec *d, PetscReal *e, TaoLineSearchConvergedReason *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(e);
  *ierr = TaoLineSearchGetSolution(*a, *b, c, *d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchgetstartingvector_ TAOLINESEARCHGETSTARTINGVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchgetstartingvector_ taolinesearchgetstartingvector
#endif
PETSC_EXTERN void taolinesearchgetstartingvector_(TaoLineSearch *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoLineSearchGetStartingVector(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchgetstepdirection_ TAOLINESEARCHGETSTEPDIRECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchgetstepdirection_ taolinesearchgetstepdirection
#endif
PETSC_EXTERN void taolinesearchgetstepdirection_(TaoLineSearch *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoLineSearchGetStepDirection(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchgetfullstepobjective_ TAOLINESEARCHGETFULLSTEPOBJECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchgetfullstepobjective_ taolinesearchgetfullstepobjective
#endif
PETSC_EXTERN void taolinesearchgetfullstepobjective_(TaoLineSearch *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TaoLineSearchGetFullStepObjective(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchsetvariablebounds_ TAOLINESEARCHSETVARIABLEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchsetvariablebounds_ taolinesearchsetvariablebounds
#endif
PETSC_EXTERN void taolinesearchsetvariablebounds_(TaoLineSearch *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TaoLineSearchSetVariableBounds(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchsetinitialsteplength_ TAOLINESEARCHSETINITIALSTEPLENGTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchsetinitialsteplength_ taolinesearchsetinitialsteplength
#endif
PETSC_EXTERN void taolinesearchsetinitialsteplength_(TaoLineSearch *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TaoLineSearchSetInitialStepLength(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchgetsteplength_ TAOLINESEARCHGETSTEPLENGTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchgetsteplength_ taolinesearchgetsteplength
#endif
PETSC_EXTERN void taolinesearchgetsteplength_(TaoLineSearch *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TaoLineSearchGetStepLength(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchappendoptionsprefix_ TAOLINESEARCHAPPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchappendoptionsprefix_ taolinesearchappendoptionsprefix
#endif
PETSC_EXTERN void taolinesearchappendoptionsprefix_(TaoLineSearch *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TaoLineSearchAppendOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchgetoptionsprefix_ TAOLINESEARCHGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchgetoptionsprefix_ taolinesearchgetoptionsprefix
#endif
PETSC_EXTERN void taolinesearchgetoptionsprefix_(TaoLineSearch *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TaoLineSearchGetOptionsPrefix(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctaolinesearch.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taolinesearchsetoptionsprefix_ TAOLINESEARCHSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taolinesearchsetoptionsprefix_ taolinesearchsetoptionsprefix
#endif
PETSC_EXTERN void taolinesearchsetoptionsprefix_(TaoLineSearch *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TaoLineSearchSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
