%define OT_Solver_doc
"SolverImplementation of 1D non linear equations.

Parameters
----------
absError : positive float
    Absolute error between two successive iterates at the end point.
    Default value is defined in the `ResourceMap` via the `Solver-DefaultAbsoluteError`
    key is set to :math:`10^{-5}`.
relError : positive float
    Relative error between the two last successive iterates with
    regards to the last iterate.
    Default value is defined in the `ResourceMap` via the `Solver-DefaultRelativeError`
    key is set to :math:`10^{-5}`.
resError : positive float
    Absolute threshold on `f(x)` for accepting a given solution.
    It is also used as residual error for the least square optimizer.
    value.
    Default value is defined in the `ResourceMap` via the `Solver-DefaultResidualError`
    and is set to :math:`0`.
maximumFunctionEvaluation : int
    The maximum number of evaluations of the function.
    Default value is defined in the `ResourceMap` via the `Solver-DefaultMaximumFunctionEvaluation`
    and is set to :math:`100`.

See also
--------
Bisection, Brent, Secant

Notes
-----
This class enables to solve 1D non linear equations :

.. math::

    f(x) = value, \\forall x \\in [infPoint, supPoint]

if :math:`f` is a continuous function from :math:`\\Rset` to :math:`\\Rset`,
:math:`infPoint, supPoint \\in \\Rset` and if :math:`f` is such that
:math:`f(infPoint) \\times f(supPoint) < 0`, then :math:`f` has at least a zero
in the interval :math:`[infPoint, supPoint]`. In particular, it is used in the
root research of a 
:class:`Directional Sampling simulation <openturns.DirectionalSampling>`."
%enddef
%feature("docstring") OT::SolverImplementation
OT_Solver_doc

// ---------------------------------------------------------------------

%define OT_Solver_getAbsoluteError_doc
"Accessor to the absolute error.

Returns
-------
absError : float
    The absolute error: distance between two successive iterates at the end point."
%enddef
%feature("docstring") OT::SolverImplementation::getAbsoluteError
OT_Solver_getAbsoluteError_doc

// ---------------------------------------------------------------------

%define OT_Solver_getMaximumCallsNumber_doc
"Accessor to the maximum number of function calls.

Returns
-------
maxEval : int
    The maximum number of function calls."
%enddef
%feature("docstring") OT::SolverImplementation::getMaximumCallsNumber
OT_Solver_getMaximumCallsNumber_doc

// ---------------------------------------------------------------------

%define OT_Solver_getRelativeError_doc
"Accessor to the relative error.

Returns
-------
relError : float
    The relative error: distance between the two last successive iterates with
    regards to the last iterate."
%enddef
%feature("docstring") OT::SolverImplementation::getRelativeError
OT_Solver_getRelativeError_doc

// ---------------------------------------------------------------------

%define OT_Solver_getResidualError_doc
"Accessor to the residual error.

Returns
-------
resError : float
    The residual errors: difference between the last iterate value and the
    expected value."
%enddef
%feature("docstring") OT::SolverImplementation::getResidualError
OT_Solver_getResidualError_doc

// ---------------------------------------------------------------------

%define OT_Solver_setAbsoluteError_doc
"Accessor to the absolute error.

Parameters
----------
absError : float
    The absolute error: distance between two successive iterates at the end point."
%enddef
%feature("docstring") OT::SolverImplementation::setAbsoluteError
OT_Solver_setAbsoluteError_doc

// ---------------------------------------------------------------------

%define OT_Solver_setMaximumCallsNumber_doc
"Accessor to the maximum number of function calls.

Parameters
----------
maxEval : int
    The maximum number of function calls."
%enddef
%feature("docstring") OT::SolverImplementation::setMaximumCallsNumber
OT_Solver_setMaximumCallsNumber_doc

// ---------------------------------------------------------------------

%define OT_Solver_setRelativeError_doc
"Accessor to the relative error.

Parameters
----------
relError : float
    The relative error: distance between the two last successive iterates with
    regards to the last iterate."
%enddef
%feature("docstring") OT::SolverImplementation::setRelativeError
OT_Solver_setRelativeError_doc

// ---------------------------------------------------------------------

%define OT_Solver_setResidualError_doc
"Accessor to the residual error.

Parameters
----------
resError : float
    The residual errors: difference between the last iterate value and the
    expected value."
%enddef
%feature("docstring") OT::SolverImplementation::setResidualError
OT_Solver_setResidualError_doc

// ---------------------------------------------------------------------

%define OT_Solver_getCallsNumber_doc
"Accessor to the number of function calls.

Returns
-------
nEval : int
    The number of function calls."
%enddef
%feature("docstring") OT::SolverImplementation::getCallsNumber
OT_Solver_getCallsNumber_doc

// ---------------------------------------------------------------------

%define OT_Solver_solve_doc
"Solve an equation.

Parameters
----------
function : :class:`~openturns.Function`
    The function of the equation :math:`function(x) = value` to be solved in the
    interval :math:`[infPoint, supPoint]`.
value : float
    The value to which the function must be equal.
infPoint, supPoint : float
    Lower and upper bounds of the variable :math:`x` range.
infValue, supValue : float, optional
    The values such that :math:`infValue = function(infPoint)`,
    and :math:`supValue = function(supPoint)`.
    :math:`infValue` must be of opposite sign of :math:`supValue`.
startingPoint : sequence of float
    Starting point for solving a system of (non linear) equations.
bounds : :class:`~openturns.Interval`
    Bounds for searching the solution of the system of equations.

Returns
-------
result : float
    The result of the root research.
"
%enddef
%feature("docstring") OT::SolverImplementation::solve
OT_Solver_solve_doc
