// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_DispPerCount_HeaderFile
#define _IFSelect_DispPerCount_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IFSelect_DispPerCount.hxx>

#include <Handle_IFSelect_IntParam.hxx>
#include <IFSelect_Dispatch.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Boolean.hxx>
class IFSelect_IntParam;
class Interface_InterfaceError;
class TCollection_AsciiString;
class Interface_Graph;
class IFGraph_SubPartsIterator;


//! A DispPerCount gathers all the input Entities into one or
//! several Packets, each containing a defined count of Entity
//! This count is a Parameter of the DispPerCount, given as an
//! IntParam, thus allowing external control of its Value
class IFSelect_DispPerCount : public IFSelect_Dispatch
{

public:

  
  //! Creates a DispPerCount with no Count (default value 1)
  Standard_EXPORT IFSelect_DispPerCount();
  
  //! Returns the Count Parameter used for splitting
  Standard_EXPORT   Handle(IFSelect_IntParam) Count()  const;
  
  //! Sets a new Parameter for Count
  Standard_EXPORT   void SetCount (const Handle(IFSelect_IntParam)& count) ;
  
  //! Returns the effective value of the count parameter
  //! (if Count Parameter not Set or value not positive, returns 1)
  Standard_EXPORT   Standard_Integer CountValue()  const;
  
  //! Returns as Label, "One File per <count> Input Entities"
  Standard_EXPORT   TCollection_AsciiString Label()  const;
  
  //! Returns True, maximum count is given as <nbent>
  Standard_EXPORT virtual   Standard_Boolean LimitedMax (const Standard_Integer nbent, Standard_Integer& max)  const;
  
  //! Returns True (count is easy to know) and count is computed
  //! from length of input list (RootResult from Final Selection)
  Standard_EXPORT virtual   Standard_Integer PacketsCount (const Interface_Graph& G, Standard_Integer& count)  const;
  
  //! Computes the list of produced Packets. It defines Packets in
  //! order to have at most <Count> Entities per Packet, Entities
  //! are given by RootResult from the Final Selection.
  Standard_EXPORT   void Packets (const Interface_Graph& G, IFGraph_SubPartsIterator& packs)  const;




  DEFINE_STANDARD_RTTI(IFSelect_DispPerCount)

protected:




private: 


  Handle(IFSelect_IntParam) thecount;


};







#endif // _IFSelect_DispPerCount_HeaderFile
