/*
 * Copyright (C) 2014-2022, AdaCore
 * SPDX-License-Identifier: Apache-2.0
 */

// This file contains the native implementations for JNI
// functions used in Libadalang.java

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <jni.h>

#include "com_adacore_libadalang_Libadalang_JNI_LIB.h"
#include "libadalang.h"

// ==========
// Global declarations
// ==========

char jvm_running = 0;

// ==========
// Type declaration
// ==========

// Structure to store the information for event handler
typedef struct {
    JNIEnv *env;
    jobject unit_requested_callback;
    jobject unit_parsed_callback;
} event_handler_data;

// ==========
// Function delcarations
// ==========

jclass main_class_ref = NULL;
jmethodID encodeUTF32_method_id = NULL;
jmethodID decodeUTF32_method_id = NULL;
jmethodID check_exception_method_id = NULL;

void * PointerWrapper_new_value();
jobject PointerWrapper_wrap(JNIEnv *, void *);
void * PointerWrapper_unwrap(JNIEnv *, jobject);

jclass PointerWrapper_class_ref = NULL;
jmethodID PointerWrapper_constructor_id = NULL;
jmethodID PointerWrapper_getter_id = NULL;

ada_exception LangkitException_new_value();
jthrowable LangkitException_wrap(JNIEnv *, ada_exception);

jclass LangkitException_class_ref = NULL;
jmethodID LangkitException_constructor_id = NULL;

ada_token_kind TokenKind_new_value();
jobject TokenKind_wrap(JNIEnv *, ada_token_kind);
ada_token_kind TokenKind_unwrap(JNIEnv *, jobject);

jclass TokenKind_class_ref = NULL;
jmethodID TokenKind_from_c_method_id = NULL;
jmethodID TokenKind_to_c_method_id = NULL;


    

ada_analysis_unit_kind AnalysisUnitKind_new_value();
jobject AnalysisUnitKind_wrap(JNIEnv *, ada_analysis_unit_kind);
ada_analysis_unit_kind AnalysisUnitKind_unwrap(JNIEnv *, jobject);

jclass AnalysisUnitKind_class_ref = NULL;
jmethodID AnalysisUnitKind_from_c_method_id = NULL;
jmethodID AnalysisUnitKind_to_c_method_id = NULL;


    

ada_lookup_kind LookupKind_new_value();
jobject LookupKind_wrap(JNIEnv *, ada_lookup_kind);
ada_lookup_kind LookupKind_unwrap(JNIEnv *, jobject);

jclass LookupKind_class_ref = NULL;
jmethodID LookupKind_from_c_method_id = NULL;
jmethodID LookupKind_to_c_method_id = NULL;


    

ada_designated_env_kind DesignatedEnvKind_new_value();
jobject DesignatedEnvKind_wrap(JNIEnv *, ada_designated_env_kind);
ada_designated_env_kind DesignatedEnvKind_unwrap(JNIEnv *, jobject);

jclass DesignatedEnvKind_class_ref = NULL;
jmethodID DesignatedEnvKind_from_c_method_id = NULL;
jmethodID DesignatedEnvKind_to_c_method_id = NULL;


    

ada_ref_result_kind RefResultKind_new_value();
jobject RefResultKind_wrap(JNIEnv *, ada_ref_result_kind);
ada_ref_result_kind RefResultKind_unwrap(JNIEnv *, jobject);

jclass RefResultKind_class_ref = NULL;
jmethodID RefResultKind_from_c_method_id = NULL;
jmethodID RefResultKind_to_c_method_id = NULL;


    

ada_call_expr_kind CallExprKind_new_value();
jobject CallExprKind_wrap(JNIEnv *, ada_call_expr_kind);
ada_call_expr_kind CallExprKind_unwrap(JNIEnv *, jobject);

jclass CallExprKind_class_ref = NULL;
jmethodID CallExprKind_from_c_method_id = NULL;
jmethodID CallExprKind_to_c_method_id = NULL;


    

ada_grammar_rule GrammarRule_new_value();
jobject GrammarRule_wrap(JNIEnv *, ada_grammar_rule);
ada_grammar_rule GrammarRule_unwrap(JNIEnv *, jobject);

jclass GrammarRule_class_ref = NULL;
jmethodID GrammarRule_from_c_method_id = NULL;
jmethodID GrammarRule_to_c_method_id = NULL;


uint32_t Char_new_value();
jobject Char_wrap(JNIEnv *, uint32_t);
uint32_t Char_unwrap(JNIEnv *, jobject);

jclass Char_class_ref = NULL;
jmethodID Char_constructor_id = NULL;
jfieldID Char_value_field_id = NULL;

ada_big_integer BigIntegerWrapper_new_value();
jobject BigIntegerWrapper_wrap(JNIEnv *, ada_big_integer);
ada_big_integer BigIntegerWrapper_unwrap(JNIEnv *, jobject);
void BigIntegerWrapper_release(ada_big_integer);

jclass BigInteger_class_ref = NULL;
jmethodID BigInteger_constructor_id = NULL;
jmethodID BigInteger_to_string_method_id = NULL;

ada_symbol_type Symbol_new_value();
jobject Symbol_wrap(JNIEnv *, ada_symbol_type);
ada_symbol_type Symbol_unwrap(JNIEnv *, jobject, ada_analysis_context);
jthrowable new_symbol_exception(JNIEnv *, jstring);

jclass Symbol_class_ref = NULL;
jmethodID Symbol_constructor_id = NULL;
jfieldID Symbol_text_field_id = NULL;
jclass SymbolException_class_ref = NULL;
jmethodID SymbolException_constructor_id = NULL;

ada_string_type StringWrapper_new_value();
jobject StringWrapper_wrap(JNIEnv *, ada_string_type);
ada_string_type StringWrapper_unwrap(JNIEnv *, jobject);
void StringWrapper_release(ada_string_type);

ada_text Text_new_value();
jobject Text_wrap(JNIEnv *, ada_text);
ada_text Text_unwrap(JNIEnv *, jobject);
jstring get_text_content(JNIEnv *, jobject);
jobject text_from_content(JNIEnv *, jstring);

jclass Text_class_ref = NULL;
jmethodID Text_constructor_id = NULL;
jmethodID Text_extended_constructor_id = NULL;
jmethodID Text_create_method_id = NULL;
jmethodID Text_get_content_method_id = NULL;
jfieldID Text_chars_field_id = NULL;
jfieldID Text_length_field_id = NULL;
jfieldID Text_is_allocated_field_id = NULL;
jfieldID Text_is_owner_field_id = NULL;

ada_source_location SourceLocation_new_value();
jobject SourceLocation_wrap(JNIEnv *, ada_source_location);
ada_source_location SourceLocation_unwrap(JNIEnv *, jobject);

jclass SourceLocation_class_ref = NULL;
jmethodID SourceLocation_constructor_id = NULL;
jfieldID SourceLocation_line_field_id = NULL;
jfieldID SourceLocation_column_field_id = NULL;

ada_source_location_range SourceLocationRange_new_value();
jobject SourceLocationRange_wrap(JNIEnv *, ada_source_location_range);
ada_source_location_range SourceLocationRange_unwrap(JNIEnv *, jobject);

jclass SourceLocationRange_class_ref = NULL;
jmethodID SourceLocationRange_constructor_id = NULL;
jfieldID SourceLocationRange_start_field_id = NULL;
jfieldID SourceLocationRange_end_field_id = NULL;

ada_diagnostic Diagnostic_new_value();
jobject Diagnostic_wrap(JNIEnv *, ada_diagnostic);
ada_diagnostic Diagnostic_unwrap(JNIEnv *, jobject);

jclass Diagnostic_class_ref = NULL;
jmethodID Diagnostic_constructor_id = NULL;
jfieldID Diagnostic_sloc_range_field_id = NULL;
jfieldID Diagnostic_text_field_id = NULL;

ada_file_reader FileReader_new_value();
jobject FileReader_wrap(JNIEnv *, ada_file_reader);
ada_file_reader FileReader_unwrap(JNIEnv *, jobject);

jclass FileReader_class_ref = NULL;
jmethodID FileReader_constructor_id = NULL;
jfieldID FileReader_reference_field_id = NULL;

ada_unit_provider UnitProvider_new_value();
jobject UnitProvider_wrap(JNIEnv *, ada_unit_provider);
ada_unit_provider UnitProvider_unwrap(JNIEnv *, jobject);

jclass UnitProvider_class_ref = NULL;
jmethodID UnitProvider_constructor_id = NULL;
jfieldID UnitProvider_reference_field_id = NULL;

ada_event_handler EventHandler_new_value();
jobject EventHandler_wrap(JNIEnv *, ada_event_handler);
ada_event_handler EventHandler_unwrap(JNIEnv *, jobject);

jclass EventHandler_class_ref = NULL;
jmethodID EventHandler_from_reference_id = NULL;
jfieldID EventHandler_reference_field_id = NULL;
jclass UnitRequestedCallback_class_id = NULL;
jmethodID UnitRequestedCallback_invoke_id = NULL;
jclass UnitParsedCallback_class_id = NULL;
jmethodID UnitParsedCallback_invoke_id = NULL;

ada_token Token_new_value();
jobject Token_wrap(JNIEnv *, ada_token, jobject);
ada_token Token_unwrap(JNIEnv *, jobject);
jobject Token_get_unit(JNIEnv *, jobject);
jobject NoToken_wrap(JNIEnv *, jobject);

jclass Token_class_ref = NULL;
jclass NoToken_class_ref = NULL;
jmethodID Token_constructor_id = NULL;
jmethodID Token_none_getter_method_id = NULL;
jfieldID Token_context_field_id = NULL;
jfieldID Token_tdh_field_id = NULL;
jfieldID Token_token_index_field_id = NULL;
jfieldID Token_trivia_index_field_id = NULL;
jfieldID Token_token_kind_field_id = NULL;
jfieldID Token_text_field_id = NULL;
jfieldID Token_sloc_range_field_id = NULL;
jfieldID Token_unit_field_id = NULL;

ada_analysis_context AnalysisContext_new_value();
jobject AnalysisContext_wrap(JNIEnv *, ada_analysis_context);
ada_analysis_context AnalysisContext_unwrap(JNIEnv *, jobject);

jclass AnalysisContext_class_ref = NULL;
jmethodID AnalysisContext_from_reference_id = NULL;
jfieldID AnalysisContext_reference_field_id = NULL;

ada_analysis_unit AnalysisUnit_new_value();
jobject AnalysisUnit_wrap(JNIEnv *, ada_analysis_unit);
ada_analysis_unit AnalysisUnit_unwrap(JNIEnv *, jobject);

jclass AnalysisUnit_class_ref = NULL;
jmethodID AnalysisUnit_constructor_id = NULL;
jfieldID AnalysisUnit_reference_field_id = NULL;

ada_rewriting_apply_result RewritingApplyResult_new_value();
jobject RewritingApplyResult_wrap(JNIEnv *, ada_rewriting_apply_result);
ada_rewriting_apply_result RewritingApplyResult_unwrap(JNIEnv *, jobject);

jclass RewritingApplyResult_class_ref = NULL;
jmethodID RewritingApplyResult_contructor_id = NULL;
jmethodID RewritingApplyResult_success_id = NULL;
jfieldID RewritingApplyResult_success_field_id = NULL;
jfieldID RewritingApplyResult_unit_field_id = NULL;
jfieldID RewritingApplyResult_diagnostics_count_field_id = NULL;
jfieldID RewritingApplyResult_diagnostics_reference_field_id = NULL;

ada_rewriting_handle RewritingContext_new_value();
jobject RewritingContext_wrap(JNIEnv *, ada_rewriting_handle);
ada_rewriting_handle RewritingContext_unwrap(JNIEnv *, jobject);

jclass RewritingContext_class_ref = NULL;
jmethodID RewritingContext_from_reference_id = NULL;
jfieldID RewritingContext_reference_field_id = NULL;

ada_unit_rewriting_handle RewritingUnit_new_value();
jobject RewritingUnit_wrap(JNIEnv *, ada_unit_rewriting_handle);
ada_unit_rewriting_handle RewritingUnit_unwrap(JNIEnv *, jobject);

jclass RewritingUnit_class_ref = NULL;
jmethodID RewritingUnit_constructor_id = NULL;
jfieldID RewritingUnit_reference_field_id = NULL;

ada_node_rewriting_handle RewritingNode_new_value();
jobject RewritingNode_wrap(JNIEnv *, ada_node_rewriting_handle);
ada_node_rewriting_handle RewritingNode_unwrap(JNIEnv *, jobject);

jclass RewritingNode_class_ref = NULL;
jmethodID RewritingNode_constructor_id = NULL;
jfieldID RewritingNode_reference_field_id = NULL;


    

ada_internal_metadata Metadata_new_value();
jobject Metadata_wrap(JNIEnv *, ada_internal_metadata);
jobject Metadata_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_metadata Metadata_unwrap(JNIEnv *, jobject);


jclass Metadata_class_ref = NULL;

jmethodID Metadata_constructor_id = NULL;

jfieldID Metadata_none_field_id = NULL;

jfieldID Metadata_dottable_subp_field_id = NULL;
jfieldID Metadata_primitive_field_id = NULL;
jfieldID Metadata_primitive_real_type_field_id = NULL;


    

ada_internal_entity_info EntityInfo_new_value();
jobject EntityInfo_wrap(JNIEnv *, ada_internal_entity_info);
jobject EntityInfo_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_entity_info EntityInfo_unwrap(JNIEnv *, jobject);


jclass EntityInfo_class_ref = NULL;

jmethodID EntityInfo_constructor_id = NULL;

jfieldID EntityInfo_none_field_id = NULL;

jfieldID EntityInfo_md_field_id = NULL;
jfieldID EntityInfo_rebindings_field_id = NULL;
jfieldID EntityInfo_from_rebound_field_id = NULL;


    

ada_node Entity_new_value();
jobject Entity_wrap(JNIEnv *, ada_node);
jobject Entity_wrap_bare_node(JNIEnv *, ada_base_node);
ada_node Entity_unwrap(JNIEnv *, jobject);


jclass Entity_class_ref = NULL;

jmethodID Entity_constructor_id = NULL;

jfieldID Entity_none_field_id = NULL;

jfieldID Entity_node_field_id = NULL;
jfieldID Entity_info_field_id = NULL;


    

ada_internal_aspect Aspect_new_value();
jobject Aspect_wrap(JNIEnv *, ada_internal_aspect);
jobject Aspect_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_aspect Aspect_unwrap(JNIEnv *, jobject);


jclass Aspect_class_ref = NULL;

jmethodID Aspect_constructor_id = NULL;

jfieldID Aspect_none_field_id = NULL;

jfieldID Aspect_exists_field_id = NULL;
jfieldID Aspect_node_field_id = NULL;
jfieldID Aspect_value_field_id = NULL;
jfieldID Aspect_inherited_field_id = NULL;


    

ada_internal_completion_item CompletionItem_new_value();
jobject CompletionItem_wrap(JNIEnv *, ada_internal_completion_item);
jobject CompletionItem_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_completion_item CompletionItem_unwrap(JNIEnv *, jobject);


jclass CompletionItem_class_ref = NULL;

jmethodID CompletionItem_constructor_id = NULL;

jfieldID CompletionItem_none_field_id = NULL;

jfieldID CompletionItem_decl_field_id = NULL;
jfieldID CompletionItem_is_dot_call_field_id = NULL;
jfieldID CompletionItem_is_visible_field_id = NULL;
jfieldID CompletionItem_weight_field_id = NULL;


    

ada_internal_discrete_range DiscreteRange_new_value();
jobject DiscreteRange_wrap(JNIEnv *, ada_internal_discrete_range);
jobject DiscreteRange_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_discrete_range DiscreteRange_unwrap(JNIEnv *, jobject);


jclass DiscreteRange_class_ref = NULL;

jmethodID DiscreteRange_constructor_id = NULL;

jfieldID DiscreteRange_none_field_id = NULL;

jfieldID DiscreteRange_low_bound_field_id = NULL;
jfieldID DiscreteRange_high_bound_field_id = NULL;


    

ada_internal_discriminant_values DiscriminantValues_new_value();
jobject DiscriminantValues_wrap(JNIEnv *, ada_internal_discriminant_values);
jobject DiscriminantValues_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_discriminant_values DiscriminantValues_unwrap(JNIEnv *, jobject);


jclass DiscriminantValues_class_ref = NULL;

jmethodID DiscriminantValues_constructor_id = NULL;

jfieldID DiscriminantValues_none_field_id = NULL;

jfieldID DiscriminantValues_discriminant_field_id = NULL;
jfieldID DiscriminantValues_values_field_id = NULL;


    

ada_internal_doc_annotation DocAnnotation_new_value();
jobject DocAnnotation_wrap(JNIEnv *, ada_internal_doc_annotation);
jobject DocAnnotation_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_doc_annotation DocAnnotation_unwrap(JNIEnv *, jobject);

void DocAnnotation_release(ada_internal_doc_annotation);

jclass DocAnnotation_class_ref = NULL;

jmethodID DocAnnotation_constructor_id = NULL;

jfieldID DocAnnotation_none_field_id = NULL;

jfieldID DocAnnotation_key_field_id = NULL;
jfieldID DocAnnotation_value_field_id = NULL;


    

ada_internal_logic_context LogicContext_new_value();
jobject LogicContext_wrap(JNIEnv *, ada_internal_logic_context);
jobject LogicContext_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_logic_context LogicContext_unwrap(JNIEnv *, jobject);


jclass LogicContext_class_ref = NULL;

jmethodID LogicContext_constructor_id = NULL;

jfieldID LogicContext_none_field_id = NULL;

jfieldID LogicContext_ref_node_field_id = NULL;
jfieldID LogicContext_decl_node_field_id = NULL;


    

ada_internal_param_actual ParamActual_new_value();
jobject ParamActual_wrap(JNIEnv *, ada_internal_param_actual);
jobject ParamActual_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_param_actual ParamActual_unwrap(JNIEnv *, jobject);


jclass ParamActual_class_ref = NULL;

jmethodID ParamActual_constructor_id = NULL;

jfieldID ParamActual_none_field_id = NULL;

jfieldID ParamActual_param_field_id = NULL;
jfieldID ParamActual_actual_field_id = NULL;


    

ada_internal_ref_result RefResult_new_value();
jobject RefResult_wrap(JNIEnv *, ada_internal_ref_result);
jobject RefResult_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_ref_result RefResult_unwrap(JNIEnv *, jobject);


jclass RefResult_class_ref = NULL;

jmethodID RefResult_constructor_id = NULL;

jfieldID RefResult_none_field_id = NULL;

jfieldID RefResult_ref_field_id = NULL;
jfieldID RefResult_kind_field_id = NULL;


    

ada_internal_refd_decl RefdDecl_new_value();
jobject RefdDecl_wrap(JNIEnv *, ada_internal_refd_decl);
jobject RefdDecl_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_refd_decl RefdDecl_unwrap(JNIEnv *, jobject);


jclass RefdDecl_class_ref = NULL;

jmethodID RefdDecl_constructor_id = NULL;

jfieldID RefdDecl_none_field_id = NULL;

jfieldID RefdDecl_decl_field_id = NULL;
jfieldID RefdDecl_kind_field_id = NULL;


    

ada_internal_refd_def RefdDef_new_value();
jobject RefdDef_wrap(JNIEnv *, ada_internal_refd_def);
jobject RefdDef_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_refd_def RefdDef_unwrap(JNIEnv *, jobject);


jclass RefdDef_class_ref = NULL;

jmethodID RefdDef_constructor_id = NULL;

jfieldID RefdDef_none_field_id = NULL;

jfieldID RefdDef_def_name_field_id = NULL;
jfieldID RefdDef_kind_field_id = NULL;


    

ada_internal_shape Shape_new_value();
jobject Shape_wrap(JNIEnv *, ada_internal_shape);
jobject Shape_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_shape Shape_unwrap(JNIEnv *, jobject);

void Shape_release(ada_internal_shape);

jclass Shape_class_ref = NULL;

jmethodID Shape_constructor_id = NULL;

jfieldID Shape_none_field_id = NULL;

jfieldID Shape_components_field_id = NULL;
jfieldID Shape_discriminants_values_field_id = NULL;


    

ada_internal_solver_diagnostic SolverDiagnostic_new_value();
jobject SolverDiagnostic_wrap(JNIEnv *, ada_internal_solver_diagnostic);
jobject SolverDiagnostic_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_solver_diagnostic SolverDiagnostic_unwrap(JNIEnv *, jobject);

void SolverDiagnostic_release(ada_internal_solver_diagnostic);

jclass SolverDiagnostic_class_ref = NULL;

jmethodID SolverDiagnostic_constructor_id = NULL;

jfieldID SolverDiagnostic_none_field_id = NULL;

jfieldID SolverDiagnostic_message_template_field_id = NULL;
jfieldID SolverDiagnostic_args_field_id = NULL;
jfieldID SolverDiagnostic_location_field_id = NULL;
jfieldID SolverDiagnostic_contexts_field_id = NULL;
jfieldID SolverDiagnostic_round_field_id = NULL;


    

ada_internal_substitution Substitution_new_value();
jobject Substitution_wrap(JNIEnv *, ada_internal_substitution);
jobject Substitution_wrap_bare_node(JNIEnv *, ada_base_node);
ada_internal_substitution Substitution_unwrap(JNIEnv *, jobject);

void Substitution_release(ada_internal_substitution);

jclass Substitution_class_ref = NULL;

jmethodID Substitution_constructor_id = NULL;

jfieldID Substitution_none_field_id = NULL;

jfieldID Substitution_from_decl_field_id = NULL;
jfieldID Substitution_to_value_field_id = NULL;
jfieldID Substitution_value_type_field_id = NULL;



    

ada_internal_aspect_array AspectArrayWrapper_new_value();
jobject AspectArrayWrapper_wrap(JNIEnv *, ada_internal_aspect_array);
ada_internal_aspect_array AspectArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void AspectArrayWrapper_release(ada_internal_aspect_array);

jclass AspectArrayWrapper_class_ref = NULL;
jmethodID AspectArrayWrapper_wrap_method_id = NULL;
jmethodID AspectArrayWrapper_unwrap_method_id = NULL;


    

ada_internal_discriminant_values_array DiscriminantValuesArrayWrapper_new_value();
jobject DiscriminantValuesArrayWrapper_wrap(JNIEnv *, ada_internal_discriminant_values_array);
ada_internal_discriminant_values_array DiscriminantValuesArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void DiscriminantValuesArrayWrapper_release(ada_internal_discriminant_values_array);

jclass DiscriminantValuesArrayWrapper_class_ref = NULL;
jmethodID DiscriminantValuesArrayWrapper_wrap_method_id = NULL;
jmethodID DiscriminantValuesArrayWrapper_unwrap_method_id = NULL;


    

ada_internal_doc_annotation_array DocAnnotationArrayWrapper_new_value();
jobject DocAnnotationArrayWrapper_wrap(JNIEnv *, ada_internal_doc_annotation_array);
ada_internal_doc_annotation_array DocAnnotationArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void DocAnnotationArrayWrapper_release(ada_internal_doc_annotation_array);

jclass DocAnnotationArrayWrapper_class_ref = NULL;
jmethodID DocAnnotationArrayWrapper_wrap_method_id = NULL;
jmethodID DocAnnotationArrayWrapper_unwrap_method_id = NULL;


    

ada_node_array AcceptStmtArrayWrapper_new_value();
jobject AcceptStmtArrayWrapper_wrap(JNIEnv *, ada_node_array);
ada_node_array AcceptStmtArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void AcceptStmtArrayWrapper_release(ada_node_array);

jclass AcceptStmtArrayWrapper_class_ref = NULL;
jmethodID AcceptStmtArrayWrapper_wrap_method_id = NULL;
jmethodID AcceptStmtArrayWrapper_unwrap_method_id = NULL;


    

ada_node_array AdaNodeArrayWrapper_new_value();
jobject AdaNodeArrayWrapper_wrap(JNIEnv *, ada_node_array);
ada_node_array AdaNodeArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void AdaNodeArrayWrapper_release(ada_node_array);

jclass AdaNodeArrayWrapper_class_ref = NULL;
jmethodID AdaNodeArrayWrapper_wrap_method_id = NULL;
jmethodID AdaNodeArrayWrapper_unwrap_method_id = NULL;


    

ada_node_array BaseFormalParamDeclArrayWrapper_new_value();
jobject BaseFormalParamDeclArrayWrapper_wrap(JNIEnv *, ada_node_array);
ada_node_array BaseFormalParamDeclArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void BaseFormalParamDeclArrayWrapper_release(ada_node_array);

jclass BaseFormalParamDeclArrayWrapper_class_ref = NULL;
jmethodID BaseFormalParamDeclArrayWrapper_wrap_method_id = NULL;
jmethodID BaseFormalParamDeclArrayWrapper_unwrap_method_id = NULL;


    

ada_node_array BaseTypeDeclArrayWrapper_new_value();
jobject BaseTypeDeclArrayWrapper_wrap(JNIEnv *, ada_node_array);
ada_node_array BaseTypeDeclArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void BaseTypeDeclArrayWrapper_release(ada_node_array);

jclass BaseTypeDeclArrayWrapper_class_ref = NULL;
jmethodID BaseTypeDeclArrayWrapper_wrap_method_id = NULL;
jmethodID BaseTypeDeclArrayWrapper_unwrap_method_id = NULL;


    

ada_node_array BasicDeclArrayWrapper_new_value();
jobject BasicDeclArrayWrapper_wrap(JNIEnv *, ada_node_array);
ada_node_array BasicDeclArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void BasicDeclArrayWrapper_release(ada_node_array);

jclass BasicDeclArrayWrapper_class_ref = NULL;
jmethodID BasicDeclArrayWrapper_wrap_method_id = NULL;
jmethodID BasicDeclArrayWrapper_unwrap_method_id = NULL;


    

ada_node_array CompilationUnitArrayWrapper_new_value();
jobject CompilationUnitArrayWrapper_wrap(JNIEnv *, ada_node_array);
ada_node_array CompilationUnitArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void CompilationUnitArrayWrapper_release(ada_node_array);

jclass CompilationUnitArrayWrapper_class_ref = NULL;
jmethodID CompilationUnitArrayWrapper_wrap_method_id = NULL;
jmethodID CompilationUnitArrayWrapper_unwrap_method_id = NULL;


    

ada_node_array DefiningNameArrayWrapper_new_value();
jobject DefiningNameArrayWrapper_wrap(JNIEnv *, ada_node_array);
ada_node_array DefiningNameArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void DefiningNameArrayWrapper_release(ada_node_array);

jclass DefiningNameArrayWrapper_class_ref = NULL;
jmethodID DefiningNameArrayWrapper_wrap_method_id = NULL;
jmethodID DefiningNameArrayWrapper_unwrap_method_id = NULL;


    

ada_node_array ExprArrayWrapper_new_value();
jobject ExprArrayWrapper_wrap(JNIEnv *, ada_node_array);
ada_node_array ExprArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void ExprArrayWrapper_release(ada_node_array);

jclass ExprArrayWrapper_class_ref = NULL;
jmethodID ExprArrayWrapper_wrap_method_id = NULL;
jmethodID ExprArrayWrapper_unwrap_method_id = NULL;


    

ada_node_array GenericInstantiationArrayWrapper_new_value();
jobject GenericInstantiationArrayWrapper_wrap(JNIEnv *, ada_node_array);
ada_node_array GenericInstantiationArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void GenericInstantiationArrayWrapper_release(ada_node_array);

jclass GenericInstantiationArrayWrapper_class_ref = NULL;
jmethodID GenericInstantiationArrayWrapper_wrap_method_id = NULL;
jmethodID GenericInstantiationArrayWrapper_unwrap_method_id = NULL;


    

ada_node_array ParamSpecArrayWrapper_new_value();
jobject ParamSpecArrayWrapper_wrap(JNIEnv *, ada_node_array);
ada_node_array ParamSpecArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void ParamSpecArrayWrapper_release(ada_node_array);

jclass ParamSpecArrayWrapper_class_ref = NULL;
jmethodID ParamSpecArrayWrapper_wrap_method_id = NULL;
jmethodID ParamSpecArrayWrapper_unwrap_method_id = NULL;


    

ada_node_array PragmaNodeArrayWrapper_new_value();
jobject PragmaNodeArrayWrapper_wrap(JNIEnv *, ada_node_array);
ada_node_array PragmaNodeArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void PragmaNodeArrayWrapper_release(ada_node_array);

jclass PragmaNodeArrayWrapper_class_ref = NULL;
jmethodID PragmaNodeArrayWrapper_wrap_method_id = NULL;
jmethodID PragmaNodeArrayWrapper_unwrap_method_id = NULL;


    

ada_node_array TypeDeclArrayWrapper_new_value();
jobject TypeDeclArrayWrapper_wrap(JNIEnv *, ada_node_array);
ada_node_array TypeDeclArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void TypeDeclArrayWrapper_release(ada_node_array);

jclass TypeDeclArrayWrapper_class_ref = NULL;
jmethodID TypeDeclArrayWrapper_wrap_method_id = NULL;
jmethodID TypeDeclArrayWrapper_unwrap_method_id = NULL;


    

ada_internal_logic_context_array LogicContextArrayWrapper_new_value();
jobject LogicContextArrayWrapper_wrap(JNIEnv *, ada_internal_logic_context_array);
ada_internal_logic_context_array LogicContextArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void LogicContextArrayWrapper_release(ada_internal_logic_context_array);

jclass LogicContextArrayWrapper_class_ref = NULL;
jmethodID LogicContextArrayWrapper_wrap_method_id = NULL;
jmethodID LogicContextArrayWrapper_unwrap_method_id = NULL;


    

ada_internal_param_actual_array ParamActualArrayWrapper_new_value();
jobject ParamActualArrayWrapper_wrap(JNIEnv *, ada_internal_param_actual_array);
ada_internal_param_actual_array ParamActualArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void ParamActualArrayWrapper_release(ada_internal_param_actual_array);

jclass ParamActualArrayWrapper_class_ref = NULL;
jmethodID ParamActualArrayWrapper_wrap_method_id = NULL;
jmethodID ParamActualArrayWrapper_unwrap_method_id = NULL;


    

ada_internal_ref_result_array RefResultArrayWrapper_new_value();
jobject RefResultArrayWrapper_wrap(JNIEnv *, ada_internal_ref_result_array);
ada_internal_ref_result_array RefResultArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void RefResultArrayWrapper_release(ada_internal_ref_result_array);

jclass RefResultArrayWrapper_class_ref = NULL;
jmethodID RefResultArrayWrapper_wrap_method_id = NULL;
jmethodID RefResultArrayWrapper_unwrap_method_id = NULL;


    

ada_internal_shape_array ShapeArrayWrapper_new_value();
jobject ShapeArrayWrapper_wrap(JNIEnv *, ada_internal_shape_array);
ada_internal_shape_array ShapeArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void ShapeArrayWrapper_release(ada_internal_shape_array);

jclass ShapeArrayWrapper_class_ref = NULL;
jmethodID ShapeArrayWrapper_wrap_method_id = NULL;
jmethodID ShapeArrayWrapper_unwrap_method_id = NULL;


    

ada_internal_solver_diagnostic_array SolverDiagnosticArrayWrapper_new_value();
jobject SolverDiagnosticArrayWrapper_wrap(JNIEnv *, ada_internal_solver_diagnostic_array);
ada_internal_solver_diagnostic_array SolverDiagnosticArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void SolverDiagnosticArrayWrapper_release(ada_internal_solver_diagnostic_array);

jclass SolverDiagnosticArrayWrapper_class_ref = NULL;
jmethodID SolverDiagnosticArrayWrapper_wrap_method_id = NULL;
jmethodID SolverDiagnosticArrayWrapper_unwrap_method_id = NULL;


    

ada_internal_substitution_array SubstitutionArrayWrapper_new_value();
jobject SubstitutionArrayWrapper_wrap(JNIEnv *, ada_internal_substitution_array);
ada_internal_substitution_array SubstitutionArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void SubstitutionArrayWrapper_release(ada_internal_substitution_array);

jclass SubstitutionArrayWrapper_class_ref = NULL;
jmethodID SubstitutionArrayWrapper_wrap_method_id = NULL;
jmethodID SubstitutionArrayWrapper_unwrap_method_id = NULL;


    

ada_analysis_unit_array AnalysisUnitArrayWrapper_new_value();
jobject AnalysisUnitArrayWrapper_wrap(JNIEnv *, ada_analysis_unit_array);
ada_analysis_unit_array AnalysisUnitArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    );
void AnalysisUnitArrayWrapper_release(ada_analysis_unit_array);

jclass AnalysisUnitArrayWrapper_class_ref = NULL;
jmethodID AnalysisUnitArrayWrapper_wrap_method_id = NULL;
jmethodID AnalysisUnitArrayWrapper_unwrap_method_id = NULL;


    

ada_symbol_type_array UnboundedTextTypeArrayWrapper_new_value();
jobject UnboundedTextTypeArrayWrapper_wrap(JNIEnv *, ada_symbol_type_array);
ada_symbol_type_array UnboundedTextTypeArrayWrapper_unwrap(
    JNIEnv *,
    jobject
    , jobject);
void UnboundedTextTypeArrayWrapper_release(ada_symbol_type_array);

jclass UnboundedTextTypeArrayWrapper_class_ref = NULL;
jmethodID UnboundedTextTypeArrayWrapper_wrap_method_id = NULL;
jmethodID UnboundedTextTypeArrayWrapper_unwrap_method_id = NULL;



    

ada_internal_completion_item_iterator CompletionItemIterator_new_value();
jobject CompletionItemIterator_wrap(JNIEnv *, ada_internal_completion_item_iterator);
ada_internal_completion_item_iterator CompletionItemIterator_unwrap(JNIEnv *, jobject);

jclass CompletionItemIterator_class_ref = NULL;
jmethodID CompletionItemIterator_constructor_id = NULL;
jfieldID CompletionItemIterator_reference_field_id = NULL;


jclass AdaNode_class_ref = NULL;
jmethodID AdaNode_from_entity_id = NULL;
jfieldID AdaNode_entity_field_id = NULL;

// ==========
// Lifecycle functions
// ==========

JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1initialize(
    JNIEnv *env,
    jclass jni_lib
) {
    jvm_running = 1;

    main_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang")
    );

    encodeUTF32_method_id = (*env)->GetStaticMethodID(
        env,
        main_class_ref,
        "encodeUTF32",
        "(Ljava/lang/String;)[B"
    );

    decodeUTF32_method_id = (*env)->GetStaticMethodID(
        env,
        main_class_ref,
        "decodeUTF32",
        "([B)Ljava/lang/String;"
    );

    check_exception_method_id = (*env)->GetStaticMethodID(
        env,
        main_class_ref,
        "checkException",
        "()V"
    );

    PointerWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$PointerWrapper")
    );

    PointerWrapper_constructor_id = (*env)->GetMethodID(
        env,
        PointerWrapper_class_ref,
        "<init>",
        "(J)V"
    );

    PointerWrapper_getter_id = (*env)->GetMethodID(
        env,
        PointerWrapper_class_ref,
        "jni",
        "()J"
    );

    LangkitException_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$LangkitException")
    );

    LangkitException_constructor_id = (*env)->GetMethodID(
        env,
        LangkitException_class_ref,
        "<init>",
        "(ILjava/lang/String;)V"
    );

    Symbol_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$Symbol")
    );

    Symbol_constructor_id = (*env)->GetMethodID(
        env,
        Symbol_class_ref,
        "<init>",
        "(Ljava/lang/String;)V"
    );

    Symbol_text_field_id = (*env)->GetFieldID(
        env,
        Symbol_class_ref,
        "text",
        "Ljava/lang/String;"
    );

    SymbolException_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$SymbolException")
    );

    SymbolException_constructor_id = (*env)->GetMethodID(
        env,
        SymbolException_class_ref,
        "<init>",
        "(Ljava/lang/String;)V"
    );

    Text_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$Text")
    );

    Text_constructor_id = (*env)->GetMethodID(
        env,
        Text_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;JZ[B)V"
    );

    Text_extended_constructor_id = (*env)->GetMethodID(
        env,
        Text_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;JZZ[B)V"
    );

    Text_create_method_id = (*env)->GetStaticMethodID(
        env,
        Text_class_ref,
        "create",
        "(Ljava/lang/String;)Lcom/adacore/libadalang/Libadalang$Text;"
    );

    Text_get_content_method_id = (*env)->GetMethodID(
        env,
        Text_class_ref,
        "getContent",
        "()Ljava/lang/String;"
    );

    Text_chars_field_id = (*env)->GetFieldID(
        env,
        Text_class_ref,
        "charPointer",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );

    Text_length_field_id = (*env)->GetFieldID(
        env,
        Text_class_ref,
        "length",
        "J"
    );

    Text_is_allocated_field_id = (*env)->GetFieldID(
        env,
        Text_class_ref,
        "isAllocated",
        "Z"
    );

    Text_is_owner_field_id = (*env)->GetFieldID(
        env,
        Text_class_ref,
        "isOwner",
        "Z"
    );

    SourceLocation_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$SourceLocation")
    );

    SourceLocation_constructor_id = (*env)->GetMethodID(
        env,
        SourceLocation_class_ref,
        "<init>",
        "(IS)V"
    );

    SourceLocation_line_field_id = (*env)->GetFieldID(
        env,
        SourceLocation_class_ref,
        "line",
        "I"
    );

    SourceLocation_column_field_id = (*env)->GetFieldID(
        env,
        SourceLocation_class_ref,
        "column",
        "S"
    );

    TokenKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$TokenKind")
    );

    TokenKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        TokenKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/libadalang/Libadalang$TokenKind;"
    );

    TokenKind_to_c_method_id = (*env)->GetMethodID(
        env,
        TokenKind_class_ref,
        "toC",
        "()I"
    );

    Char_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$Char")
    );

    Char_constructor_id = (*env)->GetMethodID(
        env,
        Char_class_ref,
        "<init>",
        "(I)V"
    );

    Char_value_field_id = (*env)->GetFieldID(
        env,
        Char_class_ref,
        "value",
        "I"
    );

    BigInteger_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "java/math/BigInteger")
    );

    BigInteger_constructor_id = (*env)->GetMethodID(
        env,
        BigInteger_class_ref,
        "<init>",
        "(Ljava/lang/String;)V"
    );

    BigInteger_to_string_method_id = (*env)->GetMethodID(
        env,
        BigInteger_class_ref,
        "toString",
        "()Ljava/lang/String;"
    );

    SourceLocationRange_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$SourceLocationRange")
    );

    SourceLocationRange_constructor_id = (*env)->GetMethodID(
        env,
        SourceLocationRange_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$SourceLocation;Lcom/adacore/libadalang/Libadalang$SourceLocation;)V"
    );

    SourceLocationRange_start_field_id = (*env)->GetFieldID(
        env,
        SourceLocationRange_class_ref,
        "start",
        "Lcom/adacore/libadalang/Libadalang$SourceLocation;"
    );

    SourceLocationRange_end_field_id = (*env)->GetFieldID(
        env,
        SourceLocationRange_class_ref,
        "end",
        "Lcom/adacore/libadalang/Libadalang$SourceLocation;"
    );

    Diagnostic_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$Diagnostic")
    );

    Diagnostic_constructor_id = (*env)->GetMethodID(
        env,
        Diagnostic_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$SourceLocationRange;Lcom/adacore/libadalang/Libadalang$Text;)V"
    );

    Diagnostic_sloc_range_field_id = (*env)->GetFieldID(
        env,
        Diagnostic_class_ref,
        "sourceLocationRange",
        "Lcom/adacore/libadalang/Libadalang$SourceLocationRange;"
    );

    Diagnostic_text_field_id = (*env)->GetFieldID(
        env,
        Diagnostic_class_ref,
        "message",
        "Lcom/adacore/libadalang/Libadalang$Text;"
    );

    FileReader_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$FileReader")
    );

    FileReader_constructor_id = (*env)->GetMethodID(
        env,
        FileReader_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;)V"
    );

    FileReader_reference_field_id = (*env)->GetFieldID(
        env,
        FileReader_class_ref,
        "reference",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );

    UnitProvider_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$UnitProvider")
    );

    UnitProvider_constructor_id = (*env)->GetMethodID(
        env,
        UnitProvider_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;)V"
    );

    UnitProvider_reference_field_id = (*env)->GetFieldID(
        env,
        UnitProvider_class_ref,
        "reference",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );

    EventHandler_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$EventHandler")
    );

    EventHandler_from_reference_id = (*env)->GetStaticMethodID(
        env,
        EventHandler_class_ref,
        "fromReference",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;)Lcom/adacore/libadalang/Libadalang$EventHandler;"
    );

    EventHandler_reference_field_id = (*env)->GetFieldID(
        env,
        EventHandler_class_ref,
        "reference",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );

    UnitRequestedCallback_class_id = (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$EventHandler$UnitRequestedCallback"
        )
    );

    UnitRequestedCallback_invoke_id = (*env)->GetMethodID(
        env,
        UnitRequestedCallback_class_id,
        "invoke",
        "(Lcom/adacore/libadalang/Libadalang$AnalysisContext;Ljava/lang/String;"
        "Lcom/adacore/libadalang/Libadalang$AnalysisUnit;ZZ)V"
    );

    UnitParsedCallback_class_id = (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$EventHandler$UnitParsedCallback"
        )
    );

    UnitParsedCallback_invoke_id = (*env)->GetMethodID(
        env,
        UnitParsedCallback_class_id,
        "invoke",
        "(Lcom/adacore/libadalang/Libadalang$AnalysisContext;Lcom/adacore/libadalang/Libadalang$AnalysisUnit;Z)V"
    );

    Token_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$Token")
    );

    NoToken_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$Token$NoToken")
    );

    Token_constructor_id = (*env)->GetMethodID(
        env,
        Token_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;Lcom/adacore/libadalang/Libadalang$AnalysisUnit;Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
        "IILcom/adacore/libadalang/Libadalang$TokenKind;Ljava/lang/String;"
        "Lcom/adacore/libadalang/Libadalang$SourceLocationRange;)V"
    );

    Token_none_getter_method_id = (*env)->GetStaticMethodID(
        env,
        Token_class_ref,
        "NONE",
        "(Lcom/adacore/libadalang/Libadalang$AnalysisUnit;)Lcom/adacore/libadalang/Libadalang$Token;"
    );

    Token_context_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "contextRef",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );

    Token_tdh_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "tokenDataHandler",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );

    Token_token_index_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "tokenIndex",
        "I"
    );

    Token_trivia_index_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "triviaIndex",
        "I"
    );

    Token_token_kind_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "kind",
        "Lcom/adacore/libadalang/Libadalang$TokenKind;"
    );

    Token_text_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "text",
        "Ljava/lang/String;"
    );

    Token_sloc_range_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "sourceLocationRange",
        "Lcom/adacore/libadalang/Libadalang$SourceLocationRange;"
    );

    Token_unit_field_id = (*env)->GetFieldID(
        env,
        Token_class_ref,
        "unit",
        "Lcom/adacore/libadalang/Libadalang$AnalysisUnit;"
    );

    AnalysisContext_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$AnalysisContext")
    );

    AnalysisContext_from_reference_id = (*env)->GetStaticMethodID(
        env,
        AnalysisContext_class_ref,
        "fromReference",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;)Lcom/adacore/libadalang/Libadalang$AnalysisContext;"
    );

    AnalysisContext_reference_field_id = (*env)->GetFieldID(
        env,
        AnalysisContext_class_ref,
        "reference",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );

    AnalysisUnit_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$AnalysisUnit")
    );

    AnalysisUnit_constructor_id = (*env)->GetMethodID(
        env,
        AnalysisUnit_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;)V"
    );

    AnalysisUnit_reference_field_id = (*env)->GetFieldID(
        env,
        AnalysisUnit_class_ref,
        "reference",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );

    RewritingApplyResult_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$RewritingApplyResult")
    );

    RewritingApplyResult_contructor_id = (*env)->GetMethodID(
        env,
        RewritingApplyResult_class_ref,
        "<init>",
        "(ZLcom/adacore/libadalang/Libadalang$AnalysisUnit;ILcom/adacore/libadalang/Libadalang$PointerWrapper;)V"
    );

    RewritingApplyResult_success_id = (*env)->GetStaticMethodID(
        env,
        RewritingApplyResult_class_ref,
        "success",
        "()Lcom/adacore/libadalang/Libadalang$RewritingApplyResult;"
    );

    RewritingApplyResult_success_field_id = (*env)->GetFieldID(
        env,
        RewritingApplyResult_class_ref,
        "success",
        "Z"
    );

    RewritingApplyResult_unit_field_id = (*env)->GetFieldID(
        env,
        RewritingApplyResult_class_ref,
        "unit",
        "Lcom/adacore/libadalang/Libadalang$AnalysisUnit;"
    );

    RewritingApplyResult_diagnostics_count_field_id = (*env)->GetFieldID(
        env,
        RewritingApplyResult_class_ref,
        "diagnosticsCount",
        "I"
    );

    RewritingApplyResult_diagnostics_reference_field_id = (*env)->GetFieldID(
        env,
        RewritingApplyResult_class_ref,
        "diagnosticsReference",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );

    RewritingContext_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$RewritingContext")
    );

    RewritingContext_from_reference_id = (*env)->GetStaticMethodID(
        env,
        RewritingContext_class_ref,
        "fromReference",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;)Lcom/adacore/libadalang/Libadalang$RewritingContext;"
    );

    RewritingContext_reference_field_id = (*env)->GetFieldID(
        env,
        RewritingContext_class_ref,
        "reference",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );

    RewritingUnit_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$RewritingUnit")
    );

    RewritingUnit_constructor_id = (*env)->GetMethodID(
        env,
        RewritingUnit_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;)V"
    );

    RewritingUnit_reference_field_id = (*env)->GetFieldID(
        env,
        RewritingUnit_class_ref,
        "reference",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );

    RewritingNode_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$RewritingNode")
    );

    RewritingNode_constructor_id = (*env)->GetMethodID(
        env,
        RewritingNode_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;)V"
    );

    RewritingNode_reference_field_id = (*env)->GetFieldID(
        env,
        RewritingNode_class_ref,
        "reference",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );


    

    Metadata_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$Metadata"
        )
    );

    Metadata_constructor_id = (*env)->GetMethodID(
        env,
        Metadata_class_ref,
        "<init>",
        "(ZLcom/adacore/libadalang/Libadalang$PointerWrapper;Lcom/adacore/libadalang/Libadalang$PointerWrapper;)V"
    );

    Metadata_none_field_id = (*env)->GetStaticFieldID(
        env,
        Metadata_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$Metadata;"
    );

    Metadata_dottable_subp_field_id = (*env)->GetFieldID(
        env,
        Metadata_class_ref,
        "dottableSubp",
        "Z"
    );
    Metadata_primitive_field_id = (*env)->GetFieldID(
        env,
        Metadata_class_ref,
        "primitive",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );
    Metadata_primitive_real_type_field_id = (*env)->GetFieldID(
        env,
        Metadata_class_ref,
        "primitiveRealType",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );


    

    EntityInfo_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$EntityInfo"
        )
    );

    EntityInfo_constructor_id = (*env)->GetMethodID(
        env,
        EntityInfo_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$Metadata;Lcom/adacore/libadalang/Libadalang$PointerWrapper;Z)V"
    );

    EntityInfo_none_field_id = (*env)->GetStaticFieldID(
        env,
        EntityInfo_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$EntityInfo;"
    );

    EntityInfo_md_field_id = (*env)->GetFieldID(
        env,
        EntityInfo_class_ref,
        "md",
        "Lcom/adacore/libadalang/Libadalang$Metadata;"
    );
    EntityInfo_rebindings_field_id = (*env)->GetFieldID(
        env,
        EntityInfo_class_ref,
        "rebindings",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );
    EntityInfo_from_rebound_field_id = (*env)->GetFieldID(
        env,
        EntityInfo_class_ref,
        "fromRebound",
        "Z"
    );


    

    Entity_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$Entity"
        )
    );

    Entity_constructor_id = (*env)->GetMethodID(
        env,
        Entity_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;Lcom/adacore/libadalang/Libadalang$EntityInfo;)V"
    );

    Entity_none_field_id = (*env)->GetStaticFieldID(
        env,
        Entity_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$Entity;"
    );

    Entity_node_field_id = (*env)->GetFieldID(
        env,
        Entity_class_ref,
        "node",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );
    Entity_info_field_id = (*env)->GetFieldID(
        env,
        Entity_class_ref,
        "info",
        "Lcom/adacore/libadalang/Libadalang$EntityInfo;"
    );


    

    Aspect_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$Aspect"
        )
    );

    Aspect_constructor_id = (*env)->GetMethodID(
        env,
        Aspect_class_ref,
        "<init>",
        "(ZLcom/adacore/libadalang/Libadalang$AdaNode;Lcom/adacore/libadalang/Libadalang$Expr;Z)V"
    );

    Aspect_none_field_id = (*env)->GetStaticFieldID(
        env,
        Aspect_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$Aspect;"
    );

    Aspect_exists_field_id = (*env)->GetFieldID(
        env,
        Aspect_class_ref,
        "exists",
        "Z"
    );
    Aspect_node_field_id = (*env)->GetFieldID(
        env,
        Aspect_class_ref,
        "node",
        "Lcom/adacore/libadalang/Libadalang$AdaNode;"
    );
    Aspect_value_field_id = (*env)->GetFieldID(
        env,
        Aspect_class_ref,
        "value",
        "Lcom/adacore/libadalang/Libadalang$Expr;"
    );
    Aspect_inherited_field_id = (*env)->GetFieldID(
        env,
        Aspect_class_ref,
        "inherited",
        "Z"
    );


    

    CompletionItem_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$CompletionItem"
        )
    );

    CompletionItem_constructor_id = (*env)->GetMethodID(
        env,
        CompletionItem_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$BasicDecl;ZZI)V"
    );

    CompletionItem_none_field_id = (*env)->GetStaticFieldID(
        env,
        CompletionItem_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$CompletionItem;"
    );

    CompletionItem_decl_field_id = (*env)->GetFieldID(
        env,
        CompletionItem_class_ref,
        "decl",
        "Lcom/adacore/libadalang/Libadalang$BasicDecl;"
    );
    CompletionItem_is_dot_call_field_id = (*env)->GetFieldID(
        env,
        CompletionItem_class_ref,
        "isDotCall",
        "Z"
    );
    CompletionItem_is_visible_field_id = (*env)->GetFieldID(
        env,
        CompletionItem_class_ref,
        "isVisible",
        "Z"
    );
    CompletionItem_weight_field_id = (*env)->GetFieldID(
        env,
        CompletionItem_class_ref,
        "weight",
        "I"
    );


    

    DiscreteRange_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$DiscreteRange"
        )
    );

    DiscreteRange_constructor_id = (*env)->GetMethodID(
        env,
        DiscreteRange_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$Expr;Lcom/adacore/libadalang/Libadalang$Expr;)V"
    );

    DiscreteRange_none_field_id = (*env)->GetStaticFieldID(
        env,
        DiscreteRange_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$DiscreteRange;"
    );

    DiscreteRange_low_bound_field_id = (*env)->GetFieldID(
        env,
        DiscreteRange_class_ref,
        "lowBound",
        "Lcom/adacore/libadalang/Libadalang$Expr;"
    );
    DiscreteRange_high_bound_field_id = (*env)->GetFieldID(
        env,
        DiscreteRange_class_ref,
        "highBound",
        "Lcom/adacore/libadalang/Libadalang$Expr;"
    );


    

    DiscriminantValues_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$DiscriminantValues"
        )
    );

    DiscriminantValues_constructor_id = (*env)->GetMethodID(
        env,
        DiscriminantValues_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$Identifier;Lcom/adacore/libadalang/Libadalang$AlternativesList;)V"
    );

    DiscriminantValues_none_field_id = (*env)->GetStaticFieldID(
        env,
        DiscriminantValues_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$DiscriminantValues;"
    );

    DiscriminantValues_discriminant_field_id = (*env)->GetFieldID(
        env,
        DiscriminantValues_class_ref,
        "discriminant",
        "Lcom/adacore/libadalang/Libadalang$Identifier;"
    );
    DiscriminantValues_values_field_id = (*env)->GetFieldID(
        env,
        DiscriminantValues_class_ref,
        "values",
        "Lcom/adacore/libadalang/Libadalang$AlternativesList;"
    );


    

    DocAnnotation_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$DocAnnotation"
        )
    );

    DocAnnotation_constructor_id = (*env)->GetMethodID(
        env,
        DocAnnotation_class_ref,
        "<init>",
        "(Ljava/lang/String;Ljava/lang/String;)V"
    );

    DocAnnotation_none_field_id = (*env)->GetStaticFieldID(
        env,
        DocAnnotation_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$DocAnnotation;"
    );

    DocAnnotation_key_field_id = (*env)->GetFieldID(
        env,
        DocAnnotation_class_ref,
        "key",
        "Ljava/lang/String;"
    );
    DocAnnotation_value_field_id = (*env)->GetFieldID(
        env,
        DocAnnotation_class_ref,
        "value",
        "Ljava/lang/String;"
    );


    

    LogicContext_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$LogicContext"
        )
    );

    LogicContext_constructor_id = (*env)->GetMethodID(
        env,
        LogicContext_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$AdaNode;Lcom/adacore/libadalang/Libadalang$AdaNode;)V"
    );

    LogicContext_none_field_id = (*env)->GetStaticFieldID(
        env,
        LogicContext_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$LogicContext;"
    );

    LogicContext_ref_node_field_id = (*env)->GetFieldID(
        env,
        LogicContext_class_ref,
        "refNode",
        "Lcom/adacore/libadalang/Libadalang$AdaNode;"
    );
    LogicContext_decl_node_field_id = (*env)->GetFieldID(
        env,
        LogicContext_class_ref,
        "declNode",
        "Lcom/adacore/libadalang/Libadalang$AdaNode;"
    );


    

    ParamActual_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$ParamActual"
        )
    );

    ParamActual_constructor_id = (*env)->GetMethodID(
        env,
        ParamActual_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$DefiningName;Lcom/adacore/libadalang/Libadalang$Expr;)V"
    );

    ParamActual_none_field_id = (*env)->GetStaticFieldID(
        env,
        ParamActual_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$ParamActual;"
    );

    ParamActual_param_field_id = (*env)->GetFieldID(
        env,
        ParamActual_class_ref,
        "param",
        "Lcom/adacore/libadalang/Libadalang$DefiningName;"
    );
    ParamActual_actual_field_id = (*env)->GetFieldID(
        env,
        ParamActual_class_ref,
        "actual",
        "Lcom/adacore/libadalang/Libadalang$Expr;"
    );


    

    RefResult_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$RefResult"
        )
    );

    RefResult_constructor_id = (*env)->GetMethodID(
        env,
        RefResult_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$BaseId;Lcom/adacore/libadalang/Libadalang$RefResultKind;)V"
    );

    RefResult_none_field_id = (*env)->GetStaticFieldID(
        env,
        RefResult_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$RefResult;"
    );

    RefResult_ref_field_id = (*env)->GetFieldID(
        env,
        RefResult_class_ref,
        "ref",
        "Lcom/adacore/libadalang/Libadalang$BaseId;"
    );
    RefResult_kind_field_id = (*env)->GetFieldID(
        env,
        RefResult_class_ref,
        "kind",
        "Lcom/adacore/libadalang/Libadalang$RefResultKind;"
    );


    

    RefdDecl_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$RefdDecl"
        )
    );

    RefdDecl_constructor_id = (*env)->GetMethodID(
        env,
        RefdDecl_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$BasicDecl;Lcom/adacore/libadalang/Libadalang$RefResultKind;)V"
    );

    RefdDecl_none_field_id = (*env)->GetStaticFieldID(
        env,
        RefdDecl_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$RefdDecl;"
    );

    RefdDecl_decl_field_id = (*env)->GetFieldID(
        env,
        RefdDecl_class_ref,
        "decl",
        "Lcom/adacore/libadalang/Libadalang$BasicDecl;"
    );
    RefdDecl_kind_field_id = (*env)->GetFieldID(
        env,
        RefdDecl_class_ref,
        "kind",
        "Lcom/adacore/libadalang/Libadalang$RefResultKind;"
    );


    

    RefdDef_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$RefdDef"
        )
    );

    RefdDef_constructor_id = (*env)->GetMethodID(
        env,
        RefdDef_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$DefiningName;Lcom/adacore/libadalang/Libadalang$RefResultKind;)V"
    );

    RefdDef_none_field_id = (*env)->GetStaticFieldID(
        env,
        RefdDef_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$RefdDef;"
    );

    RefdDef_def_name_field_id = (*env)->GetFieldID(
        env,
        RefdDef_class_ref,
        "defName",
        "Lcom/adacore/libadalang/Libadalang$DefiningName;"
    );
    RefdDef_kind_field_id = (*env)->GetFieldID(
        env,
        RefdDef_class_ref,
        "kind",
        "Lcom/adacore/libadalang/Libadalang$RefResultKind;"
    );


    

    Shape_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$Shape"
        )
    );

    Shape_constructor_id = (*env)->GetMethodID(
        env,
        Shape_class_ref,
        "<init>",
        "([Lcom/adacore/libadalang/Libadalang$BaseFormalParamDecl;[Lcom/adacore/libadalang/Libadalang$DiscriminantValues;)V"
    );

    Shape_none_field_id = (*env)->GetStaticFieldID(
        env,
        Shape_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$Shape;"
    );

    Shape_components_field_id = (*env)->GetFieldID(
        env,
        Shape_class_ref,
        "components",
        "[Lcom/adacore/libadalang/Libadalang$BaseFormalParamDecl;"
    );
    Shape_discriminants_values_field_id = (*env)->GetFieldID(
        env,
        Shape_class_ref,
        "discriminantsValues",
        "[Lcom/adacore/libadalang/Libadalang$DiscriminantValues;"
    );


    

    SolverDiagnostic_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$SolverDiagnostic"
        )
    );

    SolverDiagnostic_constructor_id = (*env)->GetMethodID(
        env,
        SolverDiagnostic_class_ref,
        "<init>",
        "(Ljava/lang/String;[Lcom/adacore/libadalang/Libadalang$AdaNode;Lcom/adacore/libadalang/Libadalang$AdaNode;[Lcom/adacore/libadalang/Libadalang$LogicContext;I)V"
    );

    SolverDiagnostic_none_field_id = (*env)->GetStaticFieldID(
        env,
        SolverDiagnostic_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$SolverDiagnostic;"
    );

    SolverDiagnostic_message_template_field_id = (*env)->GetFieldID(
        env,
        SolverDiagnostic_class_ref,
        "messageTemplate",
        "Ljava/lang/String;"
    );
    SolverDiagnostic_args_field_id = (*env)->GetFieldID(
        env,
        SolverDiagnostic_class_ref,
        "args",
        "[Lcom/adacore/libadalang/Libadalang$AdaNode;"
    );
    SolverDiagnostic_location_field_id = (*env)->GetFieldID(
        env,
        SolverDiagnostic_class_ref,
        "location",
        "Lcom/adacore/libadalang/Libadalang$AdaNode;"
    );
    SolverDiagnostic_contexts_field_id = (*env)->GetFieldID(
        env,
        SolverDiagnostic_class_ref,
        "contexts",
        "[Lcom/adacore/libadalang/Libadalang$LogicContext;"
    );
    SolverDiagnostic_round_field_id = (*env)->GetFieldID(
        env,
        SolverDiagnostic_class_ref,
        "round",
        "I"
    );


    

    Substitution_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(
            env,
            "com/adacore/libadalang/Libadalang$Substitution"
        )
    );

    Substitution_constructor_id = (*env)->GetMethodID(
        env,
        Substitution_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$BasicDecl;Ljava/math/BigInteger;Lcom/adacore/libadalang/Libadalang$BaseTypeDecl;)V"
    );

    Substitution_none_field_id = (*env)->GetStaticFieldID(
        env,
        Substitution_class_ref,
        "NONE",
        "Lcom/adacore/libadalang/Libadalang$Substitution;"
    );

    Substitution_from_decl_field_id = (*env)->GetFieldID(
        env,
        Substitution_class_ref,
        "fromDecl",
        "Lcom/adacore/libadalang/Libadalang$BasicDecl;"
    );
    Substitution_to_value_field_id = (*env)->GetFieldID(
        env,
        Substitution_class_ref,
        "toValue",
        "Ljava/math/BigInteger;"
    );
    Substitution_value_type_field_id = (*env)->GetFieldID(
        env,
        Substitution_class_ref,
        "valueType",
        "Lcom/adacore/libadalang/Libadalang$BaseTypeDecl;"
    );



    

    AnalysisUnitKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$AnalysisUnitKind")
    );

    AnalysisUnitKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        AnalysisUnitKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/libadalang/Libadalang$AnalysisUnitKind;"
    );

    AnalysisUnitKind_to_c_method_id = (*env)->GetMethodID(
        env,
        AnalysisUnitKind_class_ref,
        "toC",
        "()I"
    );


    

    LookupKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$LookupKind")
    );

    LookupKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        LookupKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/libadalang/Libadalang$LookupKind;"
    );

    LookupKind_to_c_method_id = (*env)->GetMethodID(
        env,
        LookupKind_class_ref,
        "toC",
        "()I"
    );


    

    DesignatedEnvKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$DesignatedEnvKind")
    );

    DesignatedEnvKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        DesignatedEnvKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/libadalang/Libadalang$DesignatedEnvKind;"
    );

    DesignatedEnvKind_to_c_method_id = (*env)->GetMethodID(
        env,
        DesignatedEnvKind_class_ref,
        "toC",
        "()I"
    );


    

    RefResultKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$RefResultKind")
    );

    RefResultKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        RefResultKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/libadalang/Libadalang$RefResultKind;"
    );

    RefResultKind_to_c_method_id = (*env)->GetMethodID(
        env,
        RefResultKind_class_ref,
        "toC",
        "()I"
    );


    

    CallExprKind_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$CallExprKind")
    );

    CallExprKind_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        CallExprKind_class_ref,
        "fromC",
        "(I)Lcom/adacore/libadalang/Libadalang$CallExprKind;"
    );

    CallExprKind_to_c_method_id = (*env)->GetMethodID(
        env,
        CallExprKind_class_ref,
        "toC",
        "()I"
    );


    

    GrammarRule_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$GrammarRule")
    );

    GrammarRule_from_c_method_id = (*env)->GetStaticMethodID(
        env,
        GrammarRule_class_ref,
        "fromC",
        "(I)Lcom/adacore/libadalang/Libadalang$GrammarRule;"
    );

    GrammarRule_to_c_method_id = (*env)->GetMethodID(
        env,
        GrammarRule_class_ref,
        "toC",
        "()I"
    );



    

    AspectArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$AspectArrayWrapper;")
    );

    AspectArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        AspectArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Aspect;)[Lcom/adacore/libadalang/Libadalang$Aspect;"
    );

    AspectArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        AspectArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$Aspect;)[Lcom/adacore/libadalang/Libadalang$Aspect;"
    );


    

    DiscriminantValuesArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$DiscriminantValuesArrayWrapper;")
    );

    DiscriminantValuesArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        DiscriminantValuesArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$DiscriminantValues;)[Lcom/adacore/libadalang/Libadalang$DiscriminantValues;"
    );

    DiscriminantValuesArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        DiscriminantValuesArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$DiscriminantValues;)[Lcom/adacore/libadalang/Libadalang$DiscriminantValues;"
    );


    

    DocAnnotationArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$DocAnnotationArrayWrapper;")
    );

    DocAnnotationArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        DocAnnotationArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$DocAnnotation;)[Lcom/adacore/libadalang/Libadalang$DocAnnotation;"
    );

    DocAnnotationArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        DocAnnotationArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$DocAnnotation;)[Lcom/adacore/libadalang/Libadalang$DocAnnotation;"
    );


    

    AcceptStmtArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$AcceptStmtArrayWrapper;")
    );

    AcceptStmtArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        AcceptStmtArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Entity;)[Lcom/adacore/libadalang/Libadalang$AcceptStmt;"
    );

    AcceptStmtArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        AcceptStmtArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$AcceptStmt;)[Lcom/adacore/libadalang/Libadalang$Entity;"
    );


    

    AdaNodeArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$AdaNodeArrayWrapper;")
    );

    AdaNodeArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        AdaNodeArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Entity;)[Lcom/adacore/libadalang/Libadalang$AdaNode;"
    );

    AdaNodeArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        AdaNodeArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$AdaNode;)[Lcom/adacore/libadalang/Libadalang$Entity;"
    );


    

    BaseFormalParamDeclArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$BaseFormalParamDeclArrayWrapper;")
    );

    BaseFormalParamDeclArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        BaseFormalParamDeclArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Entity;)[Lcom/adacore/libadalang/Libadalang$BaseFormalParamDecl;"
    );

    BaseFormalParamDeclArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        BaseFormalParamDeclArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$BaseFormalParamDecl;)[Lcom/adacore/libadalang/Libadalang$Entity;"
    );


    

    BaseTypeDeclArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$BaseTypeDeclArrayWrapper;")
    );

    BaseTypeDeclArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        BaseTypeDeclArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Entity;)[Lcom/adacore/libadalang/Libadalang$BaseTypeDecl;"
    );

    BaseTypeDeclArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        BaseTypeDeclArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$BaseTypeDecl;)[Lcom/adacore/libadalang/Libadalang$Entity;"
    );


    

    BasicDeclArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$BasicDeclArrayWrapper;")
    );

    BasicDeclArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        BasicDeclArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Entity;)[Lcom/adacore/libadalang/Libadalang$BasicDecl;"
    );

    BasicDeclArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        BasicDeclArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$BasicDecl;)[Lcom/adacore/libadalang/Libadalang$Entity;"
    );


    

    CompilationUnitArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$CompilationUnitArrayWrapper;")
    );

    CompilationUnitArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        CompilationUnitArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Entity;)[Lcom/adacore/libadalang/Libadalang$CompilationUnit;"
    );

    CompilationUnitArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        CompilationUnitArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$CompilationUnit;)[Lcom/adacore/libadalang/Libadalang$Entity;"
    );


    

    DefiningNameArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$DefiningNameArrayWrapper;")
    );

    DefiningNameArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        DefiningNameArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Entity;)[Lcom/adacore/libadalang/Libadalang$DefiningName;"
    );

    DefiningNameArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        DefiningNameArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$DefiningName;)[Lcom/adacore/libadalang/Libadalang$Entity;"
    );


    

    ExprArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$ExprArrayWrapper;")
    );

    ExprArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        ExprArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Entity;)[Lcom/adacore/libadalang/Libadalang$Expr;"
    );

    ExprArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        ExprArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$Expr;)[Lcom/adacore/libadalang/Libadalang$Entity;"
    );


    

    GenericInstantiationArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$GenericInstantiationArrayWrapper;")
    );

    GenericInstantiationArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        GenericInstantiationArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Entity;)[Lcom/adacore/libadalang/Libadalang$GenericInstantiation;"
    );

    GenericInstantiationArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        GenericInstantiationArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$GenericInstantiation;)[Lcom/adacore/libadalang/Libadalang$Entity;"
    );


    

    ParamSpecArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$ParamSpecArrayWrapper;")
    );

    ParamSpecArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        ParamSpecArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Entity;)[Lcom/adacore/libadalang/Libadalang$ParamSpec;"
    );

    ParamSpecArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        ParamSpecArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$ParamSpec;)[Lcom/adacore/libadalang/Libadalang$Entity;"
    );


    

    PragmaNodeArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$PragmaNodeArrayWrapper;")
    );

    PragmaNodeArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        PragmaNodeArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Entity;)[Lcom/adacore/libadalang/Libadalang$PragmaNode;"
    );

    PragmaNodeArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        PragmaNodeArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$PragmaNode;)[Lcom/adacore/libadalang/Libadalang$Entity;"
    );


    

    TypeDeclArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$TypeDeclArrayWrapper;")
    );

    TypeDeclArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        TypeDeclArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Entity;)[Lcom/adacore/libadalang/Libadalang$TypeDecl;"
    );

    TypeDeclArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        TypeDeclArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$TypeDecl;)[Lcom/adacore/libadalang/Libadalang$Entity;"
    );


    

    LogicContextArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$LogicContextArrayWrapper;")
    );

    LogicContextArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        LogicContextArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$LogicContext;)[Lcom/adacore/libadalang/Libadalang$LogicContext;"
    );

    LogicContextArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        LogicContextArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$LogicContext;)[Lcom/adacore/libadalang/Libadalang$LogicContext;"
    );


    

    ParamActualArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$ParamActualArrayWrapper;")
    );

    ParamActualArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        ParamActualArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$ParamActual;)[Lcom/adacore/libadalang/Libadalang$ParamActual;"
    );

    ParamActualArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        ParamActualArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$ParamActual;)[Lcom/adacore/libadalang/Libadalang$ParamActual;"
    );


    

    RefResultArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$RefResultArrayWrapper;")
    );

    RefResultArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        RefResultArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$RefResult;)[Lcom/adacore/libadalang/Libadalang$RefResult;"
    );

    RefResultArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        RefResultArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$RefResult;)[Lcom/adacore/libadalang/Libadalang$RefResult;"
    );


    

    ShapeArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$ShapeArrayWrapper;")
    );

    ShapeArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        ShapeArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Shape;)[Lcom/adacore/libadalang/Libadalang$Shape;"
    );

    ShapeArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        ShapeArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$Shape;)[Lcom/adacore/libadalang/Libadalang$Shape;"
    );


    

    SolverDiagnosticArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$SolverDiagnosticArrayWrapper;")
    );

    SolverDiagnosticArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        SolverDiagnosticArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$SolverDiagnostic;)[Lcom/adacore/libadalang/Libadalang$SolverDiagnostic;"
    );

    SolverDiagnosticArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        SolverDiagnosticArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$SolverDiagnostic;)[Lcom/adacore/libadalang/Libadalang$SolverDiagnostic;"
    );


    

    SubstitutionArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$SubstitutionArrayWrapper;")
    );

    SubstitutionArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        SubstitutionArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Substitution;)[Lcom/adacore/libadalang/Libadalang$Substitution;"
    );

    SubstitutionArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        SubstitutionArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$Substitution;)[Lcom/adacore/libadalang/Libadalang$Substitution;"
    );


    

    AnalysisUnitArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$AnalysisUnitArrayWrapper;")
    );

    AnalysisUnitArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        AnalysisUnitArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$AnalysisUnit;)[Lcom/adacore/libadalang/Libadalang$AnalysisUnit;"
    );

    AnalysisUnitArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        AnalysisUnitArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$AnalysisUnit;)[Lcom/adacore/libadalang/Libadalang$AnalysisUnit;"
    );


    

    UnboundedTextTypeArrayWrapper_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "Lcom/adacore/libadalang/Libadalang$UnboundedTextTypeArrayWrapper;")
    );

    UnboundedTextTypeArrayWrapper_wrap_method_id = (*env)->GetStaticMethodID(
        env,
        UnboundedTextTypeArrayWrapper_class_ref,
        "jniWrap",
        "([Lcom/adacore/libadalang/Libadalang$Symbol;)[Lcom/adacore/libadalang/Libadalang$Symbol;"
    );

    UnboundedTextTypeArrayWrapper_unwrap_method_id = (*env)->GetStaticMethodID(
        env,
        UnboundedTextTypeArrayWrapper_class_ref,
        "jniUnwrap",
        "([Lcom/adacore/libadalang/Libadalang$Symbol;)[Lcom/adacore/libadalang/Libadalang$Symbol;"
    );



    

    CompletionItemIterator_class_ref = (jclass) (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$CompletionItemIterator")
    );

    CompletionItemIterator_constructor_id = (*env)->GetMethodID(
        env,
        CompletionItemIterator_class_ref,
        "<init>",
        "(Lcom/adacore/libadalang/Libadalang$PointerWrapper;)V"
    );

    CompletionItemIterator_reference_field_id = (*env)->GetFieldID(
        env,
        CompletionItemIterator_class_ref,
        "reference",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );


    AdaNode_class_ref = (*env)->NewGlobalRef(
        env,
        (*env)->FindClass(env, "com/adacore/libadalang/Libadalang$AdaNode")
    );

    AdaNode_from_entity_id = (*env)->GetStaticMethodID(
        env,
        AdaNode_class_ref,
        "fromEntity",
        "(Lcom/adacore/libadalang/Libadalang$Entity;)Lcom/adacore/libadalang/Libadalang$AdaNode;"
    );

    AdaNode_entity_field_id = (*env)->GetFieldID(
        env,
        AdaNode_class_ref,
        "entity",
        "Lcom/adacore/libadalang/Libadalang$Entity;"
    );
}

// Function to finalize the JNI library
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1finalize(
    JNIEnv *env,
    jclass jni_lib
) {
    jvm_running = 0;
}

// ==========
// Util functions
// ==========

// Get the native reference in a Java object
void * get_reference(
    JNIEnv *env,
    jobject object
) {
    // Get the object class
    jclass clazz = (*env)->GetObjectClass(env, object);

    // Get the reference field
    jfieldID reference_field = (*env)->GetFieldID(
        env,
        clazz,
        "reference",
        "Lcom/adacore/libadalang/Libadalang$PointerWrapper;"
    );
    jobject reference = (*env)->GetObjectField(env, object, reference_field);

    // Unwrap the reference field to get pointer
    return PointerWrapper_unwrap(env, reference);
}

// Translate a Java string to a C char pointer with the UTF-8 encoding
const char * to_c_string(
    JNIEnv *env,
    jstring j_string
) {
    return (*env)->GetStringUTFChars(env, j_string, NULL);
}

// Release the given C string associated with the given Java string
void release_c_string(
    JNIEnv *env,
    jstring j_string,
    const char *c_string
) {
    (*env)->ReleaseStringUTFChars(env, j_string, c_string);
}

// Create a Java string from a C char pointer
jstring to_j_string(
    JNIEnv *env,
    const char *c_string
) {
    return (*env)->NewStringUTF(env, c_string);
}

// Decode an UTF 32 buffer in a Java string
jstring decode_utf_32(
    JNIEnv *env,
    size_t length,
    uint32_t *to_decode
) {
    // Create a byte array from the buffer to decode
    const jbyte *byte_buffer = (jbyte *) to_decode;
    jsize byte_length = (jsize) (length * 4);
    jbyteArray byte_array = (*env)->NewByteArray(
        env,
        byte_length
    );
    (*env)->SetByteArrayRegion(
        env,
        byte_array,
        0,
        byte_length,
        byte_buffer
    );

    // Call the Java method and return the result
    return (jstring) (*env)->CallStaticObjectMethod(
        env,
        main_class_ref,
        decodeUTF32_method_id,
        byte_array
    );
}

// Encode a Java string in a native buffer
void encode_utf_32(
    JNIEnv *env,
    jstring string,
    size_t *length_ref,
    uint32_t **buffer_ref
) {
    // Call the Java method to get the byte array
    jbyteArray byte_array = (jbyteArray) (*env)->CallStaticObjectMethod(
        env,
        main_class_ref,
        encodeUTF32_method_id,
        string
    );
    size_t byte_length = (size_t) (*env)->GetArrayLength(
        env,
        byte_array
    );

    // Allocate the memory for the native buffer
    *buffer_ref = (uint32_t *) malloc(byte_length);

    // Write the native buffer and the length
    *length_ref = byte_length / 4;
    (*env)->GetByteArrayRegion(
        env,
        byte_array,
        0,
        byte_length,
        (jbyte *) *buffer_ref
    );
}

void check_exception(JNIEnv *env) {
    // Call the Java checking exception function
    (*env)->CallStaticVoidMethod(
        env,
        main_class_ref,
        check_exception_method_id
    );
}

// Util function to wrap a native entity into a Java node class
jobject node_from_entity(JNIEnv *env, jobject entity) {
    return (*env)->CallStaticObjectMethod(
        env,
        AdaNode_class_ref,
        AdaNode_from_entity_id,
        entity
    );
}

// Util function to get the entity Java object from a wrapped node
jobject get_node_entity(JNIEnv *env, jobject node) {
    return (*env)->GetObjectField(
        env,
        node,
        AdaNode_entity_field_id
    );
}

// Function to get a rewriting node array from a Java one
ada_node_rewriting_handle *rewriting_nodes_to_native(
    JNIEnv *env,
    jobjectArray rewriting_nodes
) {
    int size = (*env)->GetArrayLength(env, rewriting_nodes);
    ada_node_rewriting_handle *res =
        (ada_node_rewriting_handle *) malloc(
            size * sizeof(ada_node_rewriting_handle)
        );
    for(int i = 0; i < size; i++) {
        res[i] = RewritingNode_unwrap(
            env,
            (*env)->GetObjectArrayElement(
                env,
                rewriting_nodes,
                (jsize) i
            )
        );
    }
    return res;
}

// ==========
// Language specific extensions
// ==========


      


void add_error_to_diagnostics(
    JNIEnv *env,
    jstring error,
    jobject diagnostics
) {
    // Get the "add" method of the list
    jclass clazz = (*env)->GetObjectClass(env, diagnostics);
    jmethodID add_id = (*env)-> GetMethodID(
        env,
        clazz,
        "add",
        "(Ljava/lang/Object;)Z"
    );

    // Call the "add" method with the Java string to add it to the diagnostics
    (*env)->CallVoidMethod(env, diagnostics, add_id, error);
}

// Unwrap a scenario variable in the given pointer
void ScenarioVariable_unwrap(
    JNIEnv *env,
    jobject scenario_variable,
    ada_gpr_project_scenario_variable *scenario_variables_native_ref
) {
    // Get the Java class
    jclass clazz = (*env)->GetObjectClass(env, scenario_variable);

    // Get the field ids
    jfieldID name_field = (*env)->GetFieldID(
        env,
        clazz,
        "name",
        "Ljava/lang/String;"
    );

    // Get the field values
    jstring name = (jstring) (*env)->GetObjectField(
        env,
        scenario_variable,
        name_field
    );

    // Get the native values
    const char *name_native = (*env)->GetStringUTFChars(
        env,
        name,
        NULL
    );
    int name_native_length = (*env)->GetStringUTFLength(
        env,
        name
    );

    // Allocate the buffer in the result structure
    scenario_variables_native_ref->name = calloc(name_native_length, sizeof(char));
    for(int i = 0; i < name_native_length; i++) {
        scenario_variables_native_ref->name[i] = name_native[i];
    }

    // Release the source chararcter pointer
    (*env)->ReleaseStringUTFChars(env, name, name_native);
    // Get the field ids
    jfieldID value_field = (*env)->GetFieldID(
        env,
        clazz,
        "value",
        "Ljava/lang/String;"
    );

    // Get the field values
    jstring value = (jstring) (*env)->GetObjectField(
        env,
        scenario_variable,
        value_field
    );

    // Get the native values
    const char *value_native = (*env)->GetStringUTFChars(
        env,
        value,
        NULL
    );
    int value_native_length = (*env)->GetStringUTFLength(
        env,
        value
    );

    // Allocate the buffer in the result structure
    scenario_variables_native_ref->value = calloc(value_native_length, sizeof(char));
    for(int i = 0; i < value_native_length; i++) {
        scenario_variables_native_ref->value[i] = value_native[i];
    }

    // Release the source chararcter pointer
    (*env)->ReleaseStringUTFChars(env, value, value_native);
}

// Release the given native scenario variable
void ScenarioVariable_release(
    ada_gpr_project_scenario_variable scenario_variable_native
) {
    free(scenario_variable_native.name);
    free(scenario_variable_native.value);
}

// Load a gpr project
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1gpr_1project_1load(
    JNIEnv *env,
    jclass jni_lib,
    jstring project_file,
    jobjectArray scenario_variables,
    jstring target,
    jstring runtime,
    jstring config_file,
    jobject diagnostics
) {
    // Create the scenario variable array
    ada_gpr_project_scenario_variable *scenario_variables_native = NULL;
    int scenario_variables_length = 0;
    if(scenario_variables != NULL) {
        // Get the scenario variable length
        scenario_variables_length = (*env)->GetArrayLength(env, scenario_variables);
        if(scenario_variables_length > 0) {

            // Allocate the scenario variable array
            int size = scenario_variables_length + 1;
            scenario_variables_native = (ada_gpr_project_scenario_variable*) calloc(
                (size_t) size,
                (size_t) sizeof(ada_gpr_project_scenario_variable)
            );

            // Unwrap all scenario variables in the native array
            for(int i = 0; i < scenario_variables_length; i++) {
                jobject scenario_variable = (*env)->GetObjectArrayElement(
                    env,
                    scenario_variables,
                    (jsize) i
                );
                ScenarioVariable_unwrap(
                    env,
                    scenario_variable,
                    &scenario_variables_native[i]
                );
            }

        }
    }

    // Create the common project arguments
    const char *target_c = target == NULL ? NULL : to_c_string(env, target);
    const char *runtime_c = runtime == NULL ? NULL : to_c_string(env, runtime);
    const char *config_file_c = config_file == NULL ? NULL : to_c_string(env, config_file);
    const int ada_only = 0;
    ada_gpr_project res = NULL;
    ada_string_array_ptr errors = NULL;

    // If the project file is null, load the project as an implicit one, else
    // just load the project file.
    if(project_file == NULL) {
        ada_gpr_project_load_implicit(
            target_c,
            runtime_c,
            config_file_c,
            &res,
            &errors
        );
    } else {
        const char *project_file_c = to_c_string(env, project_file);
        ada_gpr_project_load(
            project_file_c,
            scenario_variables_native,
            target_c,
            runtime_c,
            config_file_c,
            ada_only,
            &res,
            &errors
        );
        (*env)->ReleaseStringUTFChars(env, project_file, project_file_c);
    }

    // Free the scenario variables
    if(scenario_variables_native != NULL) {
        for(int i = 0; i < scenario_variables_length; i++) {
            ScenarioVariable_release(scenario_variables_native[i]);
        }
        free(scenario_variables_native);
    }

    // Free the translated strings
    if (target_c != NULL) {
        (*env)->ReleaseStringUTFChars(env, target, target_c);
    }
    if (runtime_c != NULL) {
        (*env)->ReleaseStringUTFChars(env, runtime, runtime_c);
    }
    if (config_file_c != NULL) {
        (*env)->ReleaseStringUTFChars(env, config_file, config_file_c);
    }

    // The `errors` pointer is not allocated if an exception was raised during
    // project file loading.
    if (errors != NULL) {
        // Handle the errors
        for(int i = 0 ; i < errors->length ; i++) {
            const char *error = errors->c_ptr[i];
            jstring j_error = (*env)->NewStringUTF(env, error);
            add_error_to_diagnostics(env, j_error, diagnostics);
        }

        // Free the error array
        ada_free_string_array(errors);
    }

    // Return the pointer
    return PointerWrapper_wrap(env, (void *) res);
}

// Free a gpr project
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1gpr_1project_1free(
    JNIEnv *env,
    jclass jni_lib,
    jobject project
) {
    // Do the native call
    ada_gpr_project_free((ada_gpr_project) get_reference(env, project));
}

// Get the unit provider from a gpr project
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1gpr_1project_1create_1unit_1provider(
    JNIEnv *env,
    jclass jni_lib,
    jobject project,
    jstring subproject
) {
    const char* subproject_c = NULL;

    if (subproject != NULL) {
        subproject_c = (*env)->GetStringUTFChars(env, subproject, NULL);
    }

    // Call the native function
    ada_unit_provider res = ada_gpr_project_create_unit_provider(
        (ada_gpr_project) get_reference(env, project),
        subproject_c
    );

    // Free all temporarily allocated memory
    if (subproject_c != NULL) {
        (*env)->ReleaseStringUTFChars(env, subproject, subproject_c);
    }

    // Return the new unit provider
    return UnitProvider_wrap(env, res);
}

// Get the list of the files of a project
JNIEXPORT jobjectArray Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1gpr_1project_1source_1files(
    JNIEnv *env,
    jclass jni_lib,
    jobject project,
    jint mode,
    jobjectArray subprojects
) {
    jobjectArray result_java = NULL;

    /* Convert the Java array of subprojects ("subprojects" argument) into the
       required C array (subproject_count/subprojects_c).  */
    jsize subproject_count = 0;
    const char** subprojects_c = NULL;

    if (subprojects != NULL)
      {
	subproject_count = (*env)->GetArrayLength (env, subprojects);
	subprojects_c = calloc (subproject_count, sizeof (char*));
      }

    for (int i = 0; i < subproject_count; ++i)
      {
	jstring subproject
	  = (jstring) (*env)->GetObjectArrayElement (env, subprojects, i);
	subprojects_c[i] = (*env)->GetStringUTFChars (env, subproject, NULL);
      }

    /* Call the C API.  In case of failure, return NULL and let the caller
       propagate the native exception into the Java world.  */
    ada_string_array_ptr result_c = ada_gpr_project_source_files (
        (ada_gpr_project) get_reference (env, project),
        (int) mode,
        subprojects_c,
        subproject_count
    );
    if (ada_get_last_exception () != NULL)
      goto error;

    /* Create the Java array result and initialize it.  */
    jclass clazz = (*env)->FindClass (env, "java/lang/String");
    result_java
      = (*env)->NewObjectArray (env, (jsize) result_c->length, clazz, NULL);
    for (int i = 0 ; i < result_c->length ; i++)
      {
        jstring source_file
	  = to_j_string (env, result_c->c_ptr[i]);
        (*env)->SetObjectArrayElement (env, result_java, (jsize) i,
				       (jobject) source_file);
      }

    /* Now that the Java result is ready, release the C result.  */
    ada_free_string_array (result_c);

error:
    /* Release subprojects_c.  */
    for (int i = 0; i < subproject_count; ++i)
      {
	jstring subproject
	  = (jstring) (*env)->GetObjectArrayElement(env, subprojects, i);
	(*env)->ReleaseStringUTFChars (env, subproject, subprojects_c[i]);
      }
    free (subprojects_c);

    return result_java;
}

/*
 * Create a new analysis context from a GPR project.
 *
 * The unit provider, file reader, config pragmas and default charset are
 * inferred from the designated project: see the ``getProvider`` method for the
 * semantics of the ``project`` argument.
 *
 * See the ``AnalysisContext`` class constructor for the semantics of the other
 * arguments.
 *
 * .. TODO: For now, the returned ``AnalysisContext`` instance has a weak
 *    reference to the project manager: make sure the ``ProjectManager``
 *    instance lives at least as long as the ``AnalysisContext`` one.
 */
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1gpr_1project_1create_1context(
    JNIEnv *env,
    jclass jni_lib,
    jobject project,
    jstring subproject,
    jobject event_handler,
    jboolean with_trivia,
    jint tab_stop
)
{
    const char *subproject_c = NULL;
    if (subproject != NULL)
      subproject_c = (*env)->GetStringUTFChars (env, subproject, NULL);

    ada_event_handler event_handler_c = NULL;
    if (event_handler != NULL)
        event_handler_c = EventHandler_unwrap (env, event_handler);

    /* Manually allocate a C-level analysis context so that we can initialize
       it ourselves.  */
    ada_analysis_context ctx_c = ada_allocate_analysis_context ();

    /* Create the Java wrapper, so that we have one ready for event handler
       callbacks triggered during context initialization.  */
    jobject ctx = AnalysisContext_wrap (env, ctx_c);

    /* The wrapper created its own ownership share: release ours.  */
    ada_context_decref (ctx_c);

    /* TODO: attach extra wrappers to the analysis context wrapper so that
       wrappers ("project" and "event_handler") live at least as long as the
       analysis context.  */

    /* Finally, initialize the analysis context. Note that this step may raise
       an exception: in that case, the analysis context is considered not
       initialized: release it.  */
    ada_gpr_project_initialize_context (
      (ada_gpr_project) get_reference (env, project),
      ctx_c,
      subproject_c,
      event_handler_c,
      (int) with_trivia,
      (int) tab_stop
    );
    if (subproject_c != NULL)
      (*env)->ReleaseStringUTFChars (env, subproject, subproject_c);

    const ada_exception *exc_c = ada_get_last_exception ();
    if (exc_c != NULL)
      {
          jthrowable exc = LangkitException_wrap (env, *exc_c);
          ada_context_decref (ctx_c);
          (*env)->Throw (env, exc);
      }

    return ctx;
}

// Create an auto provider reference
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1create_1auto_1provider(
    JNIEnv *env,
    jclass jni_lib,
    jobjectArray source_files,
    jstring charset
) {
    // Retrieve the number of files N
    jsize source_file_count = (*env)->GetArrayLength(env, source_files);

    // Allocate an array of N+1 element (the last one should be the null pointer),
    // indicating the end of the C array.
    const char** source_files_c = calloc(source_file_count + 1, sizeof(char*));

    for (int i = 0; i < source_file_count; ++i) {
        jstring source_file = (jstring) (*env)->GetObjectArrayElement(
            env,
            source_files,
            i
        );
        source_files_c[i] = (*env)->GetStringUTFChars(env, source_file, NULL);
    }

    const char* charset_c = NULL;

    if (charset != NULL) {
        charset_c = (*env)->GetStringUTFChars(env, charset, NULL);
    }

    // Create the auto provider
    ada_unit_provider res = ada_create_auto_provider(
        source_files_c, charset_c
    );

    // Free all temporarily allocated memory

    if (charset_c != NULL) {
        (*env)->ReleaseStringUTFChars(env, charset, charset_c);
    }

    for (int i = 0; i < source_file_count; ++i) {
        jstring source_file = (jstring) (*env)->GetObjectArrayElement(
            env,
            source_files,
            i
        );
        (*env)->ReleaseStringUTFChars(env, source_file, source_files_c[i]);
    }
    free(source_files_c);

    // Return the new unit provider
    return UnitProvider_wrap(env, res);
}

JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1set_1config_1pragmas_1mapping(
    JNIEnv *env,
    jclass jni_lib,
    jobject context,
    jobject global_pragmas,
    jobjectArray local_pragmas
) {
  ada_analysis_context context_c;
  ada_analysis_unit global_pragmas_c;
  ada_analysis_unit *local_pragmas_c;
  int i, size;

  context_c = AnalysisContext_unwrap (env, context);
  global_pragmas_c
    = (global_pragmas == NULL)
      ? NULL
      : AnalysisUnit_unwrap (env, global_pragmas);

  size = (*env)->GetArrayLength (env, local_pragmas);
  local_pragmas_c = calloc (size, sizeof (ada_analysis_unit));
  for (i = 0; i < size; ++i)
    {
      jobject unit_java
        = (*env)->GetObjectArrayElement (env, local_pragmas, (jsize) i);
      ada_analysis_unit unit_c;

      unit_c
	= (unit_java == NULL) ? NULL : AnalysisUnit_unwrap (env, unit_java);
      local_pragmas_c[i] = unit_c;
    }

  ada_set_config_pragmas_mapping (context_c, global_pragmas_c,
					local_pragmas_c);

  free (local_pragmas_c);
}



// ==========
// Custom pointer functions
// ==========

// Create a new value for a custom pointer
void * PointerWrapper_new_value() {
    return NULL;
}

// Wrap a C pointer in a Java custom pointer
jobject PointerWrapper_wrap(
    JNIEnv *env,
    void *pointer
) {
    // Create the new custom pointer
    return (*env)->NewObject(
        env,
        PointerWrapper_class_ref,
        PointerWrapper_constructor_id,
        (jlong) pointer
    );
}

// Get the C pointer from the Java custom pointer
void * PointerWrapper_unwrap(
    JNIEnv *env,
    jobject custom_pointer
) {
    // Return the C pointer
    return (void *) (*env)->CallLongMethod(
        env,
        custom_pointer,
        PointerWrapper_getter_id
    );
}

// ==========
// Exception functions
// ==========

// Create a new value for an exception
ada_exception LangkitException_new_value() {
    ada_exception res = {
        0,
        NULL
    };
    return res;
}

// Wrap a native langkit exception in a Java exception
jthrowable LangkitException_wrap(
    JNIEnv *env,
    ada_exception exception
) {
    // Return the new exception instance
    return (jthrowable) (*env)->NewObject(
        env,
        LangkitException_class_ref,
        LangkitException_constructor_id,
        (jint) exception.kind,
        to_j_string(env, exception.information)
    );
}

JNIEXPORT jthrowable Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1get_1last_1exception(
    JNIEnv *env,
    jclass jni_lib
) {
    // Call the native function
    const ada_exception *last_exception = ada_get_last_exception();

    // If last exception is null, return a null value, else wrap it
    if(last_exception == NULL) {
        return NULL;
    }
    return LangkitException_wrap(
        env,
        *last_exception
    );
}

// ==========
// Token kind functions
// ==========

// Create a new value for a token kind
ada_token_kind TokenKind_new_value() {
    return 0;
}

// Wrap a native token kind in a Java class
jobject TokenKind_wrap(
    JNIEnv *env,
    ada_token_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        TokenKind_class_ref,
        TokenKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java token kind as a native one
ada_token_kind TokenKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (ada_token_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        TokenKind_to_c_method_id
    );
}

// ==========
// Enumeration generated functions
// ==========


    

// Get a new value for the enumeration
ada_analysis_unit_kind AnalysisUnitKind_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject AnalysisUnitKind_wrap(
    JNIEnv *env,
    ada_analysis_unit_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        AnalysisUnitKind_class_ref,
        AnalysisUnitKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
ada_analysis_unit_kind AnalysisUnitKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (ada_analysis_unit_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        AnalysisUnitKind_to_c_method_id
    );
}


    

// Get a new value for the enumeration
ada_lookup_kind LookupKind_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject LookupKind_wrap(
    JNIEnv *env,
    ada_lookup_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        LookupKind_class_ref,
        LookupKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
ada_lookup_kind LookupKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (ada_lookup_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        LookupKind_to_c_method_id
    );
}


    

// Get a new value for the enumeration
ada_designated_env_kind DesignatedEnvKind_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject DesignatedEnvKind_wrap(
    JNIEnv *env,
    ada_designated_env_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        DesignatedEnvKind_class_ref,
        DesignatedEnvKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
ada_designated_env_kind DesignatedEnvKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (ada_designated_env_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        DesignatedEnvKind_to_c_method_id
    );
}


    

// Get a new value for the enumeration
ada_ref_result_kind RefResultKind_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject RefResultKind_wrap(
    JNIEnv *env,
    ada_ref_result_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        RefResultKind_class_ref,
        RefResultKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
ada_ref_result_kind RefResultKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (ada_ref_result_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        RefResultKind_to_c_method_id
    );
}


    

// Get a new value for the enumeration
ada_call_expr_kind CallExprKind_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject CallExprKind_wrap(
    JNIEnv *env,
    ada_call_expr_kind enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        CallExprKind_class_ref,
        CallExprKind_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
ada_call_expr_kind CallExprKind_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (ada_call_expr_kind) (*env)->CallIntMethod(
        env,
        enum_value,
        CallExprKind_to_c_method_id
    );
}


    

// Get a new value for the enumeration
ada_grammar_rule GrammarRule_new_value() {
    return 0;
}

// Wrap the native enum value in a Java class
jobject GrammarRule_wrap(
    JNIEnv *env,
    ada_grammar_rule enum_value_native
) {
    // Call the static method
    return (*env)->CallStaticObjectMethod(
        env,
        GrammarRule_class_ref,
        GrammarRule_from_c_method_id,
        (jint) enum_value_native
    );
}

// Unwrap a Java enum object in a native enum value
ada_grammar_rule GrammarRule_unwrap(
    JNIEnv *env,
    jobject enum_value
) {
    // Call the Java method
    return (ada_grammar_rule) (*env)->CallIntMethod(
        env,
        enum_value,
        GrammarRule_to_c_method_id
    );
}


// ==========
// Character functions
// ==========

// Create a new value for a character
uint32_t Char_new_value() {
    return 0;
}

// Wrap a native character in the Java wrapping class
jobject Char_wrap(
    JNIEnv *env,
    uint32_t char_native
) {
    // Return the new object
    return (*env)->NewObject(
        env,
        Char_class_ref,
        Char_constructor_id,
        char_native
    );
}

// Get a native character from a Java wrapping instance
uint32_t Char_unwrap(
    JNIEnv *env,
    jobject character
) {
    // Return the result field
    return (uint32_t) (*env)->GetIntField(
        env,
        character,
        Char_value_field_id
    );
}

// ==========
// Big integer functions
// ==========

// Create a new value for a big integer
ada_big_integer BigIntegerWrapper_new_value() {
    return NULL;
}

// Wrap a native big integer in the Java class
jobject BigIntegerWrapper_wrap(
    JNIEnv *env,
    ada_big_integer big_int_native
) {
    // Get the representation of the big integer
    ada_text representation_native = Text_new_value();
    ada_big_integer_text(
        big_int_native,
        &representation_native
    );
    jobject representation_text = Text_wrap(env, representation_native);
    jstring representation = get_text_content(env, representation_text);

    // Destroy the representation text
    ada_destroy_text(
        &representation_native
    );

    // Return the new big integer
    return (*env)->NewObject(
        env,
        BigInteger_class_ref,
        BigInteger_constructor_id,
        representation
    );
}

// Get the native big integer from the Java wrapping instance
ada_big_integer BigIntegerWrapper_unwrap(
    JNIEnv *env,
    jobject big_integer
) {
    // Get the representation of the big integer
    jstring representation = (*env)->CallObjectMethod(
        env,
        big_integer,
        BigInteger_to_string_method_id
    );

    // Create a text from the representations
    jobject representation_text = (*env)->CallStaticObjectMethod(
        env,
        Text_class_ref,
        Text_create_method_id,
        representation
    );
    ada_text representation_native = Text_unwrap(env, representation_text);

    // Create a bit integer from the text
    ada_big_integer res = ada_create_big_integer(
        &representation_native
    );

    // Destroy the text
    free(representation_native.chars);

    // Return the result
    return res;
}

// Release the given native big integer
void BigIntegerWrapper_release(
    ada_big_integer big_int_native
) {
    ada_big_integer_decref(big_int_native);
}

// ==========
// Symbol functions
// ==========

// Create a new value for a symbol
ada_symbol_type Symbol_new_value() {
    ada_symbol_type res = {
        0,
        NULL
    };
    return res;
}

// Wrap a native symbol in the Java class
jobject Symbol_wrap(
    JNIEnv *env,
    ada_symbol_type symbol_native
) {
    // Get the text of the symbol
    ada_text text_native = Text_new_value();
    ada_symbol_text(
        &symbol_native,
        &text_native
    );
    jobject text = Text_wrap(env, text_native);
    jstring symbol_text = get_text_content(env, text);

    // Destroy the text
    ada_destroy_text(
        &text_native
    );

    // Return the new symbol
    return (*env)->NewObject(
        env,
        Symbol_class_ref,
        Symbol_constructor_id,
        symbol_text
    );
}

// Get the native symbol from the Java wrapping instance
ada_symbol_type Symbol_unwrap(
    JNIEnv *env,
    jobject symbol,
    ada_analysis_context context_native
) {
    // Create the result structure
    ada_symbol_type res = Symbol_new_value();

    // Get the fields value
    jstring str = (jstring) (*env)->GetObjectField(
        env,
        symbol,
        Symbol_text_field_id
    );

    // Create a text from the symbol content
    jobject text = text_from_content(env, str);
    ada_text text_native = Text_unwrap(env, text);

    // Call the symbol creation
    int ret_code = ada_context_symbol(
        context_native,
        &text_native,
        &res
    );

    if(ret_code == 0) {
        // Throw a new exception
        jthrowable exception = new_symbol_exception(env, str);
        (*env)->Throw(env, exception);
    }

    // Return the result
    return res;
}

// Create a new symbol exception
jthrowable new_symbol_exception(
    JNIEnv *env,
    jstring symbol_str
) {
    // Return the exception
    return (*env)->NewObject(
        env,
        SymbolException_class_ref,
        SymbolException_constructor_id,
        symbol_str
    );
}

// ==========
// String functions
// ==========

// Create a new value for a langkit string
ada_string_type StringWrapper_new_value() {
    return NULL;
}

// Wrap a native langkit string in the Java class
jstring StringWrapper_wrap(
    JNIEnv *env,
    ada_string_type string_native
) {
    return decode_utf_32(
        env,
        (size_t) string_native->length,
        string_native->content
    );
}

// Get the native langkit string from a Java wrapping instance
ada_string_type StringWrapper_unwrap(
    JNIEnv *env,
    jstring string
) {
    // Encode the Java string
    size_t length;
    uint32_t *buffer;
    encode_utf_32(
        env,
        string,
        &length,
        &buffer
    );

    // Create a new native string
    ada_string_type res = ada_create_string(
        buffer,
        (int) length
    );

    // Free the buffer
    free(buffer);

    // Return the result
    return res;
}

// Release the given native string
void StringWrapper_release(
    ada_string_type string_native
) {
    ada_string_dec_ref(string_native);
}

// ==========
// Text functions
// ==========

// Create a new value for a langkit text
ada_text Text_new_value() {
    ada_text res = {
        NULL,
        0,
        0
    };
    return res;
}

// Wrap a langkit text in the Java wrapping class
jobject Text_wrap(
    JNIEnv *env,
    ada_text text_native
) {
    // Get the int array from the structure and translate it into Java array
    jbyteArray content = (*env)->NewByteArray(
        env,
        (jsize) text_native.length * 4
    );
    (*env)->SetByteArrayRegion(
        env,
        content,
        0,
        (jsize) text_native.length * 4,
        (jbyte *) text_native.chars
    );

    // Return the new text
    return (*env)->NewObject(
        env,
        Text_class_ref,
        Text_constructor_id,
        PointerWrapper_wrap(env, text_native.chars),
        (jlong) text_native.length,
        (jboolean) text_native.is_allocated,
        content
    );
}

// Unwrap a langit text from a Java wrapping instance
ada_text Text_unwrap(
    JNIEnv *env,
    jobject text
) {
    // Create the result structure
    ada_text res = Text_new_value();

    // Get the values
    jobject chars = (*env)->GetObjectField(
        env,
        text,
        Text_chars_field_id
    );
    jlong length = (*env)->GetLongField(
        env,
        text,
        Text_length_field_id
    );
    jboolean is_allocated = (*env)->GetBooleanField(
        env,
        text,
        Text_is_allocated_field_id
    );

    // Fill the structure with the object fields
    res.chars = (uint32_t *) PointerWrapper_unwrap(env, chars);
    res.length = (size_t) length;
    res.is_allocated = (int) is_allocated;

    // Return the result
    return res;
}

// Get the string from a text object
jstring get_text_content(
    JNIEnv *env,
    jobject text
) {
    return (jstring) (*env)->CallObjectMethod(
        env,
        text,
        Text_get_content_method_id
    );
}

// Create a text object from its string content
jobject text_from_content(
    JNIEnv *env,
    jstring content
) {
    // Call the creating method
    return (*env)->CallStaticObjectMethod(
        env,
        Text_class_ref,
        Text_create_method_id,
        content
    );
}

// Create a text Java object from its content
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1create_1text (
    JNIEnv *env,
    jclass jni_lib,
    jbyteArray content_utf32
) {
    // Get the content in a memory buffer
    size_t length = ((size_t) (*env)->GetArrayLength(env, content_utf32)) / 4;
    uint32_t *content_native = (uint32_t *) malloc(length * sizeof(uint32_t));
    (*env)->GetByteArrayRegion(
        env,
        content_utf32,
        0,
        length * 4,
        (jbyte *) content_native
    );

    // Return the new text
    return (*env)->NewObject(
        env,
        Text_class_ref,
        Text_extended_constructor_id,
        PointerWrapper_wrap(env, content_native),
        (jlong) length,
        (jboolean) 0,
        (jboolean) 1,
        content_utf32
    );
}

// Destroy a text object
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1destroy_1text (
    JNIEnv *env,
    jclass jni_lib,
    jobject text
) {
    // Get if the text is the owner of its buffer
    jboolean is_owner = (*env)->GetBooleanField(
        env,
        text,
        Text_is_owner_field_id
    );

    // Unwrap the text
    ada_text text_native = Text_unwrap(env, text);

    // If the object is the buffer owner just free the chars
    if(is_owner) {
        free((void *) text_native.chars);
    } else {
        ada_destroy_text(&text_native);
    }
}

// ==========
// Source location functions
// ==========

// Create a new value for a source location
ada_source_location SourceLocation_new_value() {
    ada_source_location res = {
        0,
        0
    };
    return res;
}

// Wrap a native source location in the Java wrapping class
jobject SourceLocation_wrap(
    JNIEnv *env,
    ada_source_location sloc_native
) {
    // Return the new source location
    return (*env)->NewObject(
        env,
        SourceLocation_class_ref,
        SourceLocation_constructor_id,
        (jint) sloc_native.line,
        (jshort) sloc_native.column
    );
}

// Get a native source location from a Java wrapping instance
ada_source_location SourceLocation_unwrap(
    JNIEnv *env,
    jobject sloc
) {
    // Create the result structure
    ada_source_location res = SourceLocation_new_value();

    // Get the fields value
    jint line = (*env)->GetIntField(
        env,
        sloc,
        SourceLocation_line_field_id
    );
    jshort column = (*env)->GetShortField(
        env,
        sloc,
        SourceLocation_column_field_id
    );

    // Fill the result structure
    res.line = (uint32_t) line;
    res.column = (uint16_t) column;

    // Return the result
    return res;
}

// ==========
// Source location range functions
// ==========

// Create a new value for a source location range
ada_source_location_range SourceLocationRange_new_value() {
    ada_source_location_range res = {
        SourceLocation_new_value(),
        SourceLocation_new_value()
    };
    return res;
}

// Wrap a native source location range in the Java wrapping class
jobject SourceLocationRange_wrap(
    JNIEnv *env,
    ada_source_location_range slocr_native
) {
    // Return the new source location range
    return (*env)->NewObject(
        env,
        SourceLocationRange_class_ref,
        SourceLocationRange_constructor_id,
        SourceLocation_wrap(env, slocr_native.start),
        SourceLocation_wrap(env, slocr_native.end)
    );
}

// Get a native source location range from a Java wrapping instance
ada_source_location_range SourceLocationRange_unwrap(
    JNIEnv *env,
    jobject slocr
) {
    // Create the result structure
    ada_source_location_range res = SourceLocationRange_new_value();

    // Get the fields value
    jobject start = (*env)->GetObjectField(
        env,
        slocr,
        SourceLocationRange_start_field_id
    );
    jobject end = (*env)->GetObjectField(
        env,
        slocr,
        SourceLocationRange_end_field_id
    );

    // Fill the result structure
    res.start = SourceLocation_unwrap(env, start);
    res.end = SourceLocation_unwrap(env, end);

    // Return the result
    return res;
}

// ==========
// Diagnostic functions
// ==========

// Create a new value for a diagnostic
ada_diagnostic Diagnostic_new_value() {
    ada_diagnostic res = {
        SourceLocationRange_new_value(),
        Text_new_value()
    };
    return res;
}

// Wrap a native diagnostic in the Java wrapping class
jobject Diagnostic_wrap(
    JNIEnv *env,
    ada_diagnostic diag_native
) {
    // Return the new diagnostic
    return (*env)->NewObject(
        env,
        Diagnostic_class_ref,
        Diagnostic_constructor_id,
        SourceLocationRange_wrap(env, diag_native.sloc_range),
        Text_wrap(env, diag_native.message)
    );
}

// Get a native diagnostic from a Java wrapping instance
ada_diagnostic Diagnostic_unwrap(
    JNIEnv *env,
    jobject diagnostic
) {
    // Create the result structure
    ada_diagnostic res = Diagnostic_new_value();

    // Get the fields value
    jobject slocr = (*env)->GetObjectField(
        env,
        diagnostic,
        Diagnostic_sloc_range_field_id
    );
    jobject text = (*env)->GetObjectField(
        env,
        diagnostic,
        Diagnostic_text_field_id
    );

    // Fill the result structure
    res.sloc_range = SourceLocationRange_unwrap(env, slocr);
    res.message = Text_unwrap(env, text);

    // Return the result
    return res;
}

// ==========
// Rewriting apply result functions
// ==========

// Create a new vakye for an apply result
ada_rewriting_apply_result RewritingApplyResult_new_value() {
    ada_rewriting_apply_result res = {
        0,
        NULL,
        0,
        NULL
    };
    return res;
}

// Wrap a native rewriting apply result
jobject RewritingApplyResult_wrap(
    JNIEnv *env,
    ada_rewriting_apply_result result_native
) {
    if(result_native.success > 0) {
        return (*env)->CallStaticObjectMethod(
            env,
            RewritingApplyResult_class_ref,
            RewritingApplyResult_success_id
        );
    }
    return (*env)->NewObject(
        env,
        RewritingApplyResult_class_ref,
        RewritingApplyResult_contructor_id,
        (jboolean) 0,
        AnalysisUnit_wrap(env, result_native.unit),
        result_native.diagnostics_count,
        PointerWrapper_wrap(env, (void *) result_native.diagnostics)
    );
}

ada_rewriting_apply_result RewritingApplyResult_unwrap(
    JNIEnv *env,
    jobject rewriting_apply_result
) {
    ada_rewriting_apply_result res = RewritingApplyResult_new_value();
    res.success = (int) (*env)->GetBooleanField(
        env,
        rewriting_apply_result,
        RewritingApplyResult_success_field_id
    );
    res.unit = AnalysisUnit_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            rewriting_apply_result,
            RewritingApplyResult_unit_field_id
        )
    );
    res.diagnostics_count = (int) (*env)->GetIntField(
        env,
        rewriting_apply_result,
        RewritingApplyResult_diagnostics_count_field_id
    );
    res.diagnostics = (ada_diagnostic *) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            rewriting_apply_result,
            RewritingApplyResult_diagnostics_reference_field_id
        )
    );
    return res;
}

// Function to get the wrapped diagnostics inside a rewriting apply result
JNIEXPORT jobjectArray Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1get_1result_1diagnostics(
    JNIEnv *env,
    jclass jni_lib,
    jint diagnostics_count,
    jlong diagnostics_reference
) {
    // Create the result array
    jobjectArray res = (*env)->NewObjectArray(
        env,
        (jsize) diagnostics_count,
        Diagnostic_class_ref,
        NULL
    );

    // Fill the result array by wrapping all diagnostics
    ada_diagnostic *diagnostics_native =
        (ada_diagnostic *) diagnostics_reference;
    for(int i = 0; i < (int) diagnostics_count; i++) {
        (*env)->SetObjectArrayElement(
            env,
            res,
            (jsize) i,
            Diagnostic_wrap(env, diagnostics_native[i])
        );
    }

    // Return the filled array
    return res;
}

// Function to free the rewriting apply result
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1free_1apply_1result(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_apply_result
) {
    ada_rewriting_apply_result result_native =
        RewritingApplyResult_unwrap(
            env,
            rewriting_apply_result
        );
    ada_rewriting_free_apply_result(&result_native);
}

// ==========
// File reader functions
// ==========

// Create a new value for a file reader
ada_file_reader FileReader_new_value() {
    return NULL;
}

// Wrap a native file reader in the Java wrapping class
jobject FileReader_wrap(
    JNIEnv *env,
    ada_file_reader file_reader_native
) {
    // Return the new file reader
    return (*env)->NewObject(
        env,
        FileReader_class_ref,
        FileReader_constructor_id,
        PointerWrapper_wrap(env, (void *) file_reader_native)
    );
}

// Get a native file reader from a Java wrapping instance
ada_file_reader FileReader_unwrap(
    JNIEnv *env,
    jobject file_reader
) {
    return (ada_file_reader) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            file_reader,
            FileReader_reference_field_id
        )
    );
}

// Decrease the reference counter of the given file reader
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1dec_1ref_1file_1reader(
    JNIEnv *env,
    jclass jni_lib,
    jobject file_reader
) {
    ada_dec_ref_file_reader(FileReader_unwrap(env, file_reader));
}

// ==========
// Unit provider functions
// ==========

// Create a new value for a unit provider
ada_unit_provider UnitProvider_new_value() {
    return NULL;
}

// Wrap a native unit provider in the Java wrapping class
jobject UnitProvider_wrap(
    JNIEnv *env,
    ada_unit_provider unit_prov_native
) {
    // Return the new unit provider
    return (*env)->NewObject(
        env,
        UnitProvider_class_ref,
        UnitProvider_constructor_id,
        PointerWrapper_wrap(env, (void *) unit_prov_native)
    );
}

// Get a native unit provider from a Java wrapping instance
ada_unit_provider UnitProvider_unwrap(
    JNIEnv *env,
    jobject unit_provider
) {
    return (ada_unit_provider) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            unit_provider,
            UnitProvider_reference_field_id
        )
    );
}

JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1dec_1ref_1unit_1provider(
    JNIEnv *env,
    jclass jni_lib,
    jobject unit_provider
) {
    ada_dec_ref_unit_provider(UnitProvider_unwrap(env, unit_provider));
}

// ==========
// Event handler functions
// ==========

// Create a new value for a event handler
ada_event_handler EventHandler_new_value() {
    return NULL;
}

// Wrap a native event handler in the Java wrapping class
jobject EventHandler_wrap(
    JNIEnv *env,
    ada_event_handler event_handler_native
) {
    // Return the new event handler
    return (*env)->CallStaticObjectMethod(
        env,
        EventHandler_class_ref,
        EventHandler_from_reference_id,
        PointerWrapper_wrap(env, (void *) event_handler_native)
    );
}

// Get the native event handler from a Java wrapping instance
ada_event_handler EventHandler_unwrap(
    JNIEnv *env,
    jobject event_handler
) {
    return (ada_event_handler) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            event_handler,
            EventHandler_reference_field_id
        )
    );
}

// Util function to destroy the native event handler
void event_handler_destroy(
    void *data
) {
    event_handler_data *eh_data = (event_handler_data *) data;
    JNIEnv *env = eh_data->env;
    if(jvm_running) {
        (*env)->DeleteGlobalRef(env, eh_data->unit_requested_callback);
        (*env)->DeleteGlobalRef(env, eh_data->unit_parsed_callback);
    }
    free(data);
}

// Util function called when a unit is requested
void event_handler_unit_requested(
    void *data,
    ada_analysis_context context,
    ada_text *name,
    ada_analysis_unit from,
    ada_bool found,
    ada_bool is_not_found_error
) {
    // Get the event handler data
    event_handler_data *eh_data = (event_handler_data *) data;
    JNIEnv *env = eh_data->env;

    // Verify that the callback is not null
    if(eh_data->unit_requested_callback != NULL) {
        // Wrap the callback arguments
        jobject analysis_context = AnalysisContext_wrap(env, context);
        jobject text = Text_wrap(env, *name);
        jobject analysis_unit = AnalysisUnit_wrap(env, from);

        // Call the unit requested callback
        (*env)->CallVoidMethod(
            env,
            eh_data->unit_requested_callback,
            UnitRequestedCallback_invoke_id,
            analysis_context,
            get_text_content(env, text),
            analysis_unit,
            (jboolean) found,
            (jboolean) is_not_found_error
        );

        // Remove the intermediary values
        ada_context_decref(context);
        ada_destroy_text(name);
    }
}

// Util function called when a unit is parsed
void event_handler_unit_parsed(
    void *data,
    ada_analysis_context context,
    ada_analysis_unit unit,
    ada_bool reparsed
) {
    // Get the event handler data
    event_handler_data *eh_data = (event_handler_data *) data;
    JNIEnv *env = eh_data->env;

    // Verify that the callback is not null
    if(eh_data->unit_parsed_callback != NULL) {
        // Wrap the callback arguments
        jobject analysis_context = AnalysisContext_wrap(env, context);
        jobject analysis_unit = AnalysisUnit_wrap(env, unit);

        // Call the unit parsed callback
        (*env)->CallVoidMethod(
            env,
            eh_data->unit_parsed_callback,
            UnitParsedCallback_invoke_id,
            analysis_context,
            analysis_unit,
            (jboolean) reparsed
        );

        // Remove the intermediary values
        ada_context_decref(context);
    }
}

// Create a new event handler
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1create_1event_1handler(
    JNIEnv *env,
    jclass jni_lib,
    jobject unit_requested_callback,
    jobject unit_parsed_callback
) {
    // Create the structure to store the event handler information
    event_handler_data *data = (event_handler_data *) malloc(
        sizeof(event_handler_data)
    );
    data->env = env;
    data->unit_requested_callback = (*env)->NewGlobalRef(
        env,
        unit_requested_callback
    );
    data->unit_parsed_callback = (*env)->NewGlobalRef(
        env,
        unit_parsed_callback
    );

    // Call the native function
    ada_event_handler res_native = ada_create_event_handler(
        (void *) data,
        &event_handler_destroy,
        &event_handler_unit_requested,
        &event_handler_unit_parsed
    );

    // Return the wrapped pointer
    return PointerWrapper_wrap(env, (void *) res_native);
}

// Decrease the reference counter of an event handler
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1dec_1ref_1event_1handler(
    JNIEnv *env,
    jclass jni_lib,
    jobject event_handler
) {
    ada_dec_ref_event_handler(EventHandler_unwrap(env, event_handler));
}

// ==========
// Token functions
// ==========

// Create a new value for a token
ada_token Token_new_value() {
    ada_token res = {
        NULL,
        NULL,
        0,
        0
    };
    return res;
}

// Wrap a native token in the Java wrapping class
jobject Token_wrap(
    JNIEnv *env,
    ada_token token_native,
    jobject analysis_unit
) {
    ada_token_kind tok_kind;
    ada_text tok_text;
    ada_source_location_range tok_sloc_range;
    jobject text;
    jstring text_string;

    // Handle the no tokens
    if(token_native.token_data == NULL) {
        return NoToken_wrap(env, analysis_unit);
    }

    // Fetch extra token data requires to build a Token instance, but not
    // present in the C-level token data type: kind, text and sloc_range.
    tok_kind = ada_token_get_kind (&token_native);
    ada_token_sloc_range (&token_native, &tok_sloc_range);

    ada_token_range_text (&token_native, &token_native, &tok_text);
    text = Text_wrap(env, tok_text);
    text_string = get_text_content(env, text);
    ada_destroy_text (&tok_text);

    return (*env)->NewObject(
        env,
        Token_class_ref,
        Token_constructor_id,
        PointerWrapper_wrap(env, token_native.context),
        analysis_unit,
        PointerWrapper_wrap(env, token_native.token_data),
        (jint) token_native.token_index,
        (jint) token_native.trivia_index,
        TokenKind_wrap(env, tok_kind),
        text_string,
        SourceLocationRange_wrap(env, tok_sloc_range)
    );
}

// Get a native token from the Java wrapping instance
ada_token Token_unwrap(
    JNIEnv *env,
    jobject token
) {
    // Prepare the result structure
    ada_token res = Token_new_value();

    // Check if the token is instance of no token
    if((*env)->IsInstanceOf(env, token, NoToken_class_ref)) {
        // Get the value from the object
        jobject context_value = (*env)->GetObjectField(
            env,
            token,
            Token_context_field_id
        );
        jobject tdh_value = (*env)->GetObjectField(
            env,
            token,
            Token_tdh_field_id
        );

        // Fill the result structure
        res.context = (ada_analysis_context) PointerWrapper_unwrap(
            env,
            context_value
        );
        res.token_data = (ada_token_data_handler) PointerWrapper_unwrap(
            env,
            tdh_value
        );
        res.token_index = 0;
        res.trivia_index = 0;

        // Return the result
        return res;

    } else {
        // Get the value from the object
        jobject context_value = (*env)->GetObjectField(
            env,
            token,
            Token_context_field_id
        );
        jobject tdh_value = (*env)->GetObjectField(
            env,
            token,
            Token_tdh_field_id
        );
        jint token_index_value = (*env)->GetIntField(
            env,
            token,
            Token_token_index_field_id
        );
        jint trivia_index_value = (*env)->GetIntField(
            env,
            token,
            Token_trivia_index_field_id
        );

        // Fill the result structure
        res.context = (ada_analysis_context) PointerWrapper_unwrap(
            env,
            context_value
        );
        res.token_data = (ada_token_data_handler) PointerWrapper_unwrap(
            env,
            tdh_value
        );
        res.token_index = (int) token_index_value;
        res.trivia_index = (int) trivia_index_value;

        // Return the result
        return res;

    }
}

// Get the analysis unit from a token
jobject Token_get_unit(
    JNIEnv *env,
    jobject token
) {
    // Return the field
    return (*env)->GetObjectField(
        env,
        token,
        Token_unit_field_id
    );
}

// Get the no token instance for the given analysis unit
jobject NoToken_wrap(
    JNIEnv *env,
    jobject analysis_unit
) {
    // Call the instance getter and return the result
    return (*env)->CallStaticObjectMethod(
        env,
        Token_class_ref,
        Token_none_getter_method_id,
        analysis_unit
    );
}

// Get the next token from the given token
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1token_1next(
    JNIEnv *env,
    jclass jni_lib,
    jobject token
) {
    // Get the token native value
    ada_token token_native = Token_unwrap(env, token);

    // Prepare the result
    ada_token res = Token_new_value();

    // Call the native function
    ada_token_next(
        &token_native,
        &res
    );

    // Return the result token
    return Token_wrap(env, res, Token_get_unit(env, token));
}

// Get the previous token from the given token
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1token_1previous(
    JNIEnv *env,
    jclass jni_lib,
    jobject token
) {
    // Get the token native value
    ada_token token_native = Token_unwrap(env, token);

    // Prepare the result
    ada_token res = Token_new_value();

    // Call the native function
    ada_token_previous(
        &token_native,
        &res
    );

    // Return the result token
    return Token_wrap(env, res, Token_get_unit(env, token));
}

// Get if the given token are equivalents
JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1token_1is_1equivalent(
    JNIEnv *env,
    jclass jni_lib,
    jobject left,
    jobject right
) {
    // Get the token native values
    ada_token left_native = Token_unwrap(env, left);
    ada_token right_native = Token_unwrap(env, right);

    // Return the result of the native call
    return (jboolean) ada_token_is_equivalent(
        &left_native,
        &right_native
    );
}

// Get the text in the token interval
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1token_1range_1text(
    JNIEnv *env,
    jclass jni_lib,
    jobject start,
    jobject end
) {
    // Get the token native values
    ada_token start_native = Token_unwrap(env, start);
    ada_token end_native = Token_unwrap(env, end);

    // Prepare the result
    ada_text res = Text_new_value();

    // Call the native function
    ada_token_range_text(
        &start_native,
        &end_native,
        &res
    );

    // Return the result text
    return Text_wrap(env, res);
}

// ==========
// Analysis context functions
// ==========

// Create a new value for an analysis context
ada_analysis_context AnalysisContext_new_value() {
    return NULL;
}

// Wrap a native analysis context in the Java wrapping class
jobject AnalysisContext_wrap(
    JNIEnv *env,
    ada_analysis_context context_native
) {
    // Return the new analysis context
    return (*env)->CallStaticObjectMethod(
        env,
        AnalysisContext_class_ref,
        AnalysisContext_from_reference_id,
        PointerWrapper_wrap(env, (void *) context_native)
    );
}

// Get a native analysis context from a Java wrapping instance
ada_analysis_context AnalysisContext_unwrap(
    JNIEnv *env,
    jobject analysis_context
) {
    return (ada_analysis_context) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            analysis_context,
            AnalysisContext_reference_field_id
        )
    );
}

// Create a new analysis context
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1create_1analysis_1context(
    JNIEnv *env,
    jclass jni_lib,
    jstring charset,
    jobject file_reader,
    jobject unit_provider,
    jobject event_handler,
    jboolean with_trivia,
    jint tab_stop
) {
    // Translate the charset string
    const char* charset_native = NULL;
    if(charset != NULL) charset_native = to_c_string(env, charset);

    // Allocate the analysis context
    ada_analysis_context res = ada_allocate_analysis_context();

    // Call the native function
    ada_initialize_analysis_context(
        res,
        charset_native,
        FileReader_unwrap(env, file_reader),
        UnitProvider_unwrap(env, unit_provider),
        EventHandler_unwrap(env, event_handler),
        (int) with_trivia,
        (int) tab_stop
    );

    // Release the allocated string
    if(charset != NULL)
        release_c_string(env, charset, charset_native);

    // Return the new custom pointer to the analysis context
    return PointerWrapper_wrap(env, res);
}

// Increase the reference counter of an analysis context
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1context_1incref(
    JNIEnv *env,
    jclass jni_lib,
    jlong analysis_context
) {
    // Call the native function
    ada_context_incref(
        (ada_analysis_context) analysis_context
    );
}

// Decrease the reference counter of an analysis context
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1context_1decref(
    JNIEnv *env,
    jclass jni_lib,
    jlong analysis_context
) {
    // Call the native funtion
    ada_context_decref(
        (ada_analysis_context) analysis_context
    );
}

// ==========
// Analysis unit functions
// ==========

// Create a new value for an analysis unit
ada_analysis_unit AnalysisUnit_new_value() {
    return NULL;
}

// Wrap a native analysis unit in the Java wrapping class
jobject AnalysisUnit_wrap(
    JNIEnv *env,
    ada_analysis_unit unit_native
) {
    // Return the new analysis unit
    return (*env)->NewObject(
        env,
        AnalysisUnit_class_ref,
        AnalysisUnit_constructor_id,
        PointerWrapper_wrap(env, (void *) unit_native)
    );
}

// Get a native analysis unit from a Java wrapping instance
ada_analysis_unit AnalysisUnit_unwrap(
    JNIEnv *env,
    jobject analysis_unit
) {
    return (ada_analysis_unit) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            analysis_unit,
            AnalysisUnit_reference_field_id
        )
    );
}

// Create an analysis unit from a file
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1get_1analysis_1unit_1from_1file(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_context,
    jstring filename,
    jstring charset,
    jboolean reparse,
    jint grammar_rule
) {
    // Translate the Java strings
    const char *filename_native = to_c_string(env, filename);
    const char *charset_native = NULL;
    if(charset != NULL) charset_native = to_c_string(env, charset);

    // Call the native function
    ada_analysis_unit res = ada_get_analysis_unit_from_file(
        AnalysisContext_unwrap(env, analysis_context),
        filename_native,
        charset_native,
        (int) reparse,
        (int) grammar_rule
    );

    // Release the strings
    release_c_string(env, filename, filename_native);
    if(charset != NULL)
        release_c_string(env, charset, charset_native);

    // Return the new Analysis unit
    return AnalysisUnit_wrap(env, res);
}

// Create an analysis unit from a buffer
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1get_1analysis_1unit_1from_1buffer(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_context,
    jstring filename,
    jstring charset,
    jstring buffer,
    jlong buffer_size,
    jint grammar_rule
) {
    // Translate the Java strings
    const char *filename_native = to_c_string(env, filename);
    const char *buffer_native = to_c_string(env, buffer);
    const char *charset_native = NULL;
    if(charset != NULL) charset_native = to_c_string(env, charset);

    // Call the native function
    ada_analysis_unit res = ada_get_analysis_unit_from_buffer(
        AnalysisContext_unwrap(env, analysis_context),
        filename_native,
        charset_native,
        buffer_native,
        (long) buffer_size,
        (int) grammar_rule
    );

    // Release the strings
    release_c_string(env, filename, filename_native);
    release_c_string(env, buffer, buffer_native);
    if(charset != NULL)
        release_c_string(env, charset, charset_native);

    // Return the new analysis unit
    return AnalysisUnit_wrap(env, res);
}

// Create an analysis unit from the unit provider.
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1get_1analysis_1unit_1from_1provider(
    JNIEnv *env,
    jclass jni_lib,
    jobject context,
    jobject name,
    jint kind,
    jstring charset,
    jboolean reparse
) {
    ada_text name_c = Text_unwrap (env, name);
    const char *charset_c
      = (charset == NULL) ? NULL : to_c_string (env, charset);

    ada_analysis_unit result = ada_get_analysis_unit_from_provider(
        AnalysisContext_unwrap(env, context),
        &name_c,
        kind,
        charset_c,
        reparse
    );

    if (charset != NULL)
      release_c_string (env, charset, charset_c);
    ada_destroy_text (&name_c);

    return AnalysisUnit_wrap(env, result);
}

// Get the root entity from an analysis unit
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1unit_1root(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Prepare the result
    ada_node res = Entity_new_value();

    // Call the native function
    ada_unit_root(
        AnalysisUnit_unwrap(env, analysis_unit),
        &res
    );

    // Return the new entity
    return Entity_wrap(env, res);
}

// Get the name of the file related to the analysis unit
JNIEXPORT jstring Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1unit_1filename(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Call the native function
    char *res_native = ada_unit_filename(
        AnalysisUnit_unwrap(env, analysis_unit)
    );

    // Return the new java string
    jstring res = to_j_string(env, res_native);

    // Free the native allocated string
    ada_free((void *) res_native);

    // Return the result
    return res;
}

// Get the token count of the analysis unit
JNIEXPORT jint Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1unit_1token_1count(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    return (jint) ada_unit_token_count(
        AnalysisUnit_unwrap(env, analysis_unit)
    );
}

JNIEXPORT jint Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1unit_1trivia_1count(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    return (jint) ada_unit_trivia_count(
        AnalysisUnit_unwrap(env, analysis_unit)
    );
}

// Get the first token of the analysis unit
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1unit_1first_1token(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Prepare the result
    ada_token res = Token_new_value();

    // Call the native function
    ada_unit_first_token(
        AnalysisUnit_unwrap(env, analysis_unit),
        &res
    );

    // Return the result token
    return Token_wrap(env, res, analysis_unit);
}

// Get the last token of the analysis unit
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1unit_1last_1token(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Prepare the result
    ada_token res = Token_new_value();

    // Call the native function
    ada_unit_last_token(
        AnalysisUnit_unwrap(env, analysis_unit),
        &res
    );

    // Return the result token
    return Token_wrap(env, res, analysis_unit);
}

// Get the analysis context for an analysis unit
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1unit_1context(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Call the native result
    ada_analysis_context res = ada_unit_context(
        AnalysisUnit_unwrap(env, analysis_unit)
    );

    // Return the result context
    return AnalysisContext_wrap(env, res);
}

// Get the count of the diagnostic in the analysis unit
JNIEXPORT jint Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1unit_1diagnostic_1count(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    // Return the casted native call
    return (jint) ada_unit_diagnostic_count(
        AnalysisUnit_unwrap(env, analysis_unit)
    );
}

// Get the nth diagnostic in the analysis unit
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1unit_1diagnostic(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit,
    jint n
) {
    // Prepare the result
    ada_diagnostic res = Diagnostic_new_value();

    // Call the native function
    ada_unit_diagnostic(
        AnalysisUnit_unwrap(env, analysis_unit),
        (unsigned) n,
        &res
    );

    // Return the diagnostic
    return Diagnostic_wrap(env, res);
}

// ==========
// Rewriting context functions
// ==========

// Create a new value for a rewriting context
ada_rewriting_handle RewritingContext_new_value() {
    return NULL;
}

// Wrap a native rewriting context in its Java class
jobject RewritingContext_wrap(
    JNIEnv *env,
    ada_rewriting_handle rewriting_context_native
) {
    return (*env)->CallStaticObjectMethod(
        env,
        RewritingContext_class_ref,
        RewritingContext_from_reference_id,
        PointerWrapper_wrap(env, (void *) rewriting_context_native)
    );
}

// Unwrap a Java rewriting context to its native value
ada_rewriting_handle RewritingContext_unwrap(
    JNIEnv *env,
    jobject rewriting_context
) {
    return (ada_rewriting_handle) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            rewriting_context,
            RewritingContext_reference_field_id
        )
    );
}

// Start a rewriting session on the given analysis context
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1start_1rewriting(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_context
) {
    // Call the native function to create a rewriting context and return the
    // wrapped result.
    return RewritingContext_wrap(
        env,
        ada_rewriting_start_rewriting(AnalysisContext_unwrap(
            env,
            analysis_context
        ))
    );
}

// Get the analysis context
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1handle_1to_1context(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context
) {
    return AnalysisContext_wrap(
        env,
        ada_rewriting_handle_to_context(
            RewritingContext_unwrap(env, rewriting_context)
        )
    );
}

// Get the rewriting units of the context
JNIEXPORT jobjectArray Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1unit_1handles(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context
) {
    // Call the native function to get the native rewriting units
    ada_unit_rewriting_handle *unit_array_native =
        ada_rewriting_unit_handles(
            RewritingContext_unwrap(env, rewriting_context)
        );

    // Count the number of units in the result
    unsigned int unit_count = 0;
    ada_unit_rewriting_handle *cursor = unit_array_native;
    while(*cursor != NULL) {
        cursor = &cursor[1];
        unit_count++;
    }

    // Create the result array and fill it
    jobjectArray res = (*env)->NewObjectArray(
        env,
        (jsize) unit_count,
        RewritingUnit_class_ref,
        NULL
    );
    for(unsigned int i = 0; i < unit_count; i++) {
        (*env)->SetObjectArrayElement(
            env,
            res,
            (jsize) i,
            RewritingUnit_wrap(env, unit_array_native[i])
        );
    }
    free(unit_array_native);
    return res;
}

// Create a new rewriting node in the given context
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1create_1node(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context,
    jint node_kind
) {
    return RewritingNode_wrap(
        env,
        ada_rewriting_create_node(
            RewritingContext_unwrap(env, rewriting_context),
            (ada_node_kind_enum) node_kind
        )
    );
}

// Create a new rewriting node with its children
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1create_1regular_1node(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context,
    jint node_kind,
    jobjectArray children
) {
    // Unwrap the children
    ada_node_rewriting_handle *children_native =
        rewriting_nodes_to_native(env, children);

    // Call the native function and wrap the result
    jobject res = RewritingNode_wrap(
        env,
        ada_rewriting_create_regular_node(
            RewritingContext_unwrap(env, rewriting_context),
            (ada_node_kind_enum) node_kind,
            children_native,
            (*env)->GetArrayLength(env, children)
        )
    );

    // Free the native children array then return the result
    free(children_native);
    return res;
}

// Create a new rewriting token node in the given context
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1create_1token_1node(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context,
    jint node_kind,
    jobject node_text
) {
    ada_text node_text_native = Text_unwrap(env, node_text);
    return RewritingNode_wrap(
        env,
        ada_rewriting_create_token_node(
            RewritingContext_unwrap(env, rewriting_context),
            (ada_node_kind_enum) node_kind,
            &node_text_native
        )
    );
}

// Create a new node tree from a template
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1create_1from_1template(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context,
    jobject template_text,
    jobjectArray arguments,
    jint rule
) {
    // Unwrap the arguments and template text
    int count = (*env)->GetArrayLength(env, arguments);
    ada_node_rewriting_handle *arguments_native =
        rewriting_nodes_to_native(env, arguments);
    ada_text template_text_native = Text_unwrap(env, template_text);

    // Call the native function
    jobject res = RewritingNode_wrap(
        env,
        ada_rewriting_create_from_template(
            RewritingContext_unwrap(env, rewriting_context),
            &template_text_native,
            arguments_native,
            count,
            (ada_grammar_rule) rule
        )
    );

    // Free the arguments native array the return the result
    free(arguments_native);
    return res;
}

// Apply the rewriting session and close it if success
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1apply(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context
) {
    ada_rewriting_apply_result res_native =
        RewritingApplyResult_new_value();
    ada_rewriting_apply(
        RewritingContext_unwrap(env, rewriting_context),
        &res_native
    );
    return RewritingApplyResult_wrap(env, res_native);
}

// Abort the rewriting session
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1abort_1rewriting(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_context
) {
    // Just call the native function
    ada_rewriting_abort_rewriting(
        RewritingContext_unwrap(env, rewriting_context)
    );
}

// ==========
// Rewriting unit functions
// ==========

// Create a new value for a native rewriting unit
ada_unit_rewriting_handle RewritingUnit_new_value() {
    return NULL;
}

// Wrap the native rewrite unit inside the Java class
jobject RewritingUnit_wrap(
    JNIEnv *env,
    ada_unit_rewriting_handle rewriting_unit_native
) {
    return (*env)->NewObject(
        env,
        RewritingUnit_class_ref,
        RewritingUnit_constructor_id,
        PointerWrapper_wrap(env, (void *) rewriting_unit_native)
    );
}

// Unwrap the Java rewrite unit into a native value
ada_unit_rewriting_handle RewritingUnit_unwrap(
    JNIEnv *env,
    jobject rewriting_unit
) {
    return (ada_unit_rewriting_handle) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            rewriting_unit,
            RewritingUnit_reference_field_id
        )
    );
}

// Get or create the rewriting unit from an analysis unit
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1unit_1to_1handle(
    JNIEnv *env,
    jclass jni_lib,
    jobject analysis_unit
) {
    return RewritingUnit_wrap(
        env,
        ada_rewriting_unit_to_handle(
            AnalysisUnit_unwrap(env, analysis_unit)
        )
    );
}

// Get the analysis unit from the rewriting unit
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1handle_1to_1unit(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_unit
) {
    return AnalysisUnit_wrap(
        env,
        ada_rewriting_handle_to_unit(
            RewritingUnit_unwrap(env, rewriting_unit)
        )
    );
}

// Get the root rewriting node of the rewriting unit
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1unit_1root(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_unit
) {
    return RewritingNode_wrap(
        env,
        ada_rewriting_unit_root(
            RewritingUnit_unwrap(env, rewriting_unit)
        )
    );
}

// Set the root rewriting node of the rewriting unit
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1unit_1set_1root(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_unit,
    jobject rewriting_node
) {
    ada_rewriting_unit_set_root(
        RewritingUnit_unwrap(env, rewriting_unit),
        RewritingNode_unwrap(env, rewriting_node)
    );
}

// Unparse the given rewriting unit
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1unit_1unparse(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_unit
) {
    ada_text res_native = Text_new_value();
    ada_rewriting_unit_unparse(
        RewritingUnit_unwrap(env, rewriting_unit),
        &res_native
    );
    return Text_wrap(env, res_native);
}

// ==========
// Rewriting node functions
// ==========

// Create a new rewriting node native value
ada_node_rewriting_handle RewritingNode_new_value() {
    return NULL;
}

// Wrap the native rewriting node
jobject RewritingNode_wrap(
    JNIEnv *env,
    ada_node_rewriting_handle rewriting_node_native
) {
    return (*env)->NewObject(
        env,
        RewritingNode_class_ref,
        RewritingNode_constructor_id,
        PointerWrapper_wrap(env, (void *) rewriting_node_native)
    );
}

// Unwrap the Java rewriting node
ada_node_rewriting_handle RewritingNode_unwrap(
    JNIEnv *env,
    jobject rewriting_node
) {
    return (ada_node_rewriting_handle) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            rewriting_node,
            RewritingNode_reference_field_id
        )
    );
}

// Get the rewriting node from the parsed node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1node_1to_1handle(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
 ) {
    return RewritingNode_wrap(
        env,
        ada_rewriting_node_to_handle(
            Entity_unwrap(env, entity).node
        )
    );
}

// Get the parsed node from the given rewriting node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1handle_1to_1node(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    ada_base_node bare_node = ada_rewriting_handle_to_node(
        RewritingNode_unwrap(
            env,
            rewriting_node
        )
    );
    ada_node res_native = Entity_new_value();
    ada_create_bare_entity(
        bare_node,
        &res_native
    );
    return Entity_wrap(env, res_native);
}

// Get the rewriting context of the given node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1node_1to_1context(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    return RewritingContext_wrap(
        env,
        ada_rewriting_node_to_context(
            RewritingNode_unwrap(env, rewriting_node)
        )
    );
}

// Clone the given rewriting node and return the result
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1clone(
    JNIEnv *env,
    jclass jni_lib,
    jobject to_clone
) {
    return RewritingNode_wrap(
        env,
        ada_rewriting_clone(
            RewritingNode_unwrap(env, to_clone)
        )
    );
}

// Unparse the given rewriting node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1node_1unparse(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    ada_text res_native = Text_new_value();
    ada_rewriting_node_unparse(
        RewritingNode_unwrap(env, rewriting_node),
        &res_native
    );
    return Text_wrap(
        env,
        res_native
    );
}

// Get the kind index of the rewriting node
JNIEXPORT jint Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    return (jint) ada_rewriting_kind(
        RewritingNode_unwrap(env, rewriting_node)
    );
}

// Get the image of the rewriting node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1node_1image(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    ada_text res_native = Text_new_value();
    ada_rewriting_node_image(
        RewritingNode_unwrap(env, rewriting_node),
        &res_native
    );
    return Text_wrap(env, res_native);
}

// Get whether the node is tied
JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1tied(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    return (jboolean) ada_rewriting_tied(
        RewritingNode_unwrap(env, rewriting_node)
    );
}

// Get the parent of the rewriting node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1parent(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    return RewritingNode_wrap(
        env,
        ada_rewriting_parent(
            RewritingNode_unwrap(env, rewriting_node)
        )
    );
}

// Get the rewriting node children
JNIEXPORT jobjectArray Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1children(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    // Call the native method
    ada_node_rewriting_handle *children = NULL;
    int count = 0;
    ada_rewriting_children(
        RewritingNode_unwrap(env, rewriting_node),
        &children,
        &count
    );

    // Create the new java array adn fill it
    jobjectArray res = (*env)->NewObjectArray(
        env,
        (jsize) count,
        RewritingNode_class_ref,
        NULL
    );
    for(int i = 0; i < count; i++) {
        (*env)->SetObjectArrayElement(
            env,
            res,
            (jsize) i,
            RewritingNode_wrap(env, children[i])
        );
    }

    // Free the native children
    free(children);

    // Return the result
    return res;
}

// Get the child of the rewriting node by its member reference
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_parent,
    jint child_member_reference
) {
    return RewritingNode_wrap(
        env,
        ada_rewriting_child(
            RewritingNode_unwrap(env, rewriting_parent),
            (ada_introspection_member_ref) child_member_reference
        )
    );
}

// Set the given child at the given member reference
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1set_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject parent,
    jint child_member_reference,
    jobject new_child
) {
    ada_rewriting_set_child(
        RewritingNode_unwrap(env, parent),
        (ada_introspection_member_ref) child_member_reference,
        RewritingNode_unwrap(env, new_child)
    );
}

// Replace the rewriting node with the new one.
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1replace(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node,
    jobject new_node
) {
    ada_rewriting_replace(
        RewritingNode_unwrap(env, rewriting_node),
        RewritingNode_unwrap(env, new_node)
    );
}

// Get the first child of the given parent
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1first_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_parent
) {
    return RewritingNode_wrap(
        env,
        ada_rewriting_first_child(
            RewritingNode_unwrap(env, rewriting_parent)
        )
    );
}

// Get the last child of the given parent
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1last_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_parent
) {
    return RewritingNode_wrap(
        env,
        ada_rewriting_last_child(
            RewritingNode_unwrap(env, rewriting_parent)
        )
    );
}

// Get the next child from the given rewriting node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1next_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    return RewritingNode_wrap(
        env,
        ada_rewriting_next_child(
            RewritingNode_unwrap(env, rewriting_node)
        )
    );
}

// Get the previous child from the given rewriting node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1previous_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    return RewritingNode_wrap(
        env,
        ada_rewriting_previous_child(
            RewritingNode_unwrap(env, rewriting_node)
        )
    );
}

// Insert the rewriting node before the other
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1insert_1before(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node,
    jobject to_insert
) {
    ada_rewriting_insert_before(
        RewritingNode_unwrap(env, rewriting_node),
        RewritingNode_unwrap(env, to_insert)
    );
}

// Insert the rewriting node after the other
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1insert_1after(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node,
    jobject to_insert
) {
    ada_rewriting_insert_after(
        RewritingNode_unwrap(env, rewriting_node),
        RewritingNode_unwrap(env, to_insert)
    );
}

// Insert the rewriting node at the beginning of children
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1insert_1first(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node,
    jobject to_insert
) {
    ada_rewriting_insert_first(
        RewritingNode_unwrap(env, rewriting_node),
        RewritingNode_unwrap(env, to_insert)
    );
}

// Insert the rewriting node at the end of children
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1insert_1last(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node,
    jobject to_insert
) {
    ada_rewriting_insert_last(
        RewritingNode_unwrap(env, rewriting_node),
        RewritingNode_unwrap(env, to_insert)
    );
}

// Remove the given node from its list parent
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1remove_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject to_remove
) {
    ada_rewriting_remove_child(
        RewritingNode_unwrap(env, to_remove)
    );
}

// Get the text of the given rewriting token node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1text(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node
) {
    ada_text res_native = Text_new_value();
    ada_rewriting_text(
        RewritingNode_unwrap(env, rewriting_node),
        &res_native
    );
    return Text_wrap(env, res_native);
}

// Set the text of the given rewriting token node
JNIEXPORT void Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1rewriting_1set_1text(
    JNIEnv *env,
    jclass jni_lib,
    jobject rewriting_node,
    jobject text
) {
    ada_text text_native = Text_unwrap(env, text);
    ada_rewriting_set_text(
        RewritingNode_unwrap(env, rewriting_node),
        &text_native
    );
}

// ==========
// Generated structure functions
// ==========


    

// Create a new value for a langkit ada_internal_metadata
ada_internal_metadata Metadata_new_value() {
    ada_internal_metadata res = {
        0,
        PointerWrapper_new_value(),
        PointerWrapper_new_value(),
    };
    return res;
}

// Wrap a native ada_internal_metadata in the Java wrapping class
jobject Metadata_wrap(
    JNIEnv *env,
    ada_internal_metadata native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        Metadata_class_ref,
        Metadata_constructor_id,
        (jboolean) native_struct.dottable_subp,PointerWrapper_wrap(env, (void*) native_struct.primitive),PointerWrapper_wrap(env, (void*) native_struct.primitive_real_type)
    );
}


// Get a native ada_internal_metadata from a Java wrapping instance
ada_internal_metadata Metadata_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_metadata res = Metadata_new_value();

    // Get the field values
    jboolean dottable_subp_value =
        (*env)->GetBooleanField(
            env,
            object,
            Metadata_dottable_subp_field_id
        );
    jobject primitive_value =
        (*env)->GetObjectField(
            env,
            object,
            Metadata_primitive_field_id
        );
    jobject primitive_real_type_value =
        (*env)->GetObjectField(
            env,
            object,
            Metadata_primitive_real_type_field_id
        );

    // Fill the result structure
    ada_bool dottable_subp_native = (ada_bool) dottable_subp_value;
    res.dottable_subp = dottable_subp_native;
    ada_base_node primitive_native = (ada_base_node) PointerWrapper_unwrap(env, primitive_value);
    res.primitive = primitive_native;
    ada_base_node primitive_real_type_native = (ada_base_node) PointerWrapper_unwrap(env, primitive_real_type_value);
    res.primitive_real_type = primitive_real_type_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit ada_internal_entity_info
ada_internal_entity_info EntityInfo_new_value() {
    ada_internal_entity_info res = {
        Metadata_new_value(),
        PointerWrapper_new_value(),
        0,
    };
    return res;
}

// Wrap a native ada_internal_entity_info in the Java wrapping class
jobject EntityInfo_wrap(
    JNIEnv *env,
    ada_internal_entity_info native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        EntityInfo_class_ref,
        EntityInfo_constructor_id,
        Metadata_wrap(env, native_struct.md),PointerWrapper_wrap(env, native_struct.rebindings),(jboolean) native_struct.from_rebound
    );
}


// Get a native ada_internal_entity_info from a Java wrapping instance
ada_internal_entity_info EntityInfo_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_entity_info res = EntityInfo_new_value();

    // Get the field values
    jobject md_value =
        (*env)->GetObjectField(
            env,
            object,
            EntityInfo_md_field_id
        );
    jobject rebindings_value =
        (*env)->GetObjectField(
            env,
            object,
            EntityInfo_rebindings_field_id
        );
    jboolean from_rebound_value =
        (*env)->GetBooleanField(
            env,
            object,
            EntityInfo_from_rebound_field_id
        );

    // Fill the result structure
    ada_internal_metadata md_native = Metadata_unwrap(env, md_value);
    res.md = md_native;
    ada_env_rebindings_type rebindings_native = PointerWrapper_unwrap(env, rebindings_value);
    res.rebindings = rebindings_native;
    ada_bool from_rebound_native = (ada_bool) from_rebound_value;
    res.from_rebound = from_rebound_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit ada_node
ada_node Entity_new_value() {
    ada_node res = {
        PointerWrapper_new_value(),
        EntityInfo_new_value(),
    };
    return res;
}

// Wrap a native ada_node in the Java wrapping class
jobject Entity_wrap(
    JNIEnv *env,
    ada_node native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        Entity_class_ref,
        Entity_constructor_id,
        PointerWrapper_wrap(env, (void*) native_struct.node),EntityInfo_wrap(env, native_struct.info)
    );
}

jobject Entity_wrap_bare_node(
    JNIEnv *env,
    ada_base_node bare_node
) {
    ada_node struct_native = Entity_new_value();
    struct_native.node = bare_node;
    return Entity_wrap(env, struct_native);
}

// Get a native ada_node from a Java wrapping instance
ada_node Entity_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_node res = Entity_new_value();

    // Get the field values
    jobject node_value =
        (*env)->GetObjectField(
            env,
            object,
            Entity_node_field_id
        );
    jobject info_value =
        (*env)->GetObjectField(
            env,
            object,
            Entity_info_field_id
        );

    // Fill the result structure
    ada_base_node node_native = (ada_base_node) PointerWrapper_unwrap(env, node_value);
    res.node = node_native;
    ada_internal_entity_info info_native = EntityInfo_unwrap(env, info_value);
    res.info = info_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit ada_internal_aspect
ada_internal_aspect Aspect_new_value() {
    ada_internal_aspect res = {
        0,
        Entity_new_value(),
        Entity_new_value(),
        0,
    };
    return res;
}

// Wrap a native ada_internal_aspect in the Java wrapping class
jobject Aspect_wrap(
    JNIEnv *env,
    ada_internal_aspect native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        Aspect_class_ref,
        Aspect_constructor_id,
        (jboolean) native_struct.exists,node_from_entity(env, Entity_wrap(env, native_struct.node)),node_from_entity(env, Entity_wrap(env, native_struct.value)),(jboolean) native_struct.inherited
    );
}


// Get a native ada_internal_aspect from a Java wrapping instance
ada_internal_aspect Aspect_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_aspect res = Aspect_new_value();

    // Get the field values
    jboolean exists_value =
        (*env)->GetBooleanField(
            env,
            object,
            Aspect_exists_field_id
        );
    jobject node_value =
        (*env)->GetObjectField(
            env,
            object,
            Aspect_node_field_id
        );
    jobject value_value =
        (*env)->GetObjectField(
            env,
            object,
            Aspect_value_field_id
        );
    jboolean inherited_value =
        (*env)->GetBooleanField(
            env,
            object,
            Aspect_inherited_field_id
        );

    // Fill the result structure
    ada_bool exists_native = (ada_bool) exists_value;
    res.exists = exists_native;
    ada_node node_native = Entity_unwrap(env, get_node_entity(env, node_value));
    res.node = node_native;
    ada_node value_native = Entity_unwrap(env, get_node_entity(env, value_value));
    res.value = value_native;
    ada_bool inherited_native = (ada_bool) inherited_value;
    res.inherited = inherited_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit ada_internal_completion_item
ada_internal_completion_item CompletionItem_new_value() {
    ada_internal_completion_item res = {
        Entity_new_value(),
        0,
        0,
        0,
    };
    return res;
}

// Wrap a native ada_internal_completion_item in the Java wrapping class
jobject CompletionItem_wrap(
    JNIEnv *env,
    ada_internal_completion_item native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        CompletionItem_class_ref,
        CompletionItem_constructor_id,
        node_from_entity(env, Entity_wrap(env, native_struct.decl)),(jboolean) native_struct.is_dot_call,(jboolean) native_struct.is_visible,(jint) native_struct.weight
    );
}


// Get a native ada_internal_completion_item from a Java wrapping instance
ada_internal_completion_item CompletionItem_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_completion_item res = CompletionItem_new_value();

    // Get the field values
    jobject decl_value =
        (*env)->GetObjectField(
            env,
            object,
            CompletionItem_decl_field_id
        );
    jboolean is_dot_call_value =
        (*env)->GetBooleanField(
            env,
            object,
            CompletionItem_is_dot_call_field_id
        );
    jboolean is_visible_value =
        (*env)->GetBooleanField(
            env,
            object,
            CompletionItem_is_visible_field_id
        );
    jint weight_value =
        (*env)->GetIntField(
            env,
            object,
            CompletionItem_weight_field_id
        );

    // Fill the result structure
    ada_node decl_native = Entity_unwrap(env, get_node_entity(env, decl_value));
    res.decl = decl_native;
    ada_bool is_dot_call_native = (ada_bool) is_dot_call_value;
    res.is_dot_call = is_dot_call_native;
    ada_bool is_visible_native = (ada_bool) is_visible_value;
    res.is_visible = is_visible_native;
    int weight_native = (int) weight_value;
    res.weight = weight_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit ada_internal_discrete_range
ada_internal_discrete_range DiscreteRange_new_value() {
    ada_internal_discrete_range res = {
        Entity_new_value(),
        Entity_new_value(),
    };
    return res;
}

// Wrap a native ada_internal_discrete_range in the Java wrapping class
jobject DiscreteRange_wrap(
    JNIEnv *env,
    ada_internal_discrete_range native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        DiscreteRange_class_ref,
        DiscreteRange_constructor_id,
        node_from_entity(env, Entity_wrap(env, native_struct.low_bound)),node_from_entity(env, Entity_wrap(env, native_struct.high_bound))
    );
}


// Get a native ada_internal_discrete_range from a Java wrapping instance
ada_internal_discrete_range DiscreteRange_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_discrete_range res = DiscreteRange_new_value();

    // Get the field values
    jobject low_bound_value =
        (*env)->GetObjectField(
            env,
            object,
            DiscreteRange_low_bound_field_id
        );
    jobject high_bound_value =
        (*env)->GetObjectField(
            env,
            object,
            DiscreteRange_high_bound_field_id
        );

    // Fill the result structure
    ada_node low_bound_native = Entity_unwrap(env, get_node_entity(env, low_bound_value));
    res.low_bound = low_bound_native;
    ada_node high_bound_native = Entity_unwrap(env, get_node_entity(env, high_bound_value));
    res.high_bound = high_bound_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit ada_internal_discriminant_values
ada_internal_discriminant_values DiscriminantValues_new_value() {
    ada_internal_discriminant_values res = {
        Entity_new_value(),
        Entity_new_value(),
    };
    return res;
}

// Wrap a native ada_internal_discriminant_values in the Java wrapping class
jobject DiscriminantValues_wrap(
    JNIEnv *env,
    ada_internal_discriminant_values native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        DiscriminantValues_class_ref,
        DiscriminantValues_constructor_id,
        node_from_entity(env, Entity_wrap(env, native_struct.discriminant)),node_from_entity(env, Entity_wrap(env, native_struct.values))
    );
}


// Get a native ada_internal_discriminant_values from a Java wrapping instance
ada_internal_discriminant_values DiscriminantValues_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_discriminant_values res = DiscriminantValues_new_value();

    // Get the field values
    jobject discriminant_value =
        (*env)->GetObjectField(
            env,
            object,
            DiscriminantValues_discriminant_field_id
        );
    jobject values_value =
        (*env)->GetObjectField(
            env,
            object,
            DiscriminantValues_values_field_id
        );

    // Fill the result structure
    ada_node discriminant_native = Entity_unwrap(env, get_node_entity(env, discriminant_value));
    res.discriminant = discriminant_native;
    ada_node values_native = Entity_unwrap(env, get_node_entity(env, values_value));
    res.values = values_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit ada_internal_doc_annotation
ada_internal_doc_annotation DocAnnotation_new_value() {
    ada_internal_doc_annotation res = {
        StringWrapper_new_value(),
        StringWrapper_new_value(),
    };
    return res;
}

// Wrap a native ada_internal_doc_annotation in the Java wrapping class
jobject DocAnnotation_wrap(
    JNIEnv *env,
    ada_internal_doc_annotation native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        DocAnnotation_class_ref,
        DocAnnotation_constructor_id,
        StringWrapper_wrap(env, native_struct.key),StringWrapper_wrap(env, native_struct.value)
    );
}


// Get a native ada_internal_doc_annotation from a Java wrapping instance
ada_internal_doc_annotation DocAnnotation_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_doc_annotation res = DocAnnotation_new_value();

    // Get the field values
    jobject key_value =
        (*env)->GetObjectField(
            env,
            object,
            DocAnnotation_key_field_id
        );
    jobject value_value =
        (*env)->GetObjectField(
            env,
            object,
            DocAnnotation_value_field_id
        );

    // Fill the result structure
    ada_string_type key_native = StringWrapper_unwrap(env, key_value);
    res.key = key_native;
    ada_string_type value_native = StringWrapper_unwrap(env, value_value);
    res.value = value_native;

    // Return the native result
    return res;
}

// Decrease the reference counter of the given structure
void DocAnnotation_release(
    ada_internal_doc_annotation struct_native
) {
    ada_internal_doc_annotation_dec_ref(&struct_native);
}


    

// Create a new value for a langkit ada_internal_logic_context
ada_internal_logic_context LogicContext_new_value() {
    ada_internal_logic_context res = {
        Entity_new_value(),
        Entity_new_value(),
    };
    return res;
}

// Wrap a native ada_internal_logic_context in the Java wrapping class
jobject LogicContext_wrap(
    JNIEnv *env,
    ada_internal_logic_context native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        LogicContext_class_ref,
        LogicContext_constructor_id,
        node_from_entity(env, Entity_wrap(env, native_struct.ref_node)),node_from_entity(env, Entity_wrap(env, native_struct.decl_node))
    );
}


// Get a native ada_internal_logic_context from a Java wrapping instance
ada_internal_logic_context LogicContext_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_logic_context res = LogicContext_new_value();

    // Get the field values
    jobject ref_node_value =
        (*env)->GetObjectField(
            env,
            object,
            LogicContext_ref_node_field_id
        );
    jobject decl_node_value =
        (*env)->GetObjectField(
            env,
            object,
            LogicContext_decl_node_field_id
        );

    // Fill the result structure
    ada_node ref_node_native = Entity_unwrap(env, get_node_entity(env, ref_node_value));
    res.ref_node = ref_node_native;
    ada_node decl_node_native = Entity_unwrap(env, get_node_entity(env, decl_node_value));
    res.decl_node = decl_node_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit ada_internal_param_actual
ada_internal_param_actual ParamActual_new_value() {
    ada_internal_param_actual res = {
        Entity_new_value(),
        Entity_new_value(),
    };
    return res;
}

// Wrap a native ada_internal_param_actual in the Java wrapping class
jobject ParamActual_wrap(
    JNIEnv *env,
    ada_internal_param_actual native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        ParamActual_class_ref,
        ParamActual_constructor_id,
        node_from_entity(env, Entity_wrap(env, native_struct.param)),node_from_entity(env, Entity_wrap(env, native_struct.actual))
    );
}


// Get a native ada_internal_param_actual from a Java wrapping instance
ada_internal_param_actual ParamActual_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_param_actual res = ParamActual_new_value();

    // Get the field values
    jobject param_value =
        (*env)->GetObjectField(
            env,
            object,
            ParamActual_param_field_id
        );
    jobject actual_value =
        (*env)->GetObjectField(
            env,
            object,
            ParamActual_actual_field_id
        );

    // Fill the result structure
    ada_node param_native = Entity_unwrap(env, get_node_entity(env, param_value));
    res.param = param_native;
    ada_node actual_native = Entity_unwrap(env, get_node_entity(env, actual_value));
    res.actual = actual_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit ada_internal_ref_result
ada_internal_ref_result RefResult_new_value() {
    ada_internal_ref_result res = {
        Entity_new_value(),
        RefResultKind_new_value(),
    };
    return res;
}

// Wrap a native ada_internal_ref_result in the Java wrapping class
jobject RefResult_wrap(
    JNIEnv *env,
    ada_internal_ref_result native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        RefResult_class_ref,
        RefResult_constructor_id,
        node_from_entity(env, Entity_wrap(env, native_struct.ref)),RefResultKind_wrap(env, native_struct.kind)
    );
}


// Get a native ada_internal_ref_result from a Java wrapping instance
ada_internal_ref_result RefResult_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_ref_result res = RefResult_new_value();

    // Get the field values
    jobject ref_value =
        (*env)->GetObjectField(
            env,
            object,
            RefResult_ref_field_id
        );
    jobject kind_value =
        (*env)->GetObjectField(
            env,
            object,
            RefResult_kind_field_id
        );

    // Fill the result structure
    ada_node ref_native = Entity_unwrap(env, get_node_entity(env, ref_value));
    res.ref = ref_native;
    ada_ref_result_kind kind_native = RefResultKind_unwrap(env, kind_value);
    res.kind = kind_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit ada_internal_refd_decl
ada_internal_refd_decl RefdDecl_new_value() {
    ada_internal_refd_decl res = {
        Entity_new_value(),
        RefResultKind_new_value(),
    };
    return res;
}

// Wrap a native ada_internal_refd_decl in the Java wrapping class
jobject RefdDecl_wrap(
    JNIEnv *env,
    ada_internal_refd_decl native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        RefdDecl_class_ref,
        RefdDecl_constructor_id,
        node_from_entity(env, Entity_wrap(env, native_struct.decl)),RefResultKind_wrap(env, native_struct.kind)
    );
}


// Get a native ada_internal_refd_decl from a Java wrapping instance
ada_internal_refd_decl RefdDecl_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_refd_decl res = RefdDecl_new_value();

    // Get the field values
    jobject decl_value =
        (*env)->GetObjectField(
            env,
            object,
            RefdDecl_decl_field_id
        );
    jobject kind_value =
        (*env)->GetObjectField(
            env,
            object,
            RefdDecl_kind_field_id
        );

    // Fill the result structure
    ada_node decl_native = Entity_unwrap(env, get_node_entity(env, decl_value));
    res.decl = decl_native;
    ada_ref_result_kind kind_native = RefResultKind_unwrap(env, kind_value);
    res.kind = kind_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit ada_internal_refd_def
ada_internal_refd_def RefdDef_new_value() {
    ada_internal_refd_def res = {
        Entity_new_value(),
        RefResultKind_new_value(),
    };
    return res;
}

// Wrap a native ada_internal_refd_def in the Java wrapping class
jobject RefdDef_wrap(
    JNIEnv *env,
    ada_internal_refd_def native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        RefdDef_class_ref,
        RefdDef_constructor_id,
        node_from_entity(env, Entity_wrap(env, native_struct.def_name)),RefResultKind_wrap(env, native_struct.kind)
    );
}


// Get a native ada_internal_refd_def from a Java wrapping instance
ada_internal_refd_def RefdDef_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_refd_def res = RefdDef_new_value();

    // Get the field values
    jobject def_name_value =
        (*env)->GetObjectField(
            env,
            object,
            RefdDef_def_name_field_id
        );
    jobject kind_value =
        (*env)->GetObjectField(
            env,
            object,
            RefdDef_kind_field_id
        );

    // Fill the result structure
    ada_node def_name_native = Entity_unwrap(env, get_node_entity(env, def_name_value));
    res.def_name = def_name_native;
    ada_ref_result_kind kind_native = RefResultKind_unwrap(env, kind_value);
    res.kind = kind_native;

    // Return the native result
    return res;
}



    

// Create a new value for a langkit ada_internal_shape
ada_internal_shape Shape_new_value() {
    ada_internal_shape res = {
        BaseFormalParamDeclArrayWrapper_new_value(),
        DiscriminantValuesArrayWrapper_new_value(),
    };
    return res;
}

// Wrap a native ada_internal_shape in the Java wrapping class
jobject Shape_wrap(
    JNIEnv *env,
    ada_internal_shape native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        Shape_class_ref,
        Shape_constructor_id,
        BaseFormalParamDeclArrayWrapper_wrap(env, native_struct.components),DiscriminantValuesArrayWrapper_wrap(env, native_struct.discriminants_values)
    );
}


// Get a native ada_internal_shape from a Java wrapping instance
ada_internal_shape Shape_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_shape res = Shape_new_value();

    // Get the field values
    jobject components_value =
        (*env)->GetObjectField(
            env,
            object,
            Shape_components_field_id
        );
    jobject discriminants_values_value =
        (*env)->GetObjectField(
            env,
            object,
            Shape_discriminants_values_field_id
        );

    // Fill the result structure
    ada_node_array components_native = BaseFormalParamDeclArrayWrapper_unwrap(env, components_value);
    res.components = components_native;
    ada_internal_discriminant_values_array discriminants_values_native = DiscriminantValuesArrayWrapper_unwrap(env, discriminants_values_value);
    res.discriminants_values = discriminants_values_native;

    // Return the native result
    return res;
}

// Decrease the reference counter of the given structure
void Shape_release(
    ada_internal_shape struct_native
) {
    ada_internal_shape_dec_ref(&struct_native);
}


    

// Create a new value for a langkit ada_internal_solver_diagnostic
ada_internal_solver_diagnostic SolverDiagnostic_new_value() {
    ada_internal_solver_diagnostic res = {
        StringWrapper_new_value(),
        AdaNodeArrayWrapper_new_value(),
        PointerWrapper_new_value(),
        LogicContextArrayWrapper_new_value(),
        0,
    };
    return res;
}

// Wrap a native ada_internal_solver_diagnostic in the Java wrapping class
jobject SolverDiagnostic_wrap(
    JNIEnv *env,
    ada_internal_solver_diagnostic native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        SolverDiagnostic_class_ref,
        SolverDiagnostic_constructor_id,
        StringWrapper_wrap(env, native_struct.message_template),AdaNodeArrayWrapper_wrap(env, native_struct.args),node_from_entity(env, Entity_wrap_bare_node(env, native_struct.location)),LogicContextArrayWrapper_wrap(env, native_struct.contexts),(jint) native_struct.round
    );
}


// Get a native ada_internal_solver_diagnostic from a Java wrapping instance
ada_internal_solver_diagnostic SolverDiagnostic_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_solver_diagnostic res = SolverDiagnostic_new_value();

    // Get the field values
    jobject message_template_value =
        (*env)->GetObjectField(
            env,
            object,
            SolverDiagnostic_message_template_field_id
        );
    jobject args_value =
        (*env)->GetObjectField(
            env,
            object,
            SolverDiagnostic_args_field_id
        );
    jobject location_value =
        (*env)->GetObjectField(
            env,
            object,
            SolverDiagnostic_location_field_id
        );
    jobject contexts_value =
        (*env)->GetObjectField(
            env,
            object,
            SolverDiagnostic_contexts_field_id
        );
    jint round_value =
        (*env)->GetIntField(
            env,
            object,
            SolverDiagnostic_round_field_id
        );

    // Fill the result structure
    ada_string_type message_template_native = StringWrapper_unwrap(env, message_template_value);
    res.message_template = message_template_native;
    ada_node_array args_native = AdaNodeArrayWrapper_unwrap(env, args_value);
    res.args = args_native;
    ada_base_node location_native = Entity_unwrap(env, get_node_entity(env, location_value)).node;
    res.location = location_native;
    ada_internal_logic_context_array contexts_native = LogicContextArrayWrapper_unwrap(env, contexts_value);
    res.contexts = contexts_native;
    int round_native = (int) round_value;
    res.round = round_native;

    // Return the native result
    return res;
}

// Decrease the reference counter of the given structure
void SolverDiagnostic_release(
    ada_internal_solver_diagnostic struct_native
) {
    ada_internal_solver_diagnostic_dec_ref(&struct_native);
}


    

// Create a new value for a langkit ada_internal_substitution
ada_internal_substitution Substitution_new_value() {
    ada_internal_substitution res = {
        Entity_new_value(),
        BigIntegerWrapper_new_value(),
        Entity_new_value(),
    };
    return res;
}

// Wrap a native ada_internal_substitution in the Java wrapping class
jobject Substitution_wrap(
    JNIEnv *env,
    ada_internal_substitution native_struct
) {
    // Return the new Java instance
    return (*env)->NewObject(
        env,
        Substitution_class_ref,
        Substitution_constructor_id,
        node_from_entity(env, Entity_wrap(env, native_struct.from_decl)),BigIntegerWrapper_wrap(env, native_struct.to_value),node_from_entity(env, Entity_wrap(env, native_struct.value_type))
    );
}


// Get a native ada_internal_substitution from a Java wrapping instance
ada_internal_substitution Substitution_unwrap(
    JNIEnv *env,
    jobject object
) {
    // Prepare the result structure
    ada_internal_substitution res = Substitution_new_value();

    // Get the field values
    jobject from_decl_value =
        (*env)->GetObjectField(
            env,
            object,
            Substitution_from_decl_field_id
        );
    jobject to_value_value =
        (*env)->GetObjectField(
            env,
            object,
            Substitution_to_value_field_id
        );
    jobject value_type_value =
        (*env)->GetObjectField(
            env,
            object,
            Substitution_value_type_field_id
        );

    // Fill the result structure
    ada_node from_decl_native = Entity_unwrap(env, get_node_entity(env, from_decl_value));
    res.from_decl = from_decl_native;
    ada_big_integer to_value_native = BigIntegerWrapper_unwrap(env, to_value_value);
    res.to_value = to_value_native;
    ada_node value_type_native = Entity_unwrap(env, get_node_entity(env, value_type_value));
    res.value_type = value_type_native;

    // Return the native result
    return res;
}

// Decrease the reference counter of the given structure
void Substitution_release(
    ada_internal_substitution struct_native
) {
    ada_internal_substitution_dec_ref(&struct_native);
}


// ==========
// Generated array functions
// ==========


    

// Create a new value for a ada_internal_aspect_array
ada_internal_aspect_array AspectArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_internal_aspect_array in the Java wrapping class
jobject AspectArrayWrapper_wrap(
    JNIEnv *env,
    ada_internal_aspect_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Aspect_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_internal_aspect elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Aspect_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        AspectArrayWrapper_class_ref,
        AspectArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_internal_aspect_array from a Java wrapping instance
ada_internal_aspect_array AspectArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        AspectArrayWrapper_class_ref,
        AspectArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_internal_aspect_array res = ada_internal_aspect_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_internal_aspect elem_native = Aspect_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void AspectArrayWrapper_release(
    ada_internal_aspect_array array_native
) {
    ada_internal_aspect_array_dec_ref(array_native);
}


    

// Create a new value for a ada_internal_discriminant_values_array
ada_internal_discriminant_values_array DiscriminantValuesArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_internal_discriminant_values_array in the Java wrapping class
jobject DiscriminantValuesArrayWrapper_wrap(
    JNIEnv *env,
    ada_internal_discriminant_values_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        DiscriminantValues_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_internal_discriminant_values elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            DiscriminantValues_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        DiscriminantValuesArrayWrapper_class_ref,
        DiscriminantValuesArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_internal_discriminant_values_array from a Java wrapping instance
ada_internal_discriminant_values_array DiscriminantValuesArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        DiscriminantValuesArrayWrapper_class_ref,
        DiscriminantValuesArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_internal_discriminant_values_array res = ada_internal_discriminant_values_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_internal_discriminant_values elem_native = DiscriminantValues_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void DiscriminantValuesArrayWrapper_release(
    ada_internal_discriminant_values_array array_native
) {
    ada_internal_discriminant_values_array_dec_ref(array_native);
}


    

// Create a new value for a ada_internal_doc_annotation_array
ada_internal_doc_annotation_array DocAnnotationArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_internal_doc_annotation_array in the Java wrapping class
jobject DocAnnotationArrayWrapper_wrap(
    JNIEnv *env,
    ada_internal_doc_annotation_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        DocAnnotation_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_internal_doc_annotation elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            DocAnnotation_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        DocAnnotationArrayWrapper_class_ref,
        DocAnnotationArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_internal_doc_annotation_array from a Java wrapping instance
ada_internal_doc_annotation_array DocAnnotationArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        DocAnnotationArrayWrapper_class_ref,
        DocAnnotationArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_internal_doc_annotation_array res = ada_internal_doc_annotation_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_internal_doc_annotation elem_native = DocAnnotation_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void DocAnnotationArrayWrapper_release(
    ada_internal_doc_annotation_array array_native
) {
    ada_internal_doc_annotation_array_dec_ref(array_native);
}


    

// Create a new value for a ada_node_array
ada_node_array AcceptStmtArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_node_array in the Java wrapping class
jobject AcceptStmtArrayWrapper_wrap(
    JNIEnv *env,
    ada_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        AcceptStmtArrayWrapper_class_ref,
        AcceptStmtArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_node_array from a Java wrapping instance
ada_node_array AcceptStmtArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        AcceptStmtArrayWrapper_class_ref,
        AcceptStmtArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_node_array res = ada_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void AcceptStmtArrayWrapper_release(
    ada_node_array array_native
) {
    ada_node_array_dec_ref(array_native);
}


    

// Create a new value for a ada_node_array
ada_node_array AdaNodeArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_node_array in the Java wrapping class
jobject AdaNodeArrayWrapper_wrap(
    JNIEnv *env,
    ada_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        AdaNodeArrayWrapper_class_ref,
        AdaNodeArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_node_array from a Java wrapping instance
ada_node_array AdaNodeArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        AdaNodeArrayWrapper_class_ref,
        AdaNodeArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_node_array res = ada_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void AdaNodeArrayWrapper_release(
    ada_node_array array_native
) {
    ada_node_array_dec_ref(array_native);
}


    

// Create a new value for a ada_node_array
ada_node_array BaseFormalParamDeclArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_node_array in the Java wrapping class
jobject BaseFormalParamDeclArrayWrapper_wrap(
    JNIEnv *env,
    ada_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        BaseFormalParamDeclArrayWrapper_class_ref,
        BaseFormalParamDeclArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_node_array from a Java wrapping instance
ada_node_array BaseFormalParamDeclArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        BaseFormalParamDeclArrayWrapper_class_ref,
        BaseFormalParamDeclArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_node_array res = ada_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void BaseFormalParamDeclArrayWrapper_release(
    ada_node_array array_native
) {
    ada_node_array_dec_ref(array_native);
}


    

// Create a new value for a ada_node_array
ada_node_array BaseTypeDeclArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_node_array in the Java wrapping class
jobject BaseTypeDeclArrayWrapper_wrap(
    JNIEnv *env,
    ada_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        BaseTypeDeclArrayWrapper_class_ref,
        BaseTypeDeclArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_node_array from a Java wrapping instance
ada_node_array BaseTypeDeclArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        BaseTypeDeclArrayWrapper_class_ref,
        BaseTypeDeclArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_node_array res = ada_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void BaseTypeDeclArrayWrapper_release(
    ada_node_array array_native
) {
    ada_node_array_dec_ref(array_native);
}


    

// Create a new value for a ada_node_array
ada_node_array BasicDeclArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_node_array in the Java wrapping class
jobject BasicDeclArrayWrapper_wrap(
    JNIEnv *env,
    ada_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        BasicDeclArrayWrapper_class_ref,
        BasicDeclArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_node_array from a Java wrapping instance
ada_node_array BasicDeclArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        BasicDeclArrayWrapper_class_ref,
        BasicDeclArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_node_array res = ada_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void BasicDeclArrayWrapper_release(
    ada_node_array array_native
) {
    ada_node_array_dec_ref(array_native);
}


    

// Create a new value for a ada_node_array
ada_node_array CompilationUnitArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_node_array in the Java wrapping class
jobject CompilationUnitArrayWrapper_wrap(
    JNIEnv *env,
    ada_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        CompilationUnitArrayWrapper_class_ref,
        CompilationUnitArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_node_array from a Java wrapping instance
ada_node_array CompilationUnitArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        CompilationUnitArrayWrapper_class_ref,
        CompilationUnitArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_node_array res = ada_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void CompilationUnitArrayWrapper_release(
    ada_node_array array_native
) {
    ada_node_array_dec_ref(array_native);
}


    

// Create a new value for a ada_node_array
ada_node_array DefiningNameArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_node_array in the Java wrapping class
jobject DefiningNameArrayWrapper_wrap(
    JNIEnv *env,
    ada_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        DefiningNameArrayWrapper_class_ref,
        DefiningNameArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_node_array from a Java wrapping instance
ada_node_array DefiningNameArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        DefiningNameArrayWrapper_class_ref,
        DefiningNameArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_node_array res = ada_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void DefiningNameArrayWrapper_release(
    ada_node_array array_native
) {
    ada_node_array_dec_ref(array_native);
}


    

// Create a new value for a ada_node_array
ada_node_array ExprArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_node_array in the Java wrapping class
jobject ExprArrayWrapper_wrap(
    JNIEnv *env,
    ada_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        ExprArrayWrapper_class_ref,
        ExprArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_node_array from a Java wrapping instance
ada_node_array ExprArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        ExprArrayWrapper_class_ref,
        ExprArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_node_array res = ada_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void ExprArrayWrapper_release(
    ada_node_array array_native
) {
    ada_node_array_dec_ref(array_native);
}


    

// Create a new value for a ada_node_array
ada_node_array GenericInstantiationArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_node_array in the Java wrapping class
jobject GenericInstantiationArrayWrapper_wrap(
    JNIEnv *env,
    ada_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        GenericInstantiationArrayWrapper_class_ref,
        GenericInstantiationArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_node_array from a Java wrapping instance
ada_node_array GenericInstantiationArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        GenericInstantiationArrayWrapper_class_ref,
        GenericInstantiationArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_node_array res = ada_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void GenericInstantiationArrayWrapper_release(
    ada_node_array array_native
) {
    ada_node_array_dec_ref(array_native);
}


    

// Create a new value for a ada_node_array
ada_node_array ParamSpecArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_node_array in the Java wrapping class
jobject ParamSpecArrayWrapper_wrap(
    JNIEnv *env,
    ada_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        ParamSpecArrayWrapper_class_ref,
        ParamSpecArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_node_array from a Java wrapping instance
ada_node_array ParamSpecArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        ParamSpecArrayWrapper_class_ref,
        ParamSpecArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_node_array res = ada_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void ParamSpecArrayWrapper_release(
    ada_node_array array_native
) {
    ada_node_array_dec_ref(array_native);
}


    

// Create a new value for a ada_node_array
ada_node_array PragmaNodeArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_node_array in the Java wrapping class
jobject PragmaNodeArrayWrapper_wrap(
    JNIEnv *env,
    ada_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        PragmaNodeArrayWrapper_class_ref,
        PragmaNodeArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_node_array from a Java wrapping instance
ada_node_array PragmaNodeArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        PragmaNodeArrayWrapper_class_ref,
        PragmaNodeArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_node_array res = ada_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void PragmaNodeArrayWrapper_release(
    ada_node_array array_native
) {
    ada_node_array_dec_ref(array_native);
}


    

// Create a new value for a ada_node_array
ada_node_array TypeDeclArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_node_array in the Java wrapping class
jobject TypeDeclArrayWrapper_wrap(
    JNIEnv *env,
    ada_node_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Entity_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_node elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Entity_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        TypeDeclArrayWrapper_class_ref,
        TypeDeclArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_node_array from a Java wrapping instance
ada_node_array TypeDeclArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        TypeDeclArrayWrapper_class_ref,
        TypeDeclArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_node_array res = ada_node_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_node elem_native = Entity_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void TypeDeclArrayWrapper_release(
    ada_node_array array_native
) {
    ada_node_array_dec_ref(array_native);
}


    

// Create a new value for a ada_internal_logic_context_array
ada_internal_logic_context_array LogicContextArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_internal_logic_context_array in the Java wrapping class
jobject LogicContextArrayWrapper_wrap(
    JNIEnv *env,
    ada_internal_logic_context_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        LogicContext_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_internal_logic_context elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            LogicContext_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        LogicContextArrayWrapper_class_ref,
        LogicContextArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_internal_logic_context_array from a Java wrapping instance
ada_internal_logic_context_array LogicContextArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        LogicContextArrayWrapper_class_ref,
        LogicContextArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_internal_logic_context_array res = ada_internal_logic_context_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_internal_logic_context elem_native = LogicContext_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void LogicContextArrayWrapper_release(
    ada_internal_logic_context_array array_native
) {
    ada_internal_logic_context_array_dec_ref(array_native);
}


    

// Create a new value for a ada_internal_param_actual_array
ada_internal_param_actual_array ParamActualArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_internal_param_actual_array in the Java wrapping class
jobject ParamActualArrayWrapper_wrap(
    JNIEnv *env,
    ada_internal_param_actual_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        ParamActual_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_internal_param_actual elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            ParamActual_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        ParamActualArrayWrapper_class_ref,
        ParamActualArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_internal_param_actual_array from a Java wrapping instance
ada_internal_param_actual_array ParamActualArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        ParamActualArrayWrapper_class_ref,
        ParamActualArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_internal_param_actual_array res = ada_internal_param_actual_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_internal_param_actual elem_native = ParamActual_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void ParamActualArrayWrapper_release(
    ada_internal_param_actual_array array_native
) {
    ada_internal_param_actual_array_dec_ref(array_native);
}


    

// Create a new value for a ada_internal_ref_result_array
ada_internal_ref_result_array RefResultArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_internal_ref_result_array in the Java wrapping class
jobject RefResultArrayWrapper_wrap(
    JNIEnv *env,
    ada_internal_ref_result_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        RefResult_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_internal_ref_result elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            RefResult_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        RefResultArrayWrapper_class_ref,
        RefResultArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_internal_ref_result_array from a Java wrapping instance
ada_internal_ref_result_array RefResultArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        RefResultArrayWrapper_class_ref,
        RefResultArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_internal_ref_result_array res = ada_internal_ref_result_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_internal_ref_result elem_native = RefResult_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void RefResultArrayWrapper_release(
    ada_internal_ref_result_array array_native
) {
    ada_internal_ref_result_array_dec_ref(array_native);
}


    

// Create a new value for a ada_internal_shape_array
ada_internal_shape_array ShapeArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_internal_shape_array in the Java wrapping class
jobject ShapeArrayWrapper_wrap(
    JNIEnv *env,
    ada_internal_shape_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Shape_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_internal_shape elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Shape_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        ShapeArrayWrapper_class_ref,
        ShapeArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_internal_shape_array from a Java wrapping instance
ada_internal_shape_array ShapeArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        ShapeArrayWrapper_class_ref,
        ShapeArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_internal_shape_array res = ada_internal_shape_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_internal_shape elem_native = Shape_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void ShapeArrayWrapper_release(
    ada_internal_shape_array array_native
) {
    ada_internal_shape_array_dec_ref(array_native);
}


    

// Create a new value for a ada_internal_solver_diagnostic_array
ada_internal_solver_diagnostic_array SolverDiagnosticArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_internal_solver_diagnostic_array in the Java wrapping class
jobject SolverDiagnosticArrayWrapper_wrap(
    JNIEnv *env,
    ada_internal_solver_diagnostic_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        SolverDiagnostic_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_internal_solver_diagnostic elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            SolverDiagnostic_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        SolverDiagnosticArrayWrapper_class_ref,
        SolverDiagnosticArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_internal_solver_diagnostic_array from a Java wrapping instance
ada_internal_solver_diagnostic_array SolverDiagnosticArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        SolverDiagnosticArrayWrapper_class_ref,
        SolverDiagnosticArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_internal_solver_diagnostic_array res = ada_internal_solver_diagnostic_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_internal_solver_diagnostic elem_native = SolverDiagnostic_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void SolverDiagnosticArrayWrapper_release(
    ada_internal_solver_diagnostic_array array_native
) {
    ada_internal_solver_diagnostic_array_dec_ref(array_native);
}


    

// Create a new value for a ada_internal_substitution_array
ada_internal_substitution_array SubstitutionArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_internal_substitution_array in the Java wrapping class
jobject SubstitutionArrayWrapper_wrap(
    JNIEnv *env,
    ada_internal_substitution_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Substitution_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_internal_substitution elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Substitution_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        SubstitutionArrayWrapper_class_ref,
        SubstitutionArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_internal_substitution_array from a Java wrapping instance
ada_internal_substitution_array SubstitutionArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        SubstitutionArrayWrapper_class_ref,
        SubstitutionArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_internal_substitution_array res = ada_internal_substitution_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_internal_substitution elem_native = Substitution_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void SubstitutionArrayWrapper_release(
    ada_internal_substitution_array array_native
) {
    ada_internal_substitution_array_dec_ref(array_native);
}


    

// Create a new value for a ada_analysis_unit_array
ada_analysis_unit_array AnalysisUnitArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_analysis_unit_array in the Java wrapping class
jobject AnalysisUnitArrayWrapper_wrap(
    JNIEnv *env,
    ada_analysis_unit_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        AnalysisUnit_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_analysis_unit elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            AnalysisUnit_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        AnalysisUnitArrayWrapper_class_ref,
        AnalysisUnitArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_analysis_unit_array from a Java wrapping instance
ada_analysis_unit_array AnalysisUnitArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    
) {

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        AnalysisUnitArrayWrapper_class_ref,
        AnalysisUnitArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_analysis_unit_array res = ada_analysis_unit_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_analysis_unit elem_native = AnalysisUnit_unwrap(env, elem);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void AnalysisUnitArrayWrapper_release(
    ada_analysis_unit_array array_native
) {
    ada_analysis_unit_array_dec_ref(array_native);
}


    

// Create a new value for a ada_symbol_type_array
ada_symbol_type_array UnboundedTextTypeArrayWrapper_new_value() {
    return NULL;
}

// Wrap a native ada_symbol_type_array in the Java wrapping class
jobject UnboundedTextTypeArrayWrapper_wrap(
    JNIEnv *env,
    ada_symbol_type_array array_native
) {
    // Get the size of the array
    int array_size = array_native->n;

    // Create a new Java array of object of the element type
    jarray array_content = (*env)->NewObjectArray(
        env,
        (jsize) array_size,
        Symbol_class_ref,
        NULL
    );

    // Put elements in the Java array
    for(int i = 0 ; i < array_size ; i++) {
        ada_symbol_type elem = array_native->items[i];
        (*env)->SetObjectArrayElement(
            env,
            array_content,
            (jsize) i,
            Symbol_wrap(env, elem)
        );
    }

    // Return the new array
    return (*env)->CallStaticObjectMethod(
        env,
        UnboundedTextTypeArrayWrapper_class_ref,
        UnboundedTextTypeArrayWrapper_wrap_method_id,
        array_content
    );
}

// Get a native ada_symbol_type_array from a Java wrapping instance
ada_symbol_type_array UnboundedTextTypeArrayWrapper_unwrap(
    JNIEnv *env,
    jarray array
    , jobject context
) {
    // Unwrap the analysis context
    ada_analysis_context context_native =
        AnalysisContext_unwrap(env, context);

    //  Retrieve the array's content
    jarray content = (jarray) (*env)->CallStaticObjectMethod(
        env,
        UnboundedTextTypeArrayWrapper_class_ref,
        UnboundedTextTypeArrayWrapper_unwrap_method_id,
        array
    );

    // Get the content size
    int size = (int) (*env)->GetArrayLength(env, content);

    // Create a new native array
    ada_symbol_type_array res = ada_symbol_type_array_create(size);

    // Fill the new native array
    for(int i = 0 ; i < size ; i++) {
        jobject elem;
        elem = (*env)->GetObjectArrayElement(
            env,
            content,
            (jsize) i
        );
        ada_symbol_type elem_native = Symbol_unwrap(env, elem, context_native);
        res->items[i] = elem_native;
    }

    // Return the array
    return res;
}

// Release the given native array
void UnboundedTextTypeArrayWrapper_release(
    ada_symbol_type_array array_native
) {
    ada_symbol_type_array_dec_ref(array_native);
}


// ==========
// Generated iterator functions
// ==========


    

// Create a new value for a ada_internal_completion_item_iterator
ada_internal_completion_item_iterator CompletionItemIterator_new_value() {
    return NULL;
}

// Wrap a native ada_internal_completion_item_iterator in the Java wrapping class
jobject CompletionItemIterator_wrap(
    JNIEnv *env,
    ada_internal_completion_item_iterator struct_native
) {
    // Verify the iterator nullity
    if(struct_native == NULL) return NULL;

    // Return the new iterator
    return (*env)->NewObject(
        env,
        CompletionItemIterator_class_ref,
        CompletionItemIterator_constructor_id,
        PointerWrapper_wrap(env, (void *) struct_native)
    );
}

// Get a native ada_internal_completion_item_iterator from a Java wrapping instance
ada_internal_completion_item_iterator CompletionItemIterator_unwrap(
    JNIEnv *env,
    jobject object
) {
    return (ada_internal_completion_item_iterator) PointerWrapper_unwrap(
        env,
        (*env)->GetObjectField(
            env,
            object,
            CompletionItemIterator_reference_field_id
        )
    );
}


// ==========
// Node functions
// ==========

// Return whether the two given entities are equal
JNIEXPORT jint Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1node_1is_1equivalent(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity_left,
    jobject entity_right
) {
    // Unwrap the nodes
    ada_node entity_left_native = Entity_unwrap(env, entity_left);
    ada_node entity_right_native = Entity_unwrap(env, entity_right);

    // Call the native function
    return (jint) ada_node_is_equivalent(
        &entity_left_native,
        &entity_right_native
    );
}

// Get the hash of a node
JNIEXPORT jint Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1node_1hash(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Call the native function
    return (jint) ada_node_hash(
        &entity_native
    );
}

// Get the kind of a node
JNIEXPORT jint Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1node_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Call the native function
    return (jint) ada_node_kind(
        &entity_native
    );
}

// Get the text of a node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1node_1text(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Prepare the result
    ada_text res = Text_new_value();

    // Call the native function
    ada_node_text(
        &entity_native,
        &res
    );

    // Return the node text
    return Text_wrap(env, res);
}

// Get the source location range of a node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1node_1sloc_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Prepare the result
    ada_source_location_range res = SourceLocationRange_new_value();

    // Call the native function
    ada_node_sloc_range(
        &entity_native,
        &res
    );

    // Return the source location range
    return SourceLocationRange_wrap(env, res);
}

// Get the children count of a node
JNIEXPORT jint Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1node_1children_1count(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Call the native function
    return (jint) ada_node_children_count(
        &entity_native
    );
}

// Get the nth child of a node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1node_1child(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity,
    jint n
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Preapre the result
    ada_node res = Entity_new_value();

    // Call the native function
    ada_node_child(
        &entity_native,
        (unsigned) n,
        &res
    );

    // Return the child entity
    return Entity_wrap(env, res);
}

// Get if a node is a token node
JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1node_1is_1token_1node(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Call the native function
    return (jboolean) ada_node_is_token_node(
        &entity_native
    );
}

// Get the text image of a node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1node_1unit(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Call the native function
    ada_analysis_unit res_native = ada_node_unit(
        &entity_native
    );

    // Return the result
    return AnalysisUnit_wrap(env, res_native);
}

// Get the text image of a node
JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1node_1image(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Prepare the result
    ada_text res = Text_new_value();

    // Call the native function
    ada_node_image(
        &entity_native,
        &res
    );

    // Return the image text
    return Text_wrap(env, res);
}

// ==========
// Node field accessors
// ==========


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1declarative_1scope(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_declarative_scope(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1enclosing_1compilation_1unit(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_enclosing_compilation_unit(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1get_1uninstantiated_1node(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_get_uninstantiated_node(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1complete(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_internal_completion_item_iterator res_native = CompletionItemIterator_new_value();

    // Call the native function
    ada_ada_node_p_complete(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = CompletionItemIterator_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1valid_1keywords(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_symbol_type_array res_native = UnboundedTextTypeArrayWrapper_new_value();

    // Call the native function
    ada_ada_node_p_valid_keywords(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = UnboundedTextTypeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        UnboundedTextTypeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1generic_1instantiations(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = GenericInstantiationArrayWrapper_new_value();

    // Call the native function
    ada_ada_node_p_generic_instantiations(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = GenericInstantiationArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        GenericInstantiationArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1semantic_1parent(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_semantic_parent(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1parent_1basic_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_parent_basic_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1has_1spark_1mode_1on(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_ada_node_p_has_spark_mode_on(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1is_1subject_1to_1proof(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_ada_node_p_is_subject_to_proof(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1filter_1is_1imported_1by(
    JNIEnv *env,
    jclass jni_lib,
    jobject units_java,
    jboolean transitive_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_analysis_unit_array units_native = AnalysisUnitArrayWrapper_unwrap(env, units_java);
    ada_bool transitive_native = (ada_bool) transitive_java;

    // Prepare the result structure
    ada_analysis_unit_array res_native = AnalysisUnitArrayWrapper_new_value();

    // Call the native function
    ada_ada_node_p_filter_is_imported_by(
        &entity_native,
        units_native,
        transitive_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AnalysisUnitArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        AnalysisUnitArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */
    AnalysisUnitArrayWrapper_release(
        units_native
    );

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1resolve_1names(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_ada_node_p_resolve_names(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1nameres_1diagnostics(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_internal_solver_diagnostic_array res_native = SolverDiagnosticArrayWrapper_new_value();

    // Call the native function
    ada_ada_node_p_nameres_diagnostics(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = SolverDiagnosticArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        SolverDiagnosticArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1standard_1unit(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_analysis_unit res_native = AnalysisUnit_new_value();

    // Call the native function
    ada_ada_node_p_standard_unit(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AnalysisUnit_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1is_1keyword(
    JNIEnv *env,
    jclass jni_lib,
    jobject token_java,
    jobject language_version_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_token token_native = Token_unwrap(env, token_java);
    ada_symbol_type language_version_native = Symbol_unwrap(env, language_version_java, context_native);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_ada_node_p_is_keyword(
        &entity_native,
        &token_native,
        &language_version_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1std_1entity(
    JNIEnv *env,
    jclass jni_lib,
    jobject sym_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type sym_native = Symbol_unwrap(env, sym_java, context_native);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_std_entity(
        &entity_native,
        &sym_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1bool_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_bool_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1int_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_int_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1universal_1int_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_universal_int_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1universal_1real_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_universal_real_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1std_1char_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_std_char_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1std_1wide_1char_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_std_wide_char_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1std_1wide_1wide_1char_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_std_wide_wide_char_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1std_1string_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_std_string_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1std_1wide_1string_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_std_wide_string_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1std_1wide_1wide_1string_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_std_wide_wide_string_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1top_1level_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject unit_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_analysis_unit unit_native = AnalysisUnit_unwrap(env, unit_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_top_level_decl(
        &entity_native,
        unit_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1choice_1match(
    JNIEnv *env,
    jclass jni_lib,
    jobject value_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_big_integer value_native = BigIntegerWrapper_unwrap(env, value_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_ada_node_p_choice_match(
        &entity_native,
        &value_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */
    BigIntegerWrapper_release(
        value_native
    );

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1gnat_1xref(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_p_gnat_xref(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1spark_1mode_1aspect(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_internal_aspect res_native = Aspect_new_value();

    // Call the native function
    ada_ada_node_p_spark_mode_aspect(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Aspect_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1xref_1entry_1point(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_ada_node_p_xref_entry_point(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1p_1matching_1with_1use_1clause(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_ada_node_p_matching_with_use_clause(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1parent(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_parent(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1parents(
    JNIEnv *env,
    jclass jni_lib,
    jboolean with_self_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool with_self_native = (ada_bool) with_self_java;

    // Prepare the result structure
    ada_node_array res_native = AdaNodeArrayWrapper_new_value();

    // Call the native function
    ada_ada_node_parents(
        &entity_native,
        with_self_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AdaNodeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        AdaNodeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1children(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = AdaNodeArrayWrapper_new_value();

    // Call the native function
    ada_ada_node_children(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AdaNodeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        AdaNodeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1token_1start(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);


    // Unwrap the arguments

    // Prepare the result structure
    ada_token res_native = Token_new_value();

    // Call the native function
    ada_ada_node_token_start(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Token_wrap(env, res_native, AnalysisUnit_wrap(env, unit_native));

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1token_1end(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);


    // Unwrap the arguments

    // Prepare the result structure
    ada_token res_native = Token_new_value();

    // Call the native function
    ada_ada_node_token_end(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Token_wrap(env, res_native, AnalysisUnit_wrap(env, unit_native));

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jint Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1child_1index(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    int res_native = 0;

    // Call the native function
    ada_ada_node_child_index(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jint res = 0;
    if (exc_c == NULL)
      {
        res = (jint) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1previous_1sibling(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_previous_sibling(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1next_1sibling(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ada_node_next_sibling(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1unit(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_analysis_unit res_native = AnalysisUnit_new_value();

    // Call the native function
    ada_ada_node_unit(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AnalysisUnit_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1is_1ghost(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_ada_node_is_ghost(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ada_1node_1full_1sloc_1image(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_string_type res_native = StringWrapper_new_value();

    // Call the native function
    ada_ada_node_full_sloc_image(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1abort_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_abort_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1abstract_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_abstract_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1assoc_1list_1p_1zip_1with_1params(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_internal_param_actual_array res_native = ParamActualArrayWrapper_new_value();

    // Call the native function
    ada_assoc_list_p_zip_with_params(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = ParamActualArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        ParamActualArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1aliased_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_aliased_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1all_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_all_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1constrained_1array_1indices_1f_1list(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_constrained_array_indices_f_list(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1unconstrained_1array_1indices_1f_1types(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_unconstrained_array_indices_f_types(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1aspect_1assoc_1f_1id(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_aspect_assoc_f_id(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1aspect_1assoc_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_aspect_assoc_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1aspect_1assoc_1p_1is_1ghost_1code(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_aspect_assoc_p_is_ghost_code(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1at_1clause_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_at_clause_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1at_1clause_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_at_clause_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1attribute_1def_1clause_1f_1attribute_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_attribute_def_clause_f_attribute_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1attribute_1def_1clause_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_attribute_def_clause_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1enum_1rep_1clause_1f_1type_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_enum_rep_clause_f_type_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1enum_1rep_1clause_1f_1aggregate(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_enum_rep_clause_f_aggregate(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1enum_1rep_1clause_1p_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_internal_param_actual_array res_native = ParamActualArrayWrapper_new_value();

    // Call the native function
    ada_enum_rep_clause_p_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = ParamActualArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        ParamActualArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1record_1rep_1clause_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_record_rep_clause_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1record_1rep_1clause_1f_1at_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_record_rep_clause_f_at_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1record_1rep_1clause_1f_1components(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_record_rep_clause_f_components(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1aspect_1spec_1f_1aspect_1assocs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_aspect_spec_f_aspect_assocs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1assoc_1p_1assoc_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_assoc_p_assoc_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1contract_1case_1assoc_1f_1guard(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_contract_case_assoc_f_guard(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1contract_1case_1assoc_1f_1consequence(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_contract_case_assoc_f_consequence(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1pragma_1argument_1assoc_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_pragma_argument_assoc_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1pragma_1argument_1assoc_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_pragma_argument_assoc_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1formal_1param_1holder_1p_1abstract_1formal_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = BaseFormalParamDeclArrayWrapper_new_value();

    // Call the native function
    ada_base_formal_param_holder_p_abstract_formal_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BaseFormalParamDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BaseFormalParamDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1formal_1param_1holder_1p_1formal_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = DefiningNameArrayWrapper_new_value();

    // Call the native function
    ada_base_formal_param_holder_p_formal_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DefiningNameArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        DefiningNameArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jint Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1formal_1param_1holder_1p_1nb_1min_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    int res_native = 0;

    // Call the native function
    ada_base_formal_param_holder_p_nb_min_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jint res = 0;
    if (exc_c == NULL)
      {
        res = (jint) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jint Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1formal_1param_1holder_1p_1nb_1max_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    int res_native = 0;

    // Call the native function
    ada_base_formal_param_holder_p_nb_max_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jint res = 0;
    if (exc_c == NULL)
      {
        res = (jint) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1formal_1param_1holder_1p_1param_1types(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node_array res_native = BaseTypeDeclArrayWrapper_new_value();

    // Call the native function
    ada_base_formal_param_holder_p_param_types(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BaseTypeDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BaseTypeDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1subp_1spec_1p_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_subp_spec_p_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1subp_1spec_1p_1returns(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_subp_spec_p_returns(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1subp_1spec_1p_1primitive_1subp_1types(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node_array res_native = BaseTypeDeclArrayWrapper_new_value();

    // Call the native function
    ada_base_subp_spec_p_primitive_subp_types(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BaseTypeDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BaseTypeDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1subp_1spec_1p_1primitive_1subp_1first_1type(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_subp_spec_p_primitive_subp_first_type(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1subp_1spec_1p_1primitive_1subp_1tagged_1type(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_subp_spec_p_primitive_subp_tagged_type(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1subp_1spec_1p_1return_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_subp_spec_p_return_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1subp_1spec_1p_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = ParamSpecArrayWrapper_new_value();

    // Call the native function
    ada_base_subp_spec_p_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = ParamSpecArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        ParamSpecArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1spec_1f_1entry_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_spec_f_entry_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1spec_1f_1family_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_spec_f_family_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1spec_1f_1entry_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_spec_f_entry_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subp_1spec_1f_1subp_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subp_spec_f_subp_kind(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subp_1spec_1f_1subp_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subp_spec_f_subp_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subp_1spec_1f_1subp_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subp_spec_f_subp_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subp_1spec_1f_1subp_1returns(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subp_spec_f_subp_returns(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1synthetic_1binary_1spec_1f_1left_1param(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_synthetic_binary_spec_f_left_param(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1synthetic_1binary_1spec_1f_1right_1param(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_synthetic_binary_spec_f_right_param(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1synthetic_1binary_1spec_1f_1return_1type_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_synthetic_binary_spec_f_return_type_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1synthetic_1unary_1spec_1f_1right_1param(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_synthetic_unary_spec_f_right_param(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1synthetic_1unary_1spec_1f_1return_1type_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_synthetic_unary_spec_f_return_type_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1component_1list_1f_1components(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_component_list_f_components(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1component_1list_1f_1variant_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_component_list_f_variant_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1known_1discriminant_1part_1f_1discr_1specs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_known_discriminant_part_f_discr_specs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1completion_1formal_1params_1f_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_completion_formal_params_f_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1formal_1part_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_formal_part_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1record_1def_1f_1components(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_record_def_f_components(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1assoc_1p_1get_1params(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node_array res_native = DefiningNameArrayWrapper_new_value();

    // Call the native function
    ada_basic_assoc_p_get_params(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DefiningNameArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        DefiningNameArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1aggregate_1assoc_1f_1designators(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_aggregate_assoc_f_designators(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1aggregate_1assoc_1f_1r_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_aggregate_assoc_f_r_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1composite_1constraint_1assoc_1f_1ids(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_composite_constraint_assoc_f_ids(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1composite_1constraint_1assoc_1f_1constraint_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_composite_constraint_assoc_f_constraint_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1iterated_1assoc_1f_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_iterated_assoc_f_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1iterated_1assoc_1f_1key_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_iterated_assoc_f_key_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1iterated_1assoc_1f_1r_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_iterated_assoc_f_r_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1param_1assoc_1f_1designator(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_param_assoc_f_designator(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1param_1assoc_1f_1r_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_param_assoc_f_r_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1f_1aspects(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_f_aspects(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1is_1formal(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_basic_decl_p_is_formal(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1doc_1annotations(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_internal_doc_annotation_array res_native = DocAnnotationArrayWrapper_new_value();

    // Call the native function
    ada_basic_decl_p_doc_annotations(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DocAnnotationArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        DocAnnotationArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1doc(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_string_type res_native = StringWrapper_new_value();

    // Call the native function
    ada_basic_decl_p_doc(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1canonical_1part(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_canonical_part(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1all_1parts(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node_array res_native = BasicDeclArrayWrapper_new_value();

    // Call the native function
    ada_basic_decl_p_all_parts(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BasicDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BasicDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1get_1aspect_1assoc(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_get_aspect_assoc(
        &entity_native,
        &name_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1get_1aspect_1spec_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_get_aspect_spec_expr(
        &entity_native,
        &name_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1get_1aspect(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jboolean previous_parts_only_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);
    ada_bool previous_parts_only_native = (ada_bool) previous_parts_only_java;
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_internal_aspect res_native = Aspect_new_value();

    // Call the native function
    ada_basic_decl_p_get_aspect(
        &entity_native,
        &name_native,
        previous_parts_only_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Aspect_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1has_1aspect(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jboolean previous_parts_only_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);
    ada_bool previous_parts_only_native = (ada_bool) previous_parts_only_java;
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_basic_decl_p_has_aspect(
        &entity_native,
        &name_native,
        previous_parts_only_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1get_1pragma(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_get_pragma(
        &entity_native,
        &name_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1get_1representation_1clause(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_get_representation_clause(
        &entity_native,
        &name_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1get_1at_1clause(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_get_at_clause(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1get_1annotations(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_internal_aspect_array res_native = AspectArrayWrapper_new_value();

    // Call the native function
    ada_basic_decl_p_get_annotations(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AspectArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        AspectArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1is_1ghost_1code(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_basic_decl_p_is_ghost_code(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1is_1compilation_1unit_1root(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_basic_decl_p_is_compilation_unit_root(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1is_1visible(
    JNIEnv *env,
    jclass jni_lib,
    jobject from_node_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node from_node_native = Entity_unwrap(env, from_node_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_basic_decl_p_is_visible(
        &entity_native,
        &from_node_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1base_1subp_1declarations(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node_array res_native = BasicDeclArrayWrapper_new_value();

    // Call the native function
    ada_basic_decl_p_base_subp_declarations(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BasicDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BasicDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1root_1subp_1declarations(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node_array res_native = BasicDeclArrayWrapper_new_value();

    // Call the native function
    ada_basic_decl_p_root_subp_declarations(
        &entity_native,
        &origin_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BasicDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BasicDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1find_1all_1overrides(
    JNIEnv *env,
    jclass jni_lib,
    jobject units_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_analysis_unit_array units_native = AnalysisUnitArrayWrapper_unwrap(env, units_java);
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node_array res_native = BasicDeclArrayWrapper_new_value();

    // Call the native function
    ada_basic_decl_p_find_all_overrides(
        &entity_native,
        units_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BasicDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BasicDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */
    AnalysisUnitArrayWrapper_release(
        units_native
    );

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1defining_1names(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = DefiningNameArrayWrapper_new_value();

    // Call the native function
    ada_basic_decl_p_defining_names(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DefiningNameArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        DefiningNameArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1defining_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_defining_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1subp_1spec_1or_1null(
    JNIEnv *env,
    jclass jni_lib,
    jboolean follow_generic_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool follow_generic_native = (ada_bool) follow_generic_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_subp_spec_or_null(
        &entity_native,
        follow_generic_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1is_1subprogram(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_basic_decl_p_is_subprogram(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1relative_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_relative_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1relative_1name_1text(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_symbol_type res_native = Symbol_new_value();

    // Call the native function
    ada_basic_decl_p_relative_name_text(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Symbol_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1body_1part_1for_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_body_part_for_decl(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1most_1visible_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_most_visible_part(
        &entity_native,
        &origin_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1fully_1qualified_1name_1array(
    JNIEnv *env,
    jclass jni_lib,
    jboolean include_profile_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool include_profile_native = (ada_bool) include_profile_java;

    // Prepare the result structure
    ada_symbol_type_array res_native = UnboundedTextTypeArrayWrapper_new_value();

    // Call the native function
    ada_basic_decl_p_fully_qualified_name_array(
        &entity_native,
        include_profile_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = UnboundedTextTypeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        UnboundedTextTypeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1fully_1qualified_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_string_type res_native = StringWrapper_new_value();

    // Call the native function
    ada_basic_decl_p_fully_qualified_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1canonical_1fully_1qualified_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_string_type res_native = StringWrapper_new_value();

    // Call the native function
    ada_basic_decl_p_canonical_fully_qualified_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1unique_1identifying_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_string_type res_native = StringWrapper_new_value();

    // Call the native function
    ada_basic_decl_p_unique_identifying_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1previous_1part_1for_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_previous_part_for_decl(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1is_1static_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_basic_decl_p_is_static_decl(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1is_1imported(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_basic_decl_p_is_imported(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1type_1expression(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_type_expression(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1next_1part_1for_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_decl_p_next_part_for_decl(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1decl_1p_1is_1constant_1object(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_basic_decl_p_is_constant_object(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1abstract_1state_1decl_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_abstract_state_decl_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1anonymous_1expr_1decl_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_anonymous_expr_decl_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1anonymous_1expr_1decl_1p_1get_1formal(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_anonymous_expr_decl_p_get_formal(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1formal_1param_1decl_1p_1formal_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_formal_param_decl_p_formal_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1component_1decl_1f_1ids(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_component_decl_f_ids(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1component_1decl_1f_1component_1def(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_component_decl_f_component_def(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1component_1decl_1f_1default_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_component_decl_f_default_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1discriminant_1spec_1f_1ids(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_discriminant_spec_f_ids(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1discriminant_1spec_1f_1type_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_discriminant_spec_f_type_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1discriminant_1spec_1f_1default_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_discriminant_spec_f_default_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1formal_1f_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_formal_f_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1param_1spec_1f_1ids(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_param_spec_f_ids(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1param_1spec_1f_1has_1aliased(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_param_spec_f_has_aliased(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1param_1spec_1f_1mode(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_param_spec_f_mode(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1param_1spec_1f_1type_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_param_spec_f_type_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1param_1spec_1f_1default_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_param_spec_f_default_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1synthetic_1formal_1param_1decl_1f_1param_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_synthetic_formal_param_decl_f_param_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1package_1decl_1f_1package_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_package_decl_f_package_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1package_1decl_1f_1public_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_package_decl_f_public_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1package_1decl_1f_1private_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_package_decl_f_private_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1package_1decl_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_package_decl_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1package_1decl_1p_1body_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_package_decl_p_body_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1base_1subtype(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_base_subtype(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1attribute_1subprogram(
    JNIEnv *env,
    jclass jni_lib,
    jobject attr_name_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type attr_name_native = Symbol_unwrap(env, attr_name_java, context_native);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_attribute_subprogram(
        &entity_native,
        &attr_name_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1private_1completion(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_private_completion(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1inherited_1primitive(
    JNIEnv *env,
    jclass jni_lib,
    jobject p_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node p_native = Entity_unwrap(env, p_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_inherited_primitive(
        &entity_native,
        &p_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1get_1record_1representation_1clause(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_get_record_representation_clause(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1get_1enum_1representation_1clause(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_get_enum_representation_clause(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1get_1primitives(
    JNIEnv *env,
    jclass jni_lib,
    jboolean only_inherited_java,
    jboolean include_predefined_operators_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool only_inherited_native = (ada_bool) only_inherited_java;
    ada_bool include_predefined_operators_native = (ada_bool) include_predefined_operators_java;

    // Prepare the result structure
    ada_node_array res_native = BasicDeclArrayWrapper_new_value();

    // Call the native function
    ada_base_type_decl_p_get_primitives(
        &entity_native,
        only_inherited_native,
        include_predefined_operators_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BasicDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BasicDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1array_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_array_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1find_1derived_1types(
    JNIEnv *env,
    jclass jni_lib,
    jobject root_java,
    jobject origin_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node root_native = Entity_unwrap(env, root_java);
    ada_node origin_native = Entity_unwrap(env, origin_java);
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node_array res_native = TypeDeclArrayWrapper_new_value();

    // Call the native function
    ada_base_type_decl_p_find_derived_types(
        &entity_native,
        &root_native,
        &origin_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = TypeDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        TypeDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1scalar_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_scalar_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1specific_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_specific_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1find_1all_1derived_1types(
    JNIEnv *env,
    jclass jni_lib,
    jobject units_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_analysis_unit_array units_native = AnalysisUnitArrayWrapper_unwrap(env, units_java);
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node_array res_native = TypeDeclArrayWrapper_new_value();

    // Call the native function
    ada_base_type_decl_p_find_all_derived_types(
        &entity_native,
        units_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = TypeDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        TypeDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */
    AnalysisUnitArrayWrapper_release(
        units_native
    );

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1comp_1type(
    JNIEnv *env,
    jclass jni_lib,
    jboolean is_subscript_java,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool is_subscript_native = (ada_bool) is_subscript_java;
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_comp_type(
        &entity_native,
        is_subscript_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1index_1type(
    JNIEnv *env,
    jclass jni_lib,
    jint dim_java,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    int dim_native = (int) dim_java;
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_index_type(
        &entity_native,
        dim_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1derived_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject other_type_java,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node other_type_native = Entity_unwrap(env, other_type_java);
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_derived_type(
        &entity_native,
        &other_type_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1limited_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_limited_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1matching_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject expected_type_java,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node expected_type_native = Entity_unwrap(env, expected_type_java);
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_matching_type(
        &entity_native,
        &expected_type_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1previous_1part(
    JNIEnv *env,
    jclass jni_lib,
    jboolean go_to_incomplete_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool go_to_incomplete_native = (ada_bool) go_to_incomplete_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_previous_part(
        &entity_native,
        go_to_incomplete_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1next_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_next_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1full_1view(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_full_view(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1definite_1subtype(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_definite_subtype(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1discriminants_1list(
    JNIEnv *env,
    jclass jni_lib,
    jobject stop_recurse_at_java,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node stop_recurse_at_native = Entity_unwrap(env, stop_recurse_at_java);
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node_array res_native = BaseFormalParamDeclArrayWrapper_new_value();

    // Call the native function
    ada_base_type_decl_p_discriminants_list(
        &entity_native,
        &stop_recurse_at_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BaseFormalParamDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BaseFormalParamDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1shapes(
    JNIEnv *env,
    jclass jni_lib,
    jboolean include_discriminants_java,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool include_discriminants_native = (ada_bool) include_discriminants_java;
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_internal_shape_array res_native = ShapeArrayWrapper_new_value();

    // Call the native function
    ada_base_type_decl_p_shapes(
        &entity_native,
        include_discriminants_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = ShapeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        ShapeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1record_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_record_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1real_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_real_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1float_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_float_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1fixed_1point(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_fixed_point(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1enum_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_enum_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1access_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_access_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1char_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_char_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1classwide_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_classwide_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1discrete_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_internal_discrete_range res_native = DiscreteRange_new_value();

    // Call the native function
    ada_base_type_decl_p_discrete_range(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DiscreteRange_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1discrete_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_discrete_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1int_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_int_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1accessed_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_accessed_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1tagged_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_tagged_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1base_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_base_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1base_1types(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node_array res_native = BaseTypeDeclArrayWrapper_new_value();

    // Call the native function
    ada_base_type_decl_p_base_types(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BaseTypeDeclArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BaseTypeDeclArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1interface_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_interface_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1canonical_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_canonical_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1is_1private(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_type_decl_p_is_private(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1type_1decl_1p_1root_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_type_decl_p_root_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1subtype_1decl_1p_1get_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_subtype_decl_p_get_type(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subtype_1decl_1f_1subtype(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subtype_decl_f_subtype(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1incomplete_1type_1decl_1f_1discriminants(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_incomplete_type_decl_f_discriminants(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1incomplete_1formal_1type_1decl_1f_1is_1tagged(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_incomplete_formal_type_decl_f_is_tagged(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1incomplete_1formal_1type_1decl_1f_1default_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_incomplete_formal_type_decl_f_default_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1incomplete_1tagged_1type_1decl_1f_1has_1abstract(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_incomplete_tagged_type_decl_f_has_abstract(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1protected_1type_1decl_1f_1discriminants(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_protected_type_decl_f_discriminants(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1protected_1type_1decl_1f_1interfaces(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_protected_type_decl_f_interfaces(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1protected_1type_1decl_1f_1definition(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_protected_type_decl_f_definition(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1task_1type_1decl_1f_1discriminants(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_task_type_decl_f_discriminants(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1task_1type_1decl_1f_1definition(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_task_type_decl_f_definition(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1type_1decl_1f_1discriminants(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_type_decl_f_discriminants(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1type_1decl_1f_1type_1def(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_type_decl_f_type_def(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1formal_1type_1decl_1f_1default_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_formal_type_decl_f_default_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1basic_1subp_1decl_1p_1subp_1decl_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_basic_subp_decl_p_subp_decl_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1classic_1subp_1decl_1f_1overriding(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_classic_subp_decl_f_overriding(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1classic_1subp_1decl_1f_1subp_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_classic_subp_decl_f_subp_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1classic_1subp_1decl_1p_1body_1part(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_classic_subp_decl_p_body_part(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1formal_1subp_1decl_1f_1default_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_formal_subp_decl_f_default_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1decl_1f_1overriding(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_decl_f_overriding(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1decl_1f_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_decl_f_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1decl_1p_1body_1part(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_decl_p_body_part(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1decl_1p_1accept_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = AcceptStmtArrayWrapper_new_value();

    // Call the native function
    ada_entry_decl_p_accept_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AcceptStmtArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        AcceptStmtArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1enum_1literal_1decl_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_enum_literal_decl_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1enum_1literal_1decl_1p_1enum_1rep(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_big_integer res_native = BigIntegerWrapper_new_value();

    // Call the native function
    ada_enum_literal_decl_p_enum_rep(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BigIntegerWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BigIntegerWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1enum_1literal_1decl_1p_1enum_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_enum_literal_decl_p_enum_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1synthetic_1char_1enum_1lit_1p_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_synthetic_char_enum_lit_p_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1subp_1internal_1f_1subp_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_subp_internal_f_subp_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1synthetic_1subp_1decl_1f_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_synthetic_subp_decl_f_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1body_1node_1p_1previous_1part(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_body_node_p_previous_part(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1body_1node_1p_1decl_1part(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_body_node_p_decl_part(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1body_1node_1p_1subunit_1root(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_body_node_p_subunit_root(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1accept_1stmt_1body_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_accept_stmt_body_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1subp_1body_1f_1overriding(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_subp_body_f_overriding(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1subp_1body_1f_1subp_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_subp_body_f_subp_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1expr_1function_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_expr_function_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subp_1body_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subp_body_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subp_1body_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subp_body_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subp_1body_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subp_body_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subp_1renaming_1decl_1f_1renames(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subp_renaming_decl_f_renames(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1body_1stub_1p_1syntactic_1fully_1qualified_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_symbol_type_array res_native = UnboundedTextTypeArrayWrapper_new_value();

    // Call the native function
    ada_body_stub_p_syntactic_fully_qualified_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = UnboundedTextTypeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        UnboundedTextTypeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1package_1body_1stub_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_package_body_stub_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1protected_1body_1stub_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_protected_body_stub_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subp_1body_1stub_1f_1overriding(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subp_body_stub_f_overriding(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subp_1body_1stub_1f_1subp_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subp_body_stub_f_subp_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1task_1body_1stub_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_task_body_stub_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1body_1f_1entry_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_body_f_entry_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1body_1f_1index_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_body_f_index_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1body_1f_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_body_f_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1body_1f_1barrier(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_body_f_barrier(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1body_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_body_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1body_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_body_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1body_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_body_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1package_1body_1f_1package_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_package_body_f_package_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1package_1body_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_package_body_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1package_1body_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_package_body_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1package_1body_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_package_body_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1protected_1body_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_protected_body_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1protected_1body_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_protected_body_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1protected_1body_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_protected_body_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1task_1body_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_task_body_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1task_1body_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_task_body_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1task_1body_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_task_body_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1task_1body_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_task_body_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1index_1spec_1f_1id(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_index_spec_f_id(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1entry_1index_1spec_1f_1subtype(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_entry_index_spec_f_subtype(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1exception_1decl_1f_1ids(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_exception_decl_f_ids(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1exception_1decl_1f_1renames(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_exception_decl_f_renames(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1exception_1handler_1f_1exception_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_exception_handler_f_exception_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1exception_1handler_1f_1handled_1exceptions(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_exception_handler_f_handled_exceptions(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1exception_1handler_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_exception_handler_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1for_1loop_1var_1decl_1f_1id(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_for_loop_var_decl_f_id(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1for_1loop_1var_1decl_1f_1id_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_for_loop_var_decl_f_id_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1decl_1f_1formal_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_decl_f_formal_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1package_1decl_1f_1package_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_package_decl_f_package_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1package_1decl_1p_1body_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_package_decl_p_body_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1subp_1decl_1f_1subp_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_subp_decl_f_subp_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1subp_1decl_1p_1body_1part(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_subp_decl_p_body_part(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1instantiation_1p_1designated_1generic_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_instantiation_p_designated_generic_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1instantiation_1p_1inst_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_internal_param_actual_array res_native = ParamActualArrayWrapper_new_value();

    // Call the native function
    ada_generic_instantiation_p_inst_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = ParamActualArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        ParamActualArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1package_1instantiation_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_package_instantiation_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1package_1instantiation_1f_1generic_1pkg_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_package_instantiation_f_generic_pkg_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1package_1instantiation_1f_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_package_instantiation_f_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1subp_1instantiation_1f_1overriding(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_subp_instantiation_f_overriding(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1subp_1instantiation_1f_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_subp_instantiation_f_kind(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1subp_1instantiation_1f_1subp_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_subp_instantiation_f_subp_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1subp_1instantiation_1f_1generic_1subp_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_subp_instantiation_f_generic_subp_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1subp_1instantiation_1f_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_subp_instantiation_f_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1subp_1instantiation_1p_1designated_1subp(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_subp_instantiation_p_designated_subp(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1package_1renaming_1decl_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_package_renaming_decl_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1package_1renaming_1decl_1f_1renames(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_package_renaming_decl_f_renames(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1subp_1renaming_1decl_1f_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_subp_renaming_decl_f_kind(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1subp_1renaming_1decl_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_subp_renaming_decl_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1generic_1subp_1renaming_1decl_1f_1renames(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_generic_subp_renaming_decl_f_renames(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1label_1decl_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_label_decl_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1named_1stmt_1decl_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_named_stmt_decl_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1number_1decl_1f_1ids(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_number_decl_f_ids(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1number_1decl_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_number_decl_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1object_1decl_1f_1ids(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_object_decl_f_ids(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1object_1decl_1f_1has_1aliased(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_object_decl_f_has_aliased(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1object_1decl_1f_1has_1constant(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_object_decl_f_has_constant(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1object_1decl_1f_1mode(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_object_decl_f_mode(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1object_1decl_1f_1type_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_object_decl_f_type_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1object_1decl_1f_1default_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_object_decl_f_default_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1object_1decl_1f_1renaming_1clause(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_object_decl_f_renaming_clause(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1object_1decl_1p_1private_1part_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_object_decl_p_private_part_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1object_1decl_1p_1public_1part_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_object_decl_p_public_part_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1package_1renaming_1decl_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_package_renaming_decl_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1package_1renaming_1decl_1f_1renames(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_package_renaming_decl_f_renames(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1package_1renaming_1decl_1p_1renamed_1package(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_package_renaming_decl_p_renamed_package(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1package_1renaming_1decl_1p_1final_1renamed_1package(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_package_renaming_decl_p_final_renamed_package(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1single_1protected_1decl_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_single_protected_decl_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1single_1protected_1decl_1f_1interfaces(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_single_protected_decl_f_interfaces(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1single_1protected_1decl_1f_1definition(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_single_protected_decl_f_definition(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1single_1task_1decl_1f_1task_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_single_task_decl_f_task_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1case_1stmt_1alternative_1f_1choices(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_case_stmt_alternative_f_choices(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1case_1stmt_1alternative_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_case_stmt_alternative_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1f_1prelude(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_compilation_unit_f_prelude(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1f_1body(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_compilation_unit_f_body(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1f_1pragmas(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_compilation_unit_f_pragmas(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1p_1syntactic_1fully_1qualified_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_symbol_type_array res_native = UnboundedTextTypeArrayWrapper_new_value();

    // Call the native function
    ada_compilation_unit_p_syntactic_fully_qualified_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = UnboundedTextTypeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        UnboundedTextTypeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1p_1unit_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_analysis_unit_kind res_native = AnalysisUnitKind_new_value();

    // Call the native function
    ada_compilation_unit_p_unit_kind(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AnalysisUnitKind_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1p_1withed_1units(
    JNIEnv *env,
    jclass jni_lib,
    jboolean include_privates_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool include_privates_native = (ada_bool) include_privates_java;

    // Prepare the result structure
    ada_node_array res_native = CompilationUnitArrayWrapper_new_value();

    // Call the native function
    ada_compilation_unit_p_withed_units(
        &entity_native,
        include_privates_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = CompilationUnitArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        CompilationUnitArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1p_1imported_1units(
    JNIEnv *env,
    jclass jni_lib,
    jboolean include_privates_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool include_privates_native = (ada_bool) include_privates_java;

    // Prepare the result structure
    ada_node_array res_native = CompilationUnitArrayWrapper_new_value();

    // Call the native function
    ada_compilation_unit_p_imported_units(
        &entity_native,
        include_privates_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = CompilationUnitArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        CompilationUnitArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1p_1unit_1dependencies(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = CompilationUnitArrayWrapper_new_value();

    // Call the native function
    ada_compilation_unit_p_unit_dependencies(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = CompilationUnitArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        CompilationUnitArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1p_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_compilation_unit_p_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1p_1is_1preelaborable(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_compilation_unit_p_is_preelaborable(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1p_1other_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_compilation_unit_p_other_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1p_1has_1restriction(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_compilation_unit_p_has_restriction(
        &entity_native,
        &name_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1p_1all_1config_1pragmas(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = PragmaNodeArrayWrapper_new_value();

    // Call the native function
    ada_compilation_unit_p_all_config_pragmas(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = PragmaNodeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        PragmaNodeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1compilation_1unit_1p_1config_1pragmas(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);

    // Prepare the result structure
    ada_node_array res_native = PragmaNodeArrayWrapper_new_value();

    // Call the native function
    ada_compilation_unit_p_config_pragmas(
        &entity_native,
        &name_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = PragmaNodeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        PragmaNodeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1component_1clause_1f_1id(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_component_clause_f_id(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1component_1clause_1f_1position(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_component_clause_f_position(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1component_1clause_1f_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_component_clause_f_range(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1component_1def_1f_1has_1aliased(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_component_def_f_has_aliased(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1component_1def_1f_1has_1constant(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_component_def_f_has_constant(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1component_1def_1f_1type_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_component_def_f_type_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1constant_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_constant_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1composite_1constraint_1f_1constraints(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_composite_constraint_f_constraints(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1composite_1constraint_1p_1is_1index_1constraint(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_composite_constraint_p_is_index_constraint(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1composite_1constraint_1p_1is_1discriminant_1constraint(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_composite_constraint_p_is_discriminant_constraint(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1composite_1constraint_1p_1discriminant_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_internal_param_actual_array res_native = ParamActualArrayWrapper_new_value();

    // Call the native function
    ada_composite_constraint_p_discriminant_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = ParamActualArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        ParamActualArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1delta_1constraint_1f_1delta(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_delta_constraint_f_delta(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1delta_1constraint_1f_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_delta_constraint_f_range(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1digits_1constraint_1f_1digits(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_digits_constraint_f_digits(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1digits_1constraint_1f_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_digits_constraint_f_range(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1range_1constraint_1f_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_range_constraint_f_range(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1declarative_1part_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_declarative_part_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1elsif_1expr_1part_1f_1cond_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_elsif_expr_part_f_cond_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1elsif_1expr_1part_1f_1then_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_elsif_expr_part_f_then_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1elsif_1stmt_1part_1f_1cond_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_elsif_stmt_part_f_cond_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1elsif_1stmt_1part_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_elsif_stmt_part_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1expr_1p_1expression_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_expr_p_expression_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1expr_1p_1expected_1expression_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_expr_p_expected_expression_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1expr_1p_1is_1dynamically_1tagged(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_expr_p_is_dynamically_tagged(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1expr_1p_1is_1static_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_expr_p_is_static_expr(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1expr_1p_1eval_1as_1int(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_big_integer res_native = BigIntegerWrapper_new_value();

    // Call the native function
    ada_expr_p_eval_as_int(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BigIntegerWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BigIntegerWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1expr_1p_1eval_1as_1int_1in_1env(
    JNIEnv *env,
    jclass jni_lib,
    jobject env_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_internal_substitution_array env_native = SubstitutionArrayWrapper_unwrap(env, env_java);

    // Prepare the result structure
    ada_big_integer res_native = BigIntegerWrapper_new_value();

    // Call the native function
    ada_expr_p_eval_as_int_in_env(
        &entity_native,
        env_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BigIntegerWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BigIntegerWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */
    SubstitutionArrayWrapper_release(
        env_native
    );

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1expr_1p_1eval_1as_1string(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_string_type res_native = StringWrapper_new_value();

    // Call the native function
    ada_expr_p_eval_as_string(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1expr_1p_1eval_1as_1string_1in_1env(
    JNIEnv *env,
    jclass jni_lib,
    jobject env_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_internal_substitution_array env_native = SubstitutionArrayWrapper_unwrap(env, env_java);

    // Prepare the result structure
    ada_string_type res_native = StringWrapper_new_value();

    // Call the native function
    ada_expr_p_eval_as_string_in_env(
        &entity_native,
        env_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */
    SubstitutionArrayWrapper_release(
        env_native
    );

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1expr_1p_1matching_1nodes(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = AdaNodeArrayWrapper_new_value();

    // Call the native function
    ada_expr_p_matching_nodes(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AdaNodeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        AdaNodeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1expr_1p_1is_1dispatching_1call(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_expr_p_is_dispatching_call(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1expr_1p_1first_1corresponding_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_expr_p_first_corresponding_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1abstract_1state_1decl_1expr_1f_1state_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_abstract_state_decl_expr_f_state_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1allocator_1f_1subpool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_allocator_f_subpool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1allocator_1f_1type_1or_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_allocator_f_type_or_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1allocator_1p_1get_1allocated_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_allocator_p_get_allocated_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1aggregate_1f_1ancestor_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_aggregate_f_ancestor_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1aggregate_1f_1assocs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_aggregate_f_assocs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1aggregate_1p_1aggregate_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_internal_param_actual_array res_native = ParamActualArrayWrapper_new_value();

    // Call the native function
    ada_base_aggregate_p_aggregate_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = ParamActualArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        ParamActualArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1aggregate_1p_1is_1subaggregate(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_base_aggregate_p_is_subaggregate(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1bin_1op_1f_1left(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_bin_op_f_left(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1bin_1op_1f_1op(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_bin_op_f_op(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1bin_1op_1f_1right(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_bin_op_f_right(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1case_1expr_1alternative_1f_1choices(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_case_expr_alternative_f_choices(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1case_1expr_1alternative_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_case_expr_alternative_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1concat_1op_1f_1first_1operand(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_concat_op_f_first_operand(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1concat_1op_1f_1other_1operands(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_concat_op_f_other_operands(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1concat_1op_1p_1operands(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = ExprArrayWrapper_new_value();

    // Call the native function
    ada_concat_op_p_operands(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = ExprArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        ExprArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1concat_1operand_1f_1operator(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_concat_operand_f_operator(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1concat_1operand_1f_1operand(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_concat_operand_f_operand(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1cond_1expr_1p_1dependent_1exprs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = ExprArrayWrapper_new_value();

    // Call the native function
    ada_cond_expr_p_dependent_exprs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = ExprArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        ExprArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1case_1expr_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_case_expr_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1case_1expr_1f_1cases(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_case_expr_f_cases(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1if_1expr_1f_1cond_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_if_expr_f_cond_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1if_1expr_1f_1then_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_if_expr_f_then_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1if_1expr_1f_1alternatives(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_if_expr_f_alternatives(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1if_1expr_1f_1else_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_if_expr_f_else_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1contract_1cases_1f_1contract_1cases(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_contract_cases_f_contract_cases(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1decl_1expr_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_decl_expr_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1decl_1expr_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_decl_expr_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1format_1string_1literal_1f_1opening_1chunk(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_format_string_literal_f_opening_chunk(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1format_1string_1literal_1f_1mid_1exprs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_format_string_literal_f_mid_exprs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1format_1string_1literal_1f_1trailing_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_format_string_literal_f_trailing_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1membership_1expr_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_membership_expr_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1membership_1expr_1f_1op(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_membership_expr_f_op(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1membership_1expr_1f_1membership_1exprs(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_membership_expr_f_membership_exprs(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1enclosing_1defining_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_name_p_enclosing_defining_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1is_1defining(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_name_p_is_defining(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1name_1is(
    JNIEnv *env,
    jclass jni_lib,
    jobject sym_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type sym_native = Symbol_unwrap(env, sym_java, context_native);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_name_p_name_is(
        &entity_native,
        &sym_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1is_1direct_1call(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_name_p_is_direct_call(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1is_1access_1call(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_name_p_is_access_call(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1is_1call(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_name_p_is_call(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1is_1dot_1call(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_name_p_is_dot_call(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1failsafe_1referenced_1def_1name(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_internal_refd_def res_native = RefdDef_new_value();

    // Call the native function
    ada_name_p_failsafe_referenced_def_name(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = RefdDef_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1referenced_1defining_1name(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_name_p_referenced_defining_name(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1all_1env_1elements(
    JNIEnv *env,
    jclass jni_lib,
    jboolean seq_java,
    jobject seq_from_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool seq_native = (ada_bool) seq_java;
    ada_node seq_from_native = Entity_unwrap(env, seq_from_java);

    // Prepare the result structure
    ada_node_array res_native = AdaNodeArrayWrapper_new_value();

    // Call the native function
    ada_name_p_all_env_elements(
        &entity_native,
        seq_native,
        &seq_from_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AdaNodeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        AdaNodeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1called_1subp_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_name_p_called_subp_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1referenced_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_name_p_referenced_decl(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1failsafe_1referenced_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_internal_refd_decl res_native = RefdDecl_new_value();

    // Call the native function
    ada_name_p_failsafe_referenced_decl(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = RefdDecl_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1name_1designated_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_name_p_name_designated_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1is_1static_1subtype(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_name_p_is_static_subtype(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1name_1matches(
    JNIEnv *env,
    jclass jni_lib,
    jobject n_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node n_native = Entity_unwrap(env, n_java);

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_name_p_name_matches(
        &entity_native,
        &n_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1is_1operator_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_name_p_is_operator_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1is_1write_1reference(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_name_p_is_write_reference(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1is_1static_1call(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_name_p_is_static_call(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1call_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_internal_param_actual_array res_native = ParamActualArrayWrapper_new_value();

    // Call the native function
    ada_name_p_call_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = ParamActualArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        ParamActualArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1relative_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_name_p_relative_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1as_1symbol_1array(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_symbol_type_array res_native = UnboundedTextTypeArrayWrapper_new_value();

    // Call the native function
    ada_name_p_as_symbol_array(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = UnboundedTextTypeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        UnboundedTextTypeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1canonical_1text(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_symbol_type res_native = Symbol_new_value();

    // Call the native function
    ada_name_p_canonical_text(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Symbol_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1name_1p_1is_1constant(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_name_p_is_constant(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1array_1subcomponent_1choice_1name_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_array_subcomponent_choice_name_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1array_1subcomponent_1choice_1name_1f_1suffix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_array_subcomponent_choice_name_f_suffix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1attribute_1ref_1f_1prefix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_attribute_ref_f_prefix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1attribute_1ref_1f_1attribute(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_attribute_ref_f_attribute(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1attribute_1ref_1f_1args(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_attribute_ref_f_args(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1call_1expr_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_call_expr_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1call_1expr_1f_1suffix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_call_expr_f_suffix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1call_1expr_1p_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_call_expr_kind res_native = CallExprKind_new_value();

    // Call the native function
    ada_call_expr_p_kind(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = CallExprKind_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1call_1expr_1p_1is_1array_1slice(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_call_expr_p_is_array_slice(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_defining_name_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1canonical_1fully_1qualified_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_string_type res_native = StringWrapper_new_value();

    // Call the native function
    ada_defining_name_p_canonical_fully_qualified_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1unique_1identifying_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_string_type res_native = StringWrapper_new_value();

    // Call the native function
    ada_defining_name_p_unique_identifying_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1fully_1qualified_1name_1array(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_symbol_type_array res_native = UnboundedTextTypeArrayWrapper_new_value();

    // Call the native function
    ada_defining_name_p_fully_qualified_name_array(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = UnboundedTextTypeArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        UnboundedTextTypeArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1fully_1qualified_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_string_type res_native = StringWrapper_new_value();

    // Call the native function
    ada_defining_name_p_fully_qualified_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1basic_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_defining_name_p_basic_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1find_1refs(
    JNIEnv *env,
    jclass jni_lib,
    jobject root_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node root_native = Entity_unwrap(env, root_java);
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_internal_ref_result_array res_native = RefResultArrayWrapper_new_value();

    // Call the native function
    ada_defining_name_p_find_refs(
        &entity_native,
        &root_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = RefResultArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        RefResultArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1find_1all_1references(
    JNIEnv *env,
    jclass jni_lib,
    jobject units_java,
    jboolean follow_renamings_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_analysis_unit_array units_native = AnalysisUnitArrayWrapper_unwrap(env, units_java);
    ada_bool follow_renamings_native = (ada_bool) follow_renamings_java;
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_internal_ref_result_array res_native = RefResultArrayWrapper_new_value();

    // Call the native function
    ada_defining_name_p_find_all_references(
        &entity_native,
        units_native,
        follow_renamings_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = RefResultArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        RefResultArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */
    AnalysisUnitArrayWrapper_release(
        units_native
    );

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1find_1all_1calls(
    JNIEnv *env,
    jclass jni_lib,
    jobject units_java,
    jboolean follow_renamings_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_analysis_unit_array units_native = AnalysisUnitArrayWrapper_unwrap(env, units_java);
    ada_bool follow_renamings_native = (ada_bool) follow_renamings_java;
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_internal_ref_result_array res_native = RefResultArrayWrapper_new_value();

    // Call the native function
    ada_defining_name_p_find_all_calls(
        &entity_native,
        units_native,
        follow_renamings_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = RefResultArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        RefResultArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */
    AnalysisUnitArrayWrapper_release(
        units_native
    );

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1next_1part(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_defining_name_p_next_part(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1previous_1part(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_defining_name_p_previous_part(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1canonical_1part(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_defining_name_p_canonical_part(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1most_1visible_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_defining_name_p_most_visible_part(
        &entity_native,
        &origin_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1all_1parts(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node_array res_native = DefiningNameArrayWrapper_new_value();

    // Call the native function
    ada_defining_name_p_all_parts(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DefiningNameArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        DefiningNameArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1get_1aspect(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jboolean previous_parts_only_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);
    ada_bool previous_parts_only_native = (ada_bool) previous_parts_only_java;
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_internal_aspect res_native = Aspect_new_value();

    // Call the native function
    ada_defining_name_p_get_aspect(
        &entity_native,
        &name_native,
        previous_parts_only_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Aspect_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1has_1aspect(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jboolean previous_parts_only_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);
    ada_bool previous_parts_only_native = (ada_bool) previous_parts_only_java;
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_defining_name_p_has_aspect(
        &entity_native,
        &name_native,
        previous_parts_only_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1get_1pragma(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_defining_name_p_get_pragma(
        &entity_native,
        &name_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1get_1representation_1clause(
    JNIEnv *env,
    jclass jni_lib,
    jobject name_java,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);

    // Get the node unit
    ada_analysis_unit unit_native = ada_node_unit(&entity_native);

    // Get the node context
    ada_analysis_context context_native =
        ada_unit_context(unit_native);

    // Unwrap the arguments
    ada_symbol_type name_native = Symbol_unwrap(env, name_java, context_native);
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_defining_name_p_get_representation_clause(
        &entity_native,
        &name_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1get_1at_1clause(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_defining_name_p_get_at_clause(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1get_1annotations(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_internal_aspect_array res_native = AspectArrayWrapper_new_value();

    // Call the native function
    ada_defining_name_p_get_annotations(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = AspectArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        AspectArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1is_1imported(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_defining_name_p_is_imported(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1defining_1name_1p_1is_1ghost_1code(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_defining_name_p_is_ghost_code(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1discrete_1subtype_1name_1f_1subtype(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_discrete_subtype_name_f_subtype(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1dotted_1name_1f_1prefix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_dotted_name_f_prefix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1dotted_1name_1f_1suffix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_dotted_name_f_suffix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1end_1name_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_end_name_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1end_1name_1p_1basic_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_end_name_p_basic_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1explicit_1deref_1f_1prefix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_explicit_deref_f_prefix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1qual_1expr_1f_1prefix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_qual_expr_f_prefix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1qual_1expr_1f_1suffix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_qual_expr_f_suffix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1reduce_1attribute_1ref_1f_1prefix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_reduce_attribute_ref_f_prefix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1reduce_1attribute_1ref_1f_1attribute(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_reduce_attribute_ref_f_attribute(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1reduce_1attribute_1ref_1f_1args(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_reduce_attribute_ref_f_args(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1char_1literal_1p_1denoted_1value(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    uint32_t res_native = Char_new_value();

    // Call the native function
    ada_char_literal_p_denoted_value(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Char_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1string_1literal_1p_1denoted_1value(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_string_type res_native = StringWrapper_new_value();

    // Call the native function
    ada_string_literal_p_denoted_value(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = StringWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        StringWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1int_1literal_1p_1denoted_1value(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_big_integer res_native = BigIntegerWrapper_new_value();

    // Call the native function
    ada_int_literal_p_denoted_value(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = BigIntegerWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        BigIntegerWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1update_1attribute_1ref_1f_1prefix(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_update_attribute_ref_f_prefix(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1update_1attribute_1ref_1f_1attribute(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_update_attribute_ref_f_attribute(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1update_1attribute_1ref_1f_1values(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_update_attribute_ref_f_values(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1paren_1expr_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_paren_expr_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1quantified_1expr_1f_1quantifier(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_quantified_expr_f_quantifier(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1quantified_1expr_1f_1loop_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_quantified_expr_f_loop_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1quantified_1expr_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_quantified_expr_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1raise_1expr_1f_1exception_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_raise_expr_f_exception_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1raise_1expr_1f_1error_1message(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_raise_expr_f_error_message(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1un_1op_1f_1op(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_un_op_f_op(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1un_1op_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_un_op_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1for_1loop_1iter_1filter_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_for_loop_iter_filter_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1format_1string_1chunk_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_format_string_chunk_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1format_1string_1chunk_1f_1string_1tok(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_format_string_chunk_f_string_tok(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1handled_1stmts_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_handled_stmts_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1handled_1stmts_1f_1exceptions(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_handled_stmts_f_exceptions(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1library_1item_1f_1has_1private(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_library_item_f_has_private(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1library_1item_1f_1item(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_library_item_f_item(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1limited_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_limited_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1for_1loop_1spec_1f_1var_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_for_loop_spec_f_var_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1for_1loop_1spec_1f_1loop_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_for_loop_spec_f_loop_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1for_1loop_1spec_1f_1has_1reverse(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_for_loop_spec_f_has_reverse(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1for_1loop_1spec_1f_1iter_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_for_loop_spec_f_iter_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1for_1loop_1spec_1f_1iter_1filter(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_for_loop_spec_f_iter_filter(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1while_1loop_1spec_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_while_loop_spec_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1multi_1abstract_1state_1decl_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_multi_abstract_state_decl_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1not_1null_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_not_null_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1params_1f_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_params_f_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1paren_1abstract_1state_1decl_1f_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_paren_abstract_state_decl_f_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1pp_1elsif_1directive_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_pp_elsif_directive_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1pp_1elsif_1directive_1f_1then_1kw(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_pp_elsif_directive_f_then_kw(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1pp_1if_1directive_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_pp_if_directive_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1pp_1if_1directive_1f_1then_1kw(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_pp_if_directive_f_then_kw(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1pragma_1node_1f_1id(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_pragma_node_f_id(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1pragma_1node_1f_1args(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_pragma_node_f_args(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1pragma_1node_1p_1is_1ghost_1code(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_pragma_node_p_is_ghost_code(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1pragma_1node_1p_1associated_1entities(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node_array res_native = DefiningNameArrayWrapper_new_value();

    // Call the native function
    ada_pragma_node_p_associated_entities(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = DefiningNameArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        DefiningNameArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1private_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_private_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1protected_1def_1f_1public_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_protected_def_f_public_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1protected_1def_1f_1private_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_protected_def_f_private_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1protected_1def_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_protected_def_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1protected_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_protected_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1range_1spec_1f_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_range_spec_f_range(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1renaming_1clause_1f_1renamed_1object(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_renaming_clause_f_renamed_object(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1reverse_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_reverse_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1select_1when_1part_1f_1cond_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_select_when_part_f_cond_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1select_1when_1part_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_select_when_part_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1stmt_1p_1is_1ghost_1code(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_stmt_p_is_ghost_code(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1accept_1stmt_1f_1body_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_accept_stmt_f_body_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1accept_1stmt_1f_1entry_1index_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_accept_stmt_f_entry_index_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1accept_1stmt_1f_1params(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_accept_stmt_f_params(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1accept_1stmt_1p_1corresponding_1entry(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_accept_stmt_p_corresponding_entry(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1accept_1stmt_1with_1stmts_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_accept_stmt_with_stmts_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1accept_1stmt_1with_1stmts_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_accept_stmt_with_stmts_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1loop_1stmt_1f_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_loop_stmt_f_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1loop_1stmt_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_loop_stmt_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1base_1loop_1stmt_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_base_loop_stmt_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1begin_1block_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_begin_block_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1begin_1block_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_begin_block_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1decl_1block_1f_1decls(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_decl_block_f_decls(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1decl_1block_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_decl_block_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1decl_1block_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_decl_block_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1case_1stmt_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_case_stmt_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1case_1stmt_1f_1pragmas(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_case_stmt_f_pragmas(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1case_1stmt_1f_1alternatives(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_case_stmt_f_alternatives(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1extended_1return_1stmt_1f_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_extended_return_stmt_f_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1extended_1return_1stmt_1f_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_extended_return_stmt_f_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1if_1stmt_1f_1cond_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_if_stmt_f_cond_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1if_1stmt_1f_1then_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_if_stmt_f_then_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1if_1stmt_1f_1alternatives(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_if_stmt_f_alternatives(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1if_1stmt_1f_1else_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_if_stmt_f_else_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1named_1stmt_1f_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_named_stmt_f_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1named_1stmt_1f_1stmt(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_named_stmt_f_stmt(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1select_1stmt_1f_1guards(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_select_stmt_f_guards(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1select_1stmt_1f_1else_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_select_stmt_f_else_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1select_1stmt_1f_1abort_1stmts(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_select_stmt_f_abort_stmts(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1abort_1stmt_1f_1names(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_abort_stmt_f_names(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1assign_1stmt_1f_1dest(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_assign_stmt_f_dest(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1assign_1stmt_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_assign_stmt_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1call_1stmt_1f_1call(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_call_stmt_f_call(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1delay_1stmt_1f_1has_1until(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_delay_stmt_f_has_until(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1delay_1stmt_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_delay_stmt_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1exit_1stmt_1f_1loop_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_exit_stmt_f_loop_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1exit_1stmt_1f_1cond_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_exit_stmt_f_cond_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1goto_1stmt_1f_1label_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_goto_stmt_f_label_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1label_1f_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_label_f_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1raise_1stmt_1f_1exception_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_raise_stmt_f_exception_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1raise_1stmt_1f_1error_1message(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_raise_stmt_f_error_message(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1requeue_1stmt_1f_1call_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_requeue_stmt_f_call_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1requeue_1stmt_1f_1has_1abort(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_requeue_stmt_f_has_abort(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1return_1stmt_1f_1return_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_return_stmt_f_return_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1simple_1decl_1stmt_1f_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_simple_decl_stmt_f_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subunit_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subunit_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subunit_1f_1body(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subunit_f_body(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subunit_1p_1body_1root(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subunit_p_body_root(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1synchronized_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_synchronized_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1tagged_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_tagged_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1task_1def_1f_1interfaces(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_task_def_f_interfaces(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1task_1def_1f_1public_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_task_def_f_public_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1task_1def_1f_1private_1part(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_task_def_f_private_part(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1task_1def_1f_1end_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_task_def_f_end_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1access_1def_1f_1has_1not_1null(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_access_def_f_has_not_null(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1access_1to_1subp_1def_1f_1has_1protected(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_access_to_subp_def_f_has_protected(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1access_1to_1subp_1def_1f_1subp_1spec(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_access_to_subp_def_f_subp_spec(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1anonymous_1type_1access_1def_1f_1type_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_anonymous_type_access_def_f_type_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1type_1access_1def_1f_1has_1all(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_type_access_def_f_has_all(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1type_1access_1def_1f_1has_1constant(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_type_access_def_f_has_constant(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1type_1access_1def_1f_1subtype_1indication(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_type_access_def_f_subtype_indication(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1array_1type_1def_1f_1indices(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_array_type_def_f_indices(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1array_1type_1def_1f_1component_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_array_type_def_f_component_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1derived_1type_1def_1f_1has_1abstract(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_derived_type_def_f_has_abstract(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1derived_1type_1def_1f_1has_1limited(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_derived_type_def_f_has_limited(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1derived_1type_1def_1f_1has_1synchronized(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_derived_type_def_f_has_synchronized(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1derived_1type_1def_1f_1subtype_1indication(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_derived_type_def_f_subtype_indication(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1derived_1type_1def_1f_1interfaces(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_derived_type_def_f_interfaces(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1derived_1type_1def_1f_1record_1extension(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_derived_type_def_f_record_extension(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1derived_1type_1def_1f_1has_1with_1private(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_derived_type_def_f_has_with_private(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1enum_1type_1def_1f_1enum_1literals(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_enum_type_def_f_enum_literals(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1interface_1type_1def_1f_1interface_1kind(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_interface_type_def_f_interface_kind(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1interface_1type_1def_1f_1interfaces(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_interface_type_def_f_interfaces(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1mod_1int_1type_1def_1f_1expr(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_mod_int_type_def_f_expr(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1private_1type_1def_1f_1has_1abstract(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_private_type_def_f_has_abstract(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1private_1type_1def_1f_1has_1tagged(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_private_type_def_f_has_tagged(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1private_1type_1def_1f_1has_1limited(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_private_type_def_f_has_limited(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1decimal_1fixed_1point_1def_1f_1delta(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_decimal_fixed_point_def_f_delta(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1decimal_1fixed_1point_1def_1f_1digits(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_decimal_fixed_point_def_f_digits(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1decimal_1fixed_1point_1def_1f_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_decimal_fixed_point_def_f_range(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1floating_1point_1def_1f_1num_1digits(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_floating_point_def_f_num_digits(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1floating_1point_1def_1f_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_floating_point_def_f_range(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ordinary_1fixed_1point_1def_1f_1delta(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ordinary_fixed_point_def_f_delta(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1ordinary_1fixed_1point_1def_1f_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_ordinary_fixed_point_def_f_range(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1record_1type_1def_1f_1has_1abstract(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_record_type_def_f_has_abstract(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1record_1type_1def_1f_1has_1tagged(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_record_type_def_f_has_tagged(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1record_1type_1def_1f_1has_1limited(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_record_type_def_f_has_limited(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1record_1type_1def_1f_1record_1def(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_record_type_def_f_record_def(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1signed_1int_1type_1def_1f_1range(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_signed_int_type_def_f_range(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1type_1expr_1p_1type_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_type_expr_p_type_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1type_1expr_1p_1designated_1type_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_type_expr_p_designated_type_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1type_1expr_1p_1designated_1type_1decl_1from(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_node_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_node_native = Entity_unwrap(env, origin_node_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_type_expr_p_designated_type_decl_from(
        &entity_native,
        &origin_node_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1type_1expr_1p_1subtype_1constraint(
    JNIEnv *env,
    jclass jni_lib,
    jobject origin_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_node origin_native = Entity_unwrap(env, origin_java);

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_type_expr_p_subtype_constraint(
        &entity_native,
        &origin_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1type_1expr_1p_1discriminant_1constraints(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_internal_param_actual_array res_native = ParamActualArrayWrapper_new_value();

    // Call the native function
    ada_type_expr_p_discriminant_constraints(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = ParamActualArrayWrapper_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
        ParamActualArrayWrapper_release(
            res_native
        );
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1type_1expr_1p_1is_1definite_1subtype(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_type_expr_p_is_definite_subtype(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1anonymous_1type_1f_1type_1decl(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_anonymous_type_f_type_decl(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subtype_1indication_1f_1has_1not_1null(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subtype_indication_f_has_not_null(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subtype_1indication_1f_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subtype_indication_f_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subtype_1indication_1f_1constraint(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_subtype_indication_f_constraint(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1subtype_1indication_1p_1is_1static_1subtype(
    JNIEnv *env,
    jclass jni_lib,
    jboolean imprecise_fallback_java,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments
    ada_bool imprecise_fallback_native = (ada_bool) imprecise_fallback_java;

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_subtype_indication_p_is_static_subtype(
        &entity_native,
        imprecise_fallback_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1synthetic_1type_1expr_1f_1target_1type(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_synthetic_type_expr_f_target_type(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1unconstrained_1array_1index_1f_1subtype_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_unconstrained_array_index_f_subtype_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1unconstrained_1array_1index_1f_1lower_1bound(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_unconstrained_array_index_f_lower_bound(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1until_1node_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_until_node_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1use_1package_1clause_1f_1packages(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_use_package_clause_f_packages(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1use_1type_1clause_1f_1has_1all(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_use_type_clause_f_has_all(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1use_1type_1clause_1f_1types(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_use_type_clause_f_types(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1value_1sequence_1f_1iter_1assoc(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_value_sequence_f_iter_assoc(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1variant_1f_1choices(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_variant_f_choices(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1variant_1f_1components(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_variant_f_components(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1variant_1part_1f_1discr_1name(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_variant_part_f_discr_name(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1variant_1part_1f_1variant(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_variant_part_f_variant(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1with_1clause_1f_1has_1limited(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_with_clause_f_has_limited(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1with_1clause_1f_1has_1private(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_with_clause_f_has_private(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jobject Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1with_1clause_1f_1packages(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_node res_native = Entity_new_value();

    // Call the native function
    ada_with_clause_f_packages(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jobject res = NULL;
    if (exc_c == NULL)
      {
        res = Entity_wrap(env, res_native);

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}


    

JNIEXPORT jboolean Java_com_adacore_libadalang_Libadalang_00024JNI_1LIB_ada_1with_1private_1p_1as_1bool(
    JNIEnv *env,
    jclass jni_lib,
    jobject entity
) {
    // Unwrap the node
    ada_node entity_native = Entity_unwrap(env, entity);



    // Unwrap the arguments

    // Prepare the result structure
    ada_bool res_native = 0;

    // Call the native function
    ada_with_private_p_as_bool(
        &entity_native,
        &res_native
    );

    /* If successful, wrap the return value.  */
    const ada_exception *exc_c = ada_get_last_exception ();
    jboolean res = 0;
    if (exc_c == NULL)
      {
        res = (jboolean) res_native;

        /* Release resources used to wrap the result.  */
      }

    /* Release resources used to unwrap the arguments.  */

    /* Raise the exception if any, return the result otherwise.  */
    if (exc_c != NULL)
      {
        jthrowable exc_java = LangkitException_wrap (env, *exc_c);
        (*env)->Throw (env, exc_java);
      }
    return res;
}

