#ifndef _COMMANDEXECUTER_H_INCLUDED_
#define _COMMANDEXECUTER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CommandExecuter.h  
// -----------------
// Executing commands via process forking 
//                                                        
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2007-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CommandExecuter
// 
// Description: Execution of a forked sub program 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// BASE INCLUDES
#include "Chain.h"
#include "ListT.h"
#include "SigHandler.h"

// DEFINES
#define DEFTIMEOUT 60 

class CommandExecuter  : public SigHandler {
    
public:
    
    CommandExecuter(const Chain& shellPath = Chain("/bin/sh"));
    ~CommandExecuter();
    
    int execute(const Chain& command, int timeout = DEFTIMEOUT);

    static Chain executeStream(const Chain& command);
    
private:

    Chain _shellPath;
    void sigCatch(int sig);
    int _childPid;
};
#endif
