#ifndef GODOT_CPP_NAVIGATION2D_HPP
#define GODOT_CPP_NAVIGATION2D_HPP


#include <gdnative_api_struct.gen.h>
#include <cstdint>

#include <core/CoreTypes.hpp>
#include <core/Ref.hpp>

#include "Node2D.hpp"
namespace godot {


class Navigation2D : public Node2D {
	struct ___method_bindings {
		godot_method_bind *mb_get_cell_size;
		godot_method_bind *mb_get_closest_point;
		godot_method_bind *mb_get_closest_point_owner;
		godot_method_bind *mb_get_edge_connection_margin;
		godot_method_bind *mb_get_navigation_layers;
		godot_method_bind *mb_get_rid;
		godot_method_bind *mb_get_simple_path;
		godot_method_bind *mb_set_cell_size;
		godot_method_bind *mb_set_edge_connection_margin;
		godot_method_bind *mb_set_navigation_layers;
	};
	static ___method_bindings ___mb;
	static void *_detail_class_tag;

public:
	static void ___init_method_bindings();
	inline static size_t ___get_id() { return (size_t)_detail_class_tag; }

	static inline const char *___get_class_name() { return (const char *) "Navigation2D"; }
	static inline const char *___get_godot_class_name() { return (const char *) "Navigation2D"; }
	static inline Object *___get_from_variant(Variant a) { godot_object *o = (godot_object*) a; return (o) ? (Object *) godot::nativescript_1_1_api->godot_nativescript_get_instance_binding_data(godot::_RegisterState::language_index, o) : nullptr; }

	// enums

	// constants


	static Navigation2D *_new();

	// methods
	real_t get_cell_size() const;
	Vector2 get_closest_point(const Vector2 to_point) const;
	RID get_closest_point_owner(const Vector2 to_point) const;
	real_t get_edge_connection_margin() const;
	int64_t get_navigation_layers() const;
	RID get_rid() const;
	PoolVector2Array get_simple_path(const Vector2 start, const Vector2 end, const bool optimize = true) const;
	void set_cell_size(const real_t cell_size);
	void set_edge_connection_margin(const real_t margin);
	void set_navigation_layers(const int64_t navigation_layers);

};

}

#endif