csphinxtools.librarydescription
Library
q )q}q(X   nameqX   wx.tools-4.2.1qX   kindqK X   docsqX-   Some useful tools and utilities for wxPython.qX   commentsqX    q	X   is_redundantq
X   childrenq]q(csphinxtools.librarydescription
Module
q
)q}q(hX   wx.tools.dbgqhKhX  This module provides a useful debugging framework that supports
showing nesting of function calls and allows a program to contain
lots of debugging print statements that can easily be turned on
or off to debug the code.  It also supports the ability to
have each function indent the debugging statements contained
within it, including those of any other function called within
its scope, thus allowing you to see in what order functions are
being called, and from where.

This capability is particularly useful in wxPython applications,
where exactly events occur that cause functions to be called is
not entirely clear, and because wxPython programs can't be run
from inside other debugging environments that have their own
message loops.

This module defines a Logger class, responsible for managing
debugging output.  Each Logger instance can be given a name
at construction; if this is done, '<name>:' will precede each
logging output made by that Logger instance.

The log() function this class provides takes a set of positional
arguments that are printed in order if debugging is enabled
(just like print does), followed by a set of keyword arguments
that control the behavior of the log() function itself on subsequent
calls.  The current keyword arguments are:

indent
    When set to a value of 1, this increments the current
    indentation level, causing all subsequent dbg() outputs to be
    indented by 3 more spaces.  When set to a value of 0,
    this process is reversed, causing the indent to decrease by
    3 spaces.  The default indentation level is 0.

enable
    When set to a value of 1, this turns on dbg() output for
    for program importing this module, until told to do otherwise.
    When set to a value of 0, dbg output is turned off.  (dbg
    output is off by default.)

suspend
    When set to a value of 1, this increments the current
    "suspension" level.  This makes it possible for a function
    to temporarily suspend its and any of its dependents'
    potential outputs that use the same Logger instance.
    When set to a value of 0, the suspension level is
    decremented.  When the value goes back to 0, potential
    logging is resumed (actual output depends on the
    "enable" status of the Logger instance in question.)

wxlog
    When set to a value of 1, the output will be sent to the
    active wxLog target.

stream
    When set to a non-None value, the current output stream
    (default of sys.stdout) is pushed onto a stack of streams,
    and is replaced in the dbg system with the specified stream.
    When called with a value of None, the previous stream will
    be restored (if stacked.)  If set to None without previously
    changing it will result in no action being taken.

You can also call the log function implicitly on the Logger
instance, ie. you can type::

    from wx.tools.dbg import Logger
    dbg = Logger()
    dbg('something to print')

Using this fairly simple mechanism, it is possible to get fairly
useful debugging output in a program.  Consider the following
code example:

>>> d = {1:'a', 2:'dictionary', 3:'of', 4:'words'}
>>> dbg = dbg.Logger('module')
>>> dbg(enable=1)
module: dbg enabled
>>> def foo(d):
...     dbg('foo', indent=1)
...     bar(d)
...     dbg('end of foo', indent=0)
...
>>> def bar(d):
...     dbg('bar', indent=1)
...     dbg('contents of d:', indent=1)
...     l = d.items()
...     l.sort()
...     for key, value in l:
...         dbg('%d =' % key, value)
...     dbg(indent=0)
...     dbg('end of bar', indent=0)
...
>>> foo(d)
module: foo
   module: bar
      module: contents of d:
         module: 1 = a
         module: 2 = dictionary
         module: 3 = of
         module: 4 = words
      module: end of bar
   module: end of foo
>>>qhX  #----------------------------------------------------------------------------
# Name:         dbg.py
# Author:       Will Sadkin
# Email:        wsadkin@nameconnector.com
# Created:      07/11/2002
# Copyright:    (c) 2002 by Will Sadkin, 2002
# License:      wxWindows license
# Tags:         phoenix-port
#----------------------------------------------------------------------------
# 12/21/2003 - Jeff Grimmett (grimmtooth@softhome.net)
#
# o V2.5 compatibility update
#
qh
h]qcsphinxtools.librarydescription
Class
q)q}q(hX   wx.tools.dbg.LoggerqhKhh	hh	h
h]q(csphinxtools.librarydescription
Method
q)q}q(hX   wx.tools.dbg.Logger.__init__qhKX   orderqKhX>   Initialize self.  See help(type(self)) for accurate signature.qhh	h
X	   argumentsq]q X   nameq!X   Noneq"X   Noneq#q$aX	   signatureq%X   __init__(self, name=None)q&X   obj_typeq'X   Method/Functionq(X   number_linesq)X   10q*X   parentq+hubh)q,}q-(hX   wx.tools.dbg.Logger.IsEnabledq.hKhKhh	hh	h
h]q/h%X   IsEnabled()q0h'h(h)X   3q1h+hubh)q2}q3(hX   wx.tools.dbg.Logger.IsSuspendedq4hKhKhh	hh	h
h]q5h%X
   IsSuspended()q6h'h(h)h1h+hubh)q7}q8(hX   wx.tools.dbg.Logger.logq9hKhKhX   This function provides a useful framework for generating
optional debugging output that can be displayed at an
arbitrary level of indentation.q:hh	h
h]q;(X   *argsq<h	h	q=X   **kwargsq>h	h	q?eh%X   log(self, \*args, \*\*kwargs)q@h'h(h)X   42qAh+hubh)qB}qC(hX   wx.tools.dbg.Logger.SetEnabledqDhKhKhh	hh	h
h]qEX   valueqFh	h	qGah%X   SetEnabled(self, value)qHh'h(h)X   11qIh+hubh)qJ}qK(hX   wx.tools.dbg.Logger.SetIndentqLhKhKhh	hh	h
h]qMX   valueqNh	h	qOah%X   SetIndent(self, value)qPh'h(h)X   6qQh+hubh)qR}qS(hX   wx.tools.dbg.Logger.SetStreamqThKhKhh	hh	h
h]qUX   valueqVh	h	qWah%X   SetStream(self, value)qXh'h(h)X   7qYh+hubh)qZ}q[(hX   wx.tools.dbg.Logger.SetSuspendq\hKhKhh	hh	h
h]q]X   valueq^h	h	q_ah%X   SetSuspend(self, value)q`h'h(h)hQh+hubh)qa}qb(hX   wx.tools.dbg.Logger.SetWxLogqchKhKhh	hh	h
h]qdX   valueqeh	h	qfah%X   SetWxLog(self, value)qgh'h(h)h1h+hubeX
   class_treeqh]qi(]qjX   objectqka]ql]qmX   LoggerqnaaeX
   subClassesqo]qpX   superClassesqq]qrh%X   Logger:qsX   inheritance_diagramqtcsphinxtools.inheritance
InheritanceDiagram
qu)qv}qw(X
   class_infoqx]qyX   wx.tools.dbg.Loggerqz]q{q|aX   specialsq}]q~X   wx.tools.dbg.LoggerqaX
   main_classqhubhKh'X   ClassqX   sphinx_fileqXF   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.dbg.Logger.txtqh+hh)X   104qX   method_listq]q(X   __init__qX	   IsEnabledqX   IsSuspendedqX   logqX
   SetEnabledqX	   SetIndentqX	   SetStreamqX
   SetSuspendqX   SetWxLogqeX   basesqhrubaX   filenameqX2   /home/wxpy/bb2/dist-src-py37/build/wx/tools/dbg.pyqhX?   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.dbg.txtqhKh'X	   Py_Moduleqhthu)q}q(hx]qX   wx.tools.dbg.Loggerq]qqah}]qX   wx.tools.dbg.Loggerqahhubh+hubh
)q}q(hX   wx.tools.helpviewerqhKhXV  helpviewer.py   --  Displays HTML Help in a wxHtmlHelpController window.

Usage:
    helpviewer [--cache=path] helpfile [helpfile(s)...]

    Where helpfile is the path to either a .hhp file or a .zip file
    which contains a .hhp file.  The .hhp files are the same as those
    used by Microsoft's HTML Help Workshop for creating CHM files.qhX  #----------------------------------------------------------------------
# Name:        wx.tools.helpviewer
# Purpose:     HTML Help viewer
#
# Author:      Robin Dunn
#
# Created:     11-Dec-2002
# Copyright:   (c) 2002-2020 by Total Control Software
# Licence:     wxWindows license
# Tags:        phoenix-port, py3-port
#----------------------------------------------------------------------
qh
h]q(h)q}q(hX   wx.tools.helpviewer.mainqhKhKhh	hh	h
h]qX   argsqX   sys.argvqXS   ['build.py', 'wxlib', 'sdist', 'sdist_demo', '--upload', '--gtk3', '--release', '']qqah%X   main(args=sys.argv)qh'h(h)X   53qX   firstlinenoqX   35qh+hubh)q}q(hX"   wx.tools.helpviewer.makeOtherFrameqhKhKhh	hh	h
h]qX   helpctrlqh	h	qah%X   makeOtherFrame(helpctrl)qh'h(h)X   5qhX   29qh+hubehX9   /home/wxpy/bb2/dist-src-py37/build/wx/tools/helpviewer.pyqhXF   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.helpviewer.txtqhKh'hhtNh+hubh
)q}q(hX   wx.tools.img2imgqhKhh	hX  #----------------------------------------------------------------------
# Name:        wx.tools.img2img
# Purpose:     Common routines for the image converter utilities.
#
# Author:      Robin Dunn
#
# Copyright:   (c) 2002-2020 by Total Control Software
# Licence:     wxWindows license
# Tags:        phoenix-port, py3-port
#----------------------------------------------------------------------
# 12/21/2003 - Jeff Grimmett (grimmtooth@softhome.net)
#
# o V2.5 compatibility update
#
qh
h]q(h)q}q(hX   wx.tools.img2img.convertqhKhKhh	hh	h
h]q(X   fileqh	h	qX   maskClrqh	h	qX	   outputDirqh	h	qX
   outputNameqh	h	qX   outTypeqh	h	qX   outExtqh	h	qeh%X>   convert(file, maskClr, outputDir, outputName, outType, outExt)qh'h(h)X   25qhX   23qh+hubh)q}q(hX   wx.tools.img2img.mainqhKhKhh	hh	h
h]q(X   argsqh	h	qX   outTypeqh	h	qX   outExtqh	h	qX   docqh	h	qeh%X    main(args, outType, outExt, doc)qh'h(h)X   35qhX   51qh+hubehX6   /home/wxpy/bb2/dist-src-py37/build/wx/tools/img2img.pyqhXC   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.img2img.txtqhKh'hhtNh+hubh
)q}q(hX   wx.tools.img2pngqhKhX  img2png.py  -- convert several image formats to PNG format.

Usage:

    img2png.py [options] image_files...

Options:

    -o <dir>       The directory to place the .png file(s), defaults to
                   the current directory.

    -m <#rrggbb>   If the original image has a mask or transparency defined
                   it will be used by default.  You can use this option to
                   override the default or provide a new mask by specifying
                   a colour in the image to mark as transparent.

    -n <name>      A filename to write the .png data to.  Defaults to the
                   basename of the image file + '.png'  This option overrides
                   the -o option.qhX  #----------------------------------------------------------------------
# Name:        wx.tools.img2png
# Purpose:     Convert an image to PNG format
#
# Author:      Robin Dunn
#
# Copyright:   (c) 2002-2020 by Total Control Software
# Licence:     wxWindows license
#----------------------------------------------------------------------
# 12/21/2003 - Jeff Grimmett (grimmtooth@softhome.net)
#
# o V2.5 compatibility update
#
qh
h]q(h)q}q(hX   wx.tools.img2png.mainqhKhKhh	hh	h
h]qh%X   main()qh'h(h)hYhX   43qh+hubcsphinxtools.librarydescription
Attribute
q)q}q(hX   wx.tools.img2png.appqhKhKhh	hh	h
X   valueqX   NoneqX   specsqX   NoneTypeqh'X	   Attributeqh+hubehX6   /home/wxpy/bb2/dist-src-py37/build/wx/tools/img2png.pyqhXC   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.img2png.txtqhKh'hhtNh+hubh
)q}q(hX   wx.tools.img2pyqhKhX  img2py.py  --  Convert an image to PNG format and embed it in a Python
               module with appropriate code so it can be loaded into
               a program at runtime.  The benefit is that since it is
               Python source code it can be delivered as a .pyc or
               'compiled' into the program using freeze, py2exe, etc.

Usage:

    img2py.py [options] image_file python_file

Options:

    -m <#rrggbb>   If the original image has a mask or transparency defined
                   it will be used by default.  You can use this option to
                   override the default or provide a new mask by specifying
                   a colour in the image to mark as transparent.

    -n <name>      Normally generic names (getBitmap, etc.) are used for the
                   image access functions.  If you use this option you can
                   specify a name that should be used to customize the access
                   functions, (getNameBitmap, etc.)

    -c             Maintain a catalog of names that can be used to reference
                   images.  Catalog can be accessed via catalog and
                   index attributes of the module.
                   If the -n <name> option is specified then <name>
                   is used for the catalog key and index value, otherwise
                   the filename without any path or extension is used
                   as the key.

    -a             This flag specifies that the python_file should be appended
                   to instead of overwritten.  This in combination with -n will
                   allow you to put multiple images in one Python source file.

    -i             Also output a function to return the image as a wxIcon.

    -f             Generate code compatible with the old function interface.
                   (This option is ON by default in 2.8, use -f to turn off.)

You can also import this module from your Python scripts, and use its img2py()
function. See its docstring for more info.qhXT  #----------------------------------------------------------------------
# Name:        wx.tools.img2py
# Purpose:     Convert an image to Python code.
#
# Author:      Robin Dunn
#
# Copyright:   (c) 2002-2020 by Total Control Software
# Licence:     wxWindows license
# Tags:        phoenix-port, py3-port
#----------------------------------------------------------------------
#
# Changes:
#    - Cliff Wells <LogiplexSoftware@earthlink.net>
#      20021206: Added catalog (-c) option.
#
# 12/21/2003 - Jeff Grimmett (grimmtooth@softhome.net)
#        V2.5 compatibility update
#
# 2/25/2007 - Gianluca Costa (archimede86@katamail.com)
#        -Refactorization of the script-creation code in a specific "img2py()" function
#        -Added regex parsing instead of module importing
#        -Added some "try/finally" statements
#        -Added default values as named constants
#        -Made some parts of code a bit easier to read
#        -Updated the module docstring
#        -Corrected a bug with EmptyIcon
#
# 11/26/2007 - Anthony Tuininga (anthony.tuininga@gmail.com)
#        -Use base64 encoding instead of simple repr
#        -Remove compression which doesn't buy anything in most cases and
#         costs more in many cases
#        -Use wx.lib.embeddedimage.PyEmbeddedImage class which has methods
#         rather than using standalone methods
#
qh
h]q(h)r   }r  (hX   wx.tools.img2py.b64encoder  hKhKhX  Encode the bytes-like object s using Base64 and return a bytes object.

Optional altchars should be a byte string of length 2 which specifies an
alternative alphabet for the '+' and '/' characters.  This allows an
application to e.g. generate url or filesystem safe Base64 strings.r  hh	h
h]r  (X   sr  h	h	r  X   altcharsr  X   Noner  X   Noner	  r
  eh%X   b64encode(s, altchars=None)r  h'h(h)X   13r  hX   51r
  h+hubh)r  }r  (hX   wx.tools.img2py.convertr  hKhKhh	hh	h
h]r  (X   fileNamer  h	h	r  X   maskClrr  h	h	r  X	   outputDirr  h	h	r  X
   outputNamer  h	h	r  X   outTyper  h	h	r  X   outExtr  h	h	r  eh%XB   convert(fileName, maskClr, outputDir, outputName, outType, outExt)r  h'h(h)X   14r  hX   110r   h+hubh)r!  }r"  (hX   wx.tools.img2py.img2pyr#  hKhKhX   Converts an image file to a data structure written in a Python file
--image_file: string; the path of the source image file
--python_file: string; the path of the destination python file
--other arguments: they are equivalent to the command-line argumentsr$  hh	h
h]r%  (X
   image_filer&  h	h	r'  X   python_filer(  h	h	r)  X   appendr*  X   DEFAULT_APPENDr+  X   Falser,  r-  X
   compressedr.  X   DEFAULT_COMPRESSEDr/  X   Truer0  r1  X   maskClrr2  X   DEFAULT_MASKCLRr3  X   Noner4  r5  X   imgNamer6  X   DEFAULT_IMGNAMEr7  h	r8  X   iconr9  X   DEFAULT_ICONr:  j,  r;  X   catalogr<  X   DEFAULT_CATALOGr=  j,  r>  X   functionCompatibler?  X   DEFAULT_COMPATIBLEr@  j,  rA  X   functionCompatibilerB  X   -1rC  X   -1rD  rE  h	h	h	rF  eh%X   img2py(image_file, python_file, append=DEFAULT_APPEND, compressed=DEFAULT_COMPRESSED, maskClr=DEFAULT_MASKCLR, imgName=DEFAULT_IMGNAME, icon=DEFAULT_ICON, catalog=DEFAULT_CATALOG, functionCompatible=DEFAULT_COMPATIBLE, functionCompatibile=-1, )rG  h'h(h)X   101rH  hX   160rI  h+hubh)rJ  }rK  (hX   wx.tools.img2py.mainrL  hKhKhh	hh	h
h]rM  X   argsrN  X   NonerO  X   NonerP  rQ  ah%X   main(args=None)rR  h'h(h)X   46rS  hX   261rT  h+hubh)rU  }rV  (hX   wx.tools.img2py.apprW  hKhKhh	hh	h
hX   NonerX  hX   NoneTyperY  h'hh+hubh)rZ  }r[  (hX   wx.tools.img2py.DEFAULT_APPENDr\  hKhKhX   bool(x) -> bool

Returns True when the argument x is true, False otherwise.
The builtins True and False are the only two instances of the class bool.
The class bool is a subclass of the class int, and cannot be subclassed.r]  hh	h
hj,  hX   boolr^  h'hh+hubh)r_  }r`  (hX   wx.tools.img2py.DEFAULT_CATALOGra  hKhKhX   bool(x) -> bool

Returns True when the argument x is true, False otherwise.
The builtins True and False are the only two instances of the class bool.
The class bool is a subclass of the class int, and cannot be subclassed.rb  hh	h
hj,  hX   boolrc  h'hh+hubh)rd  }re  (hX"   wx.tools.img2py.DEFAULT_COMPATIBLErf  hKhKhX   bool(x) -> bool

Returns True when the argument x is true, False otherwise.
The builtins True and False are the only two instances of the class bool.
The class bool is a subclass of the class int, and cannot be subclassed.rg  hh	h
hj,  hX   boolrh  h'hh+hubh)ri  }rj  (hX"   wx.tools.img2py.DEFAULT_COMPRESSEDrk  hKhKhX   bool(x) -> bool

Returns True when the argument x is true, False otherwise.
The builtins True and False are the only two instances of the class bool.
The class bool is a subclass of the class int, and cannot be subclassed.rl  hh	h
hj0  hX   boolrm  h'hh+hubh)rn  }ro  (hX   wx.tools.img2py.DEFAULT_ICONrp  hKhKhX   bool(x) -> bool

Returns True when the argument x is true, False otherwise.
The builtins True and False are the only two instances of the class bool.
The class bool is a subclass of the class int, and cannot be subclassed.rq  hh	h
hj,  hX   boolrr  h'hh+hubh)rs  }rt  (hX   wx.tools.img2py.DEFAULT_IMGNAMEru  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.rv  hh	h
hX   ''rw  hX   strrx  h'hh+hubh)ry  }rz  (hX   wx.tools.img2py.DEFAULT_MASKCLRr{  hKhKhh	hh	h
hX   Noner|  hX   NoneTyper}  h'hh+hubh)r~  }r  (hX   wx.tools.img2py.indexPatternr  hKhKhX#   Compiled regular expression object.r  hh	h
hX.   re.compile("\\s*index.append\\('(.+)'\\)\\s*")r  hX
   re.Patternr  h'hh+hubehX5   /home/wxpy/bb2/dist-src-py37/build/wx/tools/img2py.pyr  hXB   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.img2py.txtr  hKh'hhtNh+hubh
)r  }r  (hX   wx.tools.img2xpmr  hKhX  img2xpm.py  -- convert several image formats to XPM.

Usage:

    img2xpm.py [options] image_files...

Options:

    -o <dir>       The directory to place the .xpm file(s), defaults to
                   the current directory.

    -m <#rrggbb>   If the original image has a mask or transparency defined
                   it will be used by default.  You can use this option to
                   override the default or provide a new mask by specifying
                   a colour in the image to mark as transparent.

    -n <name>      A filename to write the .xpm data to.  Defaults to the
                   basename of the image file + '.xpm'  This option overrides
                   the -o option.r  hX  #----------------------------------------------------------------------
# Name:        wx.tools.img2xpm
# Purpose:     Convert an image to XPM format
#
# Author:      Robin Dunn
#
# Copyright:   (c) 2002-2020 by Total Control Software
# Licence:     wxWindows license
#----------------------------------------------------------------------
# 12/21/2003 - Jeff Grimmett (grimmtooth@softhome.net)
#
# o V2.5 compatibility update
#
r  h
h]r  (h)r  }r  (hX   wx.tools.img2xpm.mainr  hKhKhh	hh	h
h]r  h%X   main()r  h'h(h)hYhX   42r  h+j  ubh)r  }r  (hX   wx.tools.img2xpm.appr  hKhKhh	hh	h
hX   Noner  hX   NoneTyper  h'hh+j  ubehX6   /home/wxpy/bb2/dist-src-py37/build/wx/tools/img2xpm.pyr  hXC   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.img2xpm.txtr  hKh'hhtNh+hubh
)r  }r  (hX   wx.tools.pywxrcr  hKhX  pywxrc -- Python XML resource compiler
          (see http://wiki.wxpython.org/index.cgi/pywxrc for more info)

Usage: python pywxrc.py -h
       python pywxrc.py [-p] [-g] [-e] [-v] [-o filename] xrc input files...

  -h, --help     show help message
  -p, --python   generate python module
  -g, --gettext  output list of translatable strings (may be combined with -p)
  -e, --embed    embed XRC resources in the output file
  -v, --novar    suppress default assignment of variables
  -o, --output   output filename, or - for stdoutr  hX  #----------------------------------------------------------------------
# Name:        wx.tools.pywxrc
# Purpose:     XML resource compiler
#
# Author:      Robin Dunn
#              Based on wxrc.cpp by Vaclav Slavik, Eduardo Marques
#              Ported to Python in order to not require yet another
#              binary in wxPython distributions
#
#              Massive rework by Eli Golovinsky
#
#              Editable blocks by Roman Rolinsky
#
# Copyright:   (c) 2004-2020 by Total Control Software, 2000 Vaclav Slavik
# Licence:     wxWindows license
# Tags:        phoenix-port
#----------------------------------------------------------------------
r  h
h]r  (h)r  }r  (hX   wx.tools.pywxrc.PythonTemplatesr  hKhh	hh	h
h]r  (h)r  }r  (hX1   wx.tools.pywxrc.PythonTemplates.ADD_FILE_TO_MEMFSr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX_   "    wx.MemoryFSHandler.AddFile('XRC/%(memoryPath)s/%(filename)s', memoryview(%(filename)s))\n"r  hX   strr  h'hh+j  ubh)r  }r  (hX*   wx.tools.pywxrc.PythonTemplates.BIND_EVENTr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX:   '        self.Bind(wx.%(event)s, self.%(eventHandler)s)\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX1   wx.tools.pywxrc.PythonTemplates.BIND_WIDGET_EVENTr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hXK   '        self.Bind(wx.%(event)s, self.%(eventHandler)s, %(eventObject)s)\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX,   wx.tools.pywxrc.PythonTemplates.CLASS_HEADERr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX  'class xrc%(windowName)s(wx.%(windowClass)s):\n#!XRCED:begin-block:xrc%(windowName)s.PreCreate\n    def PreCreate(self):\n        """ This function is called during the class\'s initialization.\n\n        Override it for custom setup before the window is created usually to\n        set additional window styles using SetWindowStyle() and SetExtraStyle().\n        """\n        pass\n\n#!XRCED:end-block:xrc%(windowName)s.PreCreate\n\n    def __init__(self, parent):\n        wx.%(windowClass)s.__init__(self)\n        self.PreCreate()\n        get_resources().Load%(windowClass)s(self, parent, "%(windowName)s")\n\n        # Define variables for the controls, bind event handlers\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX4   wx.tools.pywxrc.PythonTemplates.CREATE_EVENT_HANDLERr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX   '#!XRCED:begin-block:xrc%(windowName)s.%(eventHandler)s\n    def %(eventHandler)s(self, evt):\n        # Replace with event handler code\n        print("%(eventHandler)s()")\n#!XRCED:end-block:xrc%(windowName)s.%(eventHandler)s\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX1   wx.tools.pywxrc.PythonTemplates.CREATE_WIDGET_VARr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hXE   '        self.%(widgetName)s = xrc.XRCCTRL(self, "%(widgetName)s")\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX.   wx.tools.pywxrc.PythonTemplates.FILE_AS_STRINGr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX0   "    %(filename)s = b'''\\\n%(fileData)s'''\n\n"r  hX   strr  h'hh+j  ubh)r  }r  (hX+   wx.tools.pywxrc.PythonTemplates.FILE_HEADERr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hXB  '# This file was automatically generated by pywxrc.\n# -*- coding: UTF-8 -*-\n\nimport wx\nimport wx.xrc as xrc\n\n__res = None\n\ndef get_resources():\n    """ This function provides access to the XML resources in this module."""\n    global __res\n    if __res is None:\n        __init_resources()\n    return __res\n\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX6   wx.tools.pywxrc.PythonTemplates.FRAME_MENUBAR_MENU_VARr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX  '        idx = self.GetMenuBar().FindMenu("%(label)s")\n        if idx != wx.NOT_FOUND:\n            self.%(widgetName)s = self.GetMenuBar().GetMenu(idx)\n        else:\n            self.%(widgetName)s = self.GetMenuBar().FindItemById(xrc.XRCID("%(widgetName)s")).GetSubMenu()\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX:   wx.tools.pywxrc.PythonTemplates.FRAME_MENUBAR_MENUITEM_VARr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX]   '        self.%(widgetName)s = self.GetMenuBar().FindItemById(xrc.XRCID("%(widgetName)s"))\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX1   wx.tools.pywxrc.PythonTemplates.FRAME_MENUBAR_VARr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX3   '        self.%(widgetName)s = self.GetMenuBar()\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX6   wx.tools.pywxrc.PythonTemplates.FRAME_TOOLBAR_TOOL_VARr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hXY   '        self.%(widgetName)s = self.GetToolBar().FindById(xrc.XRCID("%(widgetName)s"))\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX1   wx.tools.pywxrc.PythonTemplates.FRAME_TOOLBAR_VARr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX3   '        self.%(widgetName)s = self.GetToolBar()\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX2   wx.tools.pywxrc.PythonTemplates.GETTEXT_DUMMY_FUNCr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX  '\n# ----------------------- Gettext strings ---------------------\n\ndef __gettext_strings():\n    # This is a dummy function that lists all the strings that are used in\n    # the XRC file in the _("a string") format to be recognized by GNU\n    # gettext utilities (specifically the xgettext utility) and the\n    # mki18n.py script.  For more information see:\n    # http://wiki.wxpython.org/index.cgi/Internationalization\n\n    def _(str): pass\n\n%s\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX3   wx.tools.pywxrc.PythonTemplates.INIT_RESOURE_HEADERr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX   '# ------------------------ Resource data ----------------------\n\ndef __init_resources():\n    global __res\n    __res = xrc.XmlResource()\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX-   wx.tools.pywxrc.PythonTemplates.LOAD_RES_FILEr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r   hh	h
hX(   "    __res.Load('%(resourceFilename)s')"r  hX   strr  h'hh+j  ubh)r  }r  (hX.   wx.tools.pywxrc.PythonTemplates.LOAD_RES_MEMFSr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hXD   "    __res.Load('memory:XRC/%(memoryPath)s/%(resourceFilename)s')\n"r  hX   strr  h'hh+j  ubh)r	  }r
  (hX1   wx.tools.pywxrc.PythonTemplates.MENU_CLASS_HEADERr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX  'class xrc%(windowName)s(wx.%(windowClass)s):\n    def __init__(self):\n        pre = get_resources().LoadMenu("%(windowName)s")\n\n        # This is a copy of Robin\'s PostCreate voodoo magic in wx.Window that\n        # relinks the self object with the menu object.\n        self.this = pre.this\n        self.thisown = pre.thisown\n        pre.thisown = 0\n        if hasattr(self, \'_setOORInfo\'):\n            self._setOORInfo(self)\n\n        # Define variables for the menu items\n'r
  hX   strr  h'hh+j  ubh)r  }r  (hX-   wx.tools.pywxrc.PythonTemplates.MENU_MENU_VARr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX]   '        self.%(widgetName)s = self.FindItemById(xrc.XRCID("%(widgetName)s")).GetSubMenu()\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX1   wx.tools.pywxrc.PythonTemplates.MENU_MENUITEM_VARr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hXP   '        self.%(widgetName)s = self.FindItemById(xrc.XRCID("%(widgetName)s"))\n'r  hX   strr  h'hh+j  ubh)r  }r  (hX4   wx.tools.pywxrc.PythonTemplates.MENUBAR_CLASS_HEADERr  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hh	h
hX   'class xrc%(windowName)s(wx.%(windowClass)s):\n    def __init__(self):\n        pre = get_resources().LoadMenuBar("%(windowName)s")\n        self.PostCreate(pre)\n\n        # Define variables for the menu items\n'r  hX   strr   h'hh+j  ubh)r!  }r"  (hX0   wx.tools.pywxrc.PythonTemplates.MENUBAR_MENU_VARr#  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r$  hh	h
hX   '        idx = self.FindMenu("%(label)s")\n        if idx != wx.NOT_FOUND:\n            self.%(widgetName)s = self.GetMenu(idx)\n        else:\n            self.%(widgetName)s = self.FindItemById(xrc.XRCID("%(widgetName)s")).GetSubMenu()\n'r%  hX   strr&  h'hh+j  ubh)r'  }r(  (hX4   wx.tools.pywxrc.PythonTemplates.MENUBAR_MENUITEM_VARr)  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r*  hh	h
hXP   '        self.%(widgetName)s = self.FindItemById(xrc.XRCID("%(widgetName)s"))\n'r+  hX   strr,  h'hh+j  ubh)r-  }r.  (hX-   wx.tools.pywxrc.PythonTemplates.PREPARE_MEMFSr/  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r0  hh	h
hX6   '    wx.FileSystem.AddHandler(wx.MemoryFSHandler())\n'r1  hX   strr2  h'hh+j  ubh)r3  }r4  (hX/   wx.tools.pywxrc.PythonTemplates.SUBCLASS_HEADERr5  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r6  hh	h
hX  'class %(subclass)s(wx.%(windowClass)s):\n    def __init__(self):\n        wx.%(windowClass)s.__init__(self)\n        self.Bind(wx.EVT_WINDOW_CREATE, self.OnCreate)\n\n#!XRCED:begin-block:%(subclass)s._PostInit\n    def _PostInit(self):\n        """ This function is called after the subclassed object is created.\n\n        Override it for custom setup before the window is created usually to\n        set additional window styles using SetWindowStyle() and SetExtraStyle().\n        """\n        pass\n#!XRCED:end-block:%(subclass)s._PostInit\n\n    def OnCreate(self, evt):\n        self.Unbind(wx.EVT_WINDOW_CREATE)\n        self._PostInit()\n'r7  hX   strr8  h'hh+j  ubh)r9  }r:  (hX4   wx.tools.pywxrc.PythonTemplates.TOOLBAR_CLASS_HEADERr;  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r<  hh	h
hX   'class xrc%(windowName)s(wx.%(windowClass)s):\n    def __init__(self, parent):\n        pre = get_resources().LoadToolBar(parent, "%(windowName)s")\n        self.PostCreate(pre)\n\n        # Define variables for the toolbar items\n'r=  hX   strr>  h'hh+j  ubh)r?  }r@  (hX0   wx.tools.pywxrc.PythonTemplates.TOOLBAR_TOOL_VARrA  hKhKhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.rB  hh	h
hXL   '        self.%(widgetName)s = self.FindById(xrc.XRCID("%(widgetName)s"))\n'rC  hX   strrD  h'hh+j  ubehh]rE  (]rF  X   objectrG  a]rH  ]rI  X   PythonTemplatesrJ  aaeho]rK  hq]rL  h%X   PythonTemplatesrM  hthu)rN  }rO  (hx]rP  X   wx.tools.pywxrc.PythonTemplatesrQ  ]rR  rS  ah}]rT  X   wx.tools.pywxrc.PythonTemplatesrU  ahj  ubhKh'hhXR   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.pywxrc.PythonTemplates.txtrV  h+j  h)X   208rW  h]rX  hjL  ubh)rY  }rZ  (hX#   wx.tools.pywxrc.XmlResourceCompilerr[  hKhh	hh	h
h]r\  (h)r]  }r^  (hX2   wx.tools.pywxrc.XmlResourceCompiler.CheckAssignVarr_  hKhKhh	hh	h
h]r`  X   widgetra  h	h	rb  ah%X   CheckAssignVar(self, widget)rc  h'h(h)X   15rd  h+jY  ubh)re  }rf  (hX/   wx.tools.pywxrc.XmlResourceCompiler.ConvertTextrg  hKhKhX          Encode special characters as escaped C/Python string characters.

           
=> \n
           
 => \r
                => \t
           \ => \
           " => "

       Returns result as string, which is bytes in py2 or unicode in py3.
       rh  hh	h
h]ri  X   strj  h	h	rk  ah%X   ConvertText(self, st)rl  h'h(h)X   45rm  h+jY  ubh)rn  }ro  (hX0   wx.tools.pywxrc.XmlResourceCompiler.FileToStringrp  hKhKhh	hh	h
h]rq  X   filenamerr  h	h	rs  ah%X   FileToString(self, filename)rt  h'h(h)X   29ru  h+jY  ubh)rv  }rw  (hX5   wx.tools.pywxrc.XmlResourceCompiler.FindStringsInNoderx  hKhKhh	hh	h
h]ry  X   parentrz  h	h	r{  ah%X   FindStringsInNode(self, parent)r|  h'h(h)X   39r}  h+jY  ubh)r~  }r  (hX3   wx.tools.pywxrc.XmlResourceCompiler.GenerateClassesr  hKhKhh	hh	h
h]r  X   resourceDocumentr  h	h	r  ah%X'   GenerateClasses(self, resourceDocument)r  h'h(h)X   32r  h+jY  ubh)r  }r  (hX9   wx.tools.pywxrc.XmlResourceCompiler.GenerateEventHandlersr  hKhKhh	hh	h
h]r  (X   windowClassr  h	h	r  X
   windowNamer  h	h	r  X	   topWindowr  h	h	r  X   varsr  h	h	r  eh%XE   GenerateEventHandlers(self, windowClass, windowName, topWindow, vars)r  h'h(h)X   48r  h+jY  ubh)r  }r  (hXA   wx.tools.pywxrc.XmlResourceCompiler.GenerateInitResourcesEmbeddedr  hKhKhh	hh	h
h]r  (X   resourceFilenamer  h	h	r  X   resourceDocumentr  h	h	r  eh%XG   GenerateInitResourcesEmbedded(self, resourceFilename, resourceDocument)r  h'h(h)X   27r  h+jY  ubh)r  }r  (hX=   wx.tools.pywxrc.XmlResourceCompiler.GenerateInitResourcesFiler  hKhKhh	hh	h
h]r  (X   resourceFilenamer  h	h	r  X   resourceDocumentr  h	h	r  eh%XC   GenerateInitResourcesFile(self, resourceFilename, resourceDocument)r  h'h(h)hYh+jY  ubh)r  }r  (hX8   wx.tools.pywxrc.XmlResourceCompiler.GenerateMenuBarClassr  hKhKhh	hh	h
h]r  (X   windowClassr  h	h	r  X
   windowNamer  h	h	r  X	   topWindowr  h	h	r  X   varsr  h	h	r  eh%XD   GenerateMenuBarClass(self, windowClass, windowName, topWindow, vars)r  h'h(h)X   28r  h+jY  ubh)r  }r  (hX5   wx.tools.pywxrc.XmlResourceCompiler.GenerateMenuClassr  hKhKhh	hh	h
h]r  (X   windowClassr  h	h	r  X
   windowNamer  h	h	r  X	   topWindowr  h	h	r  X   varsr  h	h	r  eh%XA   GenerateMenuClass(self, windowClass, windowName, topWindow, vars)r  h'h(h)X   26r  h+jY  ubh)r  }r  (hX6   wx.tools.pywxrc.XmlResourceCompiler.GenerateSubclassesr  hKhKhh	hh	h
h]r  X   resourceDocumentr  h	h	r  ah%X*   GenerateSubclasses(self, resourceDocument)r  h'h(h)X   30r  h+jY  ubh)r  }r  (hX8   wx.tools.pywxrc.XmlResourceCompiler.GenerateToolBarClassr  hKhKhh	hh	h
h]r  (X   windowClassr  h	h	r  X
   windowNamer  h	h	r  X	   topWindowr  h	h	r  X   varsr  h	h	r  eh%XD   GenerateToolBarClass(self, windowClass, windowName, topWindow, vars)r  h'h(h)X   21r  h+jY  ubh)r  }r  (hX7   wx.tools.pywxrc.XmlResourceCompiler.GenerateWidgetClassr  hKhKhh	hh	h
h]r  (X   windowClassr  h	h	r  X
   windowNamer  h	h	r  X	   topWindowr  h	h	r  X   varsr  h	h	r  eh%XC   GenerateWidgetClass(self, windowClass, windowName, topWindow, vars)r  h'h(h)X   37r  h+jY  ubh)r  }r  (hX5   wx.tools.pywxrc.XmlResourceCompiler.GetMemoryFilenamer  hKhKhh	hh	h
h]r  X   filenamer  h	h	r  ah%X!   GetMemoryFilename(self, filename)r  h'h(h)X   4r  h+jY  ubh)r  }r  (hX5   wx.tools.pywxrc.XmlResourceCompiler.MakeGetTextOutputr  hKhKhXM   Just output the gettext strings by themselves, with no other
code generation.r  hh	h
h]r  (X
   inputFilesr  h	h	r  X   outputFilenamer  h	h	r  eh%X3   MakeGetTextOutput(self, inputFiles, outputFilename)r  h'h(h)X   14r  h+jY  ubh)r  }r  (hX4   wx.tools.pywxrc.XmlResourceCompiler.MakePythonModuler  hKhKhh	hh	h
h]r  (X
   inputFilesr  h	h	r  X   outputFilenamer   h	h	r  X   embedResourcesr  X   Falser  j,  r  X   generateGetTextr  X   Falser  j,  r  X   assignVariablesr  X   Truer	  j0  r
  eh%Xu   MakePythonModule(self, inputFiles, outputFilename, embedResources=False, generateGetText=False, assignVariables=True)r  h'h(h)X   57r  h+jY  ubh)r
  }r  (hX8   wx.tools.pywxrc.XmlResourceCompiler.NodeContainsFilenamer  hKhKhX1   Does 'node' contain filename information at all? r  hh	h
h]r  X   noder  h	h	r  ah%X    NodeContainsFilename(self, node)r  h'h(h)X   30r  h+jY  ubh)r  }r  (hX1   wx.tools.pywxrc.XmlResourceCompiler.ReplaceBlocksr  hKhKhh	hh	h
h]r  X   inputr  h	h	r  ah%X   ReplaceBlocks(self, input)r  h'h(h)X   20r  h+jY  ubh)r  }r  (hX9   wx.tools.pywxrc.XmlResourceCompiler.ReplaceFilenamesInXRCr   hKhKhX   Finds all files mentioned in resource file, e.g. <bitmap>filename</bitmap>
and replaces them with the memory filenames.

Fills a list of the filenames found.r!  hh	h
h]r"  (X   noder#  h	h	r$  X   filesr%  h	h	r&  X   resourcePathr'  h	h	r(  eh%X6   ReplaceFilenamesInXRC(self, node, files, resourcePath)r)  h'h(h)X   29r*  h+jY  ubh)r+  }r,  (hX-   wx.tools.pywxrc.XmlResourceCompiler.templatesr-  hKhKhh	hh	h
hX:   <wx.tools.pywxrc.PythonTemplates object at 0x7f7aec071150>r.  hX   wx.tools.pywxrc.PythonTemplatesr/  h'hh+jY  ubehh]r0  (]r1  X   objectr2  a]r3  ]r4  X   XmlResourceCompilerr5  aaeho]r6  hq]r7  h%X3   XmlResourceCompiler:  templates = PythonTemplates()r8  hthu)r9  }r:  (hx]r;  X#   wx.tools.pywxrc.XmlResourceCompilerr<  ]r=  r>  ah}]r?  X#   wx.tools.pywxrc.XmlResourceCompilerr@  ahjY  ubhKh'hhXV   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.pywxrc.XmlResourceCompiler.txtrA  h+j  h)X   609rB  h]rC  (X   CheckAssignVarrD  X   ConvertTextrE  X   FileToStringrF  X   FindStringsInNoderG  X   GenerateClassesrH  X   GenerateEventHandlersrI  X   GenerateInitResourcesEmbeddedrJ  X   GenerateInitResourcesFilerK  X   GenerateMenuBarClassrL  X   GenerateMenuClassrM  X   GenerateSubclassesrN  X   GenerateToolBarClassrO  X   GenerateWidgetClassrP  X   GetMemoryFilenamerQ  X   MakeGetTextOutputrR  X   MakePythonModulerS  X   NodeContainsFilenamerT  X
   ReplaceBlocksrU  X   ReplaceFilenamesInXRCrV  ehj7  ubh)rW  }rX  (hX   wx.tools.pywxrc.mainrY  hKhKhh	hh	h
h]rZ  X   argsr[  X   Noner\  X   Noner]  r^  ah%X   main(args=None)r_  h'h(h)X   80r`  hX   868ra  h+j  ubh)rb  }rc  (hX   wx.tools.pywxrc.byte2intrd  hKhKhX   itemgetter(item, ...) --> itemgetter object

Return a callable object that fetches the given item(s) from its operand.
After f = itemgetter(2), the call f(r) returns r[2].
After g = itemgetter(2, 5, 3), the call g(r) returns (r[2], r[5], r[3])re  hh	h
hX   operator.itemgetter(0)rf  hX   operator.itemgetterrg  h'hh+j  ubh)rh  }ri  (hX   wx.tools.pywxrc.reBeginBlockrj  hKhKhj  hh	h
hX)   re.compile('^#!XRCED:begin-block:(\\S+)')rk  hX
   re.Patternrl  h'hh+j  ubh)rm  }rn  (hX   wx.tools.pywxrc.reEndBlockro  hKhKhj  hh	h
hX'   re.compile('^#!XRCED:end-block:(\\S+)')rp  hX
   re.Patternrq  h'hh+j  ubehX5   /home/wxpy/bb2/dist-src-py37/build/wx/tools/pywxrc.pyrr  hXB   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.pywxrc.txtrs  hKh'hhthu)rt  }ru  (hx]rv  (X   wx.tools.pywxrc.PythonTemplatesrw  ]rx  ry  X#   wx.tools.pywxrc.XmlResourceCompilerrz  ]r{  r|  eh}]r}  (X   wx.tools.pywxrc.PythonTemplatesr~  X#   wx.tools.pywxrc.XmlResourceCompilerr  ehj  ubh+hubh
)r  }r  (hX   wx.tools.wxgetr  hKhX0  wxget.py -- wx Version of wget utility for platform that don't have it already.

Usage:
    wxget URL [DEST_DIR]

Where URL is a file URL and the optional DEST_DIR is a destination directory to
download to, (default is to prompt the user).
The --trusted option can be used to suppress certificate checks.r  hXq  # -*- coding: utf-8 -*-
#----------------------------------------------------------------------
# Name:        wx.tools.wxget
# Purpose:     wx Based alternative to wget
#
# Author:      Steve Barnes
#
# Created:     06-Aug-2017
# Copyright:   (c) 2017-2020 by Steve Barnes
# Licence:     wxWindows license
# Tags:        phoenix-port, py3-port
#
# Module to allow cross platform downloads originally from answers to:
# https://stackoverflow.com/questions/22676/how-do-i-download-a-file-over-http-using-python
# by Stan and PabloG then converted to wx.
#----------------------------------------------------------------------
r  h
h]r  (h)r  }r  (hX   wx.tools.wxget.HTTPErrorr  hKhXB   Raised when HTTP error occurs, but also acts like non-error returnr  hh	h
h]r  (h)r  }r  (hX!   wx.tools.wxget.HTTPError.__init__r  hKhKhX>   Initialize self.  See help(type(self)) for accurate signature.r  hh	h
h]r  (X   urlr  h	h	r  X   coder  h	h	r  X   msgr  h	h	r  X   hdrsr  h	h	r  X   fpr  h	h	r  eh%X(   __init__(self, url, code, msg, hdrs, fp)r  h'h(h)X   13r  h+j  ubcsphinxtools.librarydescription
Property
r  )r  }r  (hX    wx.tools.wxget.HTTPError.headersr  hKhKhh	hh	h
X   getterr  X   headersr  X   setterr  j  X   deleterr  h	h'X   Propertyr  h+j  ubj  )r  }r  (hX   wx.tools.wxget.HTTPError.reasonr  hKhKhh	hh	h
j  X   reasonr  j  h	j  h	h'j  h+j  ubehh]r  (]r  X   objectr  a]r  (]r  X
   BaseExceptionr  a]r  (]r  X	   Exceptionr  a]r  (]r  X   OSErrorr  a]r  (]r  X   URLErrorr  a]r  ]r  X	   HTTPErrorr  aaeee]r  X   _TemporaryFileWrapperr  a]r  (]r  X   addbaser  a]r  (]r  X   addinfor  a]r  (]r  X
   addinfourlr  a]r  ]r  j  aaeeeeeho]r  hq]r  (X   urllib.error.URLErrorr  X   urllib.response.addinfourlr  eh%X/   HTTPError(URLError, urllib.response.addinfourl)r  htNhKh'hhXK   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.wxget.HTTPError.txtr  h+j  h)X   37r  ubh)r  }r  (hX   wx.tools.wxget.URLErrorr  hKhX"   Base class for I/O related errors.r  hh	h
h]r  h)r  }r  (hX    wx.tools.wxget.URLError.__init__r  hKhKhX>   Initialize self.  See help(type(self)) for accurate signature.r  hh	h
h]r  (X   reasonr  h	h	r  X   filenamer  X   Noner  X   Noner  r  eh%X%   __init__(self, reason, filename=None)r  h'h(h)hQh+j  ubahh]r  (]r  X   objectr  a]r  (]r  X
   BaseExceptionr  a]r  (]r  X	   Exceptionr  a]r  (]r  X   OSErrorr  a]r  ]r  j  aaeeeeho]r  (X!   urllib.error.ContentTooShortErrorr  X   urllib.error.HTTPErrorr  ehq]r  X   OSErrorr  ah%X   URLError(OSError)r  htNhKh'hhXJ   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.wxget.URLError.txtr  h+j  h)X   15r  ubh)r  }r  (hX   wx.tools.wxget.download_filer  hKhKhX~   Download and save a file specified by url to dest directory, with force will
operate silently and overwrite any existing file.r  hh	h
h]r  (X   urlr  h	h	r  X   destr  X   Noner  X   Noner  r   X   forcer  X   Falser  j,  r  X   trustedr  X   Falser  j,  r  eh%X9   download_file(url, dest=None, force=False, trusted=False)r  h'h(h)X   33r  hX   184r	  h+j  ubh)r
  }r  (hX   wx.tools.wxget.download_pipr  hKhKhX   Try to download via pip.r
  hh	h
h]r  (X   urlr  h	h	r  X   filenamer  h	h	r  X   forcer  X   Falser  j,  r  X   trustedr  X   Falser  j,  r  eh%X7   download_pip(url, filename, force=False, trusted=False)r  h'h(h)X   28r  hX   156r  h+j  ubh)r  }r  (hX   wx.tools.wxget.download_urllibr  hKhKhX   Try to download via urllib.r  hh	h
h]r   (X   urlr!  h	h	r"  X   filenamer#  h	h	r$  eh%X   download_urllib(url, filename)r%  h'h(h)X   47r&  hX   109r'  h+j  ubh)r(  }r)  (hX   wx.tools.wxget.download_wgetr*  hKhKhX   Try to download via wget.r+  hh	h
h]r,  (X   urlr-  h	h	r.  X   filenamer/  h	h	r0  X   trustedr1  X   Falser2  j,  r3  eh%X+   download_wget(url, filename, trusted=False)r4  h'h(h)X   15r5  hX   94r6  h+j  ubh)r7  }r8  (hX    wx.tools.wxget.get_docs_demo_urlr9  hKhKhX!   Get the URL for the docs or demo.r:  hh	h
h]r;  X   demor<  X   Falser=  j,  r>  ah%X   get_docs_demo_url(demo=False)r?  h'h(h)X   13r@  hX   47rA  h+j  ubh)rB  }rC  (hX   wx.tools.wxget.get_save_pathrD  hKhKhX   Get the file save location.rE  hh	h
h]rF  (X   urlrG  h	h	rH  X   dest_dirrI  h	h	rJ  X   forcerK  X   FalserL  j,  rM  eh%X)   get_save_path(url, dest_dir, force=False)rN  h'h(h)X   34rO  hX   60rP  h+j  ubh)rQ  }rR  (hX   wx.tools.wxget.mainrS  hKhKhX   Entry point for wxget.rT  hh	h
h]rU  X   argsrV  X   sys.argvrW  XS   ['build.py', 'wxlib', 'sdist', 'sdist_demo', '--upload', '--gtk3', '--release', '']rX  rY  ah%X   main(args=sys.argv)rZ  h'h(h)X   36r[  hX   217r\  h+j  ubh)r]  }r^  (hX   wx.tools.wxget.absolute_importr_  hKhKhh	hh	h
hX=   _Feature((2, 5, 0, 'alpha', 1), (3, 0, 0, 'alpha', 0), 16384)r`  hX   __future__._Featurera  h'hh+j  ubh)rb  }rc  (hX   wx.tools.wxget.divisionrd  hKhKhh	hh	h
hX<   _Feature((2, 2, 0, 'alpha', 2), (3, 0, 0, 'alpha', 0), 8192)re  hX   __future__._Featurerf  h'hh+j  ubh)rg  }rh  (hX   wx.tools.wxget.print_functionri  hKhKhh	hh	h
hX=   _Feature((2, 6, 0, 'alpha', 2), (3, 0, 0, 'alpha', 0), 65536)rj  hX   __future__._Featurerk  h'hh+j  ubh)rl  }rm  (hX   wx.tools.wxget.unicode_literalsrn  hKhKhh	hh	h
hX>   _Feature((2, 6, 0, 'alpha', 2), (3, 0, 0, 'alpha', 0), 131072)ro  hX   __future__._Featurerp  h'hh+j  ubehX4   /home/wxpy/bb2/dist-src-py37/build/wx/tools/wxget.pyrq  hXA   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.wxget.txtrr  hKh'hhtNh+hubh
)rs  }rt  (hX   wx.tools.wxget_docs_demoru  hKhX   wxget_docs_demo.py -- Launch the appropriate wx Docs or Demo.

Usage:
    wxget_docs_demo [docs|demo]

Will install if missing, the requested item for the current version and then
launch it.

Use: doc|demo --force to force a fresh download.rv  hX+  # -*- coding: utf-8 -*-
#----------------------------------------------------------------------
# Name:        wx.tools.wxget_docs_demo
# Purpose:     wx fetch and launch demo or docs
#
# Author:      Steve Barnes
#
# Created:     06-Aug-2017
# Copyright:   (c) 2017-2020 by Steve Barnes
# Licence:     wxWindows license
# Tags:        phoenix-port, py3-port
#
# Module to allow the correct version of the documents and/or demos to be
# launched after, if necessarily being fetched.
#----------------------------------------------------------------------
rw  h
h]rx  (h)ry  }rz  (hX"   wx.tools.wxget_docs_demo.HTTPErrorr{  hKhj  hh	h
h]r|  (h)r}  }r~  (hX+   wx.tools.wxget_docs_demo.HTTPError.__init__r  hKhKhX>   Initialize self.  See help(type(self)) for accurate signature.r  hh	h
h]r  (X   urlr  h	h	r  X   coder  h	h	r  X   msgr  h	h	r  X   hdrsr  h	h	r  X   fpr  h	h	r  eh%X(   __init__(self, url, code, msg, hdrs, fp)r  h'h(h)X   13r  h+jy  ubj  )r  }r  (hX*   wx.tools.wxget_docs_demo.HTTPError.headersr  hKhKhh	hh	h
j  j  j  j  j  h	h'j  h+jy  ubj  )r  }r  (hX)   wx.tools.wxget_docs_demo.HTTPError.reasonr  hKhKhh	hh	h
j  j  j  h	j  h	h'j  h+jy  ubehh]r  (]r  X   objectr  a]r  (]r  X
   BaseExceptionr  a]r  (]r  X	   Exceptionr  a]r  (]r  X   OSErrorr  a]r  (]r  j  a]r  ]r  j  aaeee]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  ]r  j  aaeeeeeho]r  hq]r  (X   urllib.error.URLErrorr  X   urllib.response.addinfourlr  eh%X/   HTTPError(URLError, urllib.response.addinfourl)r  htNhKh'hhXU   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.wxget_docs_demo.HTTPError.txtr  h+js  h)X   37r  ubh)r  }r  (hX"   wx.tools.wxget_docs_demo.demo_mainr  hKhKhX   Get/Launch Demo.r  hh	h
h]r  X   argsr  X   sys.argvr  XS   ['build.py', 'wxlib', 'sdist', 'sdist_demo', '--upload', '--gtk3', '--release', '']r  r  ah%X   demo_main(args=sys.argv)r  h'h(h)X   19r  hX   154r  h+js  ubh)r  }r  (hX"   wx.tools.wxget_docs_demo.docs_mainr  hKhKhX   Get/Launch Docs.r  hh	h
h]r  X   argsr  X   sys.argvr  XS   ['build.py', 'wxlib', 'sdist', 'sdist_demo', '--upload', '--gtk3', '--release', '']r  r  ah%X   docs_main(args=sys.argv)r  h'h(h)X   18r  hX   136r  h+js  ubh)r  }r  (hX   wx.tools.wxget_docs_demo.doner  hKhKhX   Tidy up and exit.r  hh	h
h]r  X   resultr  X   0r  X   0r  r  ah%X   done(result=0)r  h'h(h)X   11r  hX   125r  h+js  ubh)r  }r  (hX&   wx.tools.wxget_docs_demo.ensure_wx_appr  hKhKhX'   Ensure that there is a wx.App instance.r  hh	h
h]r  h%X   ensure_wx_app()r  h'h(h)X   8r  hX   55r  h+js  ubh)r  }r  (hX!   wx.tools.wxget_docs_demo.get_itemr  hKhKhX
   Get the item r  hh	h
h]r  (X   finalr  h	h	r  X   urlr  h	h	r  X   cacher  h	h	r  X   namer  h	h	r  X   extr  h	h	r  X   forcedr  X   Falser  j,  r  eh%X4   get_item(final, url, cache, name, ext, forced=False)r  h'h(h)X   28r  hX   91r  h+js  ubh)r  }r  (hX'   wx.tools.wxget_docs_demo.get_paths_dictr  hKhKhX'   Get a dictionary of the required paths.r  hh	h
h]r  h%X   get_paths_dict()r  h'h(h)X   20r  hX   63r  h+js  ubh)r  }r  (hX   wx.tools.wxget_docs_demo.mainr  hKhKhX   Command line main.r   hh	h
h]r  X   argsr  X   sys.argvr  XS   ['build.py', 'wxlib', 'sdist', 'sdist_demo', '--upload', '--gtk3', '--release', '']r  r  ah%X   main(args=sys.argv)r  h'h(h)X   10r  hX   173r  h+js  ubh)r	  }r
  (hX%   wx.tools.wxget_docs_demo.pathname2urlr  hKhKhXw   OS-specific conversion from a file system path to a relative URL
of the 'file' scheme; not recommended for general use.r  hh	h
h]r
  X   pathnamer  h	h	r  ah%X   pathname2url(pathname)r  h'h(h)hhX   1687r  h+js  ubh)r  }r  (hX%   wx.tools.wxget_docs_demo.report_errorr  hKhKhX   Report a problem.r  hh	h
h]r  X   err_textr  h	h	r  ah%X   report_error(err_text)r  h'h(h)hQhX   119r  h+js  ubh)r  }r  (hX&   wx.tools.wxget_docs_demo.unpack_cachedr  hKhKhX   Unpack from the cache.r  hh	h
h]r  (X   cachedr   h	h	r!  X   dest_dirr"  h	h	r#  eh%X   unpack_cached(cached, dest_dir)r$  h'h(h)j  hX   83r%  h+js  ubh)r&  }r'  (hX(   wx.tools.wxget_docs_demo.absolute_importr(  hKhKhh	hh	h
hX=   _Feature((2, 5, 0, 'alpha', 1), (3, 0, 0, 'alpha', 0), 16384)r)  hX   __future__._Featurer*  h'hh+js  ubh)r+  }r,  (hX   wx.tools.wxget_docs_demo.APPr-  hKhKhh	hh	h
hX   Noner.  hX   NoneTyper/  h'hh+js  ubh)r0  }r1  (hX!   wx.tools.wxget_docs_demo.divisionr2  hKhKhh	hh	h
hX<   _Feature((2, 2, 0, 'alpha', 2), (3, 0, 0, 'alpha', 0), 8192)r3  hX   __future__._Featurer4  h'hh+js  ubh)r5  }r6  (hX'   wx.tools.wxget_docs_demo.print_functionr7  hKhKhh	hh	h
hX=   _Feature((2, 6, 0, 'alpha', 2), (3, 0, 0, 'alpha', 0), 65536)r8  hX   __future__._Featurer9  h'hh+js  ubh)r:  }r;  (hX)   wx.tools.wxget_docs_demo.unicode_literalsr<  hKhKhh	hh	h
hX>   _Feature((2, 6, 0, 'alpha', 2), (3, 0, 0, 'alpha', 0), 131072)r=  hX   __future__._Featurer>  h'hh+js  ubehX>   /home/wxpy/bb2/dist-src-py37/build/wx/tools/wxget_docs_demo.pyr?  hXK   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.wxget_docs_demo.txtr@  hKh'hhtNh+hubeh+NhX7   /home/wxpy/bb2/dist-src-py37/build/wx/tools/__init__.pyrA  hK h'X   LibraryrB  X   python_versionrC  X   3.7.16-finalrD  hX;   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.tools.txtrE  X	   base_namerF  X   wx.toolsrG  ub.