# ansible-doc

> Display information on modules installed in Ansible libraries.
> Display a terse listing of plugins and their short descriptions.
> More information: <https://docs.ansible.com/projects/ansible/latest/cli/ansible-doc.html>.

- List available action plugins (modules):

`ansible-doc {{[-l|--list]}}`

- List available plugins of a specific type:

`ansible-doc {{[-t|--type]}} {{become|cache|callback|cliconf|connection|...}} {{[-l|--list]}}`

- Show information about a specific action plugin (module):

`ansible-doc {{plugin_name}}`

- Show information about a plugin with a specific type:

`ansible-doc {{[-t|--type]}} {{become|cache|callback|cliconf|connection|...}} {{plugin_name}}`

- Show the playbook snippet for action plugin (modules):

`ansible-doc {{[-s|--snippet]}} {{plugin_name}}`

- Show information about an action plugin (module) as JSON:

`ansible-doc {{[-j|--json]}} {{plugin_name}}`
