# zip

> Упаковывает и сжимает (архивирует) файлы в файл zip.
> Смотрите также: `unzip`.
> Больше информации: <https://manned.org/zip>.

- Добавить файлы/каталоги в указанный архив:

`zip {{[-r|--recurse-paths]}} {{путь/к/архиву.zip}} {{путь/к/файлу_или_каталогу1 путь/к/файлу_или_каталогу2 ...}}`

- Удалить файлы/каталоги из указанного архива:

`zip {{[-d|--delete]}} {{путь/к/архиву.zip}} {{путь/к/файлу_или_каталогу1 путь/к/файлу_или_каталогу2 ...}}`

- Заархивировать файлы/каталоги, исключая некоторые:

`zip {{[-r|--recurse-paths]}} {{путь/к/архиву.zip}} {{путь/к/файлу_или_каталогу1 путь/к/файлу_или_каталогу2 ...}} {{[-x|--exclude]}} {{путь/к/исключаемым_файлам_или_каталогам}}`

- Заархивировать файлы/каталоги с заданной степенью сжатия (`0` — без сжатия, `9` — максимальная):

`zip {{[-r|--recurse-paths]}} -{{0..9}} {{путь/к/архиву.zip}} {{путь/к/файлу_или_каталогу1 путь/к/файлу_или_каталогу2 ...}}`

- Создать зашифрованный паролем архив:

`zip {{[-re|--recurse-paths --encrypt]}} {{путь/к/архиву.zip}} {{путь/к/файлу_или_каталогу1 путь/к/файлу_или_каталогу2 ...}}`

- Заархивировать файлы/каталоги в многотомный архив (например, частями по 3 Гб):

`zip {{[-rs|--recurse-paths --split-size]}} {{3g}} {{путь/к/архиву.zip}} {{путь/к/файлу_или_каталогу1 путь/к/файлу_или_каталогу2 ...}}`

- Вывести содержимое указанного архива:

`zip {{[-sf|--split-size --freshen]}} {{путь/к/архиву.zip}}`
