# npm

> Менеджер пакетов JavaScript и Node.js.
> Управлять проектами Node.js и их зависимостями.
> Больше информации: <https://docs.npmjs.com/cli/npm/>.

- Создать файл `package.json` со значениями по умолчанию (без `--yes` для интерактивного режима):

`npm init {{[-y|--yes]}}`

- Загрузить все пакеты, перечисленные как зависимости в `package.json`:

`npm {{[i|install]}}`

- Загрузить определённую версию пакета и добавить его в список зависимостей в `package.json`:

`npm {{[i|install]}} {{пакет}}@{{версия}}`

- Загрузить последнюю версию пакета и добавить его в список зависимостей разработки в `package.json`:

`npm {{[i|install]}} {{пакет}} {{[-D|--save-dev]}}`

- Загрузить последнюю версию пакета и установить его глобально:

`npm {{[i|install]}} {{пакет}} {{[-g|--global]}}`

- Удалить пакет и убрать его из списка зависимостей в `package.json`:

`npm {{[r|uninstall]}} {{пакет}}`

- Вывести список всех локально установленных зависимостей:

`npm {{[ls|list]}}`

- Вывести список всех глобально установленных пакетов верхнего уровня:

`npm {{[ls|list]}} {{[-g|--global]}} --depth {{0}}`
