# docker container run

> Запускать команду в новом контейнере Docker.
> Больше информации: <https://docs.docker.com/reference/cli/docker/container/run/>.

- Запустить команду в новом контейнере из образа с указанным тегом:

`docker {{[run|container run]}} {{образ:тег}} {{команда}}`

- Запустить команду в новом контейнере в фоновом режиме и вывести его ID:

`docker {{[run|container run]}} {{[-d|--detach]}} {{образ}} {{команда}}`

- Запустить команду во временном (одноразовом) контейнере в интерактивном режиме с псевдотерминалом:

`docker {{[run|container run]}} --rm {{[-it|--interactive --tty]}} {{образ}} {{команда}}`

- Запустить команду в новом контейнере с передачей переменных окружения:

`docker {{[run|container run]}} {{[-e|--env]}} '{{переменная}}={{значение}}' {{[-e|--env]}} {{переменная}} {{образ}} {{команда}}`

- Запустить команду в новом контейнере с примонтированными томами (bind mounts):

`docker {{[run|container run]}} {{[-v|--volume]}} /{{путь/к/пути_на_хосте}}:/{{путь/к/пути_в_контейнере}} {{образ}} {{команда}}`

- Запустить команду в новом контейнере с опубликованными портами:

`docker {{[run|container run]}} {{[-p|--publish]}} {{порт_хоста}}:{{порт_контейнера}} {{образ}} {{команда}}`

- Запустить команду в новом контейнере, переопределив точку входа (entrypoint) образа:

`docker {{[run|container run]}} --entrypoint {{команда}} {{образ}}`

- Запустить команду в новом контейнере, подключив его к сети:

`docker {{[run|container run]}} --network {{сеть}} {{образ}}`
