# 7za

> Архиватор файлов с высокой степенью сжатия.
> То же, что и `7z`, за исключением того, что поддерживает меньшее количество типов файлов, но является кроссплатформенным.
> Больше информации: <https://manned.org/7za>.

- Архивировать ([a]rchive) файл или директорию:

`7za a {{путь/к/архиву.7z}} {{путь/к/файлу_или_директории}}`

- Зашифровать существующий архив (включая имена файлов):

`7za a {{путь/к/зашифрованному_архиву.7z}} -p{{пароль}} -mhe={{on}} {{путь/к/архиву.7z}}`

- Распаковать (e[x]tract) архив, сохраняя оригинальную структуру директорий:

`7za x {{путь/к/архиву.7z}}`

- Распаковать (e[x]tract) архив в указанную директорию:

`7za x {{путь/к/архиву.7z}} -o{{путь/к/директории}}`

- Распаковать (e[x]tract) архив в `stdout`:

`7za x {{путь/к/архиву.7z}} -so`

- Архивировать ([a]rchive), используя определённый тип архива:

`7za a -t{{7z|bzip2|gzip|lzip|tar|...}} {{путь/к/архиву.7z}} {{путь/к/файлу_или_директории}}`

- Вывести список ([l]ist) содержимого архива:

`7za l {{путь/к/архиву.7z}}`

- Задать уровень сжатия (выше означает лучшее сжатие, но медленнее):

`7za a {{путь/к/архиву.7z}} -mx={{0|1|3|5|7|9}} {{путь/к/файлу_или_директории}}`
