# cargo

> Gerencia projetos Rust e as dependências dos modulos (crates).
> Alguns subcomandos como `build` tem a sua própria documentação.
> Mais informações: <https://doc.rust-lang.org/stable/cargo/>.

- Procura por crates:

`cargo search {{string_procurada}}`

- Instala uma crate:

`cargo install {{nome_da_crate}}`

- Lista as crates instaladas:

`cargo install --list`

- Cria um novo binário ou projeyo Rust de biblioteca no diretório especificado (ou o diretório atual por padrão):

`cargo init --{{bin|lib}} {{caminho/para/diretório}}`

- Adiciona uma dependência ao Cargo.toml no diretório atual:

`cargo add {{dependência}}`

- Constrói o projeto Rust no diretório atual usando o perfil de lançamento:

`cargo {{[b|build]}} {{[-r|--release]}}`

- Constrói o projeto Rust no diretório atual utilizando o nightly compilador:

`cargo +nightly {{[b|build]}}`

- Constrói o projeto Rust utilizando um número específico de threads (padrão é o número de cores do CPU):

`cargo {{[b|build]}} {{[-j|--jobs]}} {{número_de_threads}}`
