# vim

> コマンドラインのテキストエディタである Vim（Vi IMproved）には、さまざまな種類のテキスト操作のためのモードが用意されています。
> `<i>` を押すと編集モードになります。`<Esc>` を押すと通常モードに戻り、通常のテキスト挿入はできません。
> 参照: `vimdiff`, `vimtutor`, `nvim`, `gvim`。
> もっと詳しく: <https://www.vim.org/>。

- ファイルを開く:

`vim {{ファイルへのパス}}`

- 指定した行番号でファイルを開く:

`vim +{{ライン番号}} {{ファイルへのパス}}`

- Vim のヘルプマニュアルを見る:

`<:>help<Enter>`

- 保存と終了:

`{{<Esc><Z><Z>|<Esc><:>x<Enter>|<Esc><:>wq<Enter>}}`

- 最後の操作を元に戻す:

`<Esc><u>`

- ファイル内のパターンを検索する（`<n>`/`<N>` を押すと次/前のマッチに進む）:

`</>{{検索パターン}}<Enter>`

- ファイル全体での正規表現による置換の実行:

`<:>%s/{{パターン}}/{{置き換え後}}/g<Enter>`

- ライン番号の表示:

`<:>set nu<Enter>`
