# hping3

> Utilidad de ping avanzada que soporta protocolos TCP, UDP y raw IP.
> Mejor correrla con privilegios elevados.
> Vea también: `masscan`, `naabu`, `nmap`, `rustscan`, `zmap`.
> Más información: <https://manned.org/hping3>.

- Ping a un destino con 4 solicitudes ping ICMP:

`hping3 {{[-1|--icmp]}} {{[-c|--count]}} 4 {{ip_o_nombre_de_servidor}}`

- Ping a una dirección IP sobre UDP en el puerto 80:

`hping3 {{[-2|--udp]}} {{[-p|--destport]}} 80 {{[-S|--syn]}} {{ip_o_nombre_de_servidor}}`

- Escanea el puerto TCP 80, haciéndolo desde el puerto de origen local 5090:

`hping3 {{[-V|--verbose]}} {{[-S|--syn]}} {{[-p|--destport]}} 80 {{[-s|--baseport]}} 5090 {{ip_o_nombre_de_servidor}}`

- Traceroute utilizando un escaneado TCP a un puerto de destino específico:

`hping3 {{[-T|--traceroute]}} {{[-V|--verbose]}} {{[-S|--syn]}} {{[-p|--destport]}} {{80}} {{ip_o_nombre_de_servidor}}`

- Escanea un conjunto de puertos TCP en una dirección IP específica:

`hping3 {{[-8|--scan]}} {{80,3000,9000}} {{[-S|--syn]}} {{ip_o_nombre_de_servidor}}`

- Realiza un escaneado TCP ACK para comprobar si un equipo dado está vivo:

`hping3 {{[-c|--count]}} {{2}} {{[-V|--verbose]}} {{[-p|--destport]}} {{80}} {{[-A|--ack]}} {{ip_o_nombre_de_servidor}}`

- Realiza una prueba de carga en el puerto 80:

`hping3 --flood {{[-p|--destport]}} 80 {{[-S|--syn]}} {{ip_o_nombre_de_servidor}}`
