# 2to3

> Python 2-এর কোডকে স্বয়ংক্রিয়ভাবে Python 3–এ রূপান্তর করার জন্য ব্যবহৃত হয়।
> এই মডিউলটি Python 3.11 থেকে ডিপ্রিকেটেড এবং Python 3.13 থেকে সম্পূর্ণভাবে রিমুভ করা হয়েছে।
> রেফারেন্সের জন্য দেখুন: <https://github.com/python/cpython/blob/8d42e2d915c3096e7eac1c649751d1da567bb7c3/Doc/whatsnew/3.13.rst?plain=1#L188>।
> আরও তথ্য পাবেন: <https://manned.org/2to3>।

- ফাইলে কোনো পরিবর্তন না করে, যেসব পরিবর্তন করা হবে সেগুলো দেখান (dry-run):

`2to3 {{ফাইল.py/এর/পাথ}}`

- একটি Python 2 ফাইলকে Python 3–এ রূপান্তর করুন:

`2to3 {{[-w|--write]}} {{ফাইল.py/এর/পাথ}}`

- নির্দিষ্ট Python 2 ভাষাগত ফিচারগুলোকে Python 3–এ রূপান্তর করুন:

`2to3 {{[-w|--write]}} {{ফাইল.py/এর/পাথ}} {{[-f|--fix]}} {{raw_input}} {{[-f|--fix]}} {{প্রিন্ট}}`

- নির্দিষ্ট করা ফিচারগুলো বাদ দিয়ে বাকি সব Python 2 ভাষাগত ফিচারকে Python 3–এ রূপান্তর করুন:

`2to3 {{[-w|--write]}} {{ফাইল.py/এর/পাথ}} {{[-x|--nofix]}} {{has_key}} {{[-x|--nofix]}} {{isinstance}}`

- Python 2 থেকে Python 3–এ রূপান্তরযোগ্য সব এভেলেভেল ভাষাগত ফিচারের তালিকা দেখান:

`2to3 {{[-l|--list-fixes]}}`

- একটি ডিরেক্টরির সব Python 2 ফাইলকে Python 3–এ রূপান্তর করুন:

`2to3 {{[-o|--output-dir]}} {{python3_ডিরেক্টরি/এর/পাথ}} {{[-W|--write-unchanged-files]}} {{[-n|--nobackups]}} {{python2_ডিরেক্টরি/এর/পাথ}}`

- একাধিক থ্রেড ব্যবহার করে 2to3 চালান:

`2to3 {{[-j|--processes]}} {{4}} {{[-o|--output-dir]}} {{python3_ডিরেক্টরি/এর/পাথ}} {{[-w|--write]}} {{[-n|--nobackups]}} --no-diffs {{python2_ডিরেক্টরি/এর/পাথ}}`
