/* amd64-linux.elf-fold.h
   created from amd64-linux.elf-fold.bin, 20666 (0x50ba) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_AMD64_LINUX_ELF_FOLD_SIZE    20666
#define STUB_AMD64_LINUX_ELF_FOLD_ADLER32 0x47c198ad
#define STUB_AMD64_LINUX_ELF_FOLD_CRC32   0xa1b2fc98

unsigned char stub_amd64_linux_elf_fold[20666] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,128, 36,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 26,  0, 23,  0,
/* 0x0040 */   0,240,255,255,255,255,255,255,243, 15, 30,250, 76,137,109, 48,
/* 0x0050 */  76,137,232,131,224,  1,  9, 69, 16, 72,137,230,246, 69, 48,  2,
/* 0x0060 */ 117,  7, 72,129,236,  0, 16,  0,  0, 72,137,231,106,  8, 89,243,
/* 0x0070 */  72,165, 72,131, 62,  0, 72,165,117,248, 73,137,254,246, 69, 48,
/* 0x0080 */   2,117,  2, 72,171, 72,131, 62,  0, 72,165,117,248, 73,137,252,
/* 0x0090 */  72,137,249, 72,131, 62,  0, 72,165, 72,165,117,246, 73,137,255,
/* 0x00a0 */  73,137,245, 73, 41,252,246, 69, 48,  2,116,  8,131,205,255, 73,
/* 0x00b0 */ 137,254,235,114, 87, 72,141, 61,  0,  0,  0,  0, 41,246,232,  0,
/* 0x00c0 */   0,  0,  0,137,197, 94,186,255, 15,  0,  0,106, 89, 88, 15,  5,
/* 0x00d0 */ 133,192,121,  5, 87, 94,106, 15, 88,145,253, 73,141,125,255,176,
/* 0x00e0 */   0,170, 72,141,116, 14,255,243,164, 72,131,239,  3,199,  7, 32,
/* 0x00f0 */  32, 32, 61, 73,137, 62, 72,131,231,248, 76,137,249, 72, 41,225,
/* 0x0100 */  72,131,239,  8, 73,141,119,248,137,248, 49,240,131,224,  8, 72,
/* 0x0110 */  41,199, 73,137,254, 72,193,233,  3,243, 72,165, 72,141,103,  8,
/* 0x0120 */ 252, 75,141, 76, 38,  8, 95, 94, 72,131,231,252, 65, 88, 68,137,
/* 0x0130 */ 192,131,224,  1, 72,  9,193, 73, 41,192, 77,137,197, 72,129,236,
/* 0x0140 */   0,  8,  0,  0, 72,137,226,232,  0,  0,  0,  0, 72,129,196,  0,
/* 0x0150 */   8,  0,  0,137,235, 72,137, 68, 36, 24, 73,139,181,160,  0,  0,
/* 0x0160 */   0, 76,137,239,232,  0,  0,  0,  0, 76,137,239,232,  0,  0,  0,
/* 0x0170 */   0,133,219,120, 31, 77, 41,201, 65,137,216,106,  2, 89,106,  1,
/* 0x0180 */  90,190,  0, 16,  0,  0, 41,255,232,  0,  0,  0,  0,137,223,232,
/* 0x0190 */   0,  0,  0,  0, 95, 94,106, 11, 88, 65,255, 38, 72,139,  5,157,
/* 0x01a0 */ 254,255,255,195, 81, 72, 57, 23, 76,139, 71,  8, 72,141, 74,255,
/* 0x01b0 */ 115, 10,191,127,  0,  0,  0,232,  0,  0,  0,  0, 72,131,249,255,
/* 0x01c0 */ 116, 17, 65, 15,182,  0, 72,255,201, 73,255,192,136,  6, 72,255,
/* 0x01d0 */ 198,235,233, 72,  1, 87,  8, 72, 41, 23, 88,195, 85, 72,137,245,
/* 0x01e0 */  83, 72,137,251, 72,131,236, 40, 72,131, 62,  0, 15,132,176,  0,
/* 0x01f0 */   0,  0, 72,141,116, 36, 16,186, 12,  0,  0,  0, 72,137,223,232,
/* 0x0200 */ 160,255,255,255,139, 68, 36, 16,139, 84, 36, 20,133,192,117, 20,
/* 0x0210 */ 129,250, 85, 80, 88, 33,117, 16, 72,131, 59,  0, 15,132,128,  0,
/* 0x0220 */   0,  0,235,  4,133,210,117, 10,191,127,  0,  0,  0,232,  0,  0,
/* 0x0230 */   0,  0, 57,194,119,242,137,193, 72, 59, 77,  0,119,234, 57,194,
/* 0x0240 */  72,139,117,  8,115, 51, 72,139,123,  8, 72,141, 84, 36,  8, 72,
/* 0x0250 */ 137, 76, 36,  8, 72,131,239, 12,232,  0,  0,  0,  0,133,192,117,
/* 0x0260 */ 199,139, 68, 36, 16, 72, 57, 68, 36,  8,117,188,139, 68, 36, 20,
/* 0x0270 */  72,  1, 67,  8, 72, 41,  3,235, 14, 72,131,  3, 12,137,210, 72,
/* 0x0280 */ 137,223,232, 29,255,255,255,139, 84, 36, 16, 72,139, 69,  0, 72,
/* 0x0290 */   1, 85,  8, 72, 41,208, 72,133,192, 72,137, 69,  0,233, 74,255,
/* 0x02a0 */ 255,255, 72,131,196, 40, 91, 93,195, 72,133,255, 65, 80,116, 80,
/* 0x02b0 */  64,246,199,  1,117, 74, 69, 49,192, 49,201, 72,139,  7, 65,137,
/* 0x02c0 */ 241, 76, 57,200,117,  8,255,193, 72,137, 87,  8,235, 11, 72,131,
/* 0x02d0 */ 248,  1,117,  5, 73,137,248,235, 33, 72,133,192,117, 28,133,201,
/* 0x02e0 */ 117, 30, 77,133,192,116,  9, 77,137,  8, 73,137, 80,  8,235, 16,
/* 0x02f0 */ 191,127,  0,  0,  0,232,  0,  0,  0,  0, 72,131,199, 16,235,187,
/* 0x0300 */  94,195, 65, 84, 65,137,248, 73,137,244,252, 83,137,211, 69, 49,
/* 0x0310 */ 201, 72,137,217,186,  3,  0,  0,  0, 72,129,236,  8, 16,  0,  0,
/* 0x0320 */  72,137,231,243,164, 68,137,198, 76,137,231, 65,131,200,255,177,
/* 0x0330 */  50,232,  0,  0,  0,  0, 72,137,230, 76,137,231, 72,137,217,252,
/* 0x0340 */ 243,164, 72,129,196,  8, 16,  0,  0, 91, 65, 92,195, 65, 87, 65,
/* 0x0350 */  86, 73,137,254, 65, 85, 65, 84, 85, 83, 72,129,236,152,  0,  0,
/* 0x0360 */   0, 76,  3,119, 32, 72,133,246,137, 84, 36, 84, 72,137,124, 36,
/* 0x0370 */  96, 72,137,116, 36, 88, 72,137, 76, 36, 72, 76,137, 68, 36, 64,
/* 0x0380 */  72,199, 68, 36,104,  0,  0,  0,  0, 72,199, 68, 36, 56,  0,  0,
/* 0x0390 */   0,  0, 15,183, 87, 16,116, 51, 73,139, 56, 72,141, 71, 64, 72,
/* 0x03a0 */  43,120, 72,102,131,250,  2,117,  6, 72,139,120, 16,235,  5, 72,
/* 0x03b0 */ 137,124, 36, 56, 72,139,112, 40, 72,141,  4, 62, 72,137, 68, 36,
/* 0x03c0 */ 104,232,  0,  0,  0,  0,233, 44,  1,  0,  0,102,131,250,  3, 72,
/* 0x03d0 */ 139, 84, 36, 96,184,  0,  0,  0,  0, 65,186, 16,  0,  0,  0, 72,
/* 0x03e0 */ 199, 68, 36, 48,  0, 16,  0,  0, 76,137,243, 68, 15, 68,208, 73,
/* 0x03f0 */ 131,207,255, 69, 49,228, 15,183,106, 56, 68,137, 84, 36,  8,232,
/* 0x0400 */   0,  0,  0,  0, 68,139, 84, 36,  8, 72,137,193,255,205,120, 64,
/* 0x0410 */ 131, 59,  1,117, 51, 72,139, 83, 40, 72,133,210,116, 42, 72,139,
/* 0x0420 */  67, 16, 76, 57,248, 76, 15, 66,248, 72,141,  4,  2, 73, 57,196,
/* 0x0430 */  76, 15, 66,224, 72,139, 67, 48, 72, 57, 68, 36, 48, 72, 15, 67,
/* 0x0440 */  68, 36, 48, 72,137, 68, 36, 48, 72,131,195, 56,255,205,235,190,
/* 0x0450 */  73, 33,207, 72,137,202, 73,137,205, 72,247,218, 77, 41,252,187,
/* 0x0460 */   1,  0,  0,  0, 73,141, 68, 20,255, 73, 33,197, 72, 59, 84, 36,
/* 0x0470 */  48,115, 15,  1,219,137,216, 72, 15,175,194, 72, 59, 68, 36, 48,
/* 0x0480 */ 235,239,255,203, 65,131,202, 34, 69, 49,201,137,216, 65,131,200,
/* 0x0490 */ 255, 68,137,209, 15,175,194, 76,137,255, 49,210, 70,141, 36, 40,
/* 0x04a0 */  68,137,230,232,  0,  0,  0,  0,133,219, 72,137,197,116, 54, 72,
/* 0x04b0 */ 139, 84, 36, 48, 72,247,216, 72,255,202, 72,137,211, 72, 33,195,
/* 0x04c0 */ 116, 17, 72,137,239, 72,137,222, 72,  1,221, 65, 41,220,232,  0,
/* 0x04d0 */   0,  0,  0, 69, 41,236,116, 13, 74,141,124, 45,  0, 68,137,230,
/* 0x04e0 */ 232,  0,  0,  0,  0, 73,141, 68, 45,  0, 76, 41,253, 72,137,108,
/* 0x04f0 */  36, 56, 72,137, 68, 36,104,232,  0,  0,  0,  0, 72,137, 68, 36,
/* 0x0500 */  40, 72,139, 68, 36, 96,199, 68, 36, 36,  0,  0,  0,  0,102,131,
/* 0x0510 */ 120, 56,  0, 15,132,115,  3,  0,  0, 72,131,124, 36, 88,  0,116,
/* 0x0520 */  35, 65,131, 62,  6,117, 29, 72,139, 84, 36, 56, 73,  3, 86, 16,
/* 0x0530 */ 190,  3,  0,  0,  0, 72,139,124, 36, 72,232,106,253,255,255,233,
/* 0x0540 */  45,  3,  0,  0, 65,131, 62,  1, 15,133, 35,  3,  0,  0, 73,131,
/* 0x0550 */ 126, 40,  0, 15,132, 24,  3,  0,  0, 65,139, 78,  4,199, 68, 36,
/* 0x0560 */  32, 64, 98, 81,115,131,225,  7,193,225,  2,211,108, 36, 32,131,
/* 0x0570 */ 100, 36, 32,  7, 72,131,124, 36, 88,  0,116, 90, 73,131,126,  8,
/* 0x0580 */   0,117, 83, 72,139, 68, 36, 96, 72,139, 84, 36, 56,190,  3,  0,
/* 0x0590 */   0,  0, 73,  3, 86, 16, 72,139,124, 36, 72, 72,  3, 80, 32,232,
/* 0x05a0 */   5,253,255,255, 72,139, 68, 36, 96, 72,139,124, 36, 72,190,  5,
/* 0x05b0 */   0,  0,  0, 72, 15,183, 80, 56,232,236,252,255,255, 72,139, 68,
/* 0x05c0 */  36, 96, 72,139,124, 36, 72,190,  4,  0,  0,  0, 72, 15,183, 80,
/* 0x05d0 */  54,232,211,252,255,255, 72,139,124, 36, 56, 72,139, 68, 36, 40,
/* 0x05e0 */  73,  3,126, 16, 73,139,118, 32, 73,139, 86, 40,199, 68, 36, 20,
/* 0x05f0 */   0,  0,  0,  0, 72,247,208, 73,137,245, 72,137,180, 36,128,  0,
/* 0x0600 */   0,  0, 72, 33,248, 73,137,252, 72,  1,250, 73,  1,197, 73, 41,
/* 0x0610 */ 196, 72,131,124, 36, 88,  0, 72,137,188, 36,136,  0,  0,  0, 72,
/* 0x0620 */ 137, 84, 36, 24, 76,141, 60, 55,116,109, 65,246, 70,  4,  1,116,
/* 0x0630 */  51,190, 16,  0,  0,  0, 72,141, 61,  0,  0,  0,  0,232,  0,  0,
/* 0x0640 */   0,  0, 76,137,238,137,199,137, 68, 36, 20,232,  0,  0,  0,  0,
/* 0x0650 */  68,139, 68, 36, 20, 69, 49,201,185, 17,  0,  0,  0,186,  3,  0,
/* 0x0660 */   0,  0,235, 30, 72,131,124, 36, 88,  0,116, 43,139, 84, 36, 32,
/* 0x0670 */  69, 49,201, 65,131,200,255,185, 50,  0,  0,  0,131,202,  2,131,
/* 0x0680 */ 226,251, 76,137,238, 76,137,231,232,  0,  0,  0,  0, 73, 57,196,
/* 0x0690 */ 116, 48,233,162,  1,  0,  0, 77,139, 78,  8, 68,139, 68, 36, 84,
/* 0x06a0 */ 185, 18,  0,  0,  0,139, 84, 36, 32, 76,137,238, 76,137,231, 73,
/* 0x06b0 */  41,193,232,  0,  0,  0,  0, 73, 57,196, 15,133,121,  1,  0,  0,
/* 0x06c0 */ 235, 26, 72,131,124, 36, 88,  0,116, 18, 72,139,124, 36, 88, 72,
/* 0x06d0 */ 141,180, 36,128,  0,  0,  0,232,  0,251,255,255,246, 68, 36, 32,
/* 0x06e0 */   2,116, 24,139, 68, 36, 40, 68,137,249, 76,137,255,247,217,252,
/* 0x06f0 */ 247,208, 33,193, 49,192,243,170, 73,137,255, 72,131,124, 36, 88,
/* 0x0700 */   0, 15,132, 24,  1,  0,  0, 65,246, 70,  4,  1, 15,132, 13,  1,
/* 0x0710 */   0,  0,199, 68, 36,112,243, 15, 30,250,199, 68, 36,116, 15,  5,
/* 0x0720 */  90, 88, 72,184,255,255,255,255,  1,  0,  0,  0,199, 68, 36,120,
/* 0x0730 */  62,255,224,144, 73, 35,  6, 72,186,  1,  0,  0,  0,  1,  0,  0,
/* 0x0740 */   0,139, 76, 36, 40, 72,139,172, 36,136,  0,  0,  0, 72, 57,208,
/* 0x0750 */ 247,209,117,108,137,232,247,216, 33,193,131,249, 11,118, 23,199,
/* 0x0760 */  69,  0,243, 15, 30,250,139, 68, 36,116,137, 69,  4,139, 68, 36,
/* 0x0770 */ 120,137, 69,  8,235, 74,190, 16,  0,  0,  0, 72,141, 61,  0,  0,
/* 0x0780 */   0,  0,232,  0,  0,  0,  0, 72,141,116, 36,112,137,195,186, 12,
/* 0x0790 */   0,  0,  0,137,199,232,  0,  0,  0,  0, 49,255, 69, 49,201, 65,
/* 0x07a0 */ 137,216,185,  1,  0,  0,  0,186,  5,  0,  0,  0,190, 12,  0,  0,
/* 0x07b0 */   0,232,  0,  0,  0,  0,137,223, 72,137,197,232,  0,  0,  0,  0,
/* 0x07c0 */  72,133,237,116, 19, 72,139,124, 36, 72, 72,137,234, 49,246, 72,
/* 0x07d0 */ 131,231,254,232,209,250,255,255,186,  4,  0,  0,  0, 76,137,238,
/* 0x07e0 */  76,137,231,232,  0,  0,  0,  0, 76,137,238, 76,137,231,232,  0,
/* 0x07f0 */   0,  0,  0, 68,139, 68, 36, 20,139, 84, 36, 32, 69, 49,201,185,
/* 0x0800 */  17,  0,  0,  0, 76,137,238, 76,137,231,232,  0,  0,  0,  0, 73,
/* 0x0810 */  57,196,117, 37,139,124, 36, 20,232,  0,  0,  0,  0,235, 36,131,
/* 0x0820 */ 124, 36, 32,  3,116, 29,139, 84, 36, 32, 76,137,238, 76,137,231,
/* 0x0830 */ 232,  0,  0,  0,  0,133,192,116, 10,191,127,  0,  0,  0,232,  0,
/* 0x0840 */   0,  0,  0, 76, 59,124, 36, 24,115, 39, 76, 41,124, 36, 24,139,
/* 0x0850 */  84, 36, 32, 69, 49,201, 72,139,116, 36, 24, 65,131,200,255,185,
/* 0x0860 */  50,  0,  0,  0, 76,137,255,232,  0,  0,  0,  0, 73, 57,199,117,
/* 0x0870 */ 200, 72,139, 84, 36, 96,255, 68, 36, 36, 73,131,198, 56, 15,183,
/* 0x0880 */  66, 56, 57, 68, 36, 36, 15,140,141,252,255,255, 72,131,124, 36,
/* 0x0890 */  64,  0,116, 13, 72,139, 84, 36, 56, 72,139, 68, 36, 64, 72,137,
/* 0x08a0 */  16, 72,139, 68, 36, 96, 72,139, 64, 24, 72,  1, 68, 36, 56, 72,
/* 0x08b0 */ 139, 68, 36, 56, 72,129,196,152,  0,  0,  0, 91, 93, 65, 92, 65,
/* 0x08c0 */  93, 65, 94, 65, 95,195, 65, 87, 65, 86, 73,137,206, 65, 85, 65,
/* 0x08d0 */  84, 73,137,212, 77,141,108, 36, 64, 85, 83, 72,131,236, 72,139,
/* 0x08e0 */   7, 72,137,124, 36, 24, 72,137,124, 36, 40, 76,141,124, 36,  8,
/* 0x08f0 */  72,137,116, 36, 32, 72,141,116, 36, 48, 76,137, 68, 36,  8, 72,
/* 0x0900 */ 137, 84, 36, 56, 72,137, 68, 36, 48,139, 71,  4, 72,141,124, 36,
/* 0x0910 */  16, 72,131,192, 12, 72,137, 68, 36, 16,232,189,248,255,255,232,
/* 0x0920 */   0,  0,  0,  0, 72,141,116, 36, 32, 49,210, 77,137,248, 76,137,
/* 0x0930 */ 241, 76,137,231,232, 20,250,255,255,190,  9,  0,  0,  0, 72,137,
/* 0x0940 */ 194, 76,137,247, 72,137,197,232, 93,249,255,255,102, 65,131,124,
/* 0x0950 */  36, 56,  0,199, 68, 36,  4,  0,  0,  0,  0, 15,132,136,  0,  0,
/* 0x0960 */   0, 65,131,125,  0,  3,117,105, 73,139, 63, 73,  3,125, 16, 49,
/* 0x0970 */ 210, 49,246,232,  0,  0,  0,  0,133,192,137,195,120, 23,186,  0,
/* 0x0980 */   4,  0,  0, 76,137,230,137,199,232,  0,  0,  0,  0, 72, 61,  0,
/* 0x0990 */   4,  0,  0,116, 10,191,127,  0,  0,  0,232,  0,  0,  0,  0, 77,
/* 0x09a0 */ 137,248, 49,201,137,218, 49,246, 76,137,231, 73,199,  7,  0,  0,
/* 0x09b0 */   0,  0,232,150,249,255,255, 73,139, 23, 76,137,247,190,  7,  0,
/* 0x09c0 */   0,  0, 72,137,197,232,223,248,255,255,137,223,232,  0,  0,  0,
/* 0x09d0 */   0,255, 68, 36,  4, 65, 15,183, 68, 36, 56, 73,131,197, 56, 57,
/* 0x09e0 */  68, 36,  4, 15,130,120,255,255,255, 72,131,196, 72, 72,137,232,
/* 0x09f0 */  91, 93, 65, 92, 65, 93, 65, 94, 65, 95,195,  0, 72,137, 92, 36,
/* 0x0a00 */ 224, 72,137,108, 36,232, 76,137,100, 36,240, 76,137,108, 36,248,
/* 0x0a10 */  72,131,236, 40, 73,137,252, 65,137,245, 72,141, 45,  0,  0,  0,
/* 0x0a20 */   0,190, 16,  0,  0,  0, 72,137,239,232,  0,  0,  0,  0,137,195,
/* 0x0a30 */ 131,248,234,117, 15,190,  0,  0,  0,  0, 72,137,239,232,  0,  0,
/* 0x0a40 */   0,  0,137,195,133,219,121, 31, 72,141, 61,  0,  0,  0,  0,186,
/* 0x0a50 */ 192,  1,  0,  0,190,  2,  0, 65,  0,232,  0,  0,  0,  0,137,195,
/* 0x0a60 */  72, 99,208,133,192,120, 77, 68,137,238,137,223,232,  0,  0,  0,
/* 0x0a70 */   0, 72, 99,208,133,192,120, 60, 73,131,252,  1, 25,201,131,225,
/* 0x0a80 */ 240,131,193, 17, 68,137,238, 65,185,  0,  0,  0,  0, 65,137,216,
/* 0x0a90 */ 186,  3,  0,  0,  0, 76,137,231,232,  0,  0,  0,  0, 73,137,196,
/* 0x0aa0 */ 232,  0,  0,  0,  0, 76,137,226, 73, 57,196,115,  7,141, 67,  1,
/* 0x0ab0 */  74,141, 20, 32, 72,137,208, 72,139, 92, 36,  8, 72,139,108, 36,
/* 0x0ac0 */  16, 76,139,100, 36, 24, 76,139,108, 36, 32, 72,131,196, 40,195,
/* 0x0ad0 */ 204,195, 47,112,114,111, 99, 47,115,101,108,102, 47,101,120,101,
/* 0x0ae0 */   0,184, 63,  1,  0,  0, 15,  5,133,192,121, 45,133,246,116,  4,
/* 0x0af0 */  49,246,235,237,232, 17,  0,  0,  0,192,  1,  0,  0,  2,  0, 65,
/* 0x0b00 */   0, 47,100,101,118, 47,115,104,109,  0, 94,173,146,173, 86,150,
/* 0x0b10 */  95,106,  2, 88,232, 26,  0,  0,  0,195, 72,139,  5,  0,  0,  0,
/* 0x0b20 */   0,247,208, 33,248, 72, 41,199, 72,  1,198,176,  9, 73,137,202,
/* 0x0b30 */  15,182,192, 80, 15,  5, 89, 72, 61,  0,240,255,255,114,  6,131,
/* 0x0b40 */ 249,  2,116,  1,204,195,139,  5,  0,  0,  0,  0,247,208,176, 26,
/* 0x0b50 */ 235, 52, 33,248, 72, 41,199, 72,  1,198,233,  0,  0,  0,  0,139,
/* 0x0b60 */   5,  0,  0,  0,  0,247,208, 33,248, 72, 41,199, 72,  1,198,233,
/* 0x0b70 */   0,  0,  0,  0,139,  5,  0,  0,  0,  0,247,208, 33,248, 72, 41,
/* 0x0b80 */ 199, 72,  1,198,176, 11,235,  2,176, 60,235,  2,176, 12,235,  2,
/* 0x0b90 */ 176,  3,235,  2,176, 77,235,  2,176,  2,235,  2,176, 10,235,  2,
/* 0x0ba0 */ 176, 26,235,  2,176,  1,235,  2,176,  0,235,132, 85, 72,137,229,
/* 0x0bb0 */  83, 82, 86, 87,232,101,  0,  0,  0, 91, 95, 94, 80, 15,182, 75,
/* 0x0bc0 */   9,133,201,116, 11, 15,182, 83, 10,139, 54,232,  4,  0,  0,  0,
/* 0x0bd0 */  88, 91, 93,195,131,249, 73,117, 68, 83, 87, 72,141, 76, 55,253,
/* 0x0be0 */  94, 86, 91,235, 47, 72, 57,206,115, 50, 86, 94,172, 60,128,114,
/* 0x0bf0 */  10, 60,143,119,  6,128,126,254, 15,116,  6, 44,232, 60,  1,119,
/* 0x0c00 */ 228, 72, 57,206,115, 22, 86,173, 40,208,117,223, 95, 15,200, 41,
/* 0x0c10 */ 248,  1,216,171, 72, 57,206,115,  3,172,235,223, 91,195, 82, 68,
/* 0x0c20 */  15,182, 71,  8, 87, 86, 95, 94,139, 70,  4, 72,131,198, 12, 72,
/* 0x0c30 */   1,240, 80, 87, 49,219, 49,201, 72,131,205,255,235, 86,139, 30,
/* 0x0c40 */  72,131,238,252, 17,219, 15,182, 22,243,195,243, 15, 30,250,  1,
/* 0x0c50 */ 219,116,235,243,195, 72,141,  4, 47,131,249,  5, 15,182, 16,118,
/* 0x0c60 */  33,131,253,252,119, 28,131,233,  4,139, 16, 72,131,192,  4,131,
/* 0x0c70 */ 233,  4,137, 23, 72,141,127,  4,115,239,131,193,  4, 15,182, 16,
/* 0x0c80 */ 116, 16, 72,255,192,136, 23,255,201, 15,182, 16, 72,141,127,  1,
/* 0x0c90 */ 117,240,243,195,252, 65,131,248,  8, 15,133,222,  0,  0,  0,235,
/* 0x0ca0 */   8, 72,255,198,136, 23, 72,255,199, 15,182, 22,  1,219,117, 11,
/* 0x0cb0 */ 139, 30, 72,131,238,252, 17,219, 15,182, 22,114,228,141, 65,  1,
/* 0x0cc0 */ 235, 19,255,200,  1,219,117, 11,139, 30, 72,131,238,252, 17,219,
/* 0x0cd0 */  15,182, 22, 17,192,  1,219,117, 11,139, 30, 72,131,238,252, 17,
/* 0x0ce0 */ 219, 15,182, 22, 17,192,  1,219,117, 11,139, 30, 72,131,238,252,
/* 0x0cf0 */  17,219, 15,182, 22,115,203,131,232,  3,114, 26,193,224,  8, 72,
/* 0x0d00 */ 255,198,  9,208,131,240,255, 15,132,  0,  0,  0,  0,209,248, 72,
/* 0x0d10 */  99,232,114, 68,235, 14,  1,219,117,  8,139, 30, 72,131,238,252,
/* 0x0d20 */  17,219,114, 52,255,193,  1,219,117,  8,139, 30, 72,131,238,252,
/* 0x0d30 */  17,219,114, 36,  1,219,117, 11,139, 30, 72,131,238,252, 17,219,
/* 0x0d40 */  15,182, 22, 17,201,  1,219,117,  8,139, 30, 72,131,238,252, 17,
/* 0x0d50 */ 219,115,225,131,193,  2,235, 17,  1,219,117, 11,139, 30, 72,131,
/* 0x0d60 */ 238,252, 17,219, 15,182, 22, 17,201, 72,129,253,  0,251,255,255,
/* 0x0d70 */ 131,209,  2,232,  0,  0,  0,  0,233, 44,255,255,255, 65,131,248,
/* 0x0d80 */   5, 15,133,209,  0,  0,  0,235,  8, 72,255,198,136, 23, 72,255,
/* 0x0d90 */ 199, 15,182, 22,  1,219,117, 11,139, 30, 72,131,238,252, 17,219,
/* 0x0da0 */  15,182, 22,114,228,141, 65,  1,235, 19,255,200,  1,219,117, 11,
/* 0x0db0 */ 139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,192,  1,219,117,
/* 0x0dc0 */  11,139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,192,  1,219,
/* 0x0dd0 */ 117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22,115,203,131,
/* 0x0de0 */ 232,  3,114, 24,193,224,  8, 72,255,198,  9,208,131,240,255, 15,
/* 0x0df0 */ 132,  0,  0,  0,  0,209,248, 72, 99,232,235, 15,  1,219,117, 11,
/* 0x0e00 */ 139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,201,  1,219,117,
/* 0x0e10 */  11,139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,201,117, 36,
/* 0x0e20 */ 255,193,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182,
/* 0x0e30 */  22, 17,201,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,115,
/* 0x0e40 */ 225,131,193,  2, 72,129,253,  0,251,255,255,131,209,  1,232,  0,
/* 0x0e50 */   0,  0,  0,233, 57,255,255,255, 65,131,248,  2, 15,133,186,  0,
/* 0x0e60 */   0,  0,235,  8, 72,255,198,136, 23, 72,255,199, 15,182, 22,  1,
/* 0x0e70 */ 219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22,114,228,
/* 0x0e80 */ 141, 65,  1,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,
/* 0x0e90 */ 182, 22, 17,192,  1,219,117, 11,139, 30, 72,131,238,252, 17,219,
/* 0x0ea0 */  15,182, 22,115,222,131,232,  3,114, 20,193,224,  8, 72,255,198,
/* 0x0eb0 */   9,208,131,240,255, 15,132,  0,  0,  0,  0, 72, 99,232,141, 65,
/* 0x0ec0 */   1,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22,
/* 0x0ed0 */  17,201,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182,
/* 0x0ee0 */  22, 17,201,117, 36,137,193,131,192,  2,  1,219,117, 11,139, 30,
/* 0x0ef0 */  72,131,238,252, 17,219, 15,182, 22, 17,201,  1,219,117,  8,139,
/* 0x0f00 */  30, 72,131,238,252, 17,219,115,225, 72,129,253,  0,243,255,255,
/* 0x0f10 */  17,193,232,  0,  0,  0,  0,233, 80,255,255,255, 65,131,248, 14,
/* 0x0f20 */  15,133,  0,  0,  0,  0, 87, 86,139,118,248, 72,137,209, 95, 90,
/* 0x0f30 */  85, 72,137,229, 68,139,  9, 73,137,208, 72,137,242, 72,141,119,
/* 0x0f40 */   2, 86,138,  7,255,202,136,193, 36,  7,192,233,  3, 72,199,195,
/* 0x0f50 */   0,253,255,255, 72,211,227,136,193, 72,141,156, 92,136,241,255,
/* 0x0f60 */ 255, 72,131,227,192,106,  0, 72, 57,220,117,249, 83, 72,141,123,
/* 0x0f70 */   8,138, 78,255,255,202,136, 71,  2,136,200,192,233,  4,136, 79,
/* 0x0f80 */   1, 36, 15,136,  7, 72,141, 79,252,106, 90, 65, 87, 72,141, 71,
/* 0x0f90 */   4, 69, 49,255, 65, 86, 65,190,  1,  0,  0,  0, 65, 85, 69, 49,
/* 0x0fa0 */ 237, 65, 84, 85, 83, 72,137, 76, 36,240, 72,137, 68, 36,216,184,
/* 0x0fb0 */   1,  0,  0,  0, 72,137,116, 36,248, 76,137, 68, 36,232,137,195,
/* 0x0fc0 */  68,137, 76, 36,228, 15,182, 79,  2,211,227,137,217, 72,139, 92,
/* 0x0fd0 */  36, 56,255,201,137, 76, 36,212, 15,182, 79,  1,211,224, 72,139,
/* 0x0fe0 */  76, 36,240,255,200,137, 68, 36,208, 15,182,  7,199,  1,  0,  0,
/* 0x0ff0 */   0,  0,199, 68, 36,200,  0,  0,  0,  0,199, 68, 36,196,  1,  0,
/* 0x1000 */   0,  0,199, 68, 36,192,  1,  0,  0,  0,199, 68, 36,188,  1,  0,
/* 0x1010 */   0,  0,199,  3,  0,  0,  0,  0,137, 68, 36,204, 15,182, 79,  1,
/* 0x1020 */   1,193,184,  0,  3,  0,  0,211,224, 49,201,141,184, 54,  7,  0,
/* 0x1030 */   0, 65, 57,255,115, 19, 72,139, 92, 36,216,137,200,255,193, 57,
/* 0x1040 */ 249,102,199,  4, 67,  0,  4,235,235, 72,139,124, 36,248,137,208,
/* 0x1050 */  69, 49,210, 65,131,203,255, 49,210, 73,137,252, 73,  1,196, 76,
/* 0x1060 */  57,231, 15,132,239,  8,  0,  0, 15,182,  7, 65,193,226,  8,255,
/* 0x1070 */ 194, 72,255,199, 65,  9,194,131,250,  4,126,227, 68, 59,124, 36,
/* 0x1080 */ 228, 15,131,218,  8,  0,  0,139, 68, 36,212, 72, 99, 92, 36,200,
/* 0x1090 */  72,139, 84, 36,216, 68, 33,248,137, 68, 36,184, 72, 99,108, 36,
/* 0x10a0 */ 184, 72,137,216, 72,193,224,  4, 72,  1,232, 65,129,251,255,255,
/* 0x10b0 */ 255,  0, 76,141, 12, 66,119, 26, 76, 57,231, 15,132,150,  8,  0,
/* 0x10c0 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x10d0 */   9,194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x10e0 */ 175,193, 65, 57,194, 15,131,197,  1,  0,  0, 65,137,195,184,  0,
/* 0x10f0 */   8,  0,  0, 72,139, 92, 36,216, 41,200, 15,182, 76, 36,204,190,
/* 0x1100 */   1,  0,  0,  0,193,248,  5,141,  4,  2, 65, 15,182,213,102, 65,
/* 0x1110 */ 137,  1,139, 68, 36,208, 68, 33,248,211,224,185,  8,  0,  0,  0,
/* 0x1120 */  43, 76, 36,204,211,250,  1,208,105,192,  0,  3,  0,  0,131,124,
/* 0x1130 */  36,200,  6,137,192, 76,141,140, 67,108, 14,  0,  0, 15,142,184,
/* 0x1140 */   0,  0,  0, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 15,182,
/* 0x1150 */  44,  2,  1,237, 72, 99,214,137,235,129,227,  0,  1,  0,  0, 65,
/* 0x1160 */ 129,251,255,255,255,  0, 72, 99,195, 73,141,  4, 65, 76,141,  4,
/* 0x1170 */  80,119, 26, 76, 57,231, 15,132,219,  7,  0,  0, 15,182,  7, 65,
/* 0x1180 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,
/* 0x1190 */ 144,  0,  2,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x11a0 */ 193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,  0,  1,246,
/* 0x11b0 */  41,200,193,248,  5,133,219,141,  4,  2,102, 65,137,128,  0,  2,
/* 0x11c0 */   0,  0,116, 33,235, 45, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x11d0 */ 232,  5,141,116, 54,  1,102, 41,194,133,219,102, 65,137,144,  0,
/* 0x11e0 */   2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142, 97,255,255,
/* 0x11f0 */ 255,235,120,129,254,255,  0,  0,  0,127,112, 72, 99,198, 65,129,
/* 0x1200 */ 251,255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,132,
/* 0x1210 */  67,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x1220 */ 255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,232, 11, 15,
/* 0x1230 */ 183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,
/* 0x1240 */   0,  0,  1,246, 41,200,193,248,  5,141,  4,  2,102, 65,137,  0,
/* 0x1250 */ 235,161, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,116,
/* 0x1260 */  54,  1,102, 41,194,102, 65,137, 16,235,136, 72,139, 76, 36,232,
/* 0x1270 */  68,137,248, 65,255,199, 65,137,245, 64,136, 52,  1,131,124, 36,
/* 0x1280 */ 200,  3,127, 13,199, 68, 36,200,  0,  0,  0,  0,233,166,  6,  0,
/* 0x1290 */   0,139, 84, 36,200,139, 68, 36,200,131,234,  3,131,232,  6,131,
/* 0x12a0 */ 124, 36,200,  9, 15, 79,208,137, 84, 36,200,233,135,  6,  0,  0,
/* 0x12b0 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 72,
/* 0x12c0 */ 139, 68, 36,216, 65,129,251,255,255,255,  0,102, 65,137, 17, 72,
/* 0x12d0 */ 141, 52, 88,119, 26, 76, 57,231, 15,132,121,  6,  0,  0, 15,182,
/* 0x12e0 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,
/* 0x12f0 */ 183,150,128,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x1300 */ 175,193, 65, 57,194,115, 78, 65,137,195,184,  0,  8,  0,  0, 76,
/* 0x1310 */ 139, 76, 36,216, 41,200,139, 76, 36,196, 68,137,116, 36,196,193,
/* 0x1320 */ 248,  5,141,  4,  2,139, 84, 36,192,137, 76, 36,192,102,137,134,
/* 0x1330 */ 128,  1,  0,  0, 49,192,131,124, 36,200,  6,137, 84, 36,188, 15,
/* 0x1340 */ 159,192, 73,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36,200,
/* 0x1350 */ 233, 84,  2,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x1360 */   5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,128,  1,
/* 0x1370 */   0,  0,119, 26, 76, 57,231, 15,132,218,  5,  0,  0, 15,182,  7,
/* 0x1380 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,
/* 0x1390 */ 150,152,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x13a0 */ 193, 65, 57,194, 15,131,208,  0,  0,  0, 65,184,  0,  8,  0,  0,
/* 0x13b0 */  65,137,195, 72,193,227,  5, 68,137,192, 41,200,193,248,  5,141,
/* 0x13c0 */   4,  2,102,137,134,152,  1,  0,  0, 72,139, 68, 36,216, 72,  1,
/* 0x13d0 */ 216, 65,129,251,255,255,255,  0, 72,141, 52,104,119, 26, 76, 57,
/* 0x13e0 */ 231, 15,132,112,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x13f0 */ 227,  8, 72,255,199, 65,  9,194, 15,183,150,224,  1,  0,  0, 68,
/* 0x1400 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 79,
/* 0x1410 */  65, 41,200, 65,137,195, 65,193,248,  5, 69,133,255, 66,141,  4,
/* 0x1420 */   2,102,137,134,224,  1,  0,  0, 15,132, 41,  5,  0,  0, 49,192,
/* 0x1430 */ 131,124, 36,200,  6, 72,139, 92, 36,232, 15,159,192,141, 68,  0,
/* 0x1440 */   9,137, 68, 36,200, 68,137,248, 68, 41,240, 68, 15,182, 44,  3,
/* 0x1450 */  68,137,248, 65,255,199, 68,136, 44,  3,233,216,  4,  0,  0, 65,
/* 0x1460 */  41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,102,137,
/* 0x1470 */ 150,224,  1,  0,  0,233, 17,  1,  0,  0, 65, 41,195, 65, 41,194,
/* 0x1480 */ 137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,
/* 0x1490 */ 102,137,150,152,  1,  0,  0,119, 26, 76, 57,231, 15,132,181,  4,
/* 0x14a0 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x14b0 */  65,  9,194, 15,183,150,176,  1,  0,  0, 68,137,216,193,232, 11,
/* 0x14c0 */  15,183,202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,  0,
/* 0x14d0 */   8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,176,  1,
/* 0x14e0 */   0,  0,139, 68, 36,196,233,152,  0,  0,  0, 65, 41,195, 65, 41,
/* 0x14f0 */ 194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,
/* 0x1500 */   0,102,137,150,176,  1,  0,  0,119, 26, 76, 57,231, 15,132, 68,
/* 0x1510 */   4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x1520 */ 199, 65,  9,194, 15,183,150,200,  1,  0,  0, 68,137,216,193,232,
/* 0x1530 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 29, 65,137,195,184,
/* 0x1540 */   0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,200,
/* 0x1550 */   1,  0,  0,139, 68, 36,192,235, 34, 65, 41,195, 65, 41,194,137,
/* 0x1560 */ 208,102,193,232,  5,102, 41,194,139, 68, 36,188,102,137,150,200,
/* 0x1570 */   1,  0,  0,139, 84, 36,192,137, 84, 36,188,139, 76, 36,196,137,
/* 0x1580 */  76, 36,192, 68,137,116, 36,196, 65,137,198, 49,192,131,124, 36,
/* 0x1590 */ 200,  6, 76,139, 76, 36,216, 15,159,192, 73,129,193,104, 10,  0,
/* 0x15a0 */   0,141, 68, 64,  8,137, 68, 36,200, 65,129,251,255,255,255,  0,
/* 0x15b0 */ 119, 26, 76, 57,231, 15,132,156,  3,  0,  0, 15,182,  7, 65,193,
/* 0x15c0 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 17,
/* 0x15d0 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,
/* 0x15e0 */  39, 65,137,195,184,  0,  8,  0,  0, 69, 49,237, 41,200,193,248,
/* 0x15f0 */   5,141,  4,  2,102, 65,137,  1, 72, 99, 68, 36,184, 72,193,224,
/* 0x1600 */   4, 77,141, 68,  1,  4,235,120, 65, 41,195, 65, 41,194,137,208,
/* 0x1610 */ 102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102, 65,
/* 0x1620 */ 137, 17,119, 26, 76, 57,231, 15,132, 42,  3,  0,  0, 15,182,  7,
/* 0x1630 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,
/* 0x1640 */ 183, 81,  2, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x1650 */  57,194,115, 52, 65,137,195,184,  0,  8,  0,  0, 65,189,  8,  0,
/* 0x1660 */   0,  0, 41,200,193,248,  5,141,  4,  2,102, 65,137, 65,  2, 72,
/* 0x1670 */  99, 68, 36,184, 72,193,224,  4, 77,141,132,  1,  4,  1,  0,  0,
/* 0x1680 */  65,185,  3,  0,  0,  0,235, 39, 65, 41,195, 65, 41,194,137,208,
/* 0x1690 */ 102,193,232,  5, 77,141,129,  4,  2,  0,  0, 65,189, 16,  0,  0,
/* 0x16a0 */   0,102, 41,194,102, 65,137, 81,  2, 65,185,  8,  0,  0,  0, 68,
/* 0x16b0 */ 137,203,189,  1,  0,  0,  0, 72, 99,197, 65,129,251,255,255,255,
/* 0x16c0 */   0, 73,141, 52, 64,119, 26, 76, 57,231, 15,132,135,  2,  0,  0,
/* 0x16d0 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x16e0 */ 194, 15,183, 14, 68,137,216,193,232, 11, 15,183,209, 15,175,194,
/* 0x16f0 */  65, 57,194,115, 23, 65,137,195,184,  0,  8,  0,  0,  1,237, 41,
/* 0x1700 */ 208,193,248,  5,141,  4,  1,102,137,  6,235, 22, 65, 41,195, 65,
/* 0x1710 */  41,194,137,200,102,193,232,  5,141,108, 45,  1,102, 41,193,102,
/* 0x1720 */ 137, 14,255,203,117,145,184,  1,  0,  0,  0, 68,137,201,211,224,
/* 0x1730 */  41,197, 68,  1,237,131,124, 36,200,  3, 15,143,194,  1,  0,  0,
/* 0x1740 */ 131, 68, 36,200,  7,184,  3,  0,  0,  0,131,253,  4, 15, 76,197,
/* 0x1750 */  72,139, 92, 36,216, 65,184,  1,  0,  0,  0, 72,152, 72,193,224,
/* 0x1760 */   7, 76,141,140,  3, 96,  3,  0,  0,187,  6,  0,  0,  0, 73, 99,
/* 0x1770 */ 192, 65,129,251,255,255,255,  0, 73,141, 52, 65,119, 26, 76, 57,
/* 0x1780 */ 231, 15,132,208,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x1790 */ 227,  8, 72,255,199, 65,  9,194, 15,183, 22, 68,137,216,193,232,
/* 0x17a0 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,
/* 0x17b0 */   0,  8,  0,  0, 69,  1,192, 41,200,193,248,  5,141,  4,  2,102,
/* 0x17c0 */ 137,  6,235, 23, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x17d0 */  71,141, 68,  0,  1,102, 41,194,102,137, 22,255,203,117,143, 65,
/* 0x17e0 */ 131,232, 64, 65,131,248,  3, 69,137,198, 15,142, 13,  1,  0,  0,
/* 0x17f0 */  65,131,230,  1, 68,137,192,209,248, 65,131,206,  2, 65,131,248,
/* 0x1800 */  13,141,112,255,127, 35,137,241, 72,139, 92, 36,216, 73, 99,192,
/* 0x1810 */  65,211,230, 72,  1,192, 68,137,242, 72,141, 20, 83, 72, 41,194,
/* 0x1820 */  76,141,138, 94,  5,  0,  0,235, 81,141,112,251, 65,129,251,255,
/* 0x1830 */ 255,255,  0,119, 26, 76, 57,231, 15,132, 25,  1,  0,  0, 15,182,
/* 0x1840 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,
/* 0x1850 */ 209,235, 69,  1,246, 69, 57,218,114,  7, 69, 41,218, 65,131,206,
/* 0x1860 */   1,255,206,117,199, 76,139, 76, 36,216, 65,193,230,  4,190,  4,
/* 0x1870 */   0,  0,  0, 73,129,193, 68,  6,  0,  0, 65,189,  1,  0,  0,  0,
/* 0x1880 */ 187,  1,  0,  0,  0, 72, 99,195, 65,129,251,255,255,255,  0, 77,
/* 0x1890 */ 141,  4, 65,119, 26, 76, 57,231, 15,132,185,  0,  0,  0, 15,182,
/* 0x18a0 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,
/* 0x18b0 */  15,183, 16, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x18c0 */  57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,219, 41,200,
/* 0x18d0 */ 193,248,  5,141,  4,  2,102, 65,137,  0,235, 26, 65, 41,195, 65,
/* 0x18e0 */  41,194,137,208,102,193,232,  5,141, 92, 27,  1, 69,  9,238,102,
/* 0x18f0 */  41,194,102, 65,137, 16, 69,  1,237,255,206,117,136, 65,255,198,
/* 0x1900 */ 116, 64,131,197,  2, 69, 57,254,119, 77, 72,139, 84, 36,232, 68,
/* 0x1910 */ 137,248, 68, 41,240, 68, 15,182, 44,  2, 68,137,248, 65,255,199,
/* 0x1920 */ 255,205, 68,136, 44,  2, 15,149,194, 49,192, 68, 59,124, 36,228,
/* 0x1930 */  15,146,192,133,194,117,211, 68, 59,124, 36,228, 15,130, 69,247,
/* 0x1940 */ 255,255, 65,129,251,255,255,255,  0,119, 22, 76, 57,231,184,  1,
/* 0x1950 */   0,  0,  0,116, 35,235,  7,184,  1,  0,  0,  0,235, 26, 72,255,
/* 0x1960 */ 199,137,248, 43, 68, 36,248, 72,139, 76, 36,240, 72,139, 92, 36,
/* 0x1970 */  56,137,  1, 68,137, 59, 49,192, 91, 93, 65, 92, 65, 93, 65, 94,
/* 0x1980 */  65, 95, 65, 87, 72,141, 71,  4, 69, 49,255, 65, 86, 65,190,  1,
/* 0x1990 */   0,  0,  0, 65, 85, 69, 49,237, 65, 84, 85, 83, 72,137, 76, 36,
/* 0x19a0 */ 240, 72,137, 68, 36,216,184,  1,  0,  0,  0, 72,137,116, 36,248,
/* 0x19b0 */  76,137, 68, 36,232,137,195, 68,137, 76, 36,228, 15,182, 79,  2,
/* 0x19c0 */ 211,227,137,217, 72,139, 92, 36, 56,255,201,137, 76, 36,212, 15,
/* 0x19d0 */ 182, 79,  1,211,224, 72,139, 76, 36,240,255,200,137, 68, 36,208,
/* 0x19e0 */  15,182,  7,199,  1,  0,  0,  0,  0,199, 68, 36,200,  0,  0,  0,
/* 0x19f0 */   0,199, 68, 36,196,  1,  0,  0,  0,199, 68, 36,192,  1,  0,  0,
/* 0x1a00 */   0,199, 68, 36,188,  1,  0,  0,  0,199,  3,  0,  0,  0,  0,137,
/* 0x1a10 */  68, 36,204, 15,182, 79,  1,  1,193,184,  0,  3,  0,  0,211,224,
/* 0x1a20 */  49,201,141,184, 54,  7,  0,  0, 65, 57,255,115, 19, 72,139, 92,
/* 0x1a30 */  36,216,137,200,255,193, 57,249,102,199,  4, 67,  0,  4,235,235,
/* 0x1a40 */  72,139,124, 36,248,137,208, 69, 49,210, 65,131,203,255, 49,210,
/* 0x1a50 */  73,137,252, 73,  1,196, 76, 57,231, 15,132,239,  8,  0,  0, 15,
/* 0x1a60 */ 182,  7, 65,193,226,  8,255,194, 72,255,199, 65,  9,194,131,250,
/* 0x1a70 */   4,126,227, 68, 59,124, 36,228, 15,131,218,  8,  0,  0,139, 68,
/* 0x1a80 */  36,212, 72, 99, 92, 36,200, 72,139, 84, 36,216, 68, 33,248,137,
/* 0x1a90 */  68, 36,184, 72, 99,108, 36,184, 72,137,216, 72,193,224,  4, 72,
/* 0x1aa0 */   1,232, 65,129,251,255,255,255,  0, 76,141, 12, 66,119, 26, 76,
/* 0x1ab0 */  57,231, 15,132,150,  8,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x1ac0 */ 193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,
/* 0x1ad0 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,131,197,  1,
/* 0x1ae0 */   0,  0, 65,137,195,184,  0,  8,  0,  0, 72,139, 92, 36,216, 41,
/* 0x1af0 */ 200, 15,182, 76, 36,204,190,  1,  0,  0,  0,193,248,  5,141,  4,
/* 0x1b00 */   2, 65, 15,182,213,102, 65,137,  1,139, 68, 36,208, 68, 33,248,
/* 0x1b10 */ 211,224,185,  8,  0,  0,  0, 43, 76, 36,204,211,250,  1,208,105,
/* 0x1b20 */ 192,  0,  3,  0,  0,131,124, 36,200,  6,137,192, 76,141,140, 67,
/* 0x1b30 */ 108, 14,  0,  0, 15,142,184,  0,  0,  0, 72,139, 84, 36,232, 68,
/* 0x1b40 */ 137,248, 68, 41,240, 15,182, 44,  2,  1,237, 72, 99,214,137,235,
/* 0x1b50 */ 129,227,  0,  1,  0,  0, 65,129,251,255,255,255,  0, 72, 99,195,
/* 0x1b60 */  73,141,  4, 65, 76,141,  4, 80,119, 26, 76, 57,231, 15,132,219,
/* 0x1b70 */   7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x1b80 */ 199, 65,  9,194, 65, 15,183,144,  0,  2,  0,  0, 68,137,216,193,
/* 0x1b90 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,137,195,
/* 0x1ba0 */ 184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,133,219,141,  4,
/* 0x1bb0 */   2,102, 65,137,128,  0,  2,  0,  0,116, 33,235, 45, 65, 41,195,
/* 0x1bc0 */  65, 41,194,137,208,102,193,232,  5,141,116, 54,  1,102, 41,194,
/* 0x1bd0 */ 133,219,102, 65,137,144,  0,  2,  0,  0,116, 14,129,254,255,  0,
/* 0x1be0 */   0,  0, 15,142, 97,255,255,255,235,120,129,254,255,  0,  0,  0,
/* 0x1bf0 */ 127,112, 72, 99,198, 65,129,251,255,255,255,  0, 77,141,  4, 65,
/* 0x1c00 */ 119, 26, 76, 57,231, 15,132, 67,  7,  0,  0, 15,182,  7, 65,193,
/* 0x1c10 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16,
/* 0x1c20 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,
/* 0x1c30 */  24, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,
/* 0x1c40 */ 141,  4,  2,102, 65,137,  0,235,161, 65, 41,195, 65, 41,194,137,
/* 0x1c50 */ 208,102,193,232,  5,141,116, 54,  1,102, 41,194,102, 65,137, 16,
/* 0x1c60 */ 235,136, 72,139, 76, 36,232, 68,137,248, 65,255,199, 65,137,245,
/* 0x1c70 */  64,136, 52,  1,131,124, 36,200,  3,127, 13,199, 68, 36,200,  0,
/* 0x1c80 */   0,  0,  0,233,166,  6,  0,  0,139, 84, 36,200,139, 68, 36,200,
/* 0x1c90 */ 131,234,  3,131,232,  6,131,124, 36,200,  9, 15, 79,208,137, 84,
/* 0x1ca0 */  36,200,233,135,  6,  0,  0, 65, 41,195, 65, 41,194,137,208,102,
/* 0x1cb0 */ 193,232,  5,102, 41,194, 72,139, 68, 36,216, 65,129,251,255,255,
/* 0x1cc0 */ 255,  0,102, 65,137, 17, 72,141, 52, 88,119, 26, 76, 57,231, 15,
/* 0x1cd0 */ 132,121,  6,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x1ce0 */  72,255,199, 65,  9,194, 15,183,150,128,  1,  0,  0, 68,137,216,
/* 0x1cf0 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 78, 65,137,
/* 0x1d00 */ 195,184,  0,  8,  0,  0, 76,139, 76, 36,216, 41,200,139, 76, 36,
/* 0x1d10 */ 196, 68,137,116, 36,196,193,248,  5,141,  4,  2,139, 84, 36,192,
/* 0x1d20 */ 137, 76, 36,192,102,137,134,128,  1,  0,  0, 49,192,131,124, 36,
/* 0x1d30 */ 200,  6,137, 84, 36,188, 15,159,192, 73,129,193,100,  6,  0,  0,
/* 0x1d40 */ 141,  4, 64,137, 68, 36,200,233, 84,  2,  0,  0, 65, 41,195, 65,
/* 0x1d50 */  41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,
/* 0x1d60 */ 255,  0,102,137,150,128,  1,  0,  0,119, 26, 76, 57,231, 15,132,
/* 0x1d70 */ 218,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x1d80 */ 255,199, 65,  9,194, 15,183,150,152,  1,  0,  0, 68,137,216,193,
/* 0x1d90 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,131,208,  0,  0,
/* 0x1da0 */   0, 65,184,  0,  8,  0,  0, 65,137,195, 72,193,227,  5, 68,137,
/* 0x1db0 */ 192, 41,200,193,248,  5,141,  4,  2,102,137,134,152,  1,  0,  0,
/* 0x1dc0 */  72,139, 68, 36,216, 72,  1,216, 65,129,251,255,255,255,  0, 72,
/* 0x1dd0 */ 141, 52,104,119, 26, 76, 57,231, 15,132,112,  5,  0,  0, 15,182,
/* 0x1de0 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,
/* 0x1df0 */ 183,150,224,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x1e00 */ 175,193, 65, 57,194,115, 79, 65, 41,200, 65,137,195, 65,193,248,
/* 0x1e10 */   5, 69,133,255, 66,141,  4,  2,102,137,134,224,  1,  0,  0, 15,
/* 0x1e20 */ 132, 41,  5,  0,  0, 49,192,131,124, 36,200,  6, 72,139, 92, 36,
/* 0x1e30 */ 232, 15,159,192,141, 68,  0,  9,137, 68, 36,200, 68,137,248, 68,
/* 0x1e40 */  41,240, 68, 15,182, 44,  3, 68,137,248, 65,255,199, 68,136, 44,
/* 0x1e50 */   3,233,216,  4,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x1e60 */ 232,  5,102, 41,194,102,137,150,224,  1,  0,  0,233, 17,  1,  0,
/* 0x1e70 */   0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,
/* 0x1e80 */  65,129,251,255,255,255,  0,102,137,150,152,  1,  0,  0,119, 26,
/* 0x1e90 */  76, 57,231, 15,132,181,  4,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x1ea0 */  65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,176,  1,  0,
/* 0x1eb0 */   0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x1ec0 */ 115, 32, 65,137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,
/* 0x1ed0 */   4,  2,102,137,134,176,  1,  0,  0,139, 68, 36,196,233,152,  0,
/* 0x1ee0 */   0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,
/* 0x1ef0 */ 194, 65,129,251,255,255,255,  0,102,137,150,176,  1,  0,  0,119,
/* 0x1f00 */  26, 76, 57,231, 15,132, 68,  4,  0,  0, 15,182,  7, 65,193,226,
/* 0x1f10 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,200,  1,
/* 0x1f20 */   0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x1f30 */ 194,115, 29, 65,137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,
/* 0x1f40 */ 141,  4,  2,102,137,134,200,  1,  0,  0,139, 68, 36,192,235, 34,
/* 0x1f50 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,139,
/* 0x1f60 */  68, 36,188,102,137,150,200,  1,  0,  0,139, 84, 36,192,137, 84,
/* 0x1f70 */  36,188,139, 76, 36,196,137, 76, 36,192, 68,137,116, 36,196, 65,
/* 0x1f80 */ 137,198, 49,192,131,124, 36,200,  6, 76,139, 76, 36,216, 15,159,
/* 0x1f90 */ 192, 73,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36,200,
/* 0x1fa0 */  65,129,251,255,255,255,  0,119, 26, 76, 57,231, 15,132,156,  3,
/* 0x1fb0 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x1fc0 */  65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,183,202,
/* 0x1fd0 */  15,175,193, 65, 57,194,115, 39, 65,137,195,184,  0,  8,  0,  0,
/* 0x1fe0 */  69, 49,237, 41,200,193,248,  5,141,  4,  2,102, 65,137,  1, 72,
/* 0x1ff0 */  99, 68, 36,184, 72,193,224,  4, 77,141, 68,  1,  4,235,120, 65,
/* 0x2000 */  41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,
/* 0x2010 */ 251,255,255,255,  0,102, 65,137, 17,119, 26, 76, 57,231, 15,132,
/* 0x2020 */  42,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x2030 */ 255,199, 65,  9,194, 65, 15,183, 81,  2, 68,137,216,193,232, 11,
/* 0x2040 */  15,183,202, 15,175,193, 65, 57,194,115, 52, 65,137,195,184,  0,
/* 0x2050 */   8,  0,  0, 65,189,  8,  0,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x2060 */   2,102, 65,137, 65,  2, 72, 99, 68, 36,184, 72,193,224,  4, 77,
/* 0x2070 */ 141,132,  1,  4,  1,  0,  0, 65,185,  3,  0,  0,  0,235, 39, 65,
/* 0x2080 */  41,195, 65, 41,194,137,208,102,193,232,  5, 77,141,129,  4,  2,
/* 0x2090 */   0,  0, 65,189, 16,  0,  0,  0,102, 41,194,102, 65,137, 81,  2,
/* 0x20a0 */  65,185,  8,  0,  0,  0, 68,137,203,189,  1,  0,  0,  0, 72, 99,
/* 0x20b0 */ 197, 65,129,251,255,255,255,  0, 73,141, 52, 64,119, 26, 76, 57,
/* 0x20c0 */ 231, 15,132,135,  2,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x20d0 */ 227,  8, 72,255,199, 65,  9,194, 15,183, 14, 68,137,216,193,232,
/* 0x20e0 */  11, 15,183,209, 15,175,194, 65, 57,194,115, 23, 65,137,195,184,
/* 0x20f0 */   0,  8,  0,  0,  1,237, 41,208,193,248,  5,141,  4,  1,102,137,
/* 0x2100 */   6,235, 22, 65, 41,195, 65, 41,194,137,200,102,193,232,  5,141,
/* 0x2110 */ 108, 45,  1,102, 41,193,102,137, 14,255,203,117,145,184,  1,  0,
/* 0x2120 */   0,  0, 68,137,201,211,224, 41,197, 68,  1,237,131,124, 36,200,
/* 0x2130 */   3, 15,143,194,  1,  0,  0,131, 68, 36,200,  7,184,  3,  0,  0,
/* 0x2140 */   0,131,253,  4, 15, 76,197, 72,139, 92, 36,216, 65,184,  1,  0,
/* 0x2150 */   0,  0, 72,152, 72,193,224,  7, 76,141,140,  3, 96,  3,  0,  0,
/* 0x2160 */ 187,  6,  0,  0,  0, 73, 99,192, 65,129,251,255,255,255,  0, 73,
/* 0x2170 */ 141, 52, 65,119, 26, 76, 57,231, 15,132,208,  1,  0,  0, 15,182,
/* 0x2180 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,
/* 0x2190 */ 183, 22, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x21a0 */ 194,115, 24, 65,137,195,184,  0,  8,  0,  0, 69,  1,192, 41,200,
/* 0x21b0 */ 193,248,  5,141,  4,  2,102,137,  6,235, 23, 65, 41,195, 65, 41,
/* 0x21c0 */ 194,137,208,102,193,232,  5, 71,141, 68,  0,  1,102, 41,194,102,
/* 0x21d0 */ 137, 22,255,203,117,143, 65,131,232, 64, 65,131,248,  3, 69,137,
/* 0x21e0 */ 198, 15,142, 13,  1,  0,  0, 65,131,230,  1, 68,137,192,209,248,
/* 0x21f0 */  65,131,206,  2, 65,131,248, 13,141,112,255,127, 35,137,241, 72,
/* 0x2200 */ 139, 92, 36,216, 73, 99,192, 65,211,230, 72,  1,192, 68,137,242,
/* 0x2210 */  72,141, 20, 83, 72, 41,194, 76,141,138, 94,  5,  0,  0,235, 81,
/* 0x2220 */ 141,112,251, 65,129,251,255,255,255,  0,119, 26, 76, 57,231, 15,
/* 0x2230 */ 132, 25,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x2240 */  72,255,199, 65,  9,194, 65,209,235, 69,  1,246, 69, 57,218,114,
/* 0x2250 */   7, 69, 41,218, 65,131,206,  1,255,206,117,199, 76,139, 76, 36,
/* 0x2260 */ 216, 65,193,230,  4,190,  4,  0,  0,  0, 73,129,193, 68,  6,  0,
/* 0x2270 */   0, 65,189,  1,  0,  0,  0,187,  1,  0,  0,  0, 72, 99,195, 65,
/* 0x2280 */ 129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,
/* 0x2290 */ 132,185,  0,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x22a0 */  72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,232, 11,
/* 0x22b0 */  15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,
/* 0x22c0 */   8,  0,  0,  1,219, 41,200,193,248,  5,141,  4,  2,102, 65,137,
/* 0x22d0 */   0,235, 26, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,
/* 0x22e0 */  92, 27,  1, 69,  9,238,102, 41,194,102, 65,137, 16, 69,  1,237,
/* 0x22f0 */ 255,206,117,136, 65,255,198,116, 64,131,197,  2, 69, 57,254,119,
/* 0x2300 */  77, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 68, 15,182, 44,
/* 0x2310 */   2, 68,137,248, 65,255,199,255,205, 68,136, 44,  2, 15,149,194,
/* 0x2320 */  49,192, 68, 59,124, 36,228, 15,146,192,133,194,117,211, 68, 59,
/* 0x2330 */ 124, 36,228, 15,130, 69,247,255,255, 65,129,251,255,255,255,  0,
/* 0x2340 */ 119, 22, 76, 57,231,184,  1,  0,  0,  0,116, 35,235,  7,184,  1,
/* 0x2350 */   0,  0,  0,235, 26, 72,255,199,137,248, 43, 68, 36,248, 72,139,
/* 0x2360 */  76, 36,240, 72,139, 92, 36, 56,137,  1, 68,137, 59, 49,192, 91,
/* 0x2370 */  93, 65, 92, 65, 93, 65, 94, 65, 95, 72,139,117,248, 72,139,125,
/* 0x2380 */   8,139, 75,  4, 72,  1,206,139, 19, 72,  1,215,201,233,  0,  0,
/* 0x2390 */   0,  0,  0,  0, 68,137,193,131,200,255,204,244, 88, 72, 41,199,
/* 0x23a0 */  88, 89,137, 57, 72, 41,240,195,117,112,120,  0, 47,100,101,118,
/* 0x23b0 */  47,115,104,109,  0,117,112,120,  0,117,112,120,  0,  0, 46,115,
/* 0x23c0 */ 121,109,116, 97, 98,  0, 46,115,116,114,116, 97, 98,  0, 46,115,
/* 0x23d0 */ 104,115,116,114,116, 97, 98,  0, 46,114,101,108, 97, 46,116,101,
/* 0x23e0 */ 120,116,  0, 46,114,101,108, 97, 85, 77, 70, 95, 76, 73, 78, 85,
/* 0x23f0 */  88,  0, 46,114,101,108, 97, 83, 89, 83, 67, 65, 76, 76, 83,  0,
/* 0x2400 */  69, 88, 80, 95, 72, 69, 65, 68,  0, 46,114,101,108, 97, 78, 82,
/* 0x2410 */  86, 50, 69,  0, 46,114,101,108, 97, 78, 82, 86, 50, 68,  0, 46,
/* 0x2420 */ 114,101,108, 97, 78, 82, 86, 50, 66,  0, 46,114,101,108, 97, 76,
/* 0x2430 */  90, 77, 65, 95, 68, 65, 73, 83, 89,  0, 76, 90, 77, 65, 95, 69,
/* 0x2440 */  76, 70, 48, 48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  0,
/* 0x2450 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  0, 46,114,101,108, 97,
/* 0x2460 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  0, 69, 88, 80, 95, 84,
/* 0x2470 */  65, 73, 76,  0, 83, 84, 82, 67, 79, 78,  0,  0,  0,  0,  0,  0,
/* 0x2480 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2490 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24c0 */  32,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x24d0 */   0,  0,  0,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0,  0,  0,
/* 0x24e0 */ 187,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24f0 */   8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2500 */  27,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2510 */   0,  0,  0,  0,  0,  0,  0,  0,160, 47,  0,  0,  0,  0,  0,  0,
/* 0x2520 */ 192,  3,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  1,  0,  0,  0,
/* 0x2530 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2540 */  43,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x2550 */   0,  0,  0,  0,  0,  0,  0,  0,252,  9,  0,  0,  0,  0,  0,  0,
/* 0x2560 */ 212,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2570 */   4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2580 */  38,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2590 */   0,  0,  0,  0,  0,  0,  0,  0, 96, 51,  0,  0,  0,  0,  0,  0,
/* 0x25a0 */ 192,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  3,  0,  0,  0,
/* 0x25b0 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x25c0 */  58,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x25d0 */   0,  0,  0,  0,  0,  0,  0,  0,208, 10,  0,  0,  0,  0,  0,  0,
/* 0x25e0 */ 220,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x25f0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2600 */  53,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2610 */   0,  0,  0,  0,  0,  0,  0,  0, 32, 52,  0,  0,  0,  0,  0,  0,
/* 0x2620 */ 144,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  5,  0,  0,  0,
/* 0x2630 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2640 */  67,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2650 */   0,  0,  0,  0,  0,  0,  0,  0,172, 11,  0,  0,  0,  0,  0,  0,
/* 0x2660 */ 233,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2670 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2680 */  81,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2690 */   0,  0,  0,  0,  0,  0,  0,  0,149, 12,  0,  0,  0,  0,  0,  0,
/* 0x26a0 */ 232,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x26b0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x26c0 */  76,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x26d0 */   0,  0,  0,  0,  0,  0,  0,  0,176, 52,  0,  0,  0,  0,  0,  0,
/* 0x26e0 */  48,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  8,  0,  0,  0,
/* 0x26f0 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2700 */  92,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2710 */   0,  0,  0,  0,  0,  0,  0,  0,125, 13,  0,  0,  0,  0,  0,  0,
/* 0x2720 */ 219,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2730 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2740 */  87,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2750 */   0,  0,  0,  0,  0,  0,  0,  0,224, 52,  0,  0,  0,  0,  0,  0,
/* 0x2760 */  48,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 10,  0,  0,  0,
/* 0x2770 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2780 */ 103,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2790 */   0,  0,  0,  0,  0,  0,  0,  0, 88, 14,  0,  0,  0,  0,  0,  0,
/* 0x27a0 */ 196,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x27b0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x27c0 */  98,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x27d0 */   0,  0,  0,  0,  0,  0,  0,  0, 16, 53,  0,  0,  0,  0,  0,  0,
/* 0x27e0 */  48,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 12,  0,  0,  0,
/* 0x27f0 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2800 */ 114,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2810 */   0,  0,  0,  0,  0,  0,  0,  0, 28, 15,  0,  0,  0,  0,  0,  0,
/* 0x2820 */  10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2830 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2840 */ 109,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2850 */   0,  0,  0,  0,  0,  0,  0,  0, 64, 53,  0,  0,  0,  0,  0,  0,
/* 0x2860 */  24,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 14,  0,  0,  0,
/* 0x2870 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2880 */ 125,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2890 */   0,  0,  0,  0,  0,  0,  0,  0, 38, 15,  0,  0,  0,  0,  0,  0,
/* 0x28a0 */ 101,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28b0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28c0 */ 136,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28d0 */   0,  0,  0,  0,  0,  0,  0,  0,139, 15,  0,  0,  0,  0,  0,  0,
/* 0x28e0 */ 247,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28f0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2900 */ 147,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2910 */   0,  0,  0,  0,  0,  0,  0,  0,130, 25,  0,  0,  0,  0,  0,  0,
/* 0x2920 */ 247,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2930 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2940 */ 163,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2950 */   0,  0,  0,  0,  0,  0,  0,  0,121, 35,  0,  0,  0,  0,  0,  0,
/* 0x2960 */  25,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2970 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2980 */ 158,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2990 */   0,  0,  0,  0,  0,  0,  0,  0, 88, 53,  0,  0,  0,  0,  0,  0,
/* 0x29a0 */  24,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 19,  0,  0,  0,
/* 0x29b0 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x29c0 */ 174,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x29d0 */   0,  0,  0,  0,  0,  0,  0,  0,148, 35,  0,  0,  0,  0,  0,  0,
/* 0x29e0 */  20,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x29f0 */   4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a00 */ 183,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a10 */   0,  0,  0,  0,  0,  0,  0,  0,168, 35,  0,  0,  0,  0,  0,  0,
/* 0x2a20 */  21,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a30 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a40 */  17,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a50 */   0,  0,  0,  0,  0,  0,  0,  0,189, 35,  0,  0,  0,  0,  0,  0,
/* 0x2a60 */ 190,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a70 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a80 */   1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a90 */   0,  0,  0,  0,  0,  0,  0,  0,  0, 43,  0,  0,  0,  0,  0,  0,
/* 0x2aa0 */ 192,  3,  0,  0,  0,  0,  0,  0, 25,  0,  0,  0, 15,  0,  0,  0,
/* 0x2ab0 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ac0 */   9,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ad0 */   0,  0,  0,  0,  0,  0,  0,  0,192, 46,  0,  0,  0,  0,  0,  0,
/* 0x2ae0 */ 217,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2af0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,
/* 0x2b20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b30 */   0,  0,  0,  0,  3,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  7,  0,
/* 0x2b50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b60 */   0,  0,  0,  0,  3,  0, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 21,  0,
/* 0x2b80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b90 */   0,  0,  0,  0,  3,  0, 22,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ba0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  3,  0,
/* 0x2bb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bc0 */   0,  0,  0,  0,  3,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 10,  0,
/* 0x2be0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bf0 */   0,  0,  0,  0,  3,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 14,  0,
/* 0x2c10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c20 */   0,  0,  0,  0,  3,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 17,  0,
/* 0x2c40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c50 */   0,  0,  0,  0,  3,  0, 18,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c60 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0, 16,  0,  5,  0,
/* 0x2c70 */  74,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c80 */   6,  0,  0,  0, 16,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c90 */   0,  0,  0,  0,  0,  0,  0,  0, 15,  0,  0,  0, 16,  0,  1,  0,
/* 0x2ca0 */  92,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cb0 */  29,  0,  0,  0, 16,  0,  5,  0,180,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cc0 */   0,  0,  0,  0,  0,  0,  0,  0, 36,  0,  0,  0, 16,  0, 21,  0,
/* 0x2cd0 */  20,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ce0 */  52,  0,  0,  0, 16,  0,  5,  0,118,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cf0 */   0,  0,  0,  0,  0,  0,  0,  0, 58,  0,  0,  0, 16,  0,  5,  0,
/* 0x2d00 */ 196,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d10 */  68,  0,  0,  0, 16,  0,  5,  0, 91,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d20 */   0,  0,  0,  0,  0,  0,  0,  0, 73,  0,  0,  0, 18,  0,  3,  0,
/* 0x2d30 */   0,  0,  0,  0,  0,  0,  0,  0,212,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d40 */  95,  0,  0,  0, 16,  0,  5,  0,212,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d50 */   0,  0,  0,  0,  0,  0,  0,  0,101,  0,  0,  0, 18,  0,  1,  0,
/* 0x2d60 */ 134,  8,  0,  0,  0,  0,  0,  0, 53,  1,  0,  0,  0,  0,  0,  0,
/* 0x2d70 */ 111,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d80 */   0,  0,  0,  0,  0,  0,  0,  0,124,  0,  0,  0, 16,  0,  5,  0,
/* 0x2d90 */ 216,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2da0 */ 129,  0,  0,  0, 18,  0,  1,  0,194,  2,  0,  0,  0,  0,  0,  0,
/* 0x2db0 */  75,  0,  0,  0,  0,  0,  0,  0,138,  0,  0,  0, 16,  0,  5,  0,
/* 0x2dc0 */ 208,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2dd0 */ 144,  0,  0,  0, 16,  0,  5,  0, 17,  0,  0,  0,  0,  0,  0,  0,
/* 0x2de0 */   0,  0,  0,  0,  0,  0,  0,  0,157,  0,  0,  0, 16,  0,  5,  0,
/* 0x2df0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e00 */ 165,  0,  0,  0, 16,  0,  5,  0,143,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e10 */   0,  0,  0,  0,  0,  0,  0,  0,174,  0,  0,  0, 16,  0,  5,  0,
/* 0x2e20 */ 212,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e30 */ 181,  0,  0,  0, 16,  0,  5,  0,164,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e40 */   0,  0,  0,  0,  0,  0,  0,  0,188,  0,  0,  0, 16,  0,  5,  0,
/* 0x2e50 */ 184,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e60 */ 193,  0,  0,  0, 16,  0,  5,  0,188,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e70 */   0,  0,  0,  0,  0,  0,  0,  0,197,  0,  0,  0, 16,  0,  5,  0,
/* 0x2e80 */ 200,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e90 */ 202,  0,  0,  0, 16,  0,  5,  0,204,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ea0 */   0,  0,  0,  0,  0,  0,  0,  0,211,  0,  0,  0, 16,  0,  5,  0,
/* 0x2eb0 */ 192,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ec0 */   0, 80,109, 97,112,  0,102, 95,101,120,112, 97,110,100,  0,103,
/* 0x2ed0 */ 101,116, 95,112, 97,103,101, 95,109, 97,115,107,  0,109,117,110,
/* 0x2ee0 */ 109, 97,112,  0,117,112,120, 95,109,109, 97,112, 95, 97,110,100,
/* 0x2ef0 */  95,102,100,  0, 80,115,121,110, 99,  0,102,116,114,117,110, 99,
/* 0x2f00 */  97,116,101,  0,109,109, 97,112,  0,117,112,120, 95,109,109, 97,
/* 0x2f10 */ 112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120,  0,119,
/* 0x2f20 */ 114,105,116,101,  0,117,112,120, 95,109, 97,105,110, 50,  0,109,
/* 0x2f30 */ 101,109,102,100, 95, 99,114,101, 97,116,101,  0,114,101, 97,100,
/* 0x2f40 */   0,117,110,100,101,114,108, 97,121,  0,109,115,121,110, 99,  0,
/* 0x2f50 */ 117,112,120,102,100, 95, 99,114,101, 97,116,101,  0,109,121, 95,
/* 0x2f60 */  98,107,112,116,  0, 80,112,114,111,116,101, 99,116,  0, 80,119,
/* 0x2f70 */ 114,105,116,101,  0, 80,117,110,109, 97,112,  0,101,120,105,116,
/* 0x2f80 */   0, 98,114,107,  0,111,112,101,110,  0,109,112,114,111,116,101,
/* 0x2f90 */  99,116,  0, 99,108,111,115,101,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fa0 */ 120,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  2,  0,  0,  0,
/* 0x2fb0 */ 254,255,255,255,255,255,255,255,127,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fc0 */   2,  0,  0,  0, 37,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2fd0 */   8,  1,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 25,  0,  0,  0,
/* 0x2fe0 */ 252,255,255,255,255,255,255,255, 37,  1,  0,  0,  0,  0,  0,  0,
/* 0x2ff0 */   2,  0,  0,  0, 36,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3000 */  45,  1,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 18,  0,  0,  0,
/* 0x3010 */ 252,255,255,255,255,255,255,255, 73,  1,  0,  0,  0,  0,  0,  0,
/* 0x3020 */   2,  0,  0,  0, 22,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3030 */  80,  1,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 39,  0,  0,  0,
/* 0x3040 */ 252,255,255,255,255,255,255,255,120,  1,  0,  0,  0,  0,  0,  0,
/* 0x3050 */   4,  0,  0,  0, 35,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3060 */ 238,  1,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 35,  0,  0,  0,
/* 0x3070 */ 252,255,255,255,255,255,255,255, 25,  2,  0,  0,  0,  0,  0,  0,
/* 0x3080 */   4,  0,  0,  0, 16,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3090 */ 182,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 35,  0,  0,  0,
/* 0x30a0 */ 252,255,255,255,255,255,255,255,242,  2,  0,  0,  0,  0,  0,  0,
/* 0x30b0 */   4,  0,  0,  0, 22,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x30c0 */ 130,  3,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 18,  0,  0,  0,
/* 0x30d0 */ 252,255,255,255,255,255,255,255,192,  3,  0,  0,  0,  0,  0,  0,
/* 0x30e0 */   4,  0,  0,  0, 17,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x30f0 */ 100,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 22,  0,  0,  0,
/* 0x3100 */ 252,255,255,255,255,255,255,255,143,  4,  0,  0,  0,  0,  0,  0,
/* 0x3110 */   4,  0,  0,  0, 18,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3120 */ 161,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 18,  0,  0,  0,
/* 0x3130 */ 252,255,255,255,255,255,255,255,184,  4,  0,  0,  0,  0,  0,  0,
/* 0x3140 */   4,  0,  0,  0, 17,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3150 */ 249,  5,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  6,  0,  0,  0,
/* 0x3160 */   9,  0,  0,  0,  0,  0,  0,  0,254,  5,  0,  0,  0,  0,  0,  0,
/* 0x3170 */   4,  0,  0,  0, 30,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3180 */  12,  6,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 21,  0,  0,  0,
/* 0x3190 */ 252,255,255,255,255,255,255,255, 73,  6,  0,  0,  0,  0,  0,  0,
/* 0x31a0 */   4,  0,  0,  0, 22,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x31b0 */ 115,  6,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 22,  0,  0,  0,
/* 0x31c0 */ 252,255,255,255,255,255,255,255, 62,  7,  0,  0,  0,  0,  0,  0,
/* 0x31d0 */   2,  0,  0,  0,  6,  0,  0,  0, 13,  0,  0,  0,  0,  0,  0,  0,
/* 0x31e0 */  67,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 30,  0,  0,  0,
/* 0x31f0 */ 252,255,255,255,255,255,255,255, 86,  7,  0,  0,  0,  0,  0,  0,
/* 0x3200 */   4,  0,  0,  0, 24,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3210 */ 114,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 22,  0,  0,  0,
/* 0x3220 */ 252,255,255,255,255,255,255,255,124,  7,  0,  0,  0,  0,  0,  0,
/* 0x3230 */   4,  0,  0,  0, 39,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3240 */ 164,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 20,  0,  0,  0,
/* 0x3250 */ 252,255,255,255,255,255,255,255,175,  7,  0,  0,  0,  0,  0,  0,
/* 0x3260 */   4,  0,  0,  0, 18,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3270 */ 203,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 22,  0,  0,  0,
/* 0x3280 */ 252,255,255,255,255,255,255,255,217,  7,  0,  0,  0,  0,  0,  0,
/* 0x3290 */   4,  0,  0,  0, 39,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x32a0 */ 241,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 32,  0,  0,  0,
/* 0x32b0 */ 252,255,255,255,255,255,255,255,255,  7,  0,  0,  0,  0,  0,  0,
/* 0x32c0 */   4,  0,  0,  0, 35,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x32d0 */  40,  8,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 22,  0,  0,  0,
/* 0x32e0 */ 252,255,255,255,255,255,255,255,224,  8,  0,  0,  0,  0,  0,  0,
/* 0x32f0 */   4,  0,  0,  0, 17,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3300 */  52,  9,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 37,  0,  0,  0,
/* 0x3310 */ 252,255,255,255,255,255,255,255, 73,  9,  0,  0,  0,  0,  0,  0,
/* 0x3320 */   4,  0,  0,  0, 27,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3330 */  91,  9,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 35,  0,  0,  0,
/* 0x3340 */ 252,255,255,255,255,255,255,255,141,  9,  0,  0,  0,  0,  0,  0,
/* 0x3350 */   4,  0,  0,  0, 39,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3360 */  33,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  6,  0,  0,  0,
/* 0x3370 */ 252,255,255,255,255,255,255,255, 46,  0,  0,  0,  0,  0,  0,  0,
/* 0x3380 */   4,  0,  0,  0, 26,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3390 */  66,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 26,  0,  0,  0,
/* 0x33a0 */ 252,255,255,255,255,255,255,255, 79,  0,  0,  0,  0,  0,  0,  0,
/* 0x33b0 */   2,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x33c0 */  94,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 37,  0,  0,  0,
/* 0x33d0 */ 252,255,255,255,255,255,255,255,113,  0,  0,  0,  0,  0,  0,  0,
/* 0x33e0 */   4,  0,  0,  0, 21,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x33f0 */ 157,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 22,  0,  0,  0,
/* 0x3400 */ 252,255,255,255,255,255,255,255,165,  0,  0,  0,  0,  0,  0,  0,
/* 0x3410 */   4,  0,  0,  0, 17,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3420 */  77,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  0,  0,  0,
/* 0x3430 */ 252,255,255,255,255,255,255,255,120,  0,  0,  0,  0,  0,  0,  0,
/* 0x3440 */   2,  0,  0,  0,  1,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3450 */ 145,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  0,  0,  0,
/* 0x3460 */ 252,255,255,255,255,255,255,255,166,  0,  0,  0,  0,  0,  0,  0,
/* 0x3470 */   2,  0,  0,  0,  1,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3480 */ 139,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 29,  0,  0,  0,
/* 0x3490 */ 252,255,255,255,255,255,255,255,160,  0,  0,  0,  0,  0,  0,  0,
/* 0x34a0 */   2,  0,  0,  0, 38,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x34b0 */ 223,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,
/* 0x34c0 */ 165,  0,  0,  0,  0,  0,  0,  0,116,  0,  0,  0,  0,  0,  0,  0,
/* 0x34d0 */   2,  0,  0,  0,  5,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x34e0 */ 210,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,
/* 0x34f0 */ 165,  0,  0,  0,  0,  0,  0,  0,116,  0,  0,  0,  0,  0,  0,  0,
/* 0x3500 */   2,  0,  0,  0,  5,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x3510 */ 187,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,
/* 0x3520 */ 165,  0,  0,  0,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0,  0,  0,
/* 0x3530 */   2,  0,  0,  0,  5,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x3540 */   6,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  4,  0,  0,  0,
/* 0x3550 */  21,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0,  0,  0,  0,  0,
/* 0x3560 */   2,  0,  0,  0,  5,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x3570 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 54,
/* 0x3580 */  52, 45,120, 56, 54, 45, 54, 52, 10, 10, 83,101, 99,116,105,111,
/* 0x3590 */ 110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32,
/* 0x35a0 */  32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32,
/* 0x35b0 */  86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x35c0 */  32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x35d0 */  32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,
/* 0x35e0 */ 103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 46,116,
/* 0x35f0 */ 101,120,116, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 57, 98, 98,
/* 0x3600 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42, 42,
/* 0x3610 */  51, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32,
/* 0x3620 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 32, 32, 32, 32, 48,100,
/* 0x3630 */  52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 57,102, 99, 32, 32, 50,
/* 0x3640 */  42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x3650 */  50, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 32, 32, 32, 32, 32,
/* 0x3660 */  48,100, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97,100, 48, 32,
/* 0x3670 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3680 */  32, 32, 51, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 32, 32, 32,
/* 0x3690 */  32, 32, 48,101, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 98, 97,
/* 0x36a0 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x36b0 */  83, 10, 32, 32, 52, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32,
/* 0x36c0 */  32, 32, 32, 32, 48,101, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x36d0 */  99, 57, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x36e0 */  78, 84, 83, 10, 32, 32, 53, 32, 78, 82, 86, 50, 68, 32, 32, 32,
/* 0x36f0 */  32, 32, 32, 32, 32, 32, 48,100, 98, 32, 32, 48, 32, 32, 48, 32,
/* 0x3700 */  32, 48,100, 55,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3710 */  84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 78, 82, 86, 50, 66, 32,
/* 0x3720 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 99, 52, 32, 32, 48, 32, 32,
/* 0x3730 */  48, 32, 32, 48,101, 53, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3740 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32, 76, 90, 77, 65,
/* 0x3750 */  95, 68, 65, 73, 83, 89, 32, 32, 32, 32, 48, 97, 32, 32, 48, 32,
/* 0x3760 */  32, 48, 32, 32, 48,102, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3770 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 76, 90, 77,
/* 0x3780 */  65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 54, 53, 32, 32,
/* 0x3790 */  48, 32, 32, 48, 32, 32, 48,102, 50, 54, 32, 32, 50, 42, 42, 48,
/* 0x37a0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 76,
/* 0x37b0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 57,102,
/* 0x37c0 */  55, 32, 32, 48, 32, 32, 48, 32, 32, 48,102, 56, 98, 32, 32, 50,
/* 0x37d0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49,
/* 0x37e0 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32,
/* 0x37f0 */  48, 57,102, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 56,
/* 0x3800 */  50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3810 */  83, 10, 32, 49, 49, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x3820 */  32, 32, 32, 32, 48, 49, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3830 */  50, 51, 55, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3840 */  69, 78, 84, 83, 10, 32, 49, 50, 32, 69, 88, 80, 95, 84, 65, 73,
/* 0x3850 */  76, 32, 32, 32, 32, 32, 32, 48, 49, 52, 32, 32, 48, 32, 32, 48,
/* 0x3860 */  32, 32, 48, 50, 51, 57, 52, 32, 32, 50, 42, 42, 50, 32, 32, 67,
/* 0x3870 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32, 83, 84, 82, 67,
/* 0x3880 */  79, 78, 32, 32, 32, 32, 32, 32, 32, 32, 48, 49, 53, 32, 32, 48,
/* 0x3890 */  32, 32, 48, 32, 32, 48, 50, 51, 97, 56, 32, 32, 50, 42, 42, 48,
/* 0x38a0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79,
/* 0x38b0 */  76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x38c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x38d0 */  32, 32, 46,116,101,120,116, 32, 48, 32, 46,116,101,120,116, 10,
/* 0x38e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x38f0 */  32,108, 32, 32, 32, 32,100, 32, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x3900 */  83, 32, 48, 32, 83, 89, 83, 67, 65, 76, 76, 83, 10, 48, 48, 48,
/* 0x3910 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3920 */  32, 32, 32,100, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 48,
/* 0x3930 */  32, 69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x3940 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3950 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32,
/* 0x3960 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x3970 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3980 */  32,100, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 48, 32, 69,
/* 0x3990 */  88, 80, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x39a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x39b0 */  32, 83, 84, 82, 67, 79, 78, 32, 48, 32, 83, 84, 82, 67, 79, 78,
/* 0x39c0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x39d0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95, 76, 73,
/* 0x39e0 */  78, 85, 88, 32, 48, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10,
/* 0x39f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a00 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48,
/* 0x3a10 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a20 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3a30 */  78, 82, 86, 50, 68, 32, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x3a40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3a50 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78,
/* 0x3a60 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a70 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x3a80 */  77, 65, 95, 68, 65, 73, 83, 89, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x3a90 */  68, 65, 73, 83, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3aa0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x3ab0 */  90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65,
/* 0x3ac0 */  95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ad0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3ae0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77,
/* 0x3af0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b00 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3b10 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90,
/* 0x3b20 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b30 */  48, 48, 48, 48, 48, 48, 48, 52, 97, 32,103, 32, 32, 32, 32, 32,
/* 0x3b40 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 80,109, 97,
/* 0x3b50 */ 112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b60 */  48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72,
/* 0x3b70 */  69, 65, 68, 32, 48, 32,102, 95,101,120,112, 97,110,100, 10, 48,
/* 0x3b80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 53, 99, 32,
/* 0x3b90 */ 103, 32, 32, 32, 32, 32, 32, 32, 46,116,101,120,116, 32, 48, 32,
/* 0x3ba0 */ 103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48,
/* 0x3bb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 52, 32,103,
/* 0x3bc0 */  32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32,
/* 0x3bd0 */  48, 32,109,117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3be0 */  48, 48, 48, 48, 48, 48, 48, 49, 52, 32,103, 32, 32, 32, 32, 32,
/* 0x3bf0 */  32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 48, 32,117,112,120,
/* 0x3c00 */  95,109,109, 97,112, 95, 97,110,100, 95,102,100, 10, 48, 48, 48,
/* 0x3c10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 54, 32,103, 32,
/* 0x3c20 */  32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48,
/* 0x3c30 */  32, 80,115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c40 */  48, 48, 48, 48, 48, 99, 52, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x3c50 */  83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,102,116,114,117,110,
/* 0x3c60 */  99, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c70 */  48, 48, 48, 53, 98, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89,
/* 0x3c80 */  83, 67, 65, 76, 76, 83, 32, 48, 32,109,109, 97,112, 10, 48, 48,
/* 0x3c90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,
/* 0x3ca0 */  32, 32, 32, 32, 32, 70, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88,
/* 0x3cb0 */  32, 48,100, 52, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x3cc0 */ 100, 95,102,100, 95,108,105,110,117,120, 10, 48, 48, 48, 48, 48,
/* 0x3cd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48,100, 52, 32,103, 32, 32, 32,
/* 0x3ce0 */  32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,119,
/* 0x3cf0 */ 114,105,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d00 */  48, 48, 56, 56, 54, 32,103, 32, 32, 32, 32, 32, 70, 32, 46,116,
/* 0x3d10 */ 101,120,116, 32, 48, 49, 51, 53, 32,117,112,120, 95,109, 97,105,
/* 0x3d20 */ 110, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d30 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x3d40 */  42, 32, 48, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101,
/* 0x3d50 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,100,
/* 0x3d60 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x3d70 */  76, 83, 32, 48, 32,114,101, 97,100, 10, 48, 48, 48, 48, 48, 48,
/* 0x3d80 */  48, 48, 48, 48, 48, 48, 48, 50, 99, 50, 32,103, 32, 32, 32, 32,
/* 0x3d90 */  32, 70, 32, 46,116,101,120,116, 32, 48, 52, 98, 32,117,110,100,
/* 0x3da0 */ 101,114,108, 97,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3db0 */  48, 48, 48, 48,100, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x3dc0 */  89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,115,121,110, 99, 10,
/* 0x3dd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49,
/* 0x3de0 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x3df0 */  83, 32, 48, 32,117,112,120,102,100, 95, 99,114,101, 97,116,101,
/* 0x3e00 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e10 */  48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x3e20 */  76, 83, 32, 48, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48,
/* 0x3e30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56,102, 32,103, 32,
/* 0x3e40 */  32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48,
/* 0x3e50 */  32, 80,112,114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x3e60 */  48, 48, 48, 48, 48, 48, 48, 48,100, 52, 32,103, 32, 32, 32, 32,
/* 0x3e70 */  32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 80,119,
/* 0x3e80 */ 114,105,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e90 */  48, 48, 48, 97, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89,
/* 0x3ea0 */  83, 67, 65, 76, 76, 83, 32, 48, 32, 80,117,110,109, 97,112, 10,
/* 0x3eb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 56,
/* 0x3ec0 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x3ed0 */  83, 32, 48, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ee0 */  48, 48, 48, 48, 48, 48, 48, 98, 99, 32,103, 32, 32, 32, 32, 32,
/* 0x3ef0 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 98,114,107,
/* 0x3f00 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x3f10 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x3f20 */  76, 83, 32, 48, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x3f30 */  48, 48, 48, 48, 48, 48, 48, 48, 99, 99, 32,103, 32, 32, 32, 32,
/* 0x3f40 */  32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,112,
/* 0x3f50 */ 114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f60 */  48, 48, 48, 48, 48, 99, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f70 */  83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 99,108,111,115,101,
/* 0x3f80 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x3f90 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 46,116,101,120,116, 93,
/* 0x3fa0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3fb0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3fc0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x3fd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 88, 56,
/* 0x3fe0 */  54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 83, 89,
/* 0x3ff0 */  83, 67, 65, 76, 76, 83, 43, 48,120,102,102,102,102,102,102,102,
/* 0x4000 */ 102,102,102,102,102,102,102,102,101, 10, 48, 48, 48, 48, 48, 48,
/* 0x4010 */  48, 48, 48, 48, 48, 48, 48, 48, 55,102, 32, 82, 95, 88, 56, 54,
/* 0x4020 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,111,112,101,
/* 0x4030 */ 110, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4040 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4050 */  48, 48, 49, 48, 56, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4060 */  67, 51, 50, 32, 32, 32, 32, 32,117,112,120, 95,109, 97,105,110,
/* 0x4070 */  50, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4080 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4090 */  48, 48, 49, 50, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x40a0 */  67, 51, 50, 32, 32, 32, 32, 32, 98,114,107, 43, 48,120,102,102,
/* 0x40b0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48,
/* 0x40c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 50,100, 32,
/* 0x40d0 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x40e0 */  32, 32,109,117,110,109, 97,112, 43, 48,120,102,102,102,102,102,
/* 0x40f0 */ 102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48,
/* 0x4100 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 52, 57, 32, 82, 95, 88,
/* 0x4110 */  56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,109,
/* 0x4120 */ 109, 97,112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x4130 */ 102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4140 */  48, 48, 48, 48, 49, 53, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x4150 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 99,108,111,115,101, 43,
/* 0x4160 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4170 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4180 */  49, 55, 56, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x4190 */  51, 50, 32, 32, 32, 32,101,120,105,116, 43, 48,120,102,102,102,
/* 0x41a0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x41b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,101,101, 32, 82,
/* 0x41c0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x41d0 */  32,101,120,105,116, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x41e0 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x41f0 */  48, 48, 48, 48, 48, 48, 50, 49, 57, 32, 82, 95, 88, 56, 54, 95,
/* 0x4200 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,102, 95,101,120,
/* 0x4210 */ 112, 97,110,100, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4220 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4230 */  48, 48, 48, 48, 48, 50, 98, 54, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4240 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,101,120,105,116, 43,
/* 0x4250 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4260 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4270 */  50,102, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x4280 */  51, 50, 32, 32, 32, 32,109,109, 97,112, 43, 48,120,102,102,102,
/* 0x4290 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x42a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 56, 50, 32, 82,
/* 0x42b0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x42c0 */  32,109,117,110,109, 97,112, 43, 48,120,102,102,102,102,102,102,
/* 0x42d0 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x42e0 */  48, 48, 48, 48, 48, 48, 48, 48, 51, 99, 48, 32, 82, 95, 88, 56,
/* 0x42f0 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,103,101,
/* 0x4300 */ 116, 95,112, 97,103,101, 95,109, 97,115,107, 43, 48,120,102,102,
/* 0x4310 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48,
/* 0x4320 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 54, 52, 32,
/* 0x4330 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32,
/* 0x4340 */  32, 32,109,109, 97,112, 43, 48,120,102,102,102,102,102,102,102,
/* 0x4350 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x4360 */  48, 48, 48, 48, 48, 48, 48, 52, 56,102, 32, 82, 95, 88, 56, 54,
/* 0x4370 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,117,110,
/* 0x4380 */ 109, 97,112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x4390 */ 102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x43a0 */  48, 48, 48, 48, 52, 97, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x43b0 */  95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,117,110,109, 97,112,
/* 0x43c0 */  43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x43d0 */ 102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x43e0 */  48, 52, 98, 56, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76,
/* 0x43f0 */  84, 51, 50, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,
/* 0x4400 */ 109, 97,115,107, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4410 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4420 */  48, 48, 48, 48, 48, 53,102, 57, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4430 */  52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 83, 84, 82, 67, 79,
/* 0x4440 */  78, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4450 */  48, 48, 48, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4460 */  48, 48, 53,102,101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4470 */  76, 84, 51, 50, 32, 32, 32, 32,117,112,120,102,100, 95, 99,114,
/* 0x4480 */ 101, 97,116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4490 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44a0 */  48, 48, 48, 48, 48, 54, 48, 99, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x44b0 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,102,116,114,117,110,
/* 0x44c0 */  99, 97,116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x44d0 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44e0 */  48, 48, 48, 48, 48, 54, 52, 57, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x44f0 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112, 43,
/* 0x4500 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4510 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4520 */  54, 55, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x4530 */  51, 50, 32, 32, 32, 32,109,109, 97,112, 43, 48,120,102,102,102,
/* 0x4540 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x4550 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 51,101, 32, 82,
/* 0x4560 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x4570 */  32, 83, 84, 82, 67, 79, 78, 43, 48,120, 48, 48, 48, 48, 48, 48,
/* 0x4580 */  48, 48, 48, 48, 48, 48, 48, 48, 48,100, 10, 48, 48, 48, 48, 48,
/* 0x4590 */  48, 48, 48, 48, 48, 48, 48, 48, 55, 52, 51, 32, 82, 95, 88, 56,
/* 0x45a0 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,117,112,
/* 0x45b0 */ 120,102,100, 95, 99,114,101, 97,116,101, 43, 48,120,102,102,102,
/* 0x45c0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x45d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 53, 54, 32, 82,
/* 0x45e0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x45f0 */  32,119,114,105,116,101, 43, 48,120,102,102,102,102,102,102,102,
/* 0x4600 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x4610 */  48, 48, 48, 48, 48, 48, 48, 55, 55, 50, 32, 82, 95, 88, 56, 54,
/* 0x4620 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,
/* 0x4630 */ 112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4640 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4650 */  48, 48, 55, 55, 99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4660 */  76, 84, 51, 50, 32, 32, 32, 32, 99,108,111,115,101, 43, 48,120,
/* 0x4670 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4680 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 97,
/* 0x4690 */  52, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x46a0 */  32, 32, 32, 32, 80,115,121,110, 99, 43, 48,120,102,102,102,102,
/* 0x46b0 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x46c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 97,102, 32, 82, 95,
/* 0x46d0 */  88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,
/* 0x46e0 */ 109,117,110,109, 97,112, 43, 48,120,102,102,102,102,102,102,102,
/* 0x46f0 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x4700 */  48, 48, 48, 48, 48, 48, 48, 55, 99, 98, 32, 82, 95, 88, 56, 54,
/* 0x4710 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,
/* 0x4720 */ 112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4730 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4740 */  48, 48, 55,100, 57, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4750 */  76, 84, 51, 50, 32, 32, 32, 32, 99,108,111,115,101, 43, 48,120,
/* 0x4760 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4770 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,102,
/* 0x4780 */  49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x4790 */  32, 32, 32, 32, 80,112,114,111,116,101, 99,116, 43, 48,120,102,
/* 0x47a0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x47b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,102,102,
/* 0x47c0 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32,
/* 0x47d0 */  32, 32, 32,101,120,105,116, 43, 48,120,102,102,102,102,102,102,
/* 0x47e0 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x47f0 */  48, 48, 48, 48, 48, 48, 48, 48, 56, 50, 56, 32, 82, 95, 88, 56,
/* 0x4800 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109,
/* 0x4810 */  97,112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4820 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4830 */  48, 48, 48, 56,101, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4840 */  80, 76, 84, 51, 50, 32, 32, 32, 32,103,101,116, 95,112, 97,103,
/* 0x4850 */ 101, 95,109, 97,115,107, 43, 48,120,102,102,102,102,102,102,102,
/* 0x4860 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x4870 */  48, 48, 48, 48, 48, 48, 48, 57, 51, 52, 32, 82, 95, 88, 56, 54,
/* 0x4880 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,111,112,101,
/* 0x4890 */ 110, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x48a0 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x48b0 */  48, 48, 57, 52, 57, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x48c0 */  76, 84, 51, 50, 32, 32, 32, 32,114,101, 97,100, 43, 48,120,102,
/* 0x48d0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x48e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 53, 98,
/* 0x48f0 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32,
/* 0x4900 */  32, 32, 32,101,120,105,116, 43, 48,120,102,102,102,102,102,102,
/* 0x4910 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x4920 */  48, 48, 48, 48, 48, 48, 48, 48, 57, 56,100, 32, 82, 95, 88, 56,
/* 0x4930 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32, 99,108,
/* 0x4940 */ 111,115,101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x4950 */ 102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4960 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x4970 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 93, 58, 10, 79, 70, 70, 83,
/* 0x4980 */  69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80,
/* 0x4990 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x49a0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x49b0 */  48, 48, 48, 50, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x49c0 */  67, 51, 50, 32, 32, 32, 32, 32, 83, 84, 82, 67, 79, 78, 43, 48,
/* 0x49d0 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x49e0 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x49f0 */  50,101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4a00 */  50, 32, 32, 32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,
/* 0x4a10 */ 101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4a20 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a30 */  48, 48, 48, 52, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4a40 */  76, 84, 51, 50, 32, 32, 32, 32,109,101,109,102,100, 95, 99,114,
/* 0x4a50 */ 101, 97,116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4a60 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a70 */  48, 48, 48, 48, 48, 48, 52,102, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4a80 */  52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 83, 84, 82, 67, 79,
/* 0x4a90 */  78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4aa0 */  53,101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4ab0 */  50, 32, 32, 32, 32,111,112,101,110, 43, 48,120,102,102,102,102,
/* 0x4ac0 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x4ad0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 49, 32, 82, 95,
/* 0x4ae0 */  88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,
/* 0x4af0 */ 102,116,114,117,110, 99, 97,116,101, 43, 48,120,102,102,102,102,
/* 0x4b00 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x4b10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57,100, 32, 82, 95,
/* 0x4b20 */  88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,
/* 0x4b30 */ 109,109, 97,112, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4b40 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b50 */  48, 48, 48, 48, 48, 48, 97, 53, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4b60 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,103,101,116, 95,112,
/* 0x4b70 */  97,103,101, 95,109, 97,115,107, 43, 48,120,102,102,102,102,102,
/* 0x4b80 */ 102,102,102,102,102,102,102,102,102,102, 99, 10, 10, 82, 69, 76,
/* 0x4b90 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4ba0 */  70, 79, 82, 32, 91, 83, 89, 83, 67, 65, 76, 76, 83, 93, 58, 10,
/* 0x4bb0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4bc0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4bd0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4be0 */  48, 48, 48, 48, 48, 48, 48, 52,100, 32, 82, 95, 88, 56, 54, 95,
/* 0x4bf0 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 46,116,101,120,
/* 0x4c00 */ 116, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4c10 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c20 */  48, 48, 48, 55, 56, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4c30 */  67, 51, 50, 32, 32, 32, 32, 32, 46,116,101,120,116, 43, 48,120,
/* 0x4c40 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4c50 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57,
/* 0x4c60 */  49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,
/* 0x4c70 */  32, 32, 32, 32, 46,116,101,120,116, 43, 48,120,102,102,102,102,
/* 0x4c80 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x4c90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 54, 32, 82, 95,
/* 0x4ca0 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x4cb0 */  46,116,101,120,116, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x4cc0 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4cd0 */  48, 48, 48, 48, 48, 48, 48, 56, 98, 32, 82, 95, 88, 56, 54, 95,
/* 0x4ce0 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,109,115,121,110,
/* 0x4cf0 */  99, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4d00 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d10 */  48, 48, 48, 97, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4d20 */  67, 51, 50, 32, 32, 32, 32, 32,109,112,114,111,116,101, 99,116,
/* 0x4d30 */  43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4d40 */ 102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4d50 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86,
/* 0x4d60 */  50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x4d70 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4d80 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4d90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,100,102, 32, 82,
/* 0x4da0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x4db0 */  32, 69, 88, 80, 95, 72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48,
/* 0x4dc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 53, 10, 48, 48, 48,
/* 0x4dd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95,
/* 0x4de0 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x4df0 */  69, 88, 80, 95, 84, 65, 73, 76, 43, 48,120, 48, 48, 48, 48, 48,
/* 0x4e00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 10, 82, 69, 76,
/* 0x4e10 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4e20 */  70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70,
/* 0x4e30 */  83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89,
/* 0x4e40 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e50 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e60 */  48, 48, 48, 48,100, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4e70 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65,
/* 0x4e80 */  68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e90 */  48, 48, 97, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ea0 */  48, 48, 48, 55, 52, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4eb0 */  67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76,
/* 0x4ec0 */  43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ed0 */  48, 48, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4ee0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86,
/* 0x4ef0 */  50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x4f00 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4f10 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4f20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 98, 32, 82,
/* 0x4f30 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x4f40 */  32, 69, 88, 80, 95, 72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48,
/* 0x4f50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 53, 10, 48, 48, 48,
/* 0x4f60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53,102, 32, 82, 95,
/* 0x4f70 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x4f80 */  69, 88, 80, 95, 84, 65, 73, 76, 43, 48,120, 48, 48, 48, 48, 48,
/* 0x4f90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 10, 82, 69, 76,
/* 0x4fa0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4fb0 */  70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89, 93,
/* 0x4fc0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4fd0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4fe0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4ff0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 88, 56,
/* 0x5000 */  54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 76, 90,
/* 0x5010 */  77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48, 48, 48, 48, 48,
/* 0x5020 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 53, 10, 10, 82, 69, 76,
/* 0x5030 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5040 */  70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 93,
/* 0x5050 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5060 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5070 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5080 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 88, 56,
/* 0x5090 */  54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88,
/* 0x50a0 */  80, 95, 84, 65, 73, 76, 43, 48,120, 48, 48, 48, 48, 48, 48, 48,
/* 0x50b0 */  48, 48, 48, 48, 48, 48, 48, 48, 52, 10
};
