MACRO(PYTHON_ADD_TEST TEST_NAME)

  TRIBITS_ADD_TEST(
    ${PYTHON_EXECUTABLE}
    NOEXEPREFIX
    NOEXESUFFIX
    NAME PYTHON_${TEST_NAME}
    ARGS "-m unittest ${TEST_NAME}.py"
    NUM_MPI_PROCS 1
    PASS_REGULAR_EXPRESSION "OK"
    ${ARGN}
    )

  IF(TPL_ENABLE_MPI)
    tribits_set_tests_properties(ROL_PYTHON_${TEST_NAME}_MPI_1
      PROPERTIES ENVIRONMENT "${PyROL_PYTHONPATH}")
  ELSE()
    tribits_set_tests_properties(ROL_PYTHON_${TEST_NAME}
      PROPERTIES ENVIRONMENT "${PyROL_PYTHONPATH}")
  ENDIF()

ENDMACRO(PYTHON_ADD_TEST TEST_NAME)
