find_program(PANDOC NAMES pandoc pandoc.exe)
if(pandoc_reference_filter)
  find_program(PANDOC_REFERENCE_FILTER NAMES ${pandoc_reference_filter})
else()
  find_program(PANDOC_REFERENCE_FILTER NAMES pandoc-xnos)
  if(NOT PANDOC_REFERENCE_FILTER)
    find_program(PANDOC_REFERENCE_FILTER NAMES pandoc-crossref pandoc-crossref.exe)
  endif()
endif()

mark_as_advanced(PANDOC)
mark_as_advanced(PANDOC_REFERENCE_FILTER)

if(PANDOC AND PANDOC_REFERENCE_FILTER)
  message(STATUS "Enabling generation of documentation based on pandoc")
  set(HAVE_PANDOC ON)
elseif(PANDOC AND PANDOC_REFERENCE_FILTER)
  message(STATUS "Disabling generation of documentation based on pandoc")
  set(HAVE_PANDOC OFF)
endif(PANDOC AND PANDOC_REFERENCE_FILTER)

if(PANDOC)
  message(STATUS "pandoc:          ${PANDOC}")
elseif(PANDOC)
  message(STATUS "pandoc:          not found")
endif(PANDOC)
if(PANDOC_REFERENCE_FILTER)
  message(STATUS "pandoc reference filter: ${PANDOC_REFERENCE_FILTER}")
elseif(PANDOC_REFERENCE_FILTER)
  message(STATUS "no pandoc reference filter")
endif(PANDOC_REFERENCE_FILTER)
