#!/bin/bash

export JOBNAME="${JOB_INT}${JOB_THREAD}${JOB_DEBUG}${JOB_RENAME}"
echo ${JOBNAME}
export JOBBUILDFLAGS="-O0 -g -fPIC -DCOMMON_FILE_COMPRESS_LZMA"

case "${JOB_INT}" in
     32 )
       export JOBBUILDFLAGS="${JOBBUILDFLAGS}" ;;
     32-64 )
       export JOBBUILDFLAGS="${JOBBUILDFLAGS} -DINTSIZE64 -DIDXSIZE64" ;;
     64 )
       export JOBBUILDFLAGS="${JOBBUILDFLAGS}" ;;
esac

case "${JOB_THREAD}" in
  n )
    export JOBBUILDFLAGS="${JOBBUILDFLAGS} -DSCOTCH_MPI_ASYNC_COLL" ;;
  c )
    export JOBBUILDFLAGS="${JOBBUILDFLAGS} -DCOMMON_PTHREAD" ;;
  k )
    export JOBBUILDFLAGS="${JOBBUILDFLAGS} -DCOMMON_PTHREAD -DCOMMON_PTHREAD_REDUCE_CANONICAL -DCOMMON_PTHREAD_SCAN_CANONICAL -DSCOTCH_MPI_ASYNC_COLL -DSCOTCH_PTHREAD" ;;
  s )
    export JOBBUILDFLAGS="${JOBBUILDFLAGS} -DCOMMON_PTHREAD -DCOMMON_PTHREAD_AFFINITY_LINUX -DSCOTCH_MPI_ASYNC_COLL -DSCOTCH_PTHREAD -DSCOTCH_PTHREAD_NUMBER=2" ;;
  m )
    export JOBBUILDFLAGS="${JOBBUILDFLAGS} -DCOMMON_PTHREAD -DCOMMON_PTHREAD_AFFINITY_LINUX -DSCOTCH_MPI_ASYNC_COLL -DSCOTCH_PTHREAD -DSCOTCH_PTHREAD_MPI" ;;
esac

export JOBCHECK=""
case "${JOB_DEBUG}" in
  n )
    export JOBBUILDFLAGS="${JOBBUILDFLAGS}" ;;
  a )
    export JOBBUILDFLAGS="${JOBBUILDFLAGS} -DCOMMON_RANDOM_FIXED_SEED -DSCOTCH_DEBUG_ALL" ;;
  f )
    export JOBBUILDFLAGS="${JOBBUILDFLAGS} -DCOMMON_RANDOM_FIXED_SEED -DSCOTCH_DEBUG_FULL"
    export JOBCHECK=_full ;;
esac

case "${JOB_RENAME}" in
  n )
    export JOBBUILDFLAGS="${JOBBUILDFLAGS}" ;;
  r )
    export JOBBUILDFLAGS="${JOBBUILDFLAGS} -DSCOTCH_RENAME" ;;
esac
echo ${JOBBUILDFLAGS}
