!
! Copyright (C) 2003-2021 Quantum ESPRESSO group
! This file is distributed under the terms of the
! GNU General Public License. See the file `License'
! in the root directory of the present distribution,
! or http://www.gnu.org/copyleft/gpl.txt .
!
!
!-------------------------------------------------------------------
PROGRAM interp_r_to_k
  !-----------------------------------------------------------------
  !
  !!  This simple code read the KC hamiltonian generated by 
  !!  kcw_ham in real space and interpolate on a given path (from input)
  !!   
  !!  Code written by Nicola Colonna and based on intepolation.f90 by Riccardo de Gennaro
  !
  USE mp_global,             ONLY : mp_startup,mp_global_end
  USE environment,           ONLY : environment_start, environment_end
  USE check_stop,            ONLY : check_stop_init
  USE interpolation,         ONLY : interpolate_ham, dealloc_interpolation
  !
  !
  IMPLICIT NONE
  !
  CHARACTER(LEN=9) :: code='KC_PP_INTERPOLATION'
  !
  CALL mp_startup ( )
  CALL environment_start ( code )
  ! 
  CALL kcw_pp_readin ( )
  !
  CALL kcw_bands( )
  !
  CALL dealloc_interpolation( )
  ! 
  CALL clean_pw( .TRUE. )
  !
  ! 5) Clean and Close 
  CALL mp_global_end()
  CALL environment_end( code )
  !
END PROGRAM interp_r_to_k
