// This file implements the IShellLibrary Interface for Python.
// Generated by makegw.py

#include "shell_pch.h"

#include "PyIShellLibrary.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIShellLibrary::PyIShellLibrary(IUnknown *pdisp) : PyIUnknown(pdisp) { ob_type = &type; }

PyIShellLibrary::~PyIShellLibrary() {}

/* static */ IShellLibrary *PyIShellLibrary::GetI(PyObject *self) { return (IShellLibrary *)PyIUnknown::GetI(self); }

// @pymethod |PyIShellLibrary|LoadLibraryFromItem|Loads an existing library file
PyObject *PyIShellLibrary::LoadLibraryFromItem(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    IShellItem *Library;
    PyObject *obLibrary;
    DWORD Mode;
    // @pyparm <o PyIShellItem>|Library||Shell item interface representing the library file
    // @pyparm int|Mode||Access mode, combination of storagecon.STGM_* flags
    if (!PyArg_ParseTuple(args, "Ok:LoadLibraryFromItem", &obLibrary, &Mode))
        return NULL;
    if (!PyCom_InterfaceFromPyObject(obLibrary, IID_IShellItem, (void **)&Library, FALSE))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->LoadLibraryFromItem(Library, Mode);
    Library->Release();
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIShellLibrary|LoadLibraryFromKnownFolder|Initializes library from a known folder
PyObject *PyIShellLibrary::LoadLibraryFromKnownFolder(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    IID Library;
    DWORD Mode;
    // @pyparm <o PyIID>|Library||Known folder id, shell.FOLDERID_*
    // @pyparm int|Mode||Access mode, combination of storagecon.STGM_* flags
    if (!PyArg_ParseTuple(args, "O&k:LoadLibraryFromKnownFolder", PyWinObject_AsIID, &Library, &Mode))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->LoadLibraryFromKnownFolder(Library, Mode);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIShellLibrary|AddFolder|Includes a folder
PyObject *PyIShellLibrary::AddFolder(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    IShellItem *Location;
    PyObject *obLocation;
    // @pyparm <o PyIShellItem>|Location||Shell item interface representing the folder
    if (!PyArg_ParseTuple(args, "O:AddFolder", &obLocation))
        return NULL;
    if (!PyCom_InterfaceFromPyObject(obLocation, IID_IShellItem, (void **)&Location, FALSE))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->AddFolder(Location);
    Location->Release();
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIShellLibrary|RemoveFolder|Removes a folder
PyObject *PyIShellLibrary::RemoveFolder(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    IShellItem *Location;
    PyObject *obLocation;
    // @pyparm <o PyIShellItem>|Location||Shell item interface representing the folder
    if (!PyArg_ParseTuple(args, "O:RemoveFolder", &obLocation))
        return NULL;
    if (!PyCom_InterfaceFromPyObject(obLocation, IID_IShellItem, (void **)&Location, FALSE))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->RemoveFolder(Location);
    Location->Release();
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod <o PyIShellItemArray>|PyIShellLibrary|GetFolders|Retrieves a collection of folders in the library
PyObject *PyIShellLibrary::GetFolders(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    // @pyparm int|Filter|LFF_ALLITEMS|Specifies what types of folder to return (shellcon.LFF_*)
    // @pyparm <o PyIID>|riid|IID_IShellItemArray|The interface to return, IObjectCollection and IObjectArray also
    // accepted.
    LIBRARYFOLDERFILTER Filter = LFF_ALLITEMS;
    IID riid = IID_IShellItemArray;
    void *pv;
    if (!PyArg_ParseTuple(args, "|iO&:GetFolders", &Filter, PyWinObject_AsIID, &riid))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->GetFolders(Filter, riid, &pv);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    return PyCom_PyObjectFromIUnknown((IUnknown *)pv, riid, FALSE);
}

// @pymethod <o PyIShellItem>|PyIShellLibrary|ResolveFolder|Attempts to locate a folder that has been moved or renamed
PyObject *PyIShellLibrary::ResolveFolder(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    IShellItem *FolderToResolve;
    PyObject *obFolderToResolve;
    DWORD Timeout;
    IID riid = IID_IShellItem;
    // @pyparm <o PyIShellItem>|FolderToResolve||Library item whose location has changed
    // @pyparm int|Timeout||Max search time, specified in milliseconds
    // @pyparm <o PyIID>|riid|IID_IShellItem|The interface to return
    if (!PyArg_ParseTuple(args, "Ok|O&:ResolveFolder", &obFolderToResolve, &Timeout, PyWinObject_AsIID, &riid))
        return NULL;
    if (!PyCom_InterfaceFromPyObject(obFolderToResolve, IID_IShellItem, (void **)&FolderToResolve, FALSE))
        return NULL;

    void *pv;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->ResolveFolder(FolderToResolve, Timeout, riid, &pv);
    FolderToResolve->Release();
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    return PyCom_PyObjectFromIUnknown((IUnknown *)pv, riid, FALSE);
}

// @pymethod <o PyIShellItem>|PyIShellLibrary|GetDefaultSaveFolder|Returns the default folder in which new items are
// saved
PyObject *PyIShellLibrary::GetDefaultSaveFolder(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    DEFAULTSAVEFOLDERTYPE Type = DSFT_DETECT;
    IID riid = IID_IShellItem;
    // @pyparm int|Type|DSFT_DETECT|Specifies whether to return public or private save location, shellcon.DSFT_*
    // @pyparm <o PyIID>|riid|IID_IShellItem|The interface to return
    if (!PyArg_ParseTuple(args, "|iO&:GetDefaultSaveFolder", &Type, PyWinObject_AsIID, &riid))
        return NULL;

    void *pv;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->GetDefaultSaveFolder(Type, riid, &pv);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    return PyCom_PyObjectFromIUnknown((IUnknown *)pv, riid, FALSE);
}

// @pymethod |PyIShellLibrary|SetDefaultSaveFolder|Sets the default save location
PyObject *PyIShellLibrary::SetDefaultSaveFolder(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    DEFAULTSAVEFOLDERTYPE Type;
    IShellItem *SaveFolder;
    PyObject *obSaveFolder;
    // @pyparm int|Type||Specifies public or private save location, shellcon.DSFT_*
    // @pyparm <o PyIShellItem>|SaveFolder||New default location, must be in the library
    if (!PyArg_ParseTuple(args, "iO:SetDefaultSaveFolder", &Type, &obSaveFolder))
        return NULL;
    if (!PyCom_InterfaceFromPyObject(obSaveFolder, IID_IShellItem, (void **)&SaveFolder, FALSE))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->SetDefaultSaveFolder(Type, SaveFolder);
    SaveFolder->Release();
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod int|PyIShellLibrary|GetOptions|Retrieves library option flags
// @rdesc Returns a combination of shellcon.LOF_* flags
PyObject *PyIShellLibrary::GetOptions(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    LIBRARYOPTIONFLAGS Options;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->GetOptions(&Options);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    return PyLong_FromLong(Options);
}

// @pymethod |PyIShellLibrary|SetOptions|Sets library option flags
PyObject *PyIShellLibrary::SetOptions(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    LIBRARYOPTIONFLAGS Mask, Options;
    // @pyparm int|Mask||Bitmask of flags to be changed, combination of shellcon.LOF_* values
    // @pyparm int|Options||New options, combination of shellcon.LOF_* values
    if (!PyArg_ParseTuple(args, "ii:SetOptions", &Mask, &Options))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->SetOptions(Mask, Options);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod <o PyIID>|PyIShellLibrary|GetFolderType|Returns the library type, shell.FOLDERTYPEID_*
PyObject *PyIShellLibrary::GetFolderType(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    FOLDERTYPEID ft;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->GetFolderType(&ft);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    return PyWinObject_FromIID(ft);
}

// @pymethod |PyIShellLibrary|SetFolderType|Sets the folder type for the library
PyObject *PyIShellLibrary::SetFolderType(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    FOLDERTYPEID ft;
    // @pyparm <o PyIID>|Type||New type, shell.FOLDERTYPEID_*
    if (!PyArg_ParseTuple(args, "O&:SetFolderType", PyWinObject_AsIID, &ft))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->SetFolderType(ft);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod str|PyIShellLibrary|GetIcon|Returns the location of the library's icon
// @rdesc Uses "module,resource" format
PyObject *PyIShellLibrary::GetIcon(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    LPWSTR Icon;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->GetIcon(&Icon);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    PyObject *ret = PyWinObject_FromWCHAR(Icon);
    CoTaskMemFree(Icon);  // Docs don't specify, but this doesn't leak
    return ret;
}

// @pymethod |PyIShellLibrary|SetIcon|Sets the library icon
PyObject *PyIShellLibrary::SetIcon(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    TmpWCHAR Icon;
    PyObject *obIcon;
    // @pyparm str|Icon||Icon location in "module,resource" syntax
    if (!PyArg_ParseTuple(args, "O:SetIcon", &obIcon))
        return NULL;
    if (!PyWinObject_AsWCHAR(obIcon, &Icon, FALSE))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->SetIcon(Icon);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIShellLibrary|Commit|Saves changes (only if loaded from an existing library)
PyObject *PyIShellLibrary::Commit(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->Commit();
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod <o PyIShellItem>|PyIShellLibrary|Save|Saves the library to a specific location
// @rdesc Returns a shell item for the saved file.
PyObject *PyIShellLibrary::Save(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    IShellItem *FolderToSaveIn, *SavedTo;
    PyObject *obFolderToSaveIn;
    TmpWCHAR LibraryName;
    PyObject *obLibraryName;
    LIBRARYSAVEFLAGS Flags;
    // @pyparm <o PyIShellItem>|FolderToSaveIn||The destination folder, use None to save in current user's Libraries
    // folder
    // @pyparm str|LibraryName||Filename for the new library, without file extension
    // @pyparm int|Flags||Determines behaviour if file already exists, shellcon.LSF_*
    if (!PyArg_ParseTuple(args, "OOi:Save", &obFolderToSaveIn, &obLibraryName, &Flags))
        return NULL;
    if (!PyWinObject_AsWCHAR(obLibraryName, &LibraryName, FALSE))
        return NULL;
    if (!PyCom_InterfaceFromPyObject(obFolderToSaveIn, IID_IShellItem, (void **)&FolderToSaveIn, TRUE))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->Save(FolderToSaveIn, LibraryName, Flags, &SavedTo);
    if (FolderToSaveIn)
        FolderToSaveIn->Release();
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    return PyCom_PyObjectFromIUnknown(SavedTo, IID_IShellItem, FALSE);
}

// @pymethod <o PyIShellItem>|PyIShellLibrary|SaveInKnownFolder|Saves the library in a known folder
PyObject *PyIShellLibrary::SaveInKnownFolder(PyObject *self, PyObject *args)
{
    IShellLibrary *pISL = GetI(self);
    if (pISL == NULL)
        return NULL;
    KNOWNFOLDERID FolderToSaveIn;
    TmpWCHAR LibraryName;
    PyObject *obLibraryName;
    LIBRARYSAVEFLAGS Flags;
    IShellItem *SavedTo;
    // @pyparm <o PyIID>|FolderToSaveIn||The destination folder, shell.FOLDERID_*
    // @pyparm str|LibraryName||Filename for the new library, without file extension
    // @pyparm int|Flags||Determines behaviour if file already exists, shellcon.LSF_*
    if (!PyArg_ParseTuple(args, "O&Oi:SaveInKnownFolder", PyWinObject_AsIID, &FolderToSaveIn, &obLibraryName, &Flags))
        return NULL;
    if (!PyWinObject_AsWCHAR(obLibraryName, &LibraryName, FALSE))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pISL->SaveInKnownFolder(FolderToSaveIn, LibraryName, Flags, &SavedTo);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pISL, IID_IShellLibrary);
    return PyCom_PyObjectFromIUnknown(SavedTo, IID_IShellItem, FALSE);
}

// @object PyIShellLibrary|Interface used to access Libraries
static struct PyMethodDef PyIShellLibrary_methods[] = {
    {"LoadLibraryFromItem", PyIShellLibrary::LoadLibraryFromItem,
     1},  // @pymeth LoadLibraryFromItem|Loads an existing library file
    {"LoadLibraryFromKnownFolder", PyIShellLibrary::LoadLibraryFromKnownFolder,
     1},  // @pymeth LoadLibraryFromKnownFolder|Initializes library from a known folder
    {"AddFolder", PyIShellLibrary::AddFolder, 1},        // @pymeth AddFolder|Includes a folder in the library
    {"RemoveFolder", PyIShellLibrary::RemoveFolder, 1},  // @pymeth RemoveFolder|Removes a folder
    {"GetFolders", PyIShellLibrary::GetFolders,
     1},  // @pymeth GetFolders|Retrieves a collection of folders in the library
    {"ResolveFolder", PyIShellLibrary::ResolveFolder,
     1},  // @pymeth ResolveFolder|Attempts to locate a folder that has been moved or renamed
    {"GetDefaultSaveFolder", PyIShellLibrary::GetDefaultSaveFolder,
     1},  // @pymeth GetDefaultSaveFolder|Returns the default folder in which new items are saved
    {"SetDefaultSaveFolder", PyIShellLibrary::SetDefaultSaveFolder,
     1},  // @pymeth SetDefaultSaveFolder|Sets the default save location
    {"GetOptions", PyIShellLibrary::GetOptions, METH_NOARGS},  // @pymeth GetOptions|Retrieves library option flags
    {"SetOptions", PyIShellLibrary::SetOptions, 1},            // @pymeth SetOptions|Sets library option flags
    {"GetFolderType", PyIShellLibrary::GetFolderType,
     METH_NOARGS},  // @pymeth GetFolderType|Retrieves the folder type of the library
    {"SetFolderType", PyIShellLibrary::SetFolderType, 1},  // @pymeth SetFolderType|Sets the folder type of the library
    {"GetIcon", PyIShellLibrary::GetIcon, METH_NOARGS},    // @pymeth GetIcon|Returns the location of the library's icon
    {"SetIcon", PyIShellLibrary::SetIcon, 1},              // @pymeth SetIcon|Sets the library icon
    {"Commit", PyIShellLibrary::Commit,
     METH_NOARGS},                       // @pymeth Commit|Saves changes (only if loaded from an existing library)
    {"Save", PyIShellLibrary::Save, 1},  // @pymeth Save|Saves the library to a specific location
    {"SaveInKnownFolder", PyIShellLibrary::SaveInKnownFolder,
     1},  // @pymeth SaveInKnownFolder|Saves the library in a known folder
    {NULL}};

PyComTypeObject PyIShellLibrary::type("PyIShellLibrary", &PyIUnknown::type, sizeof(PyIShellLibrary),
                                      PyIShellLibrary_methods, GET_PYCOM_CTOR(PyIShellLibrary));
