# Бенчмарки { #benchmarks }

Незалежні бенчмарки TechEmpower показують, що застосунки FastAPI, запущені під керуванням Uvicorn, є <a href="https://www.techempower.com/benchmarks/#section=test&runid=7464e520-0dc2-473d-bd34-dbdfd7e85911&hw=ph&test=query&l=zijzen-7" class="external-link" target="_blank">одним із найшвидших доступних фреймворків Python</a>, поступаючись лише самим Starlette і Uvicorn (використовуються FastAPI внутрішньо).

Але переглядаючи бенчмарки та порівняння, майте на увазі таке.

## Бенчмарки та швидкість { #benchmarks-and-speed }

Під час перегляду бенчмарків часто порівнюють кілька інструментів різних типів як рівноцінні.

Зокрема, разом порівнюють Uvicorn, Starlette і FastAPI (серед багатьох інших інструментів).

Чим простіше завдання, яке розв'язує інструмент, тим кращою буде продуктивність. І більшість бенчмарків не перевіряють додаткові можливості, що надає інструмент.

Ієрархія приблизно така:

* Uvicorn: сервер ASGI
    * Starlette: (використовує Uvicorn) веб-мікрофреймворк
        * FastAPI: (використовує Starlette) мікрофреймворк для API з низкою додаткових можливостей для створення API, з валідацією даних тощо.

* Uvicorn:
    * Матиме найвищу продуктивність, адже майже не містить додаткового коду окрім власне сервера.
    * Ви не писатимете застосунок безпосередньо на Uvicorn. Це означало б, що ваш код мав би включати принаймні приблизно весь код, який надає Starlette (або FastAPI). І якщо зробити так, ваш кінцевий застосунок матиме ті самі накладні витрати, що й під час використання фреймворку, який мінімізує код застосунку та помилки.
    * Якщо ви порівнюєте Uvicorn, порівнюйте його з Daphne, Hypercorn, uWSGI тощо. Сервери застосунків.
* Starlette:
    * Матиме наступну за швидкістю продуктивність після Uvicorn. Насправді Starlette використовує Uvicorn для запуску. Тож вона може бути «повільнішою» за Uvicorn лише через необхідність виконувати більше коду.
    * Але надає інструменти для створення простих веб-застосунків із маршрутизацією на основі шляхів тощо.
    * Якщо ви порівнюєте Starlette, порівнюйте її з Sanic, Flask, Django тощо. Веб-фреймворки (або мікрофреймворки).
* FastAPI:
    * Аналогічно до того, як Starlette використовує Uvicorn і не може бути швидшою за нього, FastAPI використовує Starlette, тож не може бути швидшою за неї.
    * FastAPI надає більше можливостей поверх Starlette. Можливості, які майже завжди потрібні під час створення API, як-от валідація та серіалізація даних. І, використовуючи його, ви безкоштовно отримуєте автоматичну документацію (автоматична документація навіть не додає накладних витрат під час роботи застосунку - вона генерується під час запуску).
    * Якби ви не використовували FastAPI і застосували Starlette безпосередньо (або інший інструмент, наприклад Sanic, Flask, Responder тощо), вам довелося б самостійно реалізувати всю валідацію та серіалізацію даних. Тож ваш кінцевий застосунок усе одно мав би ті самі накладні витрати, ніби він був створений із використанням FastAPI. І в багатьох випадках саме ця валідація та серіалізація даних становить найбільший обсяг коду в застосунках.
    * Отже, використовуючи FastAPI, ви заощаджуєте час розробки, зменшуєте кількість помилок і рядків коду та, ймовірно, отримуєте таку саму (або кращу) продуктивність, як і без нього (адже інакше вам довелося б реалізувати все це у власному коді).
    * Якщо ви порівнюєте FastAPI, порівнюйте його з веб-фреймворком (або набором інструментів), який надає валідацію даних, серіалізацію та документацію, наприклад Flask-apispec, NestJS, Molten тощо. Фреймворки з вбудованою автоматичною валідацією даних, серіалізацією та документацією.
