# Історія, проєктування і майбутнє { #history-design-and-future }

Деякий час тому <a href="https://github.com/fastapi/fastapi/issues/3#issuecomment-454956920" class="external-link" target="_blank">користувач **FastAPI** запитав</a>:

> Яка історія цього проєкту? Здається, він нізвідки за кілька тижнів став чудовим [...]

Ось трохи цієї історії.

## Альтернативи { #alternatives }

Я створював API зі складними вимогами протягом кількох років (машинне навчання, розподілені системи, асинхронні завдання, бази даних NoSQL тощо), очолюючи кілька команд розробників.

У межах цього мені довелося досліджувати, тестувати й використовувати багато альтернатив.

Історія **FastAPI** значною мірою - це історія його попередників.

Як сказано в розділі [Альтернативи](alternatives.md){.internal-link target=_blank}:

<blockquote markdown="1">

**FastAPI** не існував би без попередньої роботи інших.

Було створено багато інструментів, які надихнули на його створення.

Я роками уникав створення нового фреймворку. Спочатку я намагався вирішити всі можливості, які покриває **FastAPI**, використовуючи різні фреймворки, плагіни та інструменти.

Але в певний момент не залишилося іншого варіанту, окрім створити щось, що надає всі ці можливості, узявши найкращі ідеї з попередніх інструментів і поєднавши їх якнайкраще, використовуючи можливості самої мови, яких раніше взагалі не було (підказки типів Python 3.6+).

</blockquote>

## Дослідження { #investigation }

Використовуючи всі попередні альтернативи, я мав змогу повчитися в кожної, узяти ідеї й поєднати їх якнайкраще для себе та команд розробників, з якими працював.

Наприклад, було очевидно, що в ідеалі все має ґрунтуватися на стандартних підказках типів Python.

Також найкращим підходом було використовувати вже наявні стандарти.

Тож, ще до початку написання коду **FastAPI**, я провів кілька місяців, вивчаючи специфікації OpenAPI, Схеми JSON, OAuth2 тощо. Розуміючи їхні взаємозв'язки, перетини та відмінності.

## Проєктування { #design }

Потім я приділив час проєктуванню «API» для розробника, яке я хотів мати як користувач (як розробник, що використовує FastAPI).

Я протестував кілька ідей у найпопулярніших Python-редакторах: PyCharm, VS Code, редакторах на основі Jedi.

За даними <a href="https://www.jetbrains.com/research/python-developers-survey-2018/#development-tools" class="external-link" target="_blank">Python Developer Survey</a>, це охоплює близько 80% користувачів.

Це означає, що **FastAPI** спеціально тестувався з редакторами, якими користуються 80% розробників Python. І оскільки більшість інших редакторів працюють подібно, усі ці переваги мають працювати практично у всіх редакторах.

Так я зміг знайти найкращі способи максимально зменшити дублювання коду, забезпечити автодоповнення всюди, перевірки типів і помилок тощо.

І все це так, щоб надати найкращий досвід розробки для всіх розробників.

## Вимоги { #requirements }

Після перевірки кількох альтернатив я вирішив використовувати <a href="https://docs.pydantic.dev/" class="external-link" target="_blank">**Pydantic**</a> через його переваги.

Потім я зробив внески до нього, щоб зробити його повністю сумісним із Схемою JSON, додати підтримку різних способів оголошення обмежень і поліпшити підтримку редакторів (перевірки типів, автодоповнення) на основі тестів у кількох редакторах.

Під час розробки я також зробив внески до <a href="https://www.starlette.dev/" class="external-link" target="_blank">**Starlette**</a>, іншої ключової залежності.

## Розробка { #development }

Коли я взявся безпосередньо за створення **FastAPI**, більшість складових уже були на місцях: дизайн визначено, вимоги та інструменти підготовлено, знання про стандарти й специфікації - чіткі та свіжі.

## Майбутнє { #future }

На цей момент уже зрозуміло, що **FastAPI** зі своїми ідеями корисний для багатьох.

Його обирають замість попередніх альтернатив, бо він краще відповідає багатьом сценаріям використання.

Багато розробників і команд уже залежать від **FastAPI** у своїх проєктах (включно зі мною та моєю командою).

Але попереду ще багато покращень і можливостей.

**FastAPI** має велике майбутнє.

І [ваша допомога](help-fastapi.md){.internal-link target=_blank} дуже цінується.
